/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.LdapURL;
import com.sun.jndi.ldap.ServiceLocator;
import com.sun.jndi.ldap.spi.LdapDnsProviderResult;
import java.util.ArrayList;
import java.util.Map;
import javax.naming.NamingException;

public class DefaultLdapDnsProvider {
    public LdapDnsProviderResult lookupEndpoints(String url, Map<?, ?> env) throws NamingException {
        String[] hostports;
        String domainName;
        if (url == null || env == null) {
            throw new NullPointerException();
        }
        ArrayList<String> endpoints = new ArrayList<String>();
        LdapURL ldapUrl = new LdapURL(url);
        String dn = ldapUrl.getDN();
        String host = ldapUrl.getHost();
        int port = ldapUrl.getPort();
        if (host == null && port == -1 && dn != null && (domainName = ServiceLocator.mapDnToDomainName(dn)) != null && (hostports = ServiceLocator.getLdapService(domainName, env)) != null) {
            String scheme = ldapUrl.getScheme() + "://";
            String query = ldapUrl.getQuery();
            String urlSuffix = ldapUrl.getPath() + (query != null ? query : "");
            for (String hostPort : hostports) {
                endpoints.add(scheme + hostPort + urlSuffix);
            }
        } else {
            domainName = "";
            endpoints.add(url);
        }
        LdapDnsProviderResult res = new LdapDnsProviderResult(domainName, endpoints);
        if (res.getEndpoints().isEmpty() && res.getDomainName().isEmpty()) {
            return null;
        }
        return res;
    }
}

