/*
 * This file is part of polkit-d.
 *
 * polkit-d is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version, with
 * some exceptions, please read the COPYING file.
 *
 * polkit-d is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with gtkD; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110, USA
 */

// generated automatically - do not change
// find conversion definition on APILookup.txt
// implement new conversion functionalities on the wrap.utils pakage

module polkit.UnixNetgroup;

private import glib.ConstructionException;
private import glib.Str;
private import gobject.ObjectG;
private import polkit.IdentityIF;
private import polkit.IdentityT;
private import polkit.c.functions;
public  import polkit.c.types;


/**
 * An object representing a netgroup identity on a UNIX system.
 */
public class UnixNetgroup : ObjectG, IdentityIF
{
	/** the main Gtk struct */
	protected PolkitUnixNetgroup* polkitUnixNetgroup;

	/** Get the main Gtk struct */
	public PolkitUnixNetgroup* getUnixNetgroupStruct(bool transferOwnership = false)
	{
		if (transferOwnership)
			ownedRef = false;
		return polkitUnixNetgroup;
	}

	/** the main Gtk struct as a void* */
	protected override void* getStruct()
	{
		return cast(void*)polkitUnixNetgroup;
	}

	/**
	 * Sets our main struct and passes it to the parent class.
	 */
	public this (PolkitUnixNetgroup* polkitUnixNetgroup, bool ownedRef = false)
	{
		this.polkitUnixNetgroup = polkitUnixNetgroup;
		super(cast(GObject*)polkitUnixNetgroup, ownedRef);
	}

	// add the Identity capabilities
	mixin IdentityT!(PolkitUnixNetgroup);


	/** */
	public static GType getType()
	{
		return polkit_unix_netgroup_get_type();
	}

	/**
	 * Creates a new #PolkitUnixNetgroup object for @name.
	 *
	 * Params:
	 *     name = A netgroup name.
	 *
	 * Returns: A #PolkitUnixNetgroup object. Free with g_object_unref().
	 *
	 * Throws: ConstructionException GTK+ fails to create the object.
	 */
	public this(string name)
	{
		auto __p = polkit_unix_netgroup_new(Str.toStringz(name));

		if(__p is null)
		{
			throw new ConstructionException("null returned by new");
		}

		this(cast(PolkitUnixNetgroup*) __p, true);
	}

	/**
	 * Gets the netgroup name for @group.
	 *
	 * Returns: A netgroup name string.
	 */
	public string getName()
	{
		return Str.toString(polkit_unix_netgroup_get_name(polkitUnixNetgroup));
	}

	/**
	 * Sets @name for @group.
	 *
	 * Params:
	 *     name = A netgroup name.
	 */
	public void setName(string name)
	{
		polkit_unix_netgroup_set_name(polkitUnixNetgroup, Str.toStringz(name));
	}
}
