/*
 * This file is part of polkit-d.
 *
 * polkit-d is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version, with
 * some exceptions, please read the COPYING file.
 *
 * polkit-d is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with gtkD; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110, USA
 */

// generated automatically - do not change
// find conversion definition on APILookup.txt
// implement new conversion functionalities on the wrap.utils pakage

module polkit.TemporaryAuthorization;

private import glib.Str;
private import gobject.ObjectG;
private import polkit.SubjectIF;
private import polkit.c.functions;
public  import polkit.c.types;


/**
 * Object used to describe a temporary authorization.
 */
public class TemporaryAuthorization : ObjectG
{
	/** the main Gtk struct */
	protected PolkitTemporaryAuthorization* polkitTemporaryAuthorization;

	/** Get the main Gtk struct */
	public PolkitTemporaryAuthorization* getTemporaryAuthorizationStruct(bool transferOwnership = false)
	{
		if (transferOwnership)
			ownedRef = false;
		return polkitTemporaryAuthorization;
	}

	/** the main Gtk struct as a void* */
	protected override void* getStruct()
	{
		return cast(void*)polkitTemporaryAuthorization;
	}

	/**
	 * Sets our main struct and passes it to the parent class.
	 */
	public this (PolkitTemporaryAuthorization* polkitTemporaryAuthorization, bool ownedRef = false)
	{
		this.polkitTemporaryAuthorization = polkitTemporaryAuthorization;
		super(cast(GObject*)polkitTemporaryAuthorization, ownedRef);
	}


	/** */
	public static GType getType()
	{
		return polkit_temporary_authorization_get_type();
	}

	/**
	 * Gets the action that @authorization is for.
	 *
	 * Returns: A string owned by @authorization. Do not free.
	 */
	public string getActionId()
	{
		return Str.toString(polkit_temporary_authorization_get_action_id(polkitTemporaryAuthorization));
	}

	/**
	 * Gets the opaque identifier for @authorization.
	 *
	 * Returns: A string owned by @authorization. Do not free.
	 */
	public string getId()
	{
		return Str.toString(polkit_temporary_authorization_get_id(polkitTemporaryAuthorization));
	}

	/**
	 * Gets the subject that @authorization is for.
	 *
	 * Returns: A #PolkitSubject, free with g_object_unref().
	 */
	public SubjectIF getSubject()
	{
		auto __p = polkit_temporary_authorization_get_subject(polkitTemporaryAuthorization);

		if(__p is null)
		{
			return null;
		}

		return ObjectG.getDObject!(SubjectIF)(cast(PolkitSubject*) __p, true);
	}

	/**
	 * Gets the time when @authorization will expire.
	 *
	 * (Note that the PolicyKit daemon is using monotonic time internally
	 * so the returned value may change if system time changes.)
	 *
	 * Returns: Seconds since the Epoch Jan 1. 1970, 0:00 UTC.
	 */
	public ulong getTimeExpires()
	{
		return polkit_temporary_authorization_get_time_expires(polkitTemporaryAuthorization);
	}

	/**
	 * Gets the time when @authorization was obtained.
	 *
	 * (Note that the PolicyKit daemon is using monotonic time internally
	 * so the returned value may change if system time changes.)
	 *
	 * Returns: Seconds since the Epoch Jan 1. 1970, 0:00 UTC.
	 */
	public ulong getTimeObtained()
	{
		return polkit_temporary_authorization_get_time_obtained(polkitTemporaryAuthorization);
	}
}
