/*
 * This file is part of polkit-d.
 *
 * polkit-d is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version, with
 * some exceptions, please read the COPYING file.
 *
 * polkit-d is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with gtkD; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110, USA
 */

// generated automatically - do not change
// find conversion definition on APILookup.txt
// implement new conversion functionalities on the wrap.utils pakage

module polkit.AuthorizationResult;

private import glib.ConstructionException;
private import glib.Str;
private import gobject.ObjectG;
private import polkit.Details;
private import polkit.c.functions;
public  import polkit.c.types;


/**
 * This class represents the result you get when checking for an authorization.
 */
public class AuthorizationResult : ObjectG
{
	/** the main Gtk struct */
	protected PolkitAuthorizationResult* polkitAuthorizationResult;

	/** Get the main Gtk struct */
	public PolkitAuthorizationResult* getAuthorizationResultStruct(bool transferOwnership = false)
	{
		if (transferOwnership)
			ownedRef = false;
		return polkitAuthorizationResult;
	}

	/** the main Gtk struct as a void* */
	protected override void* getStruct()
	{
		return cast(void*)polkitAuthorizationResult;
	}

	/**
	 * Sets our main struct and passes it to the parent class.
	 */
	public this (PolkitAuthorizationResult* polkitAuthorizationResult, bool ownedRef = false)
	{
		this.polkitAuthorizationResult = polkitAuthorizationResult;
		super(cast(GObject*)polkitAuthorizationResult, ownedRef);
	}


	/** */
	public static GType getType()
	{
		return polkit_authorization_result_get_type();
	}

	/**
	 * Creates a new #PolkitAuthorizationResult object.
	 *
	 * Params:
	 *     isAuthorized = Whether the subject is authorized.
	 *     isChallenge = Whether the subject is authorized if more
	 *         information is provided. Must be %FALSE unless @is_authorized is
	 *         %TRUE.
	 *     details = Must be %NULL unless @is_authorized is %TRUE
	 *
	 * Returns: A #PolkitAuthorizationResult object. Free with g_object_unref().
	 *
	 * Throws: ConstructionException GTK+ fails to create the object.
	 */
	public this(bool isAuthorized, bool isChallenge, Details details)
	{
		auto __p = polkit_authorization_result_new(isAuthorized, isChallenge, (details is null) ? null : details.getDetailsStruct());

		if(__p is null)
		{
			throw new ConstructionException("null returned by new");
		}

		this(cast(PolkitAuthorizationResult*) __p, true);
	}

	/**
	 * Gets the details about the result.
	 *
	 * Returns: A #PolkitDetails object or
	 *     %NULL if there are no details. This object is owned by @result and
	 *     should not be freed by the caller.
	 */
	public Details getDetails()
	{
		auto __p = polkit_authorization_result_get_details(polkitAuthorizationResult);

		if(__p is null)
		{
			return null;
		}

		return ObjectG.getDObject!(Details)(cast(PolkitDetails*) __p);
	}

	/**
	 * Gets whether the authentication request was dismissed / canceled by the user.
	 *
	 * This method simply reads the value of the key/value pair in @details with the
	 * key <literal>polkit.dismissed</literal>.
	 *
	 * Returns: %TRUE if the authentication request was dismissed, %FALSE otherwise.
	 *
	 * Since: 0.101
	 */
	public bool getDismissed()
	{
		return polkit_authorization_result_get_dismissed(polkitAuthorizationResult) != 0;
	}

	/**
	 * Gets whether the subject is authorized.
	 *
	 * If the authorization is temporary, use polkit_authorization_result_get_temporary_authorization_id()
	 * to get the opaque identifier for the temporary authorization.
	 *
	 * Returns: Whether the subject is authorized.
	 */
	public bool getIsAuthorized()
	{
		return polkit_authorization_result_get_is_authorized(polkitAuthorizationResult) != 0;
	}

	/**
	 * Gets whether the subject is authorized if more information is provided.
	 *
	 * Returns: Whether the subject is authorized if more information is provided.
	 */
	public bool getIsChallenge()
	{
		return polkit_authorization_result_get_is_challenge(polkitAuthorizationResult) != 0;
	}

	/**
	 * Gets whether authorization is retained if obtained via authentication. This can only be the case
	 * if @result indicates that the subject can obtain authorization after challenge (cf.
	 * polkit_authorization_result_get_is_challenge()), e.g. when the subject is not already authorized (cf.
	 * polkit_authorization_result_get_is_authorized()).
	 *
	 * If the subject is already authorized, use polkit_authorization_result_get_temporary_authorization_id()
	 * to check if the authorization is temporary.
	 *
	 * This method simply reads the value of the key/value pair in @details with the
	 * key <literal>polkit.retains_authorization_after_challenge</literal>.
	 *
	 * Returns: %TRUE if the authorization is or will be temporary.
	 */
	public bool getRetainsAuthorization()
	{
		return polkit_authorization_result_get_retains_authorization(polkitAuthorizationResult) != 0;
	}

	/**
	 * Gets the opaque temporary authorization id for @result if @result indicates the
	 * subject is authorized and the authorization is temporary rather than one-shot or
	 * permanent.
	 *
	 * You can use this string together with the result from
	 * polkit_authority_enumerate_temporary_authorizations() to get more details
	 * about the temporary authorization or polkit_authority_revoke_temporary_authorization_by_id()
	 * to revoke the temporary authorization.
	 *
	 * If the subject is not authorized, use polkit_authorization_result_get_retains_authorization()
	 * to check if the authorization will be retained if obtained via authentication.
	 *
	 * This method simply reads the value of the key/value pair in @details with the
	 * key <literal>polkit.temporary_authorization_id</literal>.
	 *
	 * Returns: The opaque temporary authorization id for
	 *     @result or %NULL if not available. Do not free this string, it
	 *     is owned by @result.
	 */
	public string getTemporaryAuthorizationId()
	{
		return Str.toString(polkit_authorization_result_get_temporary_authorization_id(polkitAuthorizationResult));
	}
}
