/*
 * This file is part of polkit-d.
 *
 * polkit-d is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version, with
 * some exceptions, please read the COPYING file.
 *
 * polkit-d is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with gtkD; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110, USA
 */

// generated automatically - do not change
// find conversion definition on APILookup.txt
// implement new conversion functionalities on the wrap.utils pakage

module polkit.Permission;

private import gio.AsyncInitableIF;
private import gio.AsyncInitableT;
private import gio.AsyncResultIF;
private import gio.Cancellable;
private import gio.InitableIF;
private import gio.InitableT;
private import gio.Permission : DGioPermission = Permission;
private import glib.ConstructionException;
private import glib.ErrorG;
private import glib.GException;
private import glib.Str;
private import gobject.ObjectG;
private import polkit.SubjectIF;
private import polkit.c.functions;
public  import polkit.c.types;


/**
 * #PolkitPermission is a #GPermission implementation. It can be used
 * with e.g. #GtkLockButton. See the #GPermission documentation for
 * more information.
 */
public class Permission : DGioPermission, AsyncInitableIF, InitableIF
{
	/** the main Gtk struct */
	protected PolkitPermission* polkitPermission;

	/** Get the main Gtk struct */
	public PolkitPermission* getPolkitPermissionStruct(bool transferOwnership = false)
	{
		if (transferOwnership)
			ownedRef = false;
		return polkitPermission;
	}

	/** the main Gtk struct as a void* */
	protected override void* getStruct()
	{
		return cast(void*)polkitPermission;
	}

	/**
	 * Sets our main struct and passes it to the parent class.
	 */
	public this (PolkitPermission* polkitPermission, bool ownedRef = false)
	{
		this.polkitPermission = polkitPermission;
		super(cast(GPermission*)polkitPermission, ownedRef);
	}

	// add the AsyncInitable capabilities
	mixin AsyncInitableT!(PolkitPermission);

	// add the Initable capabilities
	mixin InitableT!(PolkitPermission);


	/** */
	public static GType getType()
	{
		return polkit_permission_get_type();
	}

	/**
	 * Finishes an operation started with polkit_permission_new().
	 *
	 * Params:
	 *     res = A #GAsyncResult obtained from the #GAsyncReadyCallback passed to polkit_permission_new().
	 *
	 * Returns: A #GPermission or %NULL if @error is set.
	 *
	 * Throws: GException on failure.
	 * Throws: ConstructionException GTK+ fails to create the object.
	 */
	public this(AsyncResultIF res)
	{
		GError* err = null;

		auto __p = polkit_permission_new_finish((res is null) ? null : res.getAsyncResultStruct(), &err);

		if (err !is null)
		{
			throw new GException( new ErrorG(err) );
		}

		if(__p is null)
		{
			throw new ConstructionException("null returned by new_finish");
		}

		this(cast(PolkitPermission*) __p, true);
	}

	/**
	 * Gets the PolicyKit action identifier used for @permission.
	 *
	 * Returns: A string owned by @permission. Do not free.
	 */
	public string getActionId()
	{
		return Str.toString(polkit_permission_get_action_id(polkitPermission));
	}

	/**
	 * Gets the subject used for @permission.
	 *
	 * Returns: An object owned by @permission. Do not free.
	 */
	public SubjectIF getSubject()
	{
		auto __p = polkit_permission_get_subject(polkitPermission);

		if(__p is null)
		{
			return null;
		}

		return ObjectG.getDObject!(SubjectIF)(cast(PolkitSubject*) __p);
	}

	/**
	 * Creates a #GPermission instance for the PolicyKit action
	 * @action_id.
	 *
	 * This is a synchronous failable constructor. See
	 * polkit_permission_new() for the asynchronous version.
	 *
	 * Params:
	 *     actionId = The PolicyKit action identifier.
	 *     subject = A #PolkitSubject or %NULL for the current process.
	 *     cancellable = A #GCancellable or %NULL.
	 *
	 * Returns: A #GPermission or %NULL if @error is set.
	 *
	 * Throws: GException on failure.
	 * Throws: ConstructionException GTK+ fails to create the object.
	 */
	public this(string actionId, SubjectIF subject, Cancellable cancellable)
	{
		GError* err = null;

		auto __p = polkit_permission_new_sync(Str.toStringz(actionId), (subject is null) ? null : subject.getSubjectStruct(), (cancellable is null) ? null : cancellable.getCancellableStruct(), &err);

		if (err !is null)
		{
			throw new GException( new ErrorG(err) );
		}

		if(__p is null)
		{
			throw new ConstructionException("null returned by this");
		}

		this(cast(PolkitPermission*) __p, true);
	}
}
