/*
 * This file is part of polkit-d.
 *
 * polkit-d is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version, with
 * some exceptions, please read the COPYING file.
 *
 * polkit-d is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with gtkD; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110, USA
 */

// generated automatically - do not change
// find conversion definition on APILookup.txt
// implement new conversion functionalities on the wrap.utils pakage

module polkit.IdentityT;

public  import glib.ErrorG;
public  import glib.GException;
public  import glib.Str;
public  import gobject.ObjectG;
public  import polkit.IdentityIF;
public  import polkit.c.functions;
public  import polkit.c.types;


/**
 * #PolkitIdentity is an abstract type for representing one or more
 * identities.
 */
public template IdentityT(TStruct)
{
	/** Get the main Gtk struct */
	public PolkitIdentity* getIdentityStruct(bool transferOwnership = false)
	{
		if (transferOwnership)
			ownedRef = false;
		return cast(PolkitIdentity*)getStruct();
	}


	/**
	 * Checks if @a and @b are equal, ie. represent the same identity.
	 *
	 * This function can be used in e.g. g_hash_table_new().
	 *
	 * Params:
	 *     b = A #PolkitIdentity.
	 *
	 * Returns: %TRUE if @a and @b are equal, %FALSE otherwise.
	 */
	public bool equal(IdentityIF b)
	{
		return polkit_identity_equal(getIdentityStruct(), (b is null) ? null : b.getIdentityStruct()) != 0;
	}

	/**
	 * Gets a hash code for @identity that can be used with e.g. g_hash_table_new().
	 *
	 * Returns: A hash code.
	 */
	public uint hash()
	{
		return polkit_identity_hash(getIdentityStruct());
	}

	/**
	 * Serializes @identity to a string that can be used in
	 * polkit_identity_from_string().
	 *
	 * Returns: A string representing @identity. Free with g_free().
	 */
	public override string toString()
	{
		auto retStr = polkit_identity_to_string(getIdentityStruct());

		scope(exit) Str.freeString(retStr);
		return Str.toString(retStr);
	}
}
