/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.x500.X500Principal;
import sun.misc.HexDumpEncoder;
import sun.security.provider.X509Factory;
import sun.security.util.DerEncoder;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.util.Pem;
import sun.security.util.SignatureUtil;
import sun.security.x509.AccessDescription;
import sun.security.x509.AlgorithmId;
import sun.security.x509.AttributeNameEnumeration;
import sun.security.x509.AuthorityInfoAccessExtension;
import sun.security.x509.AuthorityKeyIdentifierExtension;
import sun.security.x509.BasicConstraintsExtension;
import sun.security.x509.CRLDistributionPointsExtension;
import sun.security.x509.CertificateExtensions;
import sun.security.x509.CertificatePoliciesExtension;
import sun.security.x509.CertificateValidity;
import sun.security.x509.DNSName;
import sun.security.x509.ExtendedKeyUsageExtension;
import sun.security.x509.Extension;
import sun.security.x509.GeneralName;
import sun.security.x509.GeneralNameInterface;
import sun.security.x509.GeneralNames;
import sun.security.x509.IPAddressName;
import sun.security.x509.IssuerAlternativeNameExtension;
import sun.security.x509.KeyIdentifier;
import sun.security.x509.KeyUsageExtension;
import sun.security.x509.NameConstraintsExtension;
import sun.security.x509.OIDMap;
import sun.security.x509.OIDName;
import sun.security.x509.PKIXExtensions;
import sun.security.x509.PolicyConstraintsExtension;
import sun.security.x509.PolicyMappingsExtension;
import sun.security.x509.PrivateKeyUsageExtension;
import sun.security.x509.RFC822Name;
import sun.security.x509.SerialNumber;
import sun.security.x509.SubjectAlternativeNameExtension;
import sun.security.x509.SubjectKeyIdentifierExtension;
import sun.security.x509.URIName;
import sun.security.x509.UniqueIdentity;
import sun.security.x509.X500Name;
import sun.security.x509.X509AttributeName;
import sun.security.x509.X509CertInfo;

public class X509CertImpl
extends X509Certificate
implements DerEncoder {
    private static final long serialVersionUID = -3457612960190864406L;
    private static final String DOT = ".";
    public static final String NAME = "x509";
    public static final String INFO = "info";
    public static final String ALG_ID = "algorithm";
    public static final String SIGNATURE = "signature";
    public static final String SIGNED_CERT = "signed_cert";
    public static final String SUBJECT_DN = "x509.info.subject.dname";
    public static final String ISSUER_DN = "x509.info.issuer.dname";
    public static final String SERIAL_ID = "x509.info.serialNumber.number";
    public static final String PUBLIC_KEY = "x509.info.key.value";
    public static final String VERSION = "x509.info.version.number";
    public static final String SIG_ALG = "x509.algorithm";
    public static final String SIG = "x509.signature";
    private boolean readOnly = false;
    private byte[] signedCert = null;
    protected X509CertInfo info = null;
    protected AlgorithmId algId = null;
    protected byte[] signature = null;
    private static final String KEY_USAGE_OID = "2.5.29.15";
    private static final String EXTENDED_KEY_USAGE_OID = "2.5.29.37";
    private static final String BASIC_CONSTRAINT_OID = "2.5.29.19";
    private static final String SUBJECT_ALT_NAME_OID = "2.5.29.17";
    private static final String ISSUER_ALT_NAME_OID = "2.5.29.18";
    private static final String AUTH_INFO_ACCESS_OID = "1.3.6.1.5.5.7.1.1";
    private static final int NUM_STANDARD_KEY_USAGE = 9;
    private Collection<List<?>> subjectAlternativeNames;
    private Collection<List<?>> issuerAlternativeNames;
    private List<String> extKeyUsage;
    private Set<AccessDescription> authInfoAccess;
    private PublicKey verifiedPublicKey;
    private String verifiedProvider;
    private boolean verificationResult;
    private ConcurrentHashMap<String, String> fingerprints = new ConcurrentHashMap(2);

    public X509CertImpl() {
    }

    public X509CertImpl(byte[] certData) throws CertificateException {
        try {
            this.parse(new DerValue(certData));
        }
        catch (IOException e) {
            this.signedCert = null;
            throw new CertificateException("Unable to initialize, " + e, e);
        }
    }

    public X509CertImpl(InputStream in) throws CertificateException {
        DerValue der = null;
        BufferedInputStream inBuffered = new BufferedInputStream(in);
        try {
            inBuffered.mark(Integer.MAX_VALUE);
            der = this.readRFC1421Cert(inBuffered);
        }
        catch (IOException ioe) {
            try {
                inBuffered.reset();
                der = new DerValue(inBuffered);
            }
            catch (IOException ioe1) {
                throw new CertificateException("Input stream must be either DER-encoded bytes or RFC1421 hex-encoded DER-encoded bytes: " + ioe1.getMessage(), ioe1);
            }
        }
        try {
            this.parse(der);
        }
        catch (IOException ioe) {
            this.signedCert = null;
            throw new CertificateException("Unable to parse DER value of certificate, " + ioe, ioe);
        }
    }

    private DerValue readRFC1421Cert(InputStream in) throws IOException {
        DerValue der = null;
        String line = null;
        BufferedReader certBufferedReader = new BufferedReader(new InputStreamReader(in, "ASCII"));
        try {
            line = certBufferedReader.readLine();
        }
        catch (IOException ioe1) {
            throw new IOException("Unable to read InputStream: " + ioe1.getMessage());
        }
        if (line.equals("-----BEGIN CERTIFICATE-----")) {
            ByteArrayOutputStream decstream = new ByteArrayOutputStream();
            try {
                while ((line = certBufferedReader.readLine()) != null) {
                    if (line.equals("-----END CERTIFICATE-----")) {
                        der = new DerValue(decstream.toByteArray());
                    }
                    decstream.write(Pem.decode(line));
                }
            }
            catch (IOException ioe2) {
                throw new IOException("Unable to read InputStream: " + ioe2.getMessage());
            }
        } else {
            throw new IOException("InputStream is not RFC1421 hex-encoded DER bytes");
        }
        return der;
    }

    public X509CertImpl(X509CertInfo certInfo) {
        this.info = certInfo;
    }

    public X509CertImpl(DerValue derVal) throws CertificateException {
        try {
            this.parse(derVal);
        }
        catch (IOException e) {
            this.signedCert = null;
            throw new CertificateException("Unable to initialize, " + e, e);
        }
    }

    public void encode(OutputStream out) throws CertificateEncodingException {
        if (this.signedCert == null) {
            throw new CertificateEncodingException("Null certificate to encode");
        }
        try {
            out.write((byte[])this.signedCert.clone());
        }
        catch (IOException e) {
            throw new CertificateEncodingException(e.toString());
        }
    }

    @Override
    public void derEncode(OutputStream out) throws IOException {
        if (this.signedCert == null) {
            throw new IOException("Null certificate to encode");
        }
        out.write((byte[])this.signedCert.clone());
    }

    @Override
    public byte[] getEncoded() throws CertificateEncodingException {
        return (byte[])this.getEncodedInternal().clone();
    }

    public byte[] getEncodedInternal() throws CertificateEncodingException {
        if (this.signedCert == null) {
            throw new CertificateEncodingException("Null certificate to encode");
        }
        return this.signedCert;
    }

    @Override
    public void verify(PublicKey key) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.verify(key, "");
    }

    @Override
    public synchronized void verify(PublicKey key, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        if (sigProvider == null) {
            sigProvider = "";
        }
        if (this.verifiedPublicKey != null && this.verifiedPublicKey.equals(key) && sigProvider.equals(this.verifiedProvider)) {
            if (this.verificationResult) {
                return;
            }
            throw new SignatureException("Signature does not match.");
        }
        if (this.signedCert == null) {
            throw new CertificateEncodingException("Uninitialized certificate");
        }
        Signature sigVerf = null;
        String sigName = this.algId.getName();
        sigVerf = sigProvider.length() == 0 ? Signature.getInstance(sigName) : Signature.getInstance(sigName, sigProvider);
        try {
            SignatureUtil.initVerifyWithParam(sigVerf, key, SignatureUtil.getParamSpec(sigName, this.getSigAlgParams()));
        }
        catch (ProviderException e) {
            throw new CertificateException(e.getMessage(), e.getCause());
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CertificateException(e);
        }
        byte[] rawCert = this.info.getEncodedInfo();
        sigVerf.update(rawCert, 0, rawCert.length);
        this.verificationResult = sigVerf.verify(this.signature);
        this.verifiedPublicKey = key;
        this.verifiedProvider = sigProvider;
        if (!this.verificationResult) {
            throw new SignatureException("Signature does not match.");
        }
    }

    @Override
    public synchronized void verify(PublicKey key, Provider sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        if (this.signedCert == null) {
            throw new CertificateEncodingException("Uninitialized certificate");
        }
        Signature sigVerf = null;
        String sigName = this.algId.getName();
        sigVerf = sigProvider == null ? Signature.getInstance(sigName) : Signature.getInstance(sigName, sigProvider);
        try {
            SignatureUtil.initVerifyWithParam(sigVerf, key, SignatureUtil.getParamSpec(sigName, this.getSigAlgParams()));
        }
        catch (ProviderException e) {
            throw new CertificateException(e.getMessage(), e.getCause());
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CertificateException(e);
        }
        byte[] rawCert = this.info.getEncodedInfo();
        sigVerf.update(rawCert, 0, rawCert.length);
        this.verificationResult = sigVerf.verify(this.signature);
        this.verifiedPublicKey = key;
        if (!this.verificationResult) {
            throw new SignatureException("Signature does not match.");
        }
    }

    public void sign(PrivateKey key, String algorithm) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.sign(key, algorithm, null);
    }

    public void sign(PrivateKey key, String algorithm, String provider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        try {
            this.sign(key, null, algorithm, provider);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new SignatureException(e);
        }
    }

    public void sign(PrivateKey key, AlgorithmParameterSpec signingParams, String algorithm, String provider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException, NoSuchProviderException, SignatureException {
        try {
            if (this.readOnly) {
                throw new CertificateEncodingException("cannot over-write existing certificate");
            }
            Signature sigEngine = null;
            sigEngine = provider == null || provider.length() == 0 ? Signature.getInstance(algorithm) : Signature.getInstance(algorithm, provider);
            SignatureUtil.initSignWithParam(sigEngine, key, signingParams, null);
            this.algId = signingParams != null ? AlgorithmId.get(sigEngine.getParameters()) : AlgorithmId.get(algorithm);
            DerOutputStream out = new DerOutputStream();
            DerOutputStream tmp = new DerOutputStream();
            this.info.encode(tmp);
            byte[] rawCert = tmp.toByteArray();
            this.algId.encode(tmp);
            sigEngine.update(rawCert, 0, rawCert.length);
            this.signature = sigEngine.sign();
            tmp.putBitString(this.signature);
            out.write((byte)48, tmp);
            this.signedCert = out.toByteArray();
            this.readOnly = true;
        }
        catch (IOException e) {
            throw new CertificateEncodingException(e.toString());
        }
    }

    @Override
    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        Date date = new Date();
        this.checkValidity(date);
    }

    @Override
    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        CertificateValidity interval = null;
        try {
            interval = (CertificateValidity)this.info.get("validity");
        }
        catch (Exception e) {
            throw new CertificateNotYetValidException("Incorrect validity period");
        }
        if (interval == null) {
            throw new CertificateNotYetValidException("Null validity period");
        }
        interval.valid(date);
    }

    public Object get(String name) throws CertificateParsingException {
        X509AttributeName attr = new X509AttributeName(name);
        String id = attr.getPrefix();
        if (!id.equalsIgnoreCase(NAME)) {
            throw new CertificateParsingException("Invalid root of attribute name, expected [x509], received [" + id + "]");
        }
        id = (attr = new X509AttributeName(attr.getSuffix())).getPrefix();
        if (id.equalsIgnoreCase(INFO)) {
            if (this.info == null) {
                return null;
            }
            if (attr.getSuffix() != null) {
                try {
                    return this.info.get(attr.getSuffix());
                }
                catch (IOException e) {
                    throw new CertificateParsingException(e.toString());
                }
                catch (CertificateException e) {
                    throw new CertificateParsingException(e.toString());
                }
            }
            return this.info;
        }
        if (id.equalsIgnoreCase(ALG_ID)) {
            return this.algId;
        }
        if (id.equalsIgnoreCase(SIGNATURE)) {
            if (this.signature != null) {
                return this.signature.clone();
            }
            return null;
        }
        if (id.equalsIgnoreCase(SIGNED_CERT)) {
            if (this.signedCert != null) {
                return this.signedCert.clone();
            }
            return null;
        }
        throw new CertificateParsingException("Attribute name not recognized or get() not allowed for the same: " + id);
    }

    public void set(String name, Object obj) throws CertificateException, IOException {
        if (this.readOnly) {
            throw new CertificateException("cannot over-write existing certificate");
        }
        X509AttributeName attr = new X509AttributeName(name);
        String id = attr.getPrefix();
        if (!id.equalsIgnoreCase(NAME)) {
            throw new CertificateException("Invalid root of attribute name, expected [x509], received " + id);
        }
        id = (attr = new X509AttributeName(attr.getSuffix())).getPrefix();
        if (id.equalsIgnoreCase(INFO)) {
            if (attr.getSuffix() == null) {
                if (!(obj instanceof X509CertInfo)) {
                    throw new CertificateException("Attribute value should be of type X509CertInfo.");
                }
                this.info = (X509CertInfo)obj;
                this.signedCert = null;
            } else {
                this.info.set(attr.getSuffix(), obj);
                this.signedCert = null;
            }
        } else {
            throw new CertificateException("Attribute name not recognized or set() not allowed for the same: " + id);
        }
    }

    public void delete(String name) throws CertificateException, IOException {
        if (this.readOnly) {
            throw new CertificateException("cannot over-write existing certificate");
        }
        X509AttributeName attr = new X509AttributeName(name);
        String id = attr.getPrefix();
        if (!id.equalsIgnoreCase(NAME)) {
            throw new CertificateException("Invalid root of attribute name, expected [x509], received " + id);
        }
        id = (attr = new X509AttributeName(attr.getSuffix())).getPrefix();
        if (id.equalsIgnoreCase(INFO)) {
            if (attr.getSuffix() != null) {
                this.info = null;
            } else {
                this.info.delete(attr.getSuffix());
            }
        } else if (id.equalsIgnoreCase(ALG_ID)) {
            this.algId = null;
        } else if (id.equalsIgnoreCase(SIGNATURE)) {
            this.signature = null;
        } else if (id.equalsIgnoreCase(SIGNED_CERT)) {
            this.signedCert = null;
        } else {
            throw new CertificateException("Attribute name not recognized or delete() not allowed for the same: " + id);
        }
    }

    public Enumeration<String> getElements() {
        AttributeNameEnumeration elements = new AttributeNameEnumeration();
        elements.addElement("x509.info");
        elements.addElement(SIG_ALG);
        elements.addElement(SIG);
        elements.addElement("x509.signed_cert");
        return elements.elements();
    }

    public String getName() {
        return NAME;
    }

    @Override
    public String toString() {
        if (this.info == null || this.algId == null || this.signature == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[\n");
        sb.append(this.info.toString() + "\n");
        sb.append("  Algorithm: [" + this.algId.toString() + "]\n");
        HexDumpEncoder encoder = new HexDumpEncoder();
        sb.append("  Signature:\n" + encoder.encodeBuffer(this.signature));
        sb.append("\n]");
        return sb.toString();
    }

    @Override
    public PublicKey getPublicKey() {
        if (this.info == null) {
            return null;
        }
        try {
            PublicKey key = (PublicKey)this.info.get("key.value");
            return key;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public int getVersion() {
        if (this.info == null) {
            return -1;
        }
        try {
            int vers = (Integer)this.info.get("version.number");
            return vers + 1;
        }
        catch (Exception e) {
            return -1;
        }
    }

    @Override
    public BigInteger getSerialNumber() {
        SerialNumber ser = this.getSerialNumberObject();
        return ser != null ? ser.getNumber() : null;
    }

    public SerialNumber getSerialNumberObject() {
        if (this.info == null) {
            return null;
        }
        try {
            SerialNumber ser = (SerialNumber)this.info.get("serialNumber.number");
            return ser;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Principal getSubjectDN() {
        if (this.info == null) {
            return null;
        }
        try {
            Principal subject = (Principal)this.info.get("subject.dname");
            return subject;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public X500Principal getSubjectX500Principal() {
        if (this.info == null) {
            return null;
        }
        try {
            X500Principal subject = (X500Principal)this.info.get("subject.x500principal");
            return subject;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Principal getIssuerDN() {
        if (this.info == null) {
            return null;
        }
        try {
            Principal issuer = (Principal)this.info.get("issuer.dname");
            return issuer;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public X500Principal getIssuerX500Principal() {
        if (this.info == null) {
            return null;
        }
        try {
            X500Principal issuer = (X500Principal)this.info.get("issuer.x500principal");
            return issuer;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Date getNotBefore() {
        if (this.info == null) {
            return null;
        }
        try {
            Date d = (Date)this.info.get("validity.notBefore");
            return d;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Date getNotAfter() {
        if (this.info == null) {
            return null;
        }
        try {
            Date d = (Date)this.info.get("validity.notAfter");
            return d;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public byte[] getTBSCertificate() throws CertificateEncodingException {
        if (this.info != null) {
            return this.info.getEncodedInfo();
        }
        throw new CertificateEncodingException("Uninitialized certificate");
    }

    @Override
    public byte[] getSignature() {
        if (this.signature == null) {
            return null;
        }
        return (byte[])this.signature.clone();
    }

    @Override
    public String getSigAlgName() {
        if (this.algId == null) {
            return null;
        }
        return this.algId.getName();
    }

    @Override
    public String getSigAlgOID() {
        if (this.algId == null) {
            return null;
        }
        ObjectIdentifier oid = this.algId.getOID();
        return oid.toString();
    }

    @Override
    public byte[] getSigAlgParams() {
        if (this.algId == null) {
            return null;
        }
        try {
            return this.algId.getEncodedParams();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public boolean[] getIssuerUniqueID() {
        if (this.info == null) {
            return null;
        }
        try {
            UniqueIdentity id = (UniqueIdentity)this.info.get("issuerID");
            if (id == null) {
                return null;
            }
            return id.getId();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean[] getSubjectUniqueID() {
        if (this.info == null) {
            return null;
        }
        try {
            UniqueIdentity id = (UniqueIdentity)this.info.get("subjectID");
            if (id == null) {
                return null;
            }
            return id.getId();
        }
        catch (Exception e) {
            return null;
        }
    }

    public KeyIdentifier getAuthKeyId() {
        AuthorityKeyIdentifierExtension aki = this.getAuthorityKeyIdentifierExtension();
        if (aki != null) {
            try {
                return (KeyIdentifier)aki.get("key_id");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public KeyIdentifier getSubjectKeyId() {
        SubjectKeyIdentifierExtension ski = this.getSubjectKeyIdentifierExtension();
        if (ski != null) {
            try {
                return ski.get("key_id");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public AuthorityKeyIdentifierExtension getAuthorityKeyIdentifierExtension() {
        return (AuthorityKeyIdentifierExtension)this.getExtension(PKIXExtensions.AuthorityKey_Id);
    }

    public BasicConstraintsExtension getBasicConstraintsExtension() {
        return (BasicConstraintsExtension)this.getExtension(PKIXExtensions.BasicConstraints_Id);
    }

    public CertificatePoliciesExtension getCertificatePoliciesExtension() {
        return (CertificatePoliciesExtension)this.getExtension(PKIXExtensions.CertificatePolicies_Id);
    }

    public ExtendedKeyUsageExtension getExtendedKeyUsageExtension() {
        return (ExtendedKeyUsageExtension)this.getExtension(PKIXExtensions.ExtendedKeyUsage_Id);
    }

    public IssuerAlternativeNameExtension getIssuerAlternativeNameExtension() {
        return (IssuerAlternativeNameExtension)this.getExtension(PKIXExtensions.IssuerAlternativeName_Id);
    }

    public NameConstraintsExtension getNameConstraintsExtension() {
        return (NameConstraintsExtension)this.getExtension(PKIXExtensions.NameConstraints_Id);
    }

    public PolicyConstraintsExtension getPolicyConstraintsExtension() {
        return (PolicyConstraintsExtension)this.getExtension(PKIXExtensions.PolicyConstraints_Id);
    }

    public PolicyMappingsExtension getPolicyMappingsExtension() {
        return (PolicyMappingsExtension)this.getExtension(PKIXExtensions.PolicyMappings_Id);
    }

    public PrivateKeyUsageExtension getPrivateKeyUsageExtension() {
        return (PrivateKeyUsageExtension)this.getExtension(PKIXExtensions.PrivateKeyUsage_Id);
    }

    public SubjectAlternativeNameExtension getSubjectAlternativeNameExtension() {
        return (SubjectAlternativeNameExtension)this.getExtension(PKIXExtensions.SubjectAlternativeName_Id);
    }

    public SubjectKeyIdentifierExtension getSubjectKeyIdentifierExtension() {
        return (SubjectKeyIdentifierExtension)this.getExtension(PKIXExtensions.SubjectKey_Id);
    }

    public CRLDistributionPointsExtension getCRLDistributionPointsExtension() {
        return (CRLDistributionPointsExtension)this.getExtension(PKIXExtensions.CRLDistributionPoints_Id);
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        if (this.info == null) {
            return false;
        }
        try {
            CertificateExtensions exts = (CertificateExtensions)this.info.get("extensions");
            if (exts == null) {
                return false;
            }
            return exts.hasUnsupportedCriticalExtension();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Set<String> getCriticalExtensionOIDs() {
        if (this.info == null) {
            return null;
        }
        try {
            CertificateExtensions exts = (CertificateExtensions)this.info.get("extensions");
            if (exts == null) {
                return null;
            }
            TreeSet<String> extSet = new TreeSet<String>();
            for (Extension ex : exts.getAllExtensions()) {
                if (!ex.isCritical()) continue;
                extSet.add(ex.getExtensionId().toString());
            }
            return extSet;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Set<String> getNonCriticalExtensionOIDs() {
        if (this.info == null) {
            return null;
        }
        try {
            CertificateExtensions exts = (CertificateExtensions)this.info.get("extensions");
            if (exts == null) {
                return null;
            }
            TreeSet<String> extSet = new TreeSet<String>();
            for (Extension ex : exts.getAllExtensions()) {
                if (ex.isCritical()) continue;
                extSet.add(ex.getExtensionId().toString());
            }
            extSet.addAll(exts.getUnparseableExtensions().keySet());
            return extSet;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Extension getExtension(ObjectIdentifier oid) {
        if (this.info == null) {
            return null;
        }
        try {
            CertificateExtensions extensions;
            try {
                extensions = (CertificateExtensions)this.info.get("extensions");
            }
            catch (CertificateException ce) {
                return null;
            }
            if (extensions == null) {
                return null;
            }
            Extension ex = extensions.getExtension(oid.toString());
            if (ex != null) {
                return ex;
            }
            for (Extension ex2 : extensions.getAllExtensions()) {
                if (!ex2.getExtensionId().equals((Object)oid)) continue;
                return ex2;
            }
            return null;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public Extension getUnparseableExtension(ObjectIdentifier oid) {
        if (this.info == null) {
            return null;
        }
        try {
            CertificateExtensions extensions;
            try {
                extensions = (CertificateExtensions)this.info.get("extensions");
            }
            catch (CertificateException ce) {
                return null;
            }
            if (extensions == null) {
                return null;
            }
            return extensions.getUnparseableExtensions().get(oid.toString());
        }
        catch (IOException ioe) {
            return null;
        }
    }

    @Override
    public byte[] getExtensionValue(String oid) {
        try {
            byte[] extData;
            ObjectIdentifier findOID = new ObjectIdentifier(oid);
            String extAlias = OIDMap.getName(findOID);
            Extension certExt = null;
            CertificateExtensions exts = (CertificateExtensions)this.info.get("extensions");
            if (extAlias == null) {
                if (exts == null) {
                    return null;
                }
                for (Extension ex : exts.getAllExtensions()) {
                    ObjectIdentifier inCertOID = ex.getExtensionId();
                    if (!inCertOID.equals((Object)findOID)) continue;
                    certExt = ex;
                    break;
                }
            } else {
                try {
                    certExt = (Extension)this.get(extAlias);
                }
                catch (CertificateException certificateException) {
                    // empty catch block
                }
            }
            if (certExt == null) {
                if (exts != null) {
                    certExt = exts.getUnparseableExtensions().get(oid);
                }
                if (certExt == null) {
                    return null;
                }
            }
            if ((extData = certExt.getExtensionValue()) == null) {
                return null;
            }
            DerOutputStream out = new DerOutputStream();
            out.putOctetString(extData);
            return out.toByteArray();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean[] getKeyUsage() {
        try {
            String extAlias = OIDMap.getName(PKIXExtensions.KeyUsage_Id);
            if (extAlias == null) {
                return null;
            }
            KeyUsageExtension certExt = (KeyUsageExtension)this.get(extAlias);
            if (certExt == null) {
                return null;
            }
            boolean[] ret = certExt.getBits();
            if (ret.length < 9) {
                boolean[] usageBits = new boolean[9];
                System.arraycopy(ret, 0, usageBits, 0, ret.length);
                ret = usageBits;
            }
            return ret;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public synchronized List<String> getExtendedKeyUsage() throws CertificateParsingException {
        if (this.readOnly && this.extKeyUsage != null) {
            return this.extKeyUsage;
        }
        ExtendedKeyUsageExtension ext = this.getExtendedKeyUsageExtension();
        if (ext == null) {
            return null;
        }
        this.extKeyUsage = Collections.unmodifiableList(ext.getExtendedKeyUsage());
        return this.extKeyUsage;
    }

    public static List<String> getExtendedKeyUsage(X509Certificate cert) throws CertificateParsingException {
        try {
            byte[] ext = cert.getExtensionValue(EXTENDED_KEY_USAGE_OID);
            if (ext == null) {
                return null;
            }
            DerValue val = new DerValue(ext);
            byte[] data = val.getOctetString();
            ExtendedKeyUsageExtension ekuExt = new ExtendedKeyUsageExtension(Boolean.FALSE, data);
            return Collections.unmodifiableList(ekuExt.getExtendedKeyUsage());
        }
        catch (IOException ioe) {
            throw new CertificateParsingException(ioe);
        }
    }

    @Override
    public int getBasicConstraints() {
        try {
            String extAlias = OIDMap.getName(PKIXExtensions.BasicConstraints_Id);
            if (extAlias == null) {
                return -1;
            }
            BasicConstraintsExtension certExt = (BasicConstraintsExtension)this.get(extAlias);
            if (certExt == null) {
                return -1;
            }
            if (((Boolean)certExt.get("is_ca")).booleanValue()) {
                return (Integer)certExt.get("path_len");
            }
            return -1;
        }
        catch (Exception e) {
            return -1;
        }
    }

    private static Collection<List<?>> makeAltNames(GeneralNames names) {
        if (names.isEmpty()) {
            return Collections.emptySet();
        }
        ArrayList newNames = new ArrayList();
        for (GeneralName gname : names.names()) {
            GeneralNameInterface name = gname.getName();
            ArrayList<Object> nameEntry = new ArrayList<Object>(2);
            nameEntry.add(name.getType());
            switch (name.getType()) {
                case 1: {
                    nameEntry.add(((RFC822Name)name).getName());
                    break;
                }
                case 2: {
                    nameEntry.add(((DNSName)name).getName());
                    break;
                }
                case 4: {
                    nameEntry.add(((X500Name)name).getRFC2253Name());
                    break;
                }
                case 6: {
                    nameEntry.add(((URIName)name).getName());
                    break;
                }
                case 7: {
                    try {
                        nameEntry.add(((IPAddressName)name).getName());
                        break;
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException("IPAddress cannot be parsed", ioe);
                    }
                }
                case 8: {
                    nameEntry.add(((OIDName)name).getOID().toString());
                    break;
                }
                default: {
                    DerOutputStream derOut = new DerOutputStream();
                    try {
                        name.encode(derOut);
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException("name cannot be encoded", ioe);
                    }
                    nameEntry.add(derOut.toByteArray());
                }
            }
            newNames.add(Collections.unmodifiableList(nameEntry));
        }
        return Collections.unmodifiableCollection(newNames);
    }

    private static Collection<List<?>> cloneAltNames(Collection<List<?>> altNames) {
        boolean mustClone = false;
        for (List<?> nameEntry : altNames) {
            if (!(nameEntry.get(1) instanceof byte[])) continue;
            mustClone = true;
        }
        if (mustClone) {
            ArrayList namesCopy = new ArrayList();
            for (List<?> nameEntry : altNames) {
                Object nameObject = nameEntry.get(1);
                if (nameObject instanceof byte[]) {
                    ArrayList nameEntryCopy = new ArrayList(nameEntry);
                    nameEntryCopy.set(1, ((byte[])nameObject).clone());
                    namesCopy.add(Collections.unmodifiableList(nameEntryCopy));
                    continue;
                }
                namesCopy.add(nameEntry);
            }
            return Collections.unmodifiableCollection(namesCopy);
        }
        return altNames;
    }

    @Override
    public synchronized Collection<List<?>> getSubjectAlternativeNames() throws CertificateParsingException {
        GeneralNames names;
        if (this.readOnly && this.subjectAlternativeNames != null) {
            return X509CertImpl.cloneAltNames(this.subjectAlternativeNames);
        }
        SubjectAlternativeNameExtension subjectAltNameExt = this.getSubjectAlternativeNameExtension();
        if (subjectAltNameExt == null) {
            return null;
        }
        try {
            names = subjectAltNameExt.get("subject_name");
        }
        catch (IOException ioe) {
            return Collections.emptySet();
        }
        this.subjectAlternativeNames = X509CertImpl.makeAltNames(names);
        return this.subjectAlternativeNames;
    }

    public static Collection<List<?>> getSubjectAlternativeNames(X509Certificate cert) throws CertificateParsingException {
        try {
            GeneralNames names;
            byte[] ext = cert.getExtensionValue(SUBJECT_ALT_NAME_OID);
            if (ext == null) {
                return null;
            }
            DerValue val = new DerValue(ext);
            byte[] data = val.getOctetString();
            SubjectAlternativeNameExtension subjectAltNameExt = new SubjectAlternativeNameExtension(Boolean.FALSE, data);
            try {
                names = subjectAltNameExt.get("subject_name");
            }
            catch (IOException ioe) {
                return Collections.emptySet();
            }
            return X509CertImpl.makeAltNames(names);
        }
        catch (IOException ioe) {
            throw new CertificateParsingException(ioe);
        }
    }

    @Override
    public synchronized Collection<List<?>> getIssuerAlternativeNames() throws CertificateParsingException {
        GeneralNames names;
        if (this.readOnly && this.issuerAlternativeNames != null) {
            return X509CertImpl.cloneAltNames(this.issuerAlternativeNames);
        }
        IssuerAlternativeNameExtension issuerAltNameExt = this.getIssuerAlternativeNameExtension();
        if (issuerAltNameExt == null) {
            return null;
        }
        try {
            names = issuerAltNameExt.get("issuer_name");
        }
        catch (IOException ioe) {
            return Collections.emptySet();
        }
        this.issuerAlternativeNames = X509CertImpl.makeAltNames(names);
        return this.issuerAlternativeNames;
    }

    public static Collection<List<?>> getIssuerAlternativeNames(X509Certificate cert) throws CertificateParsingException {
        try {
            GeneralNames names;
            byte[] ext = cert.getExtensionValue(ISSUER_ALT_NAME_OID);
            if (ext == null) {
                return null;
            }
            DerValue val = new DerValue(ext);
            byte[] data = val.getOctetString();
            IssuerAlternativeNameExtension issuerAltNameExt = new IssuerAlternativeNameExtension(Boolean.FALSE, data);
            try {
                names = issuerAltNameExt.get("issuer_name");
            }
            catch (IOException ioe) {
                return Collections.emptySet();
            }
            return X509CertImpl.makeAltNames(names);
        }
        catch (IOException ioe) {
            throw new CertificateParsingException(ioe);
        }
    }

    public AuthorityInfoAccessExtension getAuthorityInfoAccessExtension() {
        return (AuthorityInfoAccessExtension)this.getExtension(PKIXExtensions.AuthInfoAccess_Id);
    }

    private void parse(DerValue val) throws CertificateException, IOException {
        if (this.readOnly) {
            throw new CertificateParsingException("cannot over-write existing certificate");
        }
        if (val.data == null || val.tag != 48) {
            throw new CertificateParsingException("invalid DER-encoded certificate data");
        }
        this.signedCert = val.toByteArray();
        DerValue[] seq = new DerValue[]{val.data.getDerValue(), val.data.getDerValue(), val.data.getDerValue()};
        if (val.data.available() != 0) {
            throw new CertificateParsingException("signed overrun, bytes = " + val.data.available());
        }
        if (seq[0].tag != 48) {
            throw new CertificateParsingException("signed fields invalid");
        }
        this.algId = AlgorithmId.parse(seq[1]);
        this.signature = seq[2].getBitString();
        if (seq[1].data.available() != 0) {
            throw new CertificateParsingException("algid field overrun");
        }
        if (seq[2].data.available() != 0) {
            throw new CertificateParsingException("signed fields overrun");
        }
        this.info = new X509CertInfo(seq[0]);
        AlgorithmId infoSigAlg = (AlgorithmId)this.info.get("algorithmID.algorithm");
        if (!this.algId.equals(infoSigAlg)) {
            throw new CertificateException("Signature algorithm mismatch");
        }
        this.readOnly = true;
    }

    private static X500Principal getX500Principal(X509Certificate cert, boolean getIssuer) throws Exception {
        byte[] encoded = cert.getEncoded();
        DerInputStream derIn = new DerInputStream(encoded);
        DerValue tbsCert = derIn.getSequence(3)[0];
        DerInputStream tbsIn = tbsCert.data;
        DerValue tmp = tbsIn.getDerValue();
        if (tmp.isContextSpecific((byte)0)) {
            tmp = tbsIn.getDerValue();
        }
        tmp = tbsIn.getDerValue();
        tmp = tbsIn.getDerValue();
        if (!getIssuer) {
            tmp = tbsIn.getDerValue();
            tmp = tbsIn.getDerValue();
        }
        byte[] principalBytes = tmp.toByteArray();
        return new X500Principal(principalBytes);
    }

    public static X500Principal getSubjectX500Principal(X509Certificate cert) {
        try {
            return X509CertImpl.getX500Principal(cert, false);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not parse subject", e);
        }
    }

    public static X500Principal getIssuerX500Principal(X509Certificate cert) {
        try {
            return X509CertImpl.getX500Principal(cert, true);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not parse issuer", e);
        }
    }

    public static byte[] getEncodedInternal(Certificate cert) throws CertificateEncodingException {
        if (cert instanceof X509CertImpl) {
            return ((X509CertImpl)cert).getEncodedInternal();
        }
        return cert.getEncoded();
    }

    public static X509CertImpl toImpl(X509Certificate cert) throws CertificateException {
        if (cert instanceof X509CertImpl) {
            return (X509CertImpl)cert;
        }
        return X509Factory.intern(cert);
    }

    public static boolean isSelfIssued(X509Certificate cert) {
        X500Principal subject = cert.getSubjectX500Principal();
        X500Principal issuer = cert.getIssuerX500Principal();
        return subject.equals(issuer);
    }

    public static boolean isSelfSigned(X509Certificate cert, String sigProvider) {
        if (X509CertImpl.isSelfIssued(cert)) {
            try {
                if (sigProvider == null) {
                    cert.verify(cert.getPublicKey());
                } else {
                    cert.verify(cert.getPublicKey(), sigProvider);
                }
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public String getFingerprint(String algorithm) {
        return this.fingerprints.computeIfAbsent(algorithm, x -> X509CertImpl.getFingerprint(x, this));
    }

    public static String getFingerprint(String algorithm, X509Certificate cert) {
        String fingerPrint = "";
        try {
            byte[] encCertInfo = cert.getEncoded();
            MessageDigest md = MessageDigest.getInstance(algorithm);
            byte[] digest = md.digest(encCertInfo);
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < digest.length; ++i) {
                X509CertImpl.byte2hex(digest[i], buf);
            }
            fingerPrint = buf.toString();
        }
        catch (NoSuchAlgorithmException | CertificateEncodingException generalSecurityException) {
            // empty catch block
        }
        return fingerPrint;
    }

    private static void byte2hex(byte b, StringBuffer buf) {
        char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int high = (b & 0xF0) >> 4;
        int low = b & 0xF;
        buf.append(hexChars[high]);
        buf.append(hexChars[low]);
    }
}

