/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.ProviderException;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import sun.security.rsa.PSSParameters;
import sun.security.util.DerEncoder;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.KeyUtil;
import sun.security.util.ObjectIdentifier;

public class AlgorithmId
implements Serializable,
DerEncoder {
    private static final long serialVersionUID = 7205873507486557157L;
    private ObjectIdentifier algid;
    private AlgorithmParameters algParams;
    private boolean constructedFromDer = true;
    protected DerValue params;
    private static boolean initOidTable = false;
    private static Map<String, ObjectIdentifier> oidTable;
    private static final Map<ObjectIdentifier, String> nameTable;
    public static final ObjectIdentifier MD2_oid;
    public static final ObjectIdentifier MD5_oid;
    public static final ObjectIdentifier SHA_oid;
    public static final ObjectIdentifier SHA224_oid;
    public static final ObjectIdentifier SHA256_oid;
    public static final ObjectIdentifier SHA384_oid;
    public static final ObjectIdentifier SHA512_oid;
    public static final ObjectIdentifier SHA512_224_oid;
    public static final ObjectIdentifier SHA512_256_oid;
    private static final int[] DH_data;
    private static final int[] DH_PKIX_data;
    private static final int[] DSA_OIW_data;
    private static final int[] DSA_PKIX_data;
    private static final int[] RSA_data;
    public static final ObjectIdentifier DH_oid;
    public static final ObjectIdentifier DH_PKIX_oid;
    public static final ObjectIdentifier DSA_oid;
    public static final ObjectIdentifier DSA_OIW_oid;
    public static final ObjectIdentifier EC_oid;
    public static final ObjectIdentifier ECDH_oid;
    public static final ObjectIdentifier RSA_oid;
    public static final ObjectIdentifier RSAEncryption_oid;
    public static final ObjectIdentifier RSAES_OAEP_oid;
    public static final ObjectIdentifier mgf1_oid;
    public static final ObjectIdentifier RSASSA_PSS_oid;
    public static final ObjectIdentifier AES_oid;
    private static final int[] md2WithRSAEncryption_data;
    private static final int[] md5WithRSAEncryption_data;
    private static final int[] sha1WithRSAEncryption_data;
    private static final int[] sha1WithRSAEncryption_OIW_data;
    private static final int[] sha224WithRSAEncryption_data;
    private static final int[] sha256WithRSAEncryption_data;
    private static final int[] sha384WithRSAEncryption_data;
    private static final int[] sha512WithRSAEncryption_data;
    private static final int[] shaWithDSA_OIW_data;
    private static final int[] sha1WithDSA_OIW_data;
    private static final int[] dsaWithSHA1_PKIX_data;
    public static final ObjectIdentifier md2WithRSAEncryption_oid;
    public static final ObjectIdentifier md5WithRSAEncryption_oid;
    public static final ObjectIdentifier sha1WithRSAEncryption_oid;
    public static final ObjectIdentifier sha1WithRSAEncryption_OIW_oid;
    public static final ObjectIdentifier sha224WithRSAEncryption_oid;
    public static final ObjectIdentifier sha256WithRSAEncryption_oid;
    public static final ObjectIdentifier sha384WithRSAEncryption_oid;
    public static final ObjectIdentifier sha512WithRSAEncryption_oid;
    public static final ObjectIdentifier sha512_224WithRSAEncryption_oid;
    public static final ObjectIdentifier sha512_256WithRSAEncryption_oid;
    public static final ObjectIdentifier shaWithDSA_OIW_oid;
    public static final ObjectIdentifier sha1WithDSA_OIW_oid;
    public static final ObjectIdentifier sha1WithDSA_oid;
    public static final ObjectIdentifier sha224WithDSA_oid;
    public static final ObjectIdentifier sha256WithDSA_oid;
    public static final ObjectIdentifier sha1WithECDSA_oid;
    public static final ObjectIdentifier sha224WithECDSA_oid;
    public static final ObjectIdentifier sha256WithECDSA_oid;
    public static final ObjectIdentifier sha384WithECDSA_oid;
    public static final ObjectIdentifier sha512WithECDSA_oid;
    public static final ObjectIdentifier specifiedWithECDSA_oid;
    public static final ObjectIdentifier pbeWithMD5AndDES_oid;
    public static final ObjectIdentifier pbeWithMD5AndRC2_oid;
    public static final ObjectIdentifier pbeWithSHA1AndDES_oid;
    public static final ObjectIdentifier pbeWithSHA1AndRC2_oid;
    public static ObjectIdentifier pbeWithSHA1AndDESede_oid;
    public static ObjectIdentifier pbeWithSHA1AndRC2_40_oid;

    @Deprecated
    public AlgorithmId() {
    }

    public AlgorithmId(ObjectIdentifier oid) {
        this.algid = oid;
    }

    public AlgorithmId(ObjectIdentifier oid, AlgorithmParameters algparams) {
        this.algid = oid;
        this.algParams = algparams;
        this.constructedFromDer = false;
    }

    private AlgorithmId(ObjectIdentifier oid, DerValue params) throws IOException {
        this.algid = oid;
        this.params = params;
        if (this.params != null) {
            this.decodeParams();
        }
    }

    protected void decodeParams() throws IOException {
        String algidName = this.getName();
        try {
            this.algParams = AlgorithmParameters.getInstance(algidName);
        }
        catch (NoSuchAlgorithmException e) {
            this.algParams = null;
            return;
        }
        this.algParams.init(this.params.toByteArray());
    }

    public final void encode(DerOutputStream out) throws IOException {
        this.derEncode(out);
    }

    @Override
    public void derEncode(OutputStream out) throws IOException {
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream tmp = new DerOutputStream();
        bytes.putOID(this.algid);
        if (!this.constructedFromDer) {
            this.params = this.algParams != null ? new DerValue(this.algParams.getEncoded()) : null;
        }
        if (this.params == null) {
            if (!this.algid.equals(RSASSA_PSS_oid)) {
                bytes.putNull();
            }
        } else {
            bytes.putDerValue(this.params);
        }
        tmp.write((byte)48, bytes);
        out.write(tmp.toByteArray());
    }

    public final byte[] encode() throws IOException {
        DerOutputStream out = new DerOutputStream();
        this.derEncode(out);
        return out.toByteArray();
    }

    public final ObjectIdentifier getOID() {
        return this.algid;
    }

    public String getName() {
        String algName = nameTable.get(this.algid);
        if (algName != null) {
            return algName;
        }
        if (this.params != null && this.algid.equals((Object)specifiedWithECDSA_oid)) {
            try {
                AlgorithmId paramsId = AlgorithmId.parse(new DerValue(this.params.toByteArray()));
                String paramsName = paramsId.getName();
                algName = AlgorithmId.makeSigAlg(paramsName, "EC");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return algName == null ? this.algid.toString() : algName;
    }

    public AlgorithmParameters getParameters() {
        return this.algParams;
    }

    public byte[] getEncodedParams() throws IOException {
        return this.params == null || this.algid.equals(specifiedWithECDSA_oid) ? null : this.params.toByteArray();
    }

    public boolean equals(AlgorithmId other) {
        boolean paramsEqual = this.params == null ? other.params == null : this.params.equals(other.params);
        return this.algid.equals((Object)other.algid) && paramsEqual;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof AlgorithmId) {
            return this.equals((AlgorithmId)other);
        }
        if (other instanceof ObjectIdentifier) {
            return this.equals((ObjectIdentifier)other);
        }
        return false;
    }

    public final boolean equals(ObjectIdentifier id) {
        return this.algid.equals((Object)id);
    }

    public int hashCode() {
        StringBuilder sbuf = new StringBuilder();
        sbuf.append(this.algid.toString());
        sbuf.append(this.paramsToString());
        return sbuf.toString().hashCode();
    }

    protected String paramsToString() {
        if (this.params == null) {
            return "";
        }
        if (this.algParams != null) {
            return this.algParams.toString();
        }
        return ", params unparsed";
    }

    public String toString() {
        return this.getName() + this.paramsToString();
    }

    public static AlgorithmId parse(DerValue val) throws IOException {
        DerValue params;
        if (val.tag != 48) {
            throw new IOException("algid parse error, not a sequence");
        }
        DerInputStream in = val.toDerInputStream();
        ObjectIdentifier algid = in.getOID();
        if (in.available() == 0) {
            params = null;
        } else {
            params = in.getDerValue();
            if (params.tag == 5) {
                if (params.length() != 0) {
                    throw new IOException("invalid NULL");
                }
                params = null;
            }
            if (in.available() != 0) {
                throw new IOException("Invalid AlgorithmIdentifier: extra data");
            }
        }
        return new AlgorithmId(algid, params);
    }

    @Deprecated
    public static AlgorithmId getAlgorithmId(String algname) throws NoSuchAlgorithmException {
        return AlgorithmId.get(algname);
    }

    public static AlgorithmId get(String algname) throws NoSuchAlgorithmException {
        ObjectIdentifier oid;
        try {
            oid = AlgorithmId.algOID(algname);
        }
        catch (IOException ioe) {
            throw new NoSuchAlgorithmException("Invalid ObjectIdentifier " + algname);
        }
        if (oid == null) {
            throw new NoSuchAlgorithmException("unrecognized algorithm name: " + algname);
        }
        return new AlgorithmId(oid);
    }

    public static AlgorithmId get(AlgorithmParameters algparams) throws NoSuchAlgorithmException {
        ObjectIdentifier oid;
        String algname = algparams.getAlgorithm();
        try {
            oid = AlgorithmId.algOID(algname);
        }
        catch (IOException ioe) {
            throw new NoSuchAlgorithmException("Invalid ObjectIdentifier " + algname);
        }
        if (oid == null) {
            throw new NoSuchAlgorithmException("unrecognized algorithm name: " + algname);
        }
        return new AlgorithmId(oid, algparams);
    }

    private static ObjectIdentifier algOID(String name) throws IOException {
        if (name.indexOf(46) != -1) {
            if (name.startsWith("OID.")) {
                return new ObjectIdentifier(name.substring("OID.".length()));
            }
            return new ObjectIdentifier(name);
        }
        if (name.equalsIgnoreCase("MD5")) {
            return MD5_oid;
        }
        if (name.equalsIgnoreCase("MD2")) {
            return MD2_oid;
        }
        if (name.equalsIgnoreCase("SHA") || name.equalsIgnoreCase("SHA1") || name.equalsIgnoreCase("SHA-1")) {
            return SHA_oid;
        }
        if (name.equalsIgnoreCase("SHA-256") || name.equalsIgnoreCase("SHA256")) {
            return SHA256_oid;
        }
        if (name.equalsIgnoreCase("SHA-384") || name.equalsIgnoreCase("SHA384")) {
            return SHA384_oid;
        }
        if (name.equalsIgnoreCase("SHA-512") || name.equalsIgnoreCase("SHA512")) {
            return SHA512_oid;
        }
        if (name.equalsIgnoreCase("SHA-224") || name.equalsIgnoreCase("SHA224")) {
            return SHA224_oid;
        }
        if (name.equalsIgnoreCase("SHA-512/224") || name.equalsIgnoreCase("SHA512/224")) {
            return SHA512_224_oid;
        }
        if (name.equalsIgnoreCase("SHA-512/256") || name.equalsIgnoreCase("SHA512/256")) {
            return SHA512_256_oid;
        }
        if (name.equalsIgnoreCase("RSA")) {
            return RSAEncryption_oid;
        }
        if (name.equalsIgnoreCase("RSASSA-PSS")) {
            return RSASSA_PSS_oid;
        }
        if (name.equalsIgnoreCase("RSAES-OAEP")) {
            return RSAES_OAEP_oid;
        }
        if (name.equalsIgnoreCase("Diffie-Hellman") || name.equalsIgnoreCase("DH")) {
            return DH_oid;
        }
        if (name.equalsIgnoreCase("DSA")) {
            return DSA_oid;
        }
        if (name.equalsIgnoreCase("EC")) {
            return EC_oid;
        }
        if (name.equalsIgnoreCase("ECDH")) {
            return ECDH_oid;
        }
        if (name.equalsIgnoreCase("AES")) {
            return AES_oid;
        }
        if (name.equalsIgnoreCase("MD5withRSA") || name.equalsIgnoreCase("MD5/RSA")) {
            return md5WithRSAEncryption_oid;
        }
        if (name.equalsIgnoreCase("MD2withRSA") || name.equalsIgnoreCase("MD2/RSA")) {
            return md2WithRSAEncryption_oid;
        }
        if (name.equalsIgnoreCase("SHAwithDSA") || name.equalsIgnoreCase("SHA1withDSA") || name.equalsIgnoreCase("SHA/DSA") || name.equalsIgnoreCase("SHA1/DSA") || name.equalsIgnoreCase("DSAWithSHA1") || name.equalsIgnoreCase("DSS") || name.equalsIgnoreCase("SHA-1/DSA")) {
            return sha1WithDSA_oid;
        }
        if (name.equalsIgnoreCase("SHA224WithDSA")) {
            return sha224WithDSA_oid;
        }
        if (name.equalsIgnoreCase("SHA256WithDSA")) {
            return sha256WithDSA_oid;
        }
        if (name.equalsIgnoreCase("SHA1WithRSA") || name.equalsIgnoreCase("SHA1/RSA")) {
            return sha1WithRSAEncryption_oid;
        }
        if (name.equalsIgnoreCase("SHA1withECDSA") || name.equalsIgnoreCase("ECDSA")) {
            return sha1WithECDSA_oid;
        }
        if (name.equalsIgnoreCase("SHA224withECDSA")) {
            return sha224WithECDSA_oid;
        }
        if (name.equalsIgnoreCase("SHA256withECDSA")) {
            return sha256WithECDSA_oid;
        }
        if (name.equalsIgnoreCase("SHA384withECDSA")) {
            return sha384WithECDSA_oid;
        }
        if (name.equalsIgnoreCase("SHA512withECDSA")) {
            return sha512WithECDSA_oid;
        }
        if (!initOidTable) {
            Provider[] provs = Security.getProviders();
            block0: for (int i = 0; i < provs.length; ++i) {
                Enumeration<Object> enum_ = provs[i].keys();
                while (enum_.hasMoreElements()) {
                    int index;
                    String alias = (String)enum_.nextElement();
                    String upperCaseAlias = alias.toUpperCase(Locale.ENGLISH);
                    if (!upperCaseAlias.startsWith("ALG.ALIAS") || (index = upperCaseAlias.indexOf("OID.", 0)) == -1) continue;
                    if ((index += "OID.".length()) == alias.length()) continue block0;
                    if (oidTable == null) {
                        oidTable = new HashMap<String, ObjectIdentifier>();
                    }
                    String oidString = alias.substring(index);
                    String stdAlgName = provs[i].getProperty(alias);
                    if (stdAlgName != null) {
                        stdAlgName = stdAlgName.toUpperCase(Locale.ENGLISH);
                    }
                    if (stdAlgName == null || oidTable.get(stdAlgName) != null) continue;
                    oidTable.put(stdAlgName, new ObjectIdentifier(oidString));
                }
            }
            if (oidTable == null) {
                oidTable = Collections.emptyMap();
            }
            initOidTable = true;
        }
        return oidTable.get(name.toUpperCase(Locale.ENGLISH));
    }

    private static ObjectIdentifier oid(int ... values) {
        return ObjectIdentifier.newInternal(values);
    }

    public static String makeSigAlg(String digAlg, String encAlg) {
        digAlg = digAlg.replace("-", "");
        if (encAlg.equalsIgnoreCase("EC")) {
            encAlg = "ECDSA";
        }
        return digAlg + "with" + encAlg;
    }

    public static String getEncAlgFromSigAlg(String signatureAlgorithm) {
        int and;
        signatureAlgorithm = signatureAlgorithm.toUpperCase(Locale.ENGLISH);
        int with = signatureAlgorithm.indexOf("WITH");
        String keyAlgorithm = null;
        if (with > 0 && (keyAlgorithm = (and = signatureAlgorithm.indexOf("AND", with + 4)) > 0 ? signatureAlgorithm.substring(with + 4, and) : signatureAlgorithm.substring(with + 4)).equalsIgnoreCase("ECDSA")) {
            keyAlgorithm = "EC";
        }
        return keyAlgorithm;
    }

    public static String getDigAlgFromSigAlg(String signatureAlgorithm) {
        int with = (signatureAlgorithm = signatureAlgorithm.toUpperCase(Locale.ENGLISH)).indexOf("WITH");
        if (with > 0) {
            return signatureAlgorithm.substring(0, with);
        }
        return null;
    }

    public static AlgorithmId getWithParameterSpec(String algName, AlgorithmParameterSpec spec) throws NoSuchAlgorithmException {
        if (spec == null) {
            return AlgorithmId.get(algName);
        }
        if (spec == PSSParamsHolder.PSS_256_SPEC) {
            return PSSParamsHolder.PSS_256_ID;
        }
        if (spec == PSSParamsHolder.PSS_384_SPEC) {
            return PSSParamsHolder.PSS_384_ID;
        }
        if (spec == PSSParamsHolder.PSS_512_SPEC) {
            return PSSParamsHolder.PSS_512_ID;
        }
        try {
            AlgorithmParameters result = AlgorithmParameters.getInstance(algName);
            result.init(spec);
            return AlgorithmId.get(result);
        }
        catch (NoSuchAlgorithmException | InvalidParameterSpecException e) {
            throw new ProviderException(e);
        }
    }

    public static PSSParameterSpec getDefaultAlgorithmParameterSpec(String sigAlg, PrivateKey k) {
        if (sigAlg.equalsIgnoreCase("RSASSA-PSS")) {
            switch (AlgorithmId.ifcFfcStrength(KeyUtil.getKeySize(k))) {
                case "SHA256": {
                    return PSSParamsHolder.PSS_256_SPEC;
                }
                case "SHA384": {
                    return PSSParamsHolder.PSS_384_SPEC;
                }
                case "SHA512": {
                    return PSSParamsHolder.PSS_512_SPEC;
                }
            }
            throw new AssertionError((Object)"Should not happen");
        }
        return null;
    }

    private static String ifcFfcStrength(int bitLength) {
        if (bitLength > 7680) {
            return "SHA512";
        }
        if (bitLength > 3072) {
            return "SHA384";
        }
        return "SHA256";
    }

    static {
        MD2_oid = ObjectIdentifier.newInternal(new int[]{1, 2, 840, 113549, 2, 2});
        MD5_oid = ObjectIdentifier.newInternal(new int[]{1, 2, 840, 113549, 2, 5});
        SHA_oid = ObjectIdentifier.newInternal(new int[]{1, 3, 14, 3, 2, 26});
        SHA224_oid = ObjectIdentifier.newInternal(new int[]{2, 16, 840, 1, 101, 3, 4, 2, 4});
        SHA256_oid = ObjectIdentifier.newInternal(new int[]{2, 16, 840, 1, 101, 3, 4, 2, 1});
        SHA384_oid = ObjectIdentifier.newInternal(new int[]{2, 16, 840, 1, 101, 3, 4, 2, 2});
        SHA512_oid = ObjectIdentifier.newInternal(new int[]{2, 16, 840, 1, 101, 3, 4, 2, 3});
        SHA512_224_oid = ObjectIdentifier.newInternal(new int[]{2, 16, 840, 1, 101, 3, 4, 2, 5});
        SHA512_256_oid = ObjectIdentifier.newInternal(new int[]{2, 16, 840, 1, 101, 3, 4, 2, 6});
        DH_data = new int[]{1, 2, 840, 113549, 1, 3, 1};
        DH_PKIX_data = new int[]{1, 2, 840, 10046, 2, 1};
        DSA_OIW_data = new int[]{1, 3, 14, 3, 2, 12};
        DSA_PKIX_data = new int[]{1, 2, 840, 10040, 4, 1};
        RSA_data = new int[]{2, 5, 8, 1, 1};
        EC_oid = AlgorithmId.oid(1, 2, 840, 10045, 2, 1);
        ECDH_oid = AlgorithmId.oid(1, 3, 132, 1, 12);
        RSAEncryption_oid = AlgorithmId.oid(1, 2, 840, 113549, 1, 1, 1);
        RSAES_OAEP_oid = AlgorithmId.oid(1, 2, 840, 113549, 1, 1, 7);
        mgf1_oid = AlgorithmId.oid(1, 2, 840, 113549, 1, 1, 8);
        RSASSA_PSS_oid = AlgorithmId.oid(1, 2, 840, 113549, 1, 1, 10);
        AES_oid = AlgorithmId.oid(2, 16, 840, 1, 101, 3, 4, 1);
        md2WithRSAEncryption_data = new int[]{1, 2, 840, 113549, 1, 1, 2};
        md5WithRSAEncryption_data = new int[]{1, 2, 840, 113549, 1, 1, 4};
        sha1WithRSAEncryption_data = new int[]{1, 2, 840, 113549, 1, 1, 5};
        sha1WithRSAEncryption_OIW_data = new int[]{1, 3, 14, 3, 2, 29};
        sha224WithRSAEncryption_data = new int[]{1, 2, 840, 113549, 1, 1, 14};
        sha256WithRSAEncryption_data = new int[]{1, 2, 840, 113549, 1, 1, 11};
        sha384WithRSAEncryption_data = new int[]{1, 2, 840, 113549, 1, 1, 12};
        sha512WithRSAEncryption_data = new int[]{1, 2, 840, 113549, 1, 1, 13};
        shaWithDSA_OIW_data = new int[]{1, 3, 14, 3, 2, 13};
        sha1WithDSA_OIW_data = new int[]{1, 3, 14, 3, 2, 27};
        dsaWithSHA1_PKIX_data = new int[]{1, 2, 840, 10040, 4, 3};
        sha512_224WithRSAEncryption_oid = AlgorithmId.oid(1, 2, 840, 113549, 1, 1, 15);
        sha512_256WithRSAEncryption_oid = AlgorithmId.oid(1, 2, 840, 113549, 1, 1, 16);
        sha224WithDSA_oid = AlgorithmId.oid(2, 16, 840, 1, 101, 3, 4, 3, 1);
        sha256WithDSA_oid = AlgorithmId.oid(2, 16, 840, 1, 101, 3, 4, 3, 2);
        sha1WithECDSA_oid = AlgorithmId.oid(1, 2, 840, 10045, 4, 1);
        sha224WithECDSA_oid = AlgorithmId.oid(1, 2, 840, 10045, 4, 3, 1);
        sha256WithECDSA_oid = AlgorithmId.oid(1, 2, 840, 10045, 4, 3, 2);
        sha384WithECDSA_oid = AlgorithmId.oid(1, 2, 840, 10045, 4, 3, 3);
        sha512WithECDSA_oid = AlgorithmId.oid(1, 2, 840, 10045, 4, 3, 4);
        specifiedWithECDSA_oid = AlgorithmId.oid(1, 2, 840, 10045, 4, 3);
        pbeWithMD5AndDES_oid = ObjectIdentifier.newInternal(new int[]{1, 2, 840, 113549, 1, 5, 3});
        pbeWithMD5AndRC2_oid = ObjectIdentifier.newInternal(new int[]{1, 2, 840, 113549, 1, 5, 6});
        pbeWithSHA1AndDES_oid = ObjectIdentifier.newInternal(new int[]{1, 2, 840, 113549, 1, 5, 10});
        pbeWithSHA1AndRC2_oid = ObjectIdentifier.newInternal(new int[]{1, 2, 840, 113549, 1, 5, 11});
        pbeWithSHA1AndDESede_oid = ObjectIdentifier.newInternal(new int[]{1, 2, 840, 113549, 1, 12, 1, 3});
        pbeWithSHA1AndRC2_40_oid = ObjectIdentifier.newInternal(new int[]{1, 2, 840, 113549, 1, 12, 1, 6});
        DH_oid = ObjectIdentifier.newInternal(DH_data);
        DH_PKIX_oid = ObjectIdentifier.newInternal(DH_PKIX_data);
        DSA_OIW_oid = ObjectIdentifier.newInternal(DSA_OIW_data);
        DSA_oid = ObjectIdentifier.newInternal(DSA_PKIX_data);
        RSA_oid = ObjectIdentifier.newInternal(RSA_data);
        md2WithRSAEncryption_oid = ObjectIdentifier.newInternal(md2WithRSAEncryption_data);
        md5WithRSAEncryption_oid = ObjectIdentifier.newInternal(md5WithRSAEncryption_data);
        sha1WithRSAEncryption_oid = ObjectIdentifier.newInternal(sha1WithRSAEncryption_data);
        sha1WithRSAEncryption_OIW_oid = ObjectIdentifier.newInternal(sha1WithRSAEncryption_OIW_data);
        sha224WithRSAEncryption_oid = ObjectIdentifier.newInternal(sha224WithRSAEncryption_data);
        sha256WithRSAEncryption_oid = ObjectIdentifier.newInternal(sha256WithRSAEncryption_data);
        sha384WithRSAEncryption_oid = ObjectIdentifier.newInternal(sha384WithRSAEncryption_data);
        sha512WithRSAEncryption_oid = ObjectIdentifier.newInternal(sha512WithRSAEncryption_data);
        shaWithDSA_OIW_oid = ObjectIdentifier.newInternal(shaWithDSA_OIW_data);
        sha1WithDSA_OIW_oid = ObjectIdentifier.newInternal(sha1WithDSA_OIW_data);
        sha1WithDSA_oid = ObjectIdentifier.newInternal(dsaWithSHA1_PKIX_data);
        nameTable = new HashMap<ObjectIdentifier, String>();
        nameTable.put(MD5_oid, "MD5");
        nameTable.put(MD2_oid, "MD2");
        nameTable.put(SHA_oid, "SHA-1");
        nameTable.put(SHA224_oid, "SHA-224");
        nameTable.put(SHA256_oid, "SHA-256");
        nameTable.put(SHA384_oid, "SHA-384");
        nameTable.put(SHA512_oid, "SHA-512");
        nameTable.put(SHA512_224_oid, "SHA-512/224");
        nameTable.put(SHA512_256_oid, "SHA-512/256");
        nameTable.put(RSAEncryption_oid, "RSA");
        nameTable.put(RSA_oid, "RSA");
        nameTable.put(DH_oid, "Diffie-Hellman");
        nameTable.put(DH_PKIX_oid, "Diffie-Hellman");
        nameTable.put(DSA_oid, "DSA");
        nameTable.put(DSA_OIW_oid, "DSA");
        nameTable.put(EC_oid, "EC");
        nameTable.put(ECDH_oid, "ECDH");
        nameTable.put(AES_oid, "AES");
        nameTable.put(sha1WithECDSA_oid, "SHA1withECDSA");
        nameTable.put(sha224WithECDSA_oid, "SHA224withECDSA");
        nameTable.put(sha256WithECDSA_oid, "SHA256withECDSA");
        nameTable.put(sha384WithECDSA_oid, "SHA384withECDSA");
        nameTable.put(sha512WithECDSA_oid, "SHA512withECDSA");
        nameTable.put(md5WithRSAEncryption_oid, "MD5withRSA");
        nameTable.put(md2WithRSAEncryption_oid, "MD2withRSA");
        nameTable.put(sha1WithDSA_oid, "SHA1withDSA");
        nameTable.put(sha1WithDSA_OIW_oid, "SHA1withDSA");
        nameTable.put(shaWithDSA_OIW_oid, "SHA1withDSA");
        nameTable.put(sha224WithDSA_oid, "SHA224withDSA");
        nameTable.put(sha256WithDSA_oid, "SHA256withDSA");
        nameTable.put(sha1WithRSAEncryption_oid, "SHA1withRSA");
        nameTable.put(sha1WithRSAEncryption_OIW_oid, "SHA1withRSA");
        nameTable.put(sha224WithRSAEncryption_oid, "SHA224withRSA");
        nameTable.put(sha256WithRSAEncryption_oid, "SHA256withRSA");
        nameTable.put(sha384WithRSAEncryption_oid, "SHA384withRSA");
        nameTable.put(sha512WithRSAEncryption_oid, "SHA512withRSA");
        nameTable.put(sha512_224WithRSAEncryption_oid, "SHA512/224withRSA");
        nameTable.put(sha512_256WithRSAEncryption_oid, "SHA512/256withRSA");
        nameTable.put(RSASSA_PSS_oid, "RSASSA-PSS");
        nameTable.put(RSAES_OAEP_oid, "RSAES-OAEP");
        nameTable.put(pbeWithMD5AndDES_oid, "PBEWithMD5AndDES");
        nameTable.put(pbeWithMD5AndRC2_oid, "PBEWithMD5AndRC2");
        nameTable.put(pbeWithSHA1AndDES_oid, "PBEWithSHA1AndDES");
        nameTable.put(pbeWithSHA1AndRC2_oid, "PBEWithSHA1AndRC2");
        nameTable.put(pbeWithSHA1AndDESede_oid, "PBEWithSHA1AndDESede");
        nameTable.put(pbeWithSHA1AndRC2_40_oid, "PBEWithSHA1AndRC2_40");
    }

    private static class PSSParamsHolder {
        static final PSSParameterSpec PSS_256_SPEC = new PSSParameterSpec("SHA-256", "MGF1", new MGF1ParameterSpec("SHA-256"), 32, 1);
        static final PSSParameterSpec PSS_384_SPEC = new PSSParameterSpec("SHA-384", "MGF1", new MGF1ParameterSpec("SHA-384"), 48, 1);
        static final PSSParameterSpec PSS_512_SPEC = new PSSParameterSpec("SHA-512", "MGF1", new MGF1ParameterSpec("SHA-512"), 64, 1);
        static final AlgorithmId PSS_256_ID;
        static final AlgorithmId PSS_384_ID;
        static final AlgorithmId PSS_512_ID;

        private PSSParamsHolder() {
        }

        static {
            try {
                PSS_256_ID = new AlgorithmId(RSASSA_PSS_oid, new DerValue(PSSParameters.getEncoded(PSS_256_SPEC)));
                PSS_384_ID = new AlgorithmId(RSASSA_PSS_oid, new DerValue(PSSParameters.getEncoded(PSS_384_SPEC)));
                PSS_512_ID = new AlgorithmId(RSASSA_PSS_oid, new DerValue(PSSParameters.getEncoded(PSS_512_SPEC)));
            }
            catch (IOException e) {
                throw new AssertionError("Should not happen", e);
            }
        }
    }
}

