/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import sun.security.krb5.Credentials;
import sun.security.krb5.PrincipalName;

final class ReferralsCache {
    private static Map<ReferralCacheKey, Map<String, ReferralCacheEntry>> referralsMap = new HashMap<ReferralCacheKey, Map<String, ReferralCacheEntry>>();

    ReferralsCache() {
    }

    static synchronized void put(PrincipalName cname, PrincipalName service, String fromRealm, String toRealm, Credentials creds) {
        ReferralCacheKey k = new ReferralCacheKey(cname, service);
        ReferralsCache.pruneExpired(k);
        if (creds.getEndTime().before(new Date())) {
            return;
        }
        Map<String, ReferralCacheEntry> entries = referralsMap.get(k);
        if (entries == null) {
            entries = new HashMap<String, ReferralCacheEntry>();
            referralsMap.put(k, entries);
        }
        entries.remove(fromRealm);
        ReferralCacheEntry newEntry = new ReferralCacheEntry(creds, toRealm);
        entries.put(fromRealm, newEntry);
        ReferralCacheEntry current = newEntry;
        LinkedList<ReferralCacheEntry> seen = new LinkedList<ReferralCacheEntry>();
        while (current != null) {
            if (seen.contains(current)) {
                entries.remove(newEntry.getToRealm());
                break;
            }
            seen.add(current);
            current = entries.get(current.getToRealm());
        }
    }

    static synchronized ReferralCacheEntry get(PrincipalName cname, PrincipalName service, String fromRealm) {
        ReferralCacheEntry toRef;
        ReferralCacheKey k = new ReferralCacheKey(cname, service);
        ReferralsCache.pruneExpired(k);
        Map<String, ReferralCacheEntry> entries = referralsMap.get(k);
        if (entries != null && (toRef = entries.get(fromRealm)) != null) {
            return toRef;
        }
        return null;
    }

    private static void pruneExpired(ReferralCacheKey k) {
        Date now = new Date();
        Map<String, ReferralCacheEntry> entries = referralsMap.get(k);
        if (entries != null) {
            for (Map.Entry<String, ReferralCacheEntry> mapEntry : entries.entrySet()) {
                if (!mapEntry.getValue().getCreds().getEndTime().before(now)) continue;
                entries.remove(mapEntry.getKey());
            }
        }
    }

    static final class ReferralCacheEntry {
        private final Credentials creds;
        private final String toRealm;

        ReferralCacheEntry(Credentials creds, String toRealm) {
            this.creds = creds;
            this.toRealm = toRealm;
        }

        Credentials getCreds() {
            return this.creds;
        }

        String getToRealm() {
            return this.toRealm;
        }
    }

    private static final class ReferralCacheKey {
        private PrincipalName cname;
        private PrincipalName sname;

        ReferralCacheKey(PrincipalName cname, PrincipalName sname) {
            this.cname = cname;
            this.sname = sname;
        }

        public boolean equals(Object other) {
            if (!(other instanceof ReferralCacheKey)) {
                return false;
            }
            ReferralCacheKey that = (ReferralCacheKey)other;
            return this.cname.equals(that.cname) && this.sname.equals(that.sname);
        }

        public int hashCode() {
            return this.cname.hashCode() + this.sname.hashCode();
        }
    }
}

