/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import java.io.IOException;
import java.net.InetAddress;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import sun.security.jgss.krb5.Krb5AcceptCredential;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.Checksum;
import sun.security.krb5.Credentials;
import sun.security.krb5.EncryptedData;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbCryptoException;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.internal.APOptions;
import sun.security.krb5.internal.APReq;
import sun.security.krb5.internal.Authenticator;
import sun.security.krb5.internal.AuthorizationData;
import sun.security.krb5.internal.EncTicketPart;
import sun.security.krb5.internal.HostAddress;
import sun.security.krb5.internal.KRBError;
import sun.security.krb5.internal.KdcErrException;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.KrbApErrException;
import sun.security.krb5.internal.LocalSeqNumber;
import sun.security.krb5.internal.ReplayCache;
import sun.security.krb5.internal.SeqNumber;
import sun.security.krb5.internal.Ticket;
import sun.security.krb5.internal.crypto.EType;
import sun.security.krb5.internal.rcache.AuthTimeWithHash;
import sun.security.util.DerValue;

public class KrbApReq {
    private byte[] obuf;
    private KerberosTime ctime;
    private int cusec;
    private Authenticator authenticator;
    private Credentials creds;
    private APReq apReqMessg;
    private static ReplayCache rcache = ReplayCache.getInstance();
    private static boolean DEBUG = Krb5.DEBUG;
    private static final char[] hexConst = "0123456789ABCDEF".toCharArray();

    public KrbApReq(Credentials tgsCred, boolean mutualRequired, boolean useSubKey, boolean useSeqNumber, Checksum cksum) throws Asn1Exception, KrbCryptoException, KrbException, IOException {
        APOptions apOptions;
        APOptions aPOptions = apOptions = mutualRequired ? new APOptions(2) : new APOptions();
        if (DEBUG) {
            System.out.println(">>> KrbApReq: APOptions are " + apOptions);
        }
        EncryptionKey subKey = useSubKey ? new EncryptionKey(tgsCred.getSessionKey()) : null;
        LocalSeqNumber seqNum = new LocalSeqNumber();
        this.init(apOptions, tgsCred, cksum, subKey, seqNum, null, 11);
    }

    public KrbApReq(byte[] message, Krb5AcceptCredential cred, InetAddress initiator) throws KrbException, IOException {
        this.obuf = message;
        if (this.apReqMessg == null) {
            this.decode();
        }
        this.authenticate(cred, initiator);
    }

    KrbApReq(APOptions apOptions, Ticket ticket, EncryptionKey key, PrincipalName cname, Checksum cksum, KerberosTime ctime, EncryptionKey subKey, SeqNumber seqNumber, AuthorizationData authorizationData) throws Asn1Exception, IOException, KdcErrException, KrbCryptoException {
        this.init(apOptions, ticket, key, cname, cksum, ctime, subKey, seqNumber, authorizationData, 7);
    }

    private void init(APOptions options, Credentials tgs_creds, Checksum cksum, EncryptionKey subKey, SeqNumber seqNumber, AuthorizationData authorizationData, int usage) throws KrbException, IOException {
        this.ctime = KerberosTime.now();
        this.init(options, tgs_creds.ticket, tgs_creds.key, tgs_creds.client, cksum, this.ctime, subKey, seqNumber, authorizationData, usage);
    }

    private void init(APOptions apOptions, Ticket ticket, EncryptionKey key, PrincipalName cname, Checksum cksum, KerberosTime ctime, EncryptionKey subKey, SeqNumber seqNumber, AuthorizationData authorizationData, int usage) throws Asn1Exception, IOException, KdcErrException, KrbCryptoException {
        this.createMessage(apOptions, ticket, key, cname, cksum, ctime, subKey, seqNumber, authorizationData, usage);
        this.obuf = this.apReqMessg.asn1Encode();
    }

    void decode() throws KrbException, IOException {
        DerValue encoding = new DerValue(this.obuf);
        this.decode(encoding);
    }

    void decode(DerValue encoding) throws KrbException, IOException {
        this.apReqMessg = null;
        try {
            this.apReqMessg = new APReq(encoding);
        }
        catch (Asn1Exception e) {
            this.apReqMessg = null;
            KRBError err = new KRBError(encoding);
            String errStr = err.getErrorString();
            String eText = errStr.charAt(errStr.length() - 1) == '\u0000' ? errStr.substring(0, errStr.length() - 1) : errStr;
            KrbException ke = new KrbException(err.getErrorCode(), eText);
            ke.initCause(e);
            throw ke;
        }
    }

    private void authenticate(Krb5AcceptCredential cred, InetAddress initiator) throws KrbException, IOException {
        byte[] hash;
        EncryptionKey[] keys;
        Integer kvno;
        int encPartKeyType = this.apReqMessg.ticket.encPart.getEType();
        EncryptionKey dkey = EncryptionKey.findKey(encPartKeyType, kvno = this.apReqMessg.ticket.encPart.getKeyVersionNumber(), keys = cred.getKrb5EncryptionKeys(this.apReqMessg.ticket.sname));
        if (dkey == null) {
            throw new KrbException(400, "Cannot find key of appropriate type to decrypt AP REP - " + EType.toString(encPartKeyType));
        }
        byte[] bytes = this.apReqMessg.ticket.encPart.decrypt(dkey, 2);
        byte[] temp = this.apReqMessg.ticket.encPart.reset(bytes);
        EncTicketPart enc_ticketPart = new EncTicketPart(temp);
        KrbApReq.checkPermittedEType(enc_ticketPart.key.getEType());
        byte[] bytes2 = this.apReqMessg.authenticator.decrypt(enc_ticketPart.key, 11);
        byte[] temp2 = this.apReqMessg.authenticator.reset(bytes2);
        this.authenticator = new Authenticator(temp2);
        this.ctime = this.authenticator.ctime;
        this.cusec = this.authenticator.cusec;
        this.authenticator.ctime = this.authenticator.ctime.withMicroSeconds(this.authenticator.cusec);
        if (!this.authenticator.cname.equals(enc_ticketPart.cname)) {
            throw new KrbApErrException(36);
        }
        if (!this.authenticator.ctime.inClockSkew()) {
            throw new KrbApErrException(37);
        }
        try {
            hash = MessageDigest.getInstance("MD5").digest(this.apReqMessg.authenticator.cipher);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AssertionError((Object)"Impossible");
        }
        char[] h = new char[hash.length * 2];
        for (int i = 0; i < hash.length; ++i) {
            h[2 * i] = hexConst[(hash[i] & 0xFF) >> 4];
            h[2 * i + 1] = hexConst[hash[i] & 0xF];
        }
        AuthTimeWithHash time = new AuthTimeWithHash(this.authenticator.cname.toString(), this.apReqMessg.ticket.sname.toString(), this.authenticator.ctime.getSeconds(), this.authenticator.cusec, new String(h));
        rcache.checkAndStore(KerberosTime.now(), time);
        if (initiator != null) {
            HostAddress sender = new HostAddress(initiator);
            if (enc_ticketPart.caddr != null && !enc_ticketPart.caddr.inList(sender)) {
                if (DEBUG) {
                    System.out.println(">>> KrbApReq: initiator is " + sender.getInetAddress() + ", but caddr is " + Arrays.toString(enc_ticketPart.caddr.getInetAddresses()));
                }
                throw new KrbApErrException(38);
            }
        }
        KerberosTime now = KerberosTime.now();
        if (enc_ticketPart.starttime != null && enc_ticketPart.starttime.greaterThanWRTClockSkew(now) || enc_ticketPart.flags.get(7)) {
            throw new KrbApErrException(33);
        }
        if (enc_ticketPart.endtime != null && now.greaterThanWRTClockSkew(enc_ticketPart.endtime)) {
            throw new KrbApErrException(32);
        }
        this.creds = new Credentials(this.apReqMessg.ticket, this.authenticator.cname, null, this.apReqMessg.ticket.sname, null, enc_ticketPart.key, enc_ticketPart.flags, enc_ticketPart.authtime, enc_ticketPart.starttime, enc_ticketPart.endtime, enc_ticketPart.renewTill, enc_ticketPart.caddr, enc_ticketPart.authorizationData);
        if (DEBUG) {
            System.out.println(">>> KrbApReq: authenticate succeed.");
        }
    }

    public Credentials getCreds() {
        return this.creds;
    }

    KerberosTime getCtime() {
        if (this.ctime != null) {
            return this.ctime;
        }
        return this.authenticator.ctime;
    }

    int cusec() {
        return this.cusec;
    }

    APOptions getAPOptions() throws KrbException, IOException {
        if (this.apReqMessg == null) {
            this.decode();
        }
        if (this.apReqMessg != null) {
            return this.apReqMessg.apOptions;
        }
        return null;
    }

    public boolean getMutualAuthRequired() throws KrbException, IOException {
        if (this.apReqMessg == null) {
            this.decode();
        }
        if (this.apReqMessg != null) {
            return this.apReqMessg.apOptions.get(2);
        }
        return false;
    }

    boolean useSessionKey() throws KrbException, IOException {
        if (this.apReqMessg == null) {
            this.decode();
        }
        if (this.apReqMessg != null) {
            return this.apReqMessg.apOptions.get(1);
        }
        return false;
    }

    public EncryptionKey getSubKey() {
        return this.authenticator.getSubKey();
    }

    public Integer getSeqNumber() {
        return this.authenticator.getSeqNumber();
    }

    public Checksum getChecksum() {
        return this.authenticator.getChecksum();
    }

    public byte[] getMessage() {
        return this.obuf;
    }

    public PrincipalName getClient() {
        return this.creds.getClient();
    }

    private void createMessage(APOptions apOptions, Ticket ticket, EncryptionKey key, PrincipalName cname, Checksum cksum, KerberosTime ctime, EncryptionKey subKey, SeqNumber seqNumber, AuthorizationData authorizationData, int usage) throws Asn1Exception, IOException, KdcErrException, KrbCryptoException {
        Integer seqno = null;
        if (seqNumber != null) {
            seqno = new Integer(seqNumber.current());
        }
        this.authenticator = new Authenticator(cname, cksum, ctime.getMicroSeconds(), ctime, subKey, seqno, authorizationData);
        byte[] temp = this.authenticator.asn1Encode();
        EncryptedData encAuthenticator = new EncryptedData(key, temp, usage);
        this.apReqMessg = new APReq(apOptions, ticket, encAuthenticator);
    }

    private static void checkPermittedEType(int target) throws KrbException {
        int[] etypes = EType.getDefaults("permitted_enctypes");
        if (!EType.isSupported(target, etypes)) {
            throw new KrbException(EType.toString(target) + " encryption type not in permitted_enctypes list");
        }
    }
}

