/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.ObjID;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.util.Arrays;
import sun.rmi.transport.Channel;
import sun.rmi.transport.ConnectionInputStream;
import sun.rmi.transport.ConnectionOutputStream;
import sun.rmi.transport.DGCClient;
import sun.rmi.transport.Endpoint;
import sun.rmi.transport.ObjectEndpoint;
import sun.rmi.transport.ObjectTable;
import sun.rmi.transport.Target;
import sun.rmi.transport.tcp.TCPEndpoint;

public class LiveRef
implements Cloneable {
    private final Endpoint ep;
    private final ObjID id;
    private transient Channel ch;
    private final boolean isLocal;

    public LiveRef(ObjID objID, Endpoint endpoint, boolean isLocal) {
        this.ep = endpoint;
        this.id = objID;
        this.isLocal = isLocal;
    }

    public LiveRef(int port) {
        this(new ObjID(), port);
    }

    public LiveRef(int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) {
        this(new ObjID(), port, csf, ssf);
    }

    public LiveRef(ObjID objID, int port) {
        this(objID, TCPEndpoint.getLocalEndpoint(port), true);
    }

    public LiveRef(ObjID objID, int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) {
        this(objID, TCPEndpoint.getLocalEndpoint(port, csf, ssf), true);
    }

    public Object clone() {
        try {
            LiveRef newRef = (LiveRef)super.clone();
            return newRef;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString(), e);
        }
    }

    public int getPort() {
        return ((TCPEndpoint)this.ep).getPort();
    }

    public RMIClientSocketFactory getClientSocketFactory() {
        return ((TCPEndpoint)this.ep).getClientSocketFactory();
    }

    public RMIServerSocketFactory getServerSocketFactory() {
        return ((TCPEndpoint)this.ep).getServerSocketFactory();
    }

    public void exportObject(Target target) throws RemoteException {
        this.ep.exportObject(target);
    }

    public Channel getChannel() throws RemoteException {
        if (this.ch == null) {
            this.ch = this.ep.getChannel();
        }
        return this.ch;
    }

    public ObjID getObjID() {
        return this.id;
    }

    Endpoint getEndpoint() {
        return this.ep;
    }

    public String toString() {
        String type = this.isLocal ? "local" : "remote";
        return "[endpoint:" + this.ep + "(" + type + "),objID:" + this.id + "]";
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof LiveRef) {
            LiveRef ref = (LiveRef)obj;
            return this.ep.equals(ref.ep) && this.id.equals(ref.id) && this.isLocal == ref.isLocal;
        }
        return false;
    }

    public boolean remoteEquals(Object obj) {
        if (obj != null && obj instanceof LiveRef) {
            LiveRef ref = (LiveRef)obj;
            TCPEndpoint thisEp = (TCPEndpoint)this.ep;
            TCPEndpoint refEp = (TCPEndpoint)ref.ep;
            RMIClientSocketFactory thisClientFactory = thisEp.getClientSocketFactory();
            RMIClientSocketFactory refClientFactory = refEp.getClientSocketFactory();
            if (thisEp.getPort() != refEp.getPort() || !thisEp.getHost().equals(refEp.getHost())) {
                return false;
            }
            if (thisClientFactory == null ^ refClientFactory == null) {
                return false;
            }
            if (!(thisClientFactory == null || thisClientFactory.getClass() == refClientFactory.getClass() && thisClientFactory.equals(refClientFactory))) {
                return false;
            }
            return this.id.equals(ref.id);
        }
        return false;
    }

    public void write(ObjectOutput out, boolean useNewFormat) throws IOException {
        boolean isResultStream = false;
        if (out instanceof ConnectionOutputStream) {
            ConnectionOutputStream stream = (ConnectionOutputStream)out;
            isResultStream = stream.isResultStream();
            if (this.isLocal) {
                Remote impl;
                ObjectEndpoint oe = new ObjectEndpoint(this.id, this.ep.getInboundTransport());
                Target target = ObjectTable.getTarget(oe);
                if (target != null && (impl = target.getImpl()) != null) {
                    stream.saveObject(impl);
                }
            } else {
                stream.saveObject(this);
            }
        }
        if (useNewFormat) {
            ((TCPEndpoint)this.ep).write(out);
        } else {
            ((TCPEndpoint)this.ep).writeHostPortFormat(out);
        }
        this.id.write(out);
        out.writeBoolean(isResultStream);
    }

    public static LiveRef read(ObjectInput in, boolean useNewFormat) throws IOException, ClassNotFoundException {
        TCPEndpoint ep = useNewFormat ? TCPEndpoint.read(in) : TCPEndpoint.readHostPortFormat(in);
        ObjID id = ObjID.read(in);
        boolean isResultStream = in.readBoolean();
        LiveRef ref = new LiveRef(id, ep, false);
        if (in instanceof ConnectionInputStream) {
            ConnectionInputStream stream = (ConnectionInputStream)in;
            stream.saveRef(ref);
            if (isResultStream) {
                stream.setAckNeeded();
            }
        } else {
            DGCClient.registerRefs(ep, Arrays.asList(ref));
        }
        return ref;
    }
}

