/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch.sctp;

import com.sun.nio.sctp.AbstractNotificationHandler;
import com.sun.nio.sctp.Association;
import com.sun.nio.sctp.AssociationChangeNotification;
import com.sun.nio.sctp.HandlerResult;
import com.sun.nio.sctp.IllegalUnbindException;
import com.sun.nio.sctp.InvalidStreamException;
import com.sun.nio.sctp.MessageInfo;
import com.sun.nio.sctp.NotificationHandler;
import com.sun.nio.sctp.SctpChannel;
import com.sun.nio.sctp.SctpSocketOption;
import com.sun.nio.sctp.SctpStandardSocketOptions;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.NoConnectionPendingException;
import java.nio.channels.NotYetBoundException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.spi.SelectorProvider;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import sun.nio.ch.DirectBuffer;
import sun.nio.ch.IOStatus;
import sun.nio.ch.IOUtil;
import sun.nio.ch.NativeThread;
import sun.nio.ch.Net;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.Util;
import sun.nio.ch.sctp.AssociationChange;
import sun.nio.ch.sctp.AssociationImpl;
import sun.nio.ch.sctp.ResultContainer;
import sun.nio.ch.sctp.SctpNet;
import sun.nio.ch.sctp.SctpNotification;

public class SctpChannelImpl
extends SctpChannel
implements SelChImpl {
    private final FileDescriptor fd;
    private final int fdVal;
    private volatile long receiverThread = 0L;
    private volatile long senderThread = 0L;
    private final Object receiveLock = new Object();
    private final Object sendLock = new Object();
    private final ThreadLocal<Boolean> receiveInvoked = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private final Object stateLock = new Object();
    private ChannelState state = ChannelState.UNINITIALIZED;
    int port = -1;
    private HashSet<InetSocketAddress> localAddresses = new HashSet();
    private boolean wildcard;
    private boolean readyToConnect;
    private boolean isShutdown;
    private Association association;
    private Set<SocketAddress> remoteAddresses = Collections.emptySet();
    private InternalNotificationHandler internalNotificationHandler = new InternalNotificationHandler();

    public SctpChannelImpl(SelectorProvider provider) throws IOException {
        super(provider);
        this.fd = SctpNet.socket(true);
        this.fdVal = IOUtil.fdVal(this.fd);
        this.state = ChannelState.UNCONNECTED;
    }

    public SctpChannelImpl(SelectorProvider provider, FileDescriptor fd) throws IOException {
        this(provider, fd, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SctpChannelImpl(SelectorProvider provider, FileDescriptor fd, Association association) throws IOException {
        super(provider);
        this.fd = fd;
        this.fdVal = IOUtil.fdVal(fd);
        this.state = ChannelState.CONNECTED;
        this.port = Net.localAddress(fd).getPort();
        if (association != null) {
            this.association = association;
        } else {
            ByteBuffer buf = Util.getTemporaryDirectBuffer(50);
            try {
                this.receive(buf, null, null, true);
            }
            finally {
                Util.releaseTemporaryDirectBuffer(buf);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SctpChannel bind(SocketAddress local) throws IOException {
        Object object = this.receiveLock;
        synchronized (object) {
            Object object2 = this.sendLock;
            synchronized (object2) {
                Object object3 = this.stateLock;
                synchronized (object3) {
                    this.ensureOpenAndUnconnected();
                    if (this.isBound()) {
                        SctpNet.throwAlreadyBoundException();
                    }
                    InetSocketAddress isa = local == null ? new InetSocketAddress(0) : Net.checkAddress(local);
                    SecurityManager sm = System.getSecurityManager();
                    if (sm != null) {
                        sm.checkListen(isa.getPort());
                    }
                    Net.bind(this.fd, isa.getAddress(), isa.getPort());
                    InetSocketAddress boundIsa = Net.localAddress(this.fd);
                    this.port = boundIsa.getPort();
                    this.localAddresses.add(isa);
                    if (isa.getAddress().isAnyLocalAddress()) {
                        this.wildcard = true;
                    }
                }
            }
        }
        return this;
    }

    @Override
    public SctpChannel bindAddress(InetAddress address) throws IOException {
        this.bindUnbindAddress(address, true);
        this.localAddresses.add(new InetSocketAddress(address, this.port));
        return this;
    }

    @Override
    public SctpChannel unbindAddress(InetAddress address) throws IOException {
        this.bindUnbindAddress(address, false);
        this.localAddresses.remove(new InetSocketAddress(address, this.port));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SctpChannel bindUnbindAddress(InetAddress address, boolean add) throws IOException {
        if (address == null) {
            throw new IllegalArgumentException();
        }
        Object object = this.receiveLock;
        synchronized (object) {
            Object object2 = this.sendLock;
            synchronized (object2) {
                Object object3 = this.stateLock;
                synchronized (object3) {
                    if (!this.isOpen()) {
                        throw new ClosedChannelException();
                    }
                    if (!this.isBound()) {
                        throw new NotYetBoundException();
                    }
                    if (this.wildcard) {
                        throw new IllegalStateException("Cannot add or remove addresses from a channel that is bound to the wildcard address");
                    }
                    if (address.isAnyLocalAddress()) {
                        throw new IllegalArgumentException("Cannot add or remove the wildcard address");
                    }
                    if (add) {
                        for (InetSocketAddress inetSocketAddress : this.localAddresses) {
                            if (!inetSocketAddress.getAddress().equals(address)) continue;
                            SctpNet.throwAlreadyBoundException();
                        }
                    } else {
                        if (this.localAddresses.size() <= 1) {
                            throw new IllegalUnbindException("Cannot remove address from a channel with only one address bound");
                        }
                        boolean foundAddress = false;
                        for (InetSocketAddress addr : this.localAddresses) {
                            if (!addr.getAddress().equals(address)) continue;
                            foundAddress = true;
                            break;
                        }
                        if (!foundAddress) {
                            throw new IllegalUnbindException("Cannot remove address from a channel that is not bound to that address");
                        }
                    }
                    SctpNet.bindx(this.fdVal, new InetAddress[]{address}, this.port, add);
                    if (add) {
                        this.localAddresses.add(new InetSocketAddress(address, this.port));
                    } else {
                        for (InetSocketAddress inetSocketAddress : this.localAddresses) {
                            if (!inetSocketAddress.getAddress().equals(address)) continue;
                            this.localAddresses.remove(inetSocketAddress);
                            break;
                        }
                    }
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isBound() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.port != -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isConnected() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state == ChannelState.CONNECTED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureOpenAndUnconnected() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (this.isConnected()) {
                throw new AlreadyConnectedException();
            }
            if (this.state == ChannelState.PENDING) {
                throw new ConnectionPendingException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean ensureReceiveOpen() throws ClosedChannelException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (!this.isConnected()) {
                throw new NotYetConnectedException();
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureSendOpen() throws ClosedChannelException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (this.isShutdown) {
                throw new ClosedChannelException();
            }
            if (!this.isConnected()) {
                throw new NotYetConnectedException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiverCleanup() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.receiverThread = 0L;
            if (this.state == ChannelState.KILLPENDING) {
                this.kill();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void senderCleanup() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.senderThread = 0L;
            if (this.state == ChannelState.KILLPENDING) {
                this.kill();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Association association() throws ClosedChannelException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (!this.isConnected()) {
                return null;
            }
            return this.association;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean connect(SocketAddress endpoint) throws IOException {
        Object object;
        Object object2 = this.receiveLock;
        // MONITORENTER : object2
        Object object3 = this.sendLock;
        // MONITORENTER : object3
        this.ensureOpenAndUnconnected();
        InetSocketAddress isa = Net.checkAddress(endpoint);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkConnect(isa.getAddress().getHostAddress(), isa.getPort());
        }
        Object object4 = this.blockingLock();
        // MONITORENTER : object4
        int n = 0;
        try {
            block32: {
                this.begin();
                object = this.stateLock;
                // MONITORENTER : object
                if (this.isOpen()) break block32;
                boolean bl = false;
                // MONITOREXIT : object
                this.receiverCleanup();
                this.end(n > 0 || n == -2);
                assert (IOStatus.check(n));
                // MONITOREXIT : object4
                // MONITOREXIT : object3
                // MONITOREXIT : object2
                return bl;
            }
            try {
                InetAddress ia;
                this.receiverThread = NativeThread.current();
                // MONITOREXIT : object
                do {
                    if (!(ia = isa.getAddress()).isAnyLocalAddress()) continue;
                    ia = InetAddress.getLocalHost();
                } while ((n = SctpNet.connect(this.fdVal, ia, isa.getPort())) == -3 && this.isOpen());
            }
            catch (Throwable throwable) {
                this.receiverCleanup();
                this.end(n > 0 || n == -2);
                if ($assertionsDisabled) throw throwable;
                if (IOStatus.check(n)) throw throwable;
                throw new AssertionError();
            }
            this.receiverCleanup();
            this.end(n > 0 || n == -2);
            assert (IOStatus.check(n));
        }
        catch (IOException x) {
            this.close();
            throw x;
        }
        if (n > 0) {
            object = this.stateLock;
            // MONITORENTER : object
            this.state = ChannelState.CONNECTED;
            if (!this.isBound()) {
                InetSocketAddress boundIsa = Net.localAddress(this.fd);
                this.port = boundIsa.getPort();
            }
            ByteBuffer buf = Util.getTemporaryDirectBuffer(50);
            try {
                this.receive(buf, null, null, true);
            }
            finally {
                Util.releaseTemporaryDirectBuffer(buf);
            }
            try {
                this.remoteAddresses = this.getRemoteAddresses();
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return true;
        }
        object = this.stateLock;
        // MONITORENTER : object
        if (!this.isBlocking()) {
            this.state = ChannelState.PENDING;
            return false;
        }
        assert (false);
        // MONITOREXIT : object
        // MONITOREXIT : object4
        // MONITOREXIT : object3
        // MONITOREXIT : object2
        return false;
    }

    @Override
    public boolean connect(SocketAddress endpoint, int maxOutStreams, int maxInStreams) throws IOException {
        this.ensureOpenAndUnconnected();
        return this.setOption(SctpStandardSocketOptions.SCTP_INIT_MAXSTREAMS, SctpStandardSocketOptions.InitMaxStreams.create(maxInStreams, maxOutStreams)).connect(endpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnectionPending() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state == ChannelState.PENDING;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean finishConnect() throws IOException {
        Object object;
        Object object2 = this.receiveLock;
        // MONITORENTER : object2
        Object object3 = this.sendLock;
        // MONITORENTER : object3
        Object object4 = this.stateLock;
        // MONITORENTER : object4
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (this.isConnected()) {
            // MONITOREXIT : object4
            // MONITOREXIT : object3
            // MONITOREXIT : object2
            return true;
        }
        if (this.state != ChannelState.PENDING) {
            throw new NoConnectionPendingException();
        }
        // MONITOREXIT : object4
        int n = 0;
        try {
            block44: {
                this.begin();
                object = this.blockingLock();
                // MONITORENTER : object
                Object object5 = this.stateLock;
                // MONITORENTER : object5
                if (this.isOpen()) break block44;
                boolean bl = false;
                // MONITOREXIT : object5
                // MONITOREXIT : object
                Object object6 = this.stateLock;
                // MONITORENTER : object6
                this.receiverThread = 0L;
                if (this.state == ChannelState.KILLPENDING) {
                    this.kill();
                    n = 0;
                }
                // MONITOREXIT : object6
                this.end(n > 0 || n == -2);
                assert (IOStatus.check(n));
                // MONITOREXIT : object3
                // MONITOREXIT : object2
                return bl;
            }
            try {
                this.receiverThread = NativeThread.current();
                // MONITOREXIT : object5
                if (!this.isBlocking()) {
                    while ((n = SctpChannelImpl.checkConnect(this.fd, false, this.readyToConnect)) == -3 && this.isOpen()) {
                    }
                } else {
                    while ((n = SctpChannelImpl.checkConnect(this.fd, true, this.readyToConnect)) == 0 || n == -3 && this.isOpen()) {
                    }
                }
                // MONITOREXIT : object
                object = this.stateLock;
            }
            catch (Throwable throwable) {
                Object object7 = this.stateLock;
                // MONITORENTER : object7
                this.receiverThread = 0L;
                if (this.state == ChannelState.KILLPENDING) {
                    this.kill();
                    n = 0;
                }
                // MONITOREXIT : object7
                this.end(n > 0 || n == -2);
                if ($assertionsDisabled) throw throwable;
                if (IOStatus.check(n)) throw throwable;
                throw new AssertionError();
            }
            this.receiverThread = 0L;
            if (this.state == ChannelState.KILLPENDING) {
                this.kill();
                n = 0;
            }
            // MONITOREXIT : object
            this.end(n > 0 || n == -2);
            assert (IOStatus.check(n));
        }
        catch (IOException x) {
            this.close();
            throw x;
        }
        if (n <= 0) {
            // MONITOREXIT : object3
            // MONITOREXIT : object2
            return false;
        }
        object = this.stateLock;
        // MONITORENTER : object
        this.state = ChannelState.CONNECTED;
        if (!this.isBound()) {
            InetSocketAddress boundIsa = Net.localAddress(this.fd);
            this.port = boundIsa.getPort();
        }
        ByteBuffer buf = Util.getTemporaryDirectBuffer(50);
        try {
            this.receive(buf, null, null, true);
        }
        finally {
            Util.releaseTemporaryDirectBuffer(buf);
        }
        try {
            this.remoteAddresses = this.getRemoteAddresses();
            return true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    @Override
    protected void implConfigureBlocking(boolean block) throws IOException {
        IOUtil.configureBlocking(this.fd, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void implCloseSelectableChannel() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            SctpNet.preClose(this.fdVal);
            if (this.receiverThread != 0L) {
                NativeThread.signal(this.receiverThread);
            }
            if (this.senderThread != 0L) {
                NativeThread.signal(this.senderThread);
            }
            if (!this.isRegistered()) {
                this.kill();
            }
        }
    }

    @Override
    public FileDescriptor getFD() {
        return this.fd;
    }

    @Override
    public int getFDVal() {
        return this.fdVal;
    }

    private boolean translateReadyOps(int ops, int initialOps, SelectionKeyImpl sk) {
        int intOps = sk.nioInterestOps();
        int oldOps = sk.nioReadyOps();
        int newOps = initialOps;
        if ((ops & Net.POLLNVAL) != 0) {
            return false;
        }
        if ((ops & (Net.POLLERR | Net.POLLHUP)) != 0) {
            newOps = intOps;
            sk.nioReadyOps(newOps);
            this.readyToConnect = true;
            return (newOps & ~oldOps) != 0;
        }
        if ((ops & Net.POLLIN) != 0 && (intOps & 1) != 0 && this.isConnected()) {
            newOps |= 1;
        }
        if ((ops & Net.POLLCONN) != 0 && (intOps & 8) != 0 && (this.state == ChannelState.UNCONNECTED || this.state == ChannelState.PENDING)) {
            newOps |= 8;
            this.readyToConnect = true;
        }
        if ((ops & Net.POLLOUT) != 0 && (intOps & 4) != 0 && this.isConnected()) {
            newOps |= 4;
        }
        sk.nioReadyOps(newOps);
        return (newOps & ~oldOps) != 0;
    }

    @Override
    public boolean translateAndUpdateReadyOps(int ops, SelectionKeyImpl sk) {
        return this.translateReadyOps(ops, sk.nioReadyOps(), sk);
    }

    @Override
    public boolean translateAndSetReadyOps(int ops, SelectionKeyImpl sk) {
        return this.translateReadyOps(ops, 0, sk);
    }

    @Override
    public void translateAndSetInterestOps(int ops, SelectionKeyImpl sk) {
        int newOps = 0;
        if ((ops & 1) != 0) {
            newOps |= Net.POLLIN;
        }
        if ((ops & 4) != 0) {
            newOps |= Net.POLLOUT;
        }
        if ((ops & 8) != 0) {
            newOps |= Net.POLLCONN;
        }
        sk.selector.putEventOps(sk, newOps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void kill() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == ChannelState.KILLED) {
                return;
            }
            if (this.state == ChannelState.UNINITIALIZED) {
                this.state = ChannelState.KILLED;
                return;
            }
            assert (!this.isOpen() && !this.isRegistered());
            if (this.receiverThread == 0L && this.senderThread == 0L) {
                SctpNet.close(this.fdVal);
                this.state = ChannelState.KILLED;
            } else {
                this.state = ChannelState.KILLPENDING;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> SctpChannel setOption(SctpSocketOption<T> name, T value) throws IOException {
        if (name == null) {
            throw new NullPointerException();
        }
        if (!this.supportedOptions().contains(name)) {
            throw new UnsupportedOperationException("'" + name + "' not supported");
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            SctpNet.setSocketOption(this.fdVal, name, value, 0);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getOption(SctpSocketOption<T> name) throws IOException {
        if (name == null) {
            throw new NullPointerException();
        }
        if (!this.supportedOptions().contains(name)) {
            throw new UnsupportedOperationException("'" + name + "' not supported");
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            return (T)SctpNet.getSocketOption(this.fdVal, name, 0);
        }
    }

    @Override
    public final Set<SctpSocketOption<?>> supportedOptions() {
        return DefaultOptionsHolder.defaultOptions;
    }

    @Override
    public <T> MessageInfo receive(ByteBuffer buffer, T attachment, NotificationHandler<T> handler) throws IOException {
        return this.receive(buffer, attachment, handler, false);
    }

    /*
     * Exception decompiling
     */
    private <T> MessageInfo receive(ByteBuffer buffer, T attachment, NotificationHandler<T> handler, boolean fromConnect) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 14[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int receive(int fd, ByteBuffer dst, ResultContainer resultContainer, boolean peek) throws IOException {
        int rem;
        int pos = dst.position();
        int lim = dst.limit();
        assert (pos <= lim);
        int n = rem = pos <= lim ? lim - pos : 0;
        if (dst instanceof DirectBuffer && rem > 0) {
            return this.receiveIntoNativeBuffer(fd, resultContainer, dst, rem, pos, peek);
        }
        int newSize = Math.max(rem, 1);
        ByteBuffer bb = Util.getTemporaryDirectBuffer(newSize);
        try {
            int n2 = this.receiveIntoNativeBuffer(fd, resultContainer, bb, newSize, 0, peek);
            bb.flip();
            if (n2 > 0 && rem > 0) {
                dst.put(bb);
            }
            int n3 = n2;
            return n3;
        }
        finally {
            Util.releaseTemporaryDirectBuffer(bb);
        }
    }

    private int receiveIntoNativeBuffer(int fd, ResultContainer resultContainer, ByteBuffer bb, int rem, int pos, boolean peek) throws IOException {
        int n = SctpChannelImpl.receive0(fd, resultContainer, ((DirectBuffer)((Object)bb)).address() + (long)pos, rem, peek);
        if (n > 0) {
            bb.position(pos + n);
        }
        return n;
    }

    private void handleNotificationInternal(ResultContainer resultContainer) {
        this.invokeNotificationHandler(resultContainer, this.internalNotificationHandler, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> HandlerResult invokeNotificationHandler(ResultContainer resultContainer, NotificationHandler<T> handler, T attachment) {
        SctpNotification notification = resultContainer.notification();
        Object object = this.stateLock;
        synchronized (object) {
            notification.setAssociation(this.association);
        }
        if (!(handler instanceof AbstractNotificationHandler)) {
            return handler.handleNotification(notification, attachment);
        }
        AbstractNotificationHandler absHandler = (AbstractNotificationHandler)handler;
        switch (resultContainer.type()) {
            case 3: {
                return absHandler.handleNotification(resultContainer.getAssociationChanged(), attachment);
            }
            case 4: {
                return absHandler.handleNotification(resultContainer.getPeerAddressChanged(), attachment);
            }
            case 2: {
                return absHandler.handleNotification(resultContainer.getSendFailed(), attachment);
            }
            case 5: {
                return absHandler.handleNotification(resultContainer.getShutdown(), attachment);
            }
        }
        return absHandler.handleNotification(resultContainer.notification(), attachment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAssociation(Association sendAssociation) {
        Object object = this.stateLock;
        synchronized (object) {
            if (sendAssociation != null && !sendAssociation.equals(this.association)) {
                throw new IllegalArgumentException("Cannot send to another association");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkStreamNumber(int streamNumber) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.association != null && (streamNumber < 0 || streamNumber >= this.association.maxOutboundStreams())) {
                throw new InvalidStreamException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public int send(ByteBuffer buffer, MessageInfo messageInfo) throws IOException {
        int n;
        int n2;
        block13: {
            if (buffer == null) {
                throw new IllegalArgumentException("buffer cannot be null");
            }
            if (messageInfo == null) {
                throw new IllegalArgumentException("messageInfo cannot be null");
            }
            this.checkAssociation(messageInfo.association());
            this.checkStreamNumber(messageInfo.streamNumber());
            Object object = this.sendLock;
            // MONITORENTER : object
            this.ensureSendOpen();
            n2 = 0;
            this.begin();
            Object object2 = this.stateLock;
            // MONITORENTER : object2
            if (this.isOpen()) break block13;
            int n3 = 0;
            // MONITOREXIT : object2
            this.senderCleanup();
            this.end(n2 > 0 || n2 == -2);
            assert (IOStatus.check(n2));
            // MONITOREXIT : object
            return n3;
        }
        try {
            this.senderThread = NativeThread.current();
            // MONITOREXIT : object2
            while ((n2 = this.send(this.fdVal, buffer, messageInfo)) == -3 && this.isOpen()) {
            }
            n = IOStatus.normalize(n2);
        }
        catch (Throwable throwable) {
            this.senderCleanup();
            this.end(n2 > 0 || n2 == -2);
            if ($assertionsDisabled) throw throwable;
            if (IOStatus.check(n2)) throw throwable;
            throw new AssertionError();
        }
        this.senderCleanup();
        this.end(n2 > 0 || n2 == -2);
        assert (IOStatus.check(n2));
        // MONITOREXIT : object
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int send(int fd, ByteBuffer src, MessageInfo messageInfo) throws IOException {
        int streamNumber = messageInfo.streamNumber();
        SocketAddress target = messageInfo.address();
        boolean unordered = messageInfo.isUnordered();
        int ppid = messageInfo.payloadProtocolID();
        if (src instanceof DirectBuffer) {
            return this.sendFromNativeBuffer(fd, src, target, streamNumber, unordered, ppid);
        }
        int pos = src.position();
        int lim = src.limit();
        assert (pos <= lim && streamNumber >= 0);
        int rem = pos <= lim ? lim - pos : 0;
        ByteBuffer bb = Util.getTemporaryDirectBuffer(rem);
        try {
            bb.put(src);
            bb.flip();
            src.position(pos);
            int n = this.sendFromNativeBuffer(fd, bb, target, streamNumber, unordered, ppid);
            if (n > 0) {
                src.position(pos + n);
            }
            int n2 = n;
            return n2;
        }
        finally {
            Util.releaseTemporaryDirectBuffer(bb);
        }
    }

    private int sendFromNativeBuffer(int fd, ByteBuffer bb, SocketAddress target, int streamNumber, boolean unordered, int ppid) throws IOException {
        InetAddress addr = null;
        int port = 0;
        if (target != null) {
            InetSocketAddress isa = Net.checkAddress(target);
            addr = isa.getAddress();
            port = isa.getPort();
        }
        int pos = bb.position();
        int lim = bb.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        int written = SctpChannelImpl.send0(fd, ((DirectBuffer)((Object)bb)).address() + (long)pos, rem, addr, port, -1, streamNumber, unordered, ppid);
        if (written > 0) {
            bb.position(pos + written);
        }
        return written;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SctpChannel shutdown() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.isShutdown) {
                return this;
            }
            this.ensureSendOpen();
            SctpNet.shutdown(this.fdVal, -1);
            if (this.senderThread != 0L) {
                NativeThread.signal(this.senderThread);
            }
            this.isShutdown = true;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<SocketAddress> getAllLocalAddresses() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (!this.isBound()) {
                return Collections.emptySet();
            }
            return SctpNet.getLocalAddresses(this.fdVal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<SocketAddress> getRemoteAddresses() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (!this.isConnected() || this.isShutdown) {
                return Collections.emptySet();
            }
            try {
                return SctpNet.getRemoteAddresses(this.fdVal, 0);
            }
            catch (SocketException unused) {
                return this.remoteAddresses;
            }
        }
    }

    private static native void initIDs();

    static native int receive0(int var0, ResultContainer var1, long var2, int var4, boolean var5) throws IOException;

    static native int send0(int var0, long var1, int var3, InetAddress var4, int var5, int var6, int var7, boolean var8, int var9) throws IOException;

    private static native int checkConnect(FileDescriptor var0, boolean var1, boolean var2) throws IOException;

    static {
        IOUtil.load();
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("j2sctp");
                return null;
            }
        });
        SctpChannelImpl.initIDs();
    }

    private class InternalNotificationHandler
    extends AbstractNotificationHandler<Object> {
        private InternalNotificationHandler() {
        }

        @Override
        public HandlerResult handleNotification(AssociationChangeNotification not, Object unused) {
            if (not.event().equals((Object)AssociationChangeNotification.AssocChangeEvent.COMM_UP) && SctpChannelImpl.this.association == null) {
                AssociationChange sac = (AssociationChange)not;
                SctpChannelImpl.this.association = new AssociationImpl(sac.assocId(), sac.maxInStreams(), sac.maxOutStreams());
            }
            return HandlerResult.CONTINUE;
        }
    }

    private static class DefaultOptionsHolder {
        static final Set<SctpSocketOption<?>> defaultOptions = DefaultOptionsHolder.defaultOptions();

        private DefaultOptionsHolder() {
        }

        private static Set<SctpSocketOption<?>> defaultOptions() {
            HashSet<SctpSocketOption<Object>> set = new HashSet<SctpSocketOption<Object>>(10);
            set.add(SctpStandardSocketOptions.SCTP_DISABLE_FRAGMENTS);
            set.add(SctpStandardSocketOptions.SCTP_EXPLICIT_COMPLETE);
            set.add(SctpStandardSocketOptions.SCTP_FRAGMENT_INTERLEAVE);
            set.add(SctpStandardSocketOptions.SCTP_INIT_MAXSTREAMS);
            set.add(SctpStandardSocketOptions.SCTP_NODELAY);
            set.add(SctpStandardSocketOptions.SCTP_PRIMARY_ADDR);
            set.add(SctpStandardSocketOptions.SCTP_SET_PEER_PRIMARY_ADDR);
            set.add(SctpStandardSocketOptions.SO_SNDBUF);
            set.add(SctpStandardSocketOptions.SO_RCVBUF);
            set.add(SctpStandardSocketOptions.SO_LINGER);
            return Collections.unmodifiableSet(set);
        }
    }

    private static enum ChannelState {
        UNINITIALIZED,
        UNCONNECTED,
        PENDING,
        CONNECTED,
        KILLPENDING,
        KILLED;

    }
}

