/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import com.sun.management.UnixOperatingSystemMXBean;
import java.util.concurrent.TimeUnit;
import jdk.internal.platform.Container;
import jdk.internal.platform.Metrics;
import sun.management.BaseOperatingSystemImpl;
import sun.management.VMManagement;

class OperatingSystemImpl
extends BaseOperatingSystemImpl
implements UnixOperatingSystemMXBean {
    private static final int MAX_ATTEMPTS_NUMBER = 10;
    private final Metrics containerMetrics = Container.metrics();

    OperatingSystemImpl(VMManagement vm) {
        super(vm);
    }

    @Override
    public long getTotalSwapSpaceSize() {
        if (this.containerMetrics != null) {
            long limit = this.containerMetrics.getMemoryAndSwapLimit();
            long memLimit = this.containerMetrics.getMemoryLimit();
            if (limit >= 0L && memLimit >= 0L) {
                return limit - memLimit;
            }
        }
        return this.getTotalSwapSpaceSize0();
    }

    @Override
    public long getFreeSwapSpaceSize() {
        if (this.containerMetrics != null) {
            long memSwapLimit = this.containerMetrics.getMemoryAndSwapLimit();
            long memLimit = this.containerMetrics.getMemoryLimit();
            if (memSwapLimit >= 0L && memLimit >= 0L) {
                for (int attempt = 0; attempt < 10; ++attempt) {
                    long memSwapUsage = this.containerMetrics.getMemoryAndSwapUsage();
                    long memUsage = this.containerMetrics.getMemoryUsage();
                    if (memSwapUsage <= 0L || memUsage <= 0L || memSwapUsage - memUsage < 0L) continue;
                    return memSwapLimit - memLimit - (memSwapUsage - memUsage);
                }
            }
        }
        return this.getFreeSwapSpaceSize0();
    }

    @Override
    public long getFreePhysicalMemorySize() {
        if (this.containerMetrics != null) {
            long usage = this.containerMetrics.getMemoryUsage();
            long limit = this.containerMetrics.getMemoryLimit();
            if (usage > 0L && limit >= 0L) {
                return limit - usage;
            }
        }
        return this.getFreePhysicalMemorySize0();
    }

    @Override
    public long getTotalPhysicalMemorySize() {
        long limit;
        if (this.containerMetrics != null && (limit = this.containerMetrics.getMemoryLimit()) >= 0L) {
            return limit;
        }
        return this.getTotalPhysicalMemorySize0();
    }

    @Override
    public double getSystemCpuLoad() {
        if (this.containerMetrics != null) {
            long quota = this.containerMetrics.getCpuQuota();
            if (quota > 0L) {
                long periodLength = this.containerMetrics.getCpuPeriod();
                long numPeriods = this.containerMetrics.getCpuNumPeriods();
                long usageNanos = this.containerMetrics.getCpuUsage();
                if (periodLength > 0L && numPeriods > 0L && usageNanos > 0L) {
                    long elapsedNanos = TimeUnit.MICROSECONDS.toNanos(periodLength * numPeriods);
                    double systemLoad = (double)usageNanos / (double)elapsedNanos;
                    systemLoad = Math.max(0.0, systemLoad);
                    systemLoad = Math.min(1.0, systemLoad);
                    return systemLoad;
                }
                return -1.0;
            }
            if (this.isCpuSetSameAsHostCpuSet()) {
                return this.getSystemCpuLoad0();
            }
            int[] cpuSet = this.containerMetrics.getEffectiveCpuSetCpus();
            if (cpuSet != null && cpuSet.length > 0) {
                double systemLoad = 0.0;
                for (int cpu : cpuSet) {
                    double cpuLoad = this.getSingleCpuLoad0(cpu);
                    if (cpuLoad < 0.0) {
                        return -1.0;
                    }
                    systemLoad += cpuLoad;
                }
                return systemLoad / (double)cpuSet.length;
            }
            return -1.0;
        }
        return this.getSystemCpuLoad0();
    }

    private boolean isCpuSetSameAsHostCpuSet() {
        if (this.containerMetrics != null) {
            return this.containerMetrics.getCpuSetCpus().length == this.getHostConfiguredCpuCount0();
        }
        return false;
    }

    @Override
    public native long getCommittedVirtualMemorySize();

    private native long getTotalSwapSpaceSize0();

    private native long getFreeSwapSpaceSize0();

    @Override
    public native long getProcessCpuTime();

    private native long getFreePhysicalMemorySize0();

    private native long getTotalPhysicalMemorySize0();

    @Override
    public native long getOpenFileDescriptorCount();

    @Override
    public native long getMaxFileDescriptorCount();

    private native double getSystemCpuLoad0();

    @Override
    public native double getProcessCpuLoad();

    private native double getSingleCpuLoad0(int var1);

    private native int getHostConfiguredCpuCount0();

    private static native void initialize();

    static {
        OperatingSystemImpl.initialize();
    }
}

