/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.xr;

import java.awt.GraphicsConfiguration;
import java.awt.ImageCapabilities;
import java.awt.image.ColorModel;
import sun.awt.image.SunVolatileImage;
import sun.awt.image.VolatileSurfaceManager;
import sun.java2d.SurfaceData;
import sun.java2d.xr.XRGraphicsConfig;
import sun.java2d.xr.XRSurfaceData;

public class XRVolatileSurfaceManager
extends VolatileSurfaceManager {
    public XRVolatileSurfaceManager(SunVolatileImage vImg, Object context) {
        super(vImg, context);
    }

    @Override
    protected boolean isAccelerationEnabled() {
        return true;
    }

    @Override
    protected SurfaceData initAcceleratedSurface() {
        XRSurfaceData.XRPixmapSurfaceData sData;
        try {
            XRGraphicsConfig gc = (XRGraphicsConfig)this.vImg.getGraphicsConfig();
            ColorModel cm = gc.getColorModel();
            long drawable = 0L;
            if (this.context instanceof Long) {
                drawable = (Long)this.context;
            }
            sData = XRSurfaceData.createData(gc, this.vImg.getWidth(), this.vImg.getHeight(), cm, this.vImg, drawable, this.vImg.getTransparency(), false);
        }
        catch (NullPointerException ex) {
            sData = null;
        }
        catch (OutOfMemoryError er) {
            sData = null;
        }
        return sData;
    }

    @Override
    protected boolean isConfigValid(GraphicsConfiguration gc) {
        return true;
    }

    @Override
    public ImageCapabilities getCapabilities(GraphicsConfiguration gc) {
        if (this.isConfigValid(gc) && this.isAccelerationEnabled()) {
            return new ImageCapabilities(true);
        }
        return new ImageCapabilities(false);
    }
}

