/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.opengl;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import sun.awt.X11ComponentPeer;
import sun.java2d.SurfaceData;
import sun.java2d.opengl.GLXGraphicsConfig;
import sun.java2d.opengl.OGLGraphicsConfig;
import sun.java2d.opengl.OGLSurfaceData;

public abstract class GLXSurfaceData
extends OGLSurfaceData {
    protected X11ComponentPeer peer;
    private GLXGraphicsConfig graphicsConfig;

    private native void initOps(OGLGraphicsConfig var1, X11ComponentPeer var2, long var3);

    @Override
    protected native boolean initPbuffer(long var1, long var3, boolean var5, int var6, int var7);

    protected GLXSurfaceData(X11ComponentPeer peer, GLXGraphicsConfig gc, ColorModel cm, int type) {
        super(gc, cm, type);
        this.peer = peer;
        this.graphicsConfig = gc;
        this.initOps(gc, peer, this.graphicsConfig.getAData());
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return this.graphicsConfig;
    }

    public static GLXWindowSurfaceData createData(X11ComponentPeer peer) {
        GLXGraphicsConfig gc = GLXSurfaceData.getGC(peer);
        return new GLXWindowSurfaceData(peer, gc);
    }

    public static GLXOffScreenSurfaceData createData(X11ComponentPeer peer, Image image, int type) {
        GLXGraphicsConfig gc = GLXSurfaceData.getGC(peer);
        Rectangle r = peer.getBounds();
        if (type == 4) {
            return new GLXOffScreenSurfaceData(peer, gc, r.width, r.height, image, peer.getColorModel(), 4);
        }
        return new GLXVSyncOffScreenSurfaceData(peer, gc, r.width, r.height, image, peer.getColorModel(), type);
    }

    public static GLXOffScreenSurfaceData createData(GLXGraphicsConfig gc, int width, int height, ColorModel cm, Image image, int type) {
        return new GLXOffScreenSurfaceData(null, gc, width, height, image, cm, type);
    }

    public static GLXGraphicsConfig getGC(X11ComponentPeer peer) {
        if (peer != null) {
            return (GLXGraphicsConfig)peer.getGraphicsConfiguration();
        }
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = env.getDefaultScreenDevice();
        return (GLXGraphicsConfig)gd.getDefaultConfiguration();
    }

    public static class GLXOffScreenSurfaceData
    extends GLXSurfaceData {
        private Image offscreenImage;
        private int width;
        private int height;

        public GLXOffScreenSurfaceData(X11ComponentPeer peer, GLXGraphicsConfig gc, int width, int height, Image image, ColorModel cm, int type) {
            super(peer, gc, cm, type);
            this.width = width;
            this.height = height;
            this.offscreenImage = image;
            this.initSurface(width, height);
        }

        @Override
        public SurfaceData getReplacement() {
            return GLXOffScreenSurfaceData.restoreContents(this.offscreenImage);
        }

        @Override
        public Rectangle getBounds() {
            if (this.type == 4) {
                Rectangle r = this.peer.getBounds();
                r.y = 0;
                r.x = 0;
                return r;
            }
            return new Rectangle(this.width, this.height);
        }

        @Override
        public Object getDestination() {
            return this.offscreenImage;
        }
    }

    public static class GLXVSyncOffScreenSurfaceData
    extends GLXOffScreenSurfaceData {
        private GLXOffScreenSurfaceData flipSurface;

        public GLXVSyncOffScreenSurfaceData(X11ComponentPeer peer, GLXGraphicsConfig gc, int width, int height, Image image, ColorModel cm, int type) {
            super(peer, gc, width, height, image, cm, type);
            this.flipSurface = GLXSurfaceData.createData(peer, image, 4);
        }

        public SurfaceData getFlipSurface() {
            return this.flipSurface;
        }

        @Override
        public void flush() {
            this.flipSurface.flush();
            super.flush();
        }
    }

    public static class GLXWindowSurfaceData
    extends GLXSurfaceData {
        public GLXWindowSurfaceData(X11ComponentPeer peer, GLXGraphicsConfig gc) {
            super(peer, gc, peer.getColorModel(), 1);
        }

        @Override
        public SurfaceData getReplacement() {
            return this.peer.getSurfaceData();
        }

        @Override
        public Rectangle getBounds() {
            Rectangle r = this.peer.getBounds();
            r.y = 0;
            r.x = 0;
            return r;
        }

        @Override
        public Object getDestination() {
            return this.peer.getTarget();
        }
    }
}

