/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.awt.peer.ComponentPeer;
import java.awt.peer.WindowPeer;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import sun.awt.AWTAccessor;
import sun.awt.AWTIcon32_java_icon16_png;
import sun.awt.AWTIcon32_java_icon24_png;
import sun.awt.AWTIcon32_java_icon32_png;
import sun.awt.AWTIcon32_java_icon48_png;
import sun.awt.AWTIcon64_java_icon16_png;
import sun.awt.AWTIcon64_java_icon24_png;
import sun.awt.AWTIcon64_java_icon32_png;
import sun.awt.AWTIcon64_java_icon48_png;
import sun.awt.DisplayChangedListener;
import sun.awt.IconInfo;
import sun.awt.SunToolkit;
import sun.awt.UngrabEvent;
import sun.awt.X11.Native;
import sun.awt.X11.PropMwmHints;
import sun.awt.X11.ToplevelStateListener;
import sun.awt.X11.XAtom;
import sun.awt.X11.XAtomList;
import sun.awt.X11.XAwtState;
import sun.awt.X11.XBaseWindow;
import sun.awt.X11.XButtonEvent;
import sun.awt.X11.XClientMessageEvent;
import sun.awt.X11.XConfigureEvent;
import sun.awt.X11.XConstants;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XCrossingEvent;
import sun.awt.X11.XDecoratedPeer;
import sun.awt.X11.XDialogPeer;
import sun.awt.X11.XDropTargetRegistry;
import sun.awt.X11.XEvent;
import sun.awt.X11.XEventDispatcher;
import sun.awt.X11.XFocusChangeEvent;
import sun.awt.X11.XFocusProxyWindow;
import sun.awt.X11.XKeyboardFocusManagerPeer;
import sun.awt.X11.XLightweightFramePeer;
import sun.awt.X11.XMotionEvent;
import sun.awt.X11.XNETProtocol;
import sun.awt.X11.XPanelPeer;
import sun.awt.X11.XPropertyEvent;
import sun.awt.X11.XQueryTree;
import sun.awt.X11.XSizeHints;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XUnmapEvent;
import sun.awt.X11.XVisibilityEvent;
import sun.awt.X11.XWM;
import sun.awt.X11.XWMHints;
import sun.awt.X11.XWarningWindow;
import sun.awt.X11.XWindow;
import sun.awt.X11.XWindowAttributesData;
import sun.awt.X11.XlibUtil;
import sun.awt.X11.XlibWrapper;
import sun.awt.X11GraphicsDevice;
import sun.awt.X11GraphicsEnvironment;
import sun.java2d.pipe.Region;
import sun.util.logging.PlatformLogger;

class XWindowPeer
extends XPanelPeer
implements WindowPeer,
DisplayChangedListener {
    private static final PlatformLogger log = PlatformLogger.getLogger("sun.awt.X11.XWindowPeer");
    private static final PlatformLogger focusLog = PlatformLogger.getLogger("sun.awt.X11.focus.XWindowPeer");
    private static final PlatformLogger insLog = PlatformLogger.getLogger("sun.awt.X11.insets.XWindowPeer");
    private static final PlatformLogger grabLog = PlatformLogger.getLogger("sun.awt.X11.grab.XWindowPeer");
    private static final PlatformLogger iconLog = PlatformLogger.getLogger("sun.awt.X11.icon.XWindowPeer");
    private static Set<XWindowPeer> windows = new HashSet<XWindowPeer>();
    private boolean cachedFocusableWindow;
    XWarningWindow warningWindow;
    private boolean alwaysOnTop;
    private boolean locationByPlatform;
    Dialog modalBlocker;
    boolean delayedModalBlocking = false;
    Dimension targetMinimumSize = null;
    private XWindowPeer ownerPeer;
    protected XWindowPeer prevTransientFor;
    protected XWindowPeer nextTransientFor;
    private XWindowPeer curRealTransientFor;
    private boolean grab = false;
    private boolean isMapped = false;
    private boolean mustControlStackPosition = false;
    private XEventDispatcher rootPropertyEventDispatcher = null;
    private static final AtomicBoolean isStartupNotificationRemoved = new AtomicBoolean();
    private boolean isUnhiding = false;
    private boolean isBeforeFirstMapNotify = false;
    private Window.Type windowType = Window.Type.NORMAL;
    protected Vector<ToplevelStateListener> toplevelStateListeners = new Vector();
    private static final int PREFERRED_SIZE_FOR_ICON = 128;
    private static final int MAXIMUM_BUFFER_LENGTH_NET_WM_ICON = 65535;
    private static ArrayList<IconInfo> defaultIconInfo;
    private int dropTargetCount = 0;
    XAtom XA_NET_WM_STATE;
    XAtomList net_wm_state;
    private XBaseWindow pressTarget = this;

    public final Window.Type getWindowType() {
        return this.windowType;
    }

    XWindowPeer(XCreateWindowParams params) {
        super(params.putIfNull((Object)"parent window", (Object)0L));
    }

    XWindowPeer(Window target) {
        super(new XCreateWindowParams(new Object[]{"target", target, "parent window", 0L}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void preInit(XCreateWindowParams params) {
        Color c;
        this.target = (Component)params.get("target");
        this.windowType = ((Window)this.target).getType();
        params.put("reparented", this.isOverrideRedirect() || this.isSimpleWindow());
        super.preInit(params);
        params.putIfNull((Object)"bit gravity", (Object)1);
        long eventMask = 0L;
        if (params.containsKey("event mask")) {
            eventMask = (Long)params.get("event mask");
        }
        params.put("event mask", eventMask |= 0x10000L);
        this.XA_NET_WM_STATE = XAtom.get("_NET_WM_STATE");
        params.put("overrideRedirect", this.isOverrideRedirect());
        SunToolkit.awtLock();
        try {
            windows.add(this);
        }
        finally {
            SunToolkit.awtUnlock();
        }
        this.cachedFocusableWindow = this.isFocusableWindow();
        Font f = this.target.getFont();
        if (f == null) {
            f = XWindow.getDefaultFont();
            this.target.setFont(f);
        }
        if ((c = this.target.getBackground()) == null) {
            SystemColor background = SystemColor.window;
            this.target.setBackground(background);
        }
        if ((c = this.target.getForeground()) == null) {
            this.target.setForeground(SystemColor.windowText);
        }
        this.alwaysOnTop = ((Window)this.target).isAlwaysOnTop() && ((Window)this.target).isAlwaysOnTopSupported();
        GraphicsConfiguration gc = this.getGraphicsConfiguration();
        ((X11GraphicsDevice)gc.getDevice()).addDisplayChangedListener(this);
    }

    @Override
    protected String getWMName() {
        String name = this.target.getName();
        if (name == null || name.trim().equals("")) {
            name = " ";
        }
        return name;
    }

    private static native String getLocalHostname();

    private static native int getJvmPID();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void postInit(XCreateWindowParams params) {
        XNETProtocol protocol;
        super.postInit(params);
        this.initWMProtocols();
        XAtom.get("WM_CLIENT_MACHINE").setProperty(this.getWindow(), XWindowPeer.getLocalHostname());
        XAtom.get("_NET_WM_PID").setCard32Property(this.getWindow(), (long)XWindowPeer.getJvmPID());
        Window t_window = (Window)this.target;
        Window owner = t_window.getOwner();
        if (owner != null) {
            long ownerWindow;
            this.ownerPeer = (XWindowPeer)owner.getPeer();
            if (focusLog.isLoggable(PlatformLogger.Level.FINER)) {
                focusLog.finer("Owner is " + owner);
                focusLog.finer("Owner peer is " + this.ownerPeer);
                focusLog.finer("Owner X window " + Long.toHexString(this.ownerPeer.getWindow()));
                focusLog.finer("Owner content X window " + Long.toHexString(this.ownerPeer.getContentWindow()));
            }
            if ((ownerWindow = this.ownerPeer.getWindow()) != 0L) {
                XToolkit.awtLock();
                try {
                    if (focusLog.isLoggable(PlatformLogger.Level.FINE)) {
                        focusLog.fine("Setting transient on " + Long.toHexString(this.getWindow()) + " for " + Long.toHexString(ownerWindow));
                    }
                    XWindowPeer.setToplevelTransientFor(this, this.ownerPeer, false, true);
                    XWMHints hints = this.getWMHints();
                    hints.set_flags(hints.get_flags() | 0x40L);
                    hints.set_window_group(ownerWindow);
                    XlibWrapper.XSetWMHints(XToolkit.getDisplay(), this.getWindow(), hints.pData);
                }
                finally {
                    XToolkit.awtUnlock();
                }
            }
        }
        if ((owner != null || this.isSimpleWindow()) && (protocol = XWM.getWM().getNETProtocol()) != null && protocol.active()) {
            XToolkit.awtLock();
            try {
                XAtomList net_wm_state = this.getNETWMState();
                net_wm_state.add(protocol.XA_NET_WM_STATE_SKIP_TASKBAR);
                this.setNETWMState(net_wm_state);
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
        if (((Window)this.target).getWarningString() != null && !AWTAccessor.getWindowAccessor().isTrayIconWindow((Window)this.target)) {
            this.warningWindow = new XWarningWindow((Window)this.target, this.getWindow(), this);
        }
        this.setSaveUnder(true);
        this.updateIconImages();
        this.updateShape();
        this.updateOpacity();
    }

    @Override
    public void updateIconImages() {
        Window target = (Window)this.target;
        List<Image> iconImages = target.getIconImages();
        XWindowPeer ownerPeer = this.getOwnerPeer();
        this.winAttr.icons = new ArrayList<IconInfo>();
        if (iconImages.size() != 0) {
            this.winAttr.iconsInherited = false;
            for (Image image : iconImages) {
                IconInfo iconInfo;
                if (image == null) {
                    if (!log.isLoggable(PlatformLogger.Level.FINEST)) continue;
                    log.finest("XWindowPeer.updateIconImages: Skipping the image passed into Java because it's null.");
                    continue;
                }
                try {
                    iconInfo = new IconInfo(image);
                }
                catch (Exception e) {
                    if (!log.isLoggable(PlatformLogger.Level.FINEST)) continue;
                    log.finest("XWindowPeer.updateIconImages: Perhaps the image passed into Java is broken. Skipping this icon.");
                    continue;
                }
                if (!iconInfo.isValid()) continue;
                this.winAttr.icons.add(iconInfo);
            }
        }
        this.winAttr.icons = XWindowPeer.normalizeIconImages(this.winAttr.icons);
        if (this.winAttr.icons.size() == 0) {
            if (ownerPeer != null) {
                this.winAttr.iconsInherited = true;
                this.winAttr.icons = ownerPeer.getIconInfo();
            } else {
                this.winAttr.iconsInherited = false;
                this.winAttr.icons = XWindowPeer.getDefaultIconInfo();
            }
        }
        this.recursivelySetIcon(this.winAttr.icons);
    }

    static List<IconInfo> normalizeIconImages(List<IconInfo> icons) {
        ArrayList<IconInfo> result = new ArrayList<IconInfo>();
        int totalLength = 0;
        boolean haveLargeIcon = false;
        for (IconInfo icon : icons) {
            int width = icon.getWidth();
            int height = icon.getHeight();
            int length = icon.getRawLength();
            if (width > 128 || height > 128) {
                int scaledHeight;
                if (haveLargeIcon) continue;
                int scaledWidth = width;
                for (scaledHeight = height; scaledWidth > 128 || scaledHeight > 128; scaledWidth /= 2, scaledHeight /= 2) {
                }
                icon.setScaledSize(scaledWidth, scaledHeight);
                length = icon.getRawLength();
            }
            if (totalLength + length > 65535) continue;
            totalLength += length;
            result.add(icon);
            if (width <= 128 && height <= 128) continue;
            haveLargeIcon = true;
        }
        if (iconLog.isLoggable(PlatformLogger.Level.FINEST)) {
            iconLog.finest(">>> Length_ of buffer of icons data: " + totalLength + ", maximum length: " + 65535);
        }
        return result;
    }

    static void dumpIcons(List<IconInfo> icons) {
        if (iconLog.isLoggable(PlatformLogger.Level.FINEST)) {
            iconLog.finest(">>> Sizes of icon images:");
            Iterator<IconInfo> i = icons.iterator();
            while (i.hasNext()) {
                iconLog.finest("    {0}", i.next());
            }
        }
    }

    public void recursivelySetIcon(List<IconInfo> icons) {
        XWindowPeer.dumpIcons(this.winAttr.icons);
        this.setIconHints(icons);
        Window target = (Window)this.target;
        Window[] children = target.getOwnedWindows();
        int cnt = children.length;
        for (int i = 0; i < cnt; ++i) {
            ComponentPeer childPeer = children[i].getPeer();
            if (childPeer == null || !(childPeer instanceof XWindowPeer) || !((XWindowPeer)childPeer).winAttr.iconsInherited) continue;
            ((XWindowPeer)childPeer).winAttr.icons = icons;
            ((XWindowPeer)childPeer).recursivelySetIcon(icons);
        }
    }

    List<IconInfo> getIconInfo() {
        return this.winAttr.icons;
    }

    void setIconHints(List<IconInfo> icons) {
    }

    protected static synchronized List<IconInfo> getDefaultIconInfo() {
        if (defaultIconInfo == null) {
            defaultIconInfo = new ArrayList();
            if (XlibWrapper.dataModel == 32) {
                defaultIconInfo.add(new IconInfo(AWTIcon32_java_icon16_png.java_icon16_png));
                defaultIconInfo.add(new IconInfo(AWTIcon32_java_icon24_png.java_icon24_png));
                defaultIconInfo.add(new IconInfo(AWTIcon32_java_icon32_png.java_icon32_png));
                defaultIconInfo.add(new IconInfo(AWTIcon32_java_icon48_png.java_icon48_png));
            } else {
                defaultIconInfo.add(new IconInfo(AWTIcon64_java_icon16_png.java_icon16_png));
                defaultIconInfo.add(new IconInfo(AWTIcon64_java_icon24_png.java_icon24_png));
                defaultIconInfo.add(new IconInfo(AWTIcon64_java_icon32_png.java_icon32_png));
                defaultIconInfo.add(new IconInfo(AWTIcon64_java_icon48_png.java_icon48_png));
            }
        }
        return defaultIconInfo;
    }

    private void updateShape() {
        Shape shape = AWTAccessor.getWindowAccessor().getShape((Window)this.target);
        if (shape != null) {
            this.applyShape(Region.getInstance(shape, null));
        }
    }

    private void updateOpacity() {
        float opacity = AWTAccessor.getWindowAccessor().getOpacity((Window)this.target);
        if (opacity < 1.0f) {
            this.setOpacity(opacity);
        }
    }

    @Override
    public void updateMinimumSize() {
        this.targetMinimumSize = this.target.isMinimumSizeSet() ? this.target.getMinimumSize() : null;
    }

    public Dimension getTargetMinimumSize() {
        return this.targetMinimumSize == null ? null : new Dimension(this.targetMinimumSize);
    }

    public XWindowPeer getOwnerPeer() {
        return this.ownerPeer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBounds(int x, int y, int width, int height, int op) {
        XToolkit.awtLock();
        try {
            boolean isMoved;
            Rectangle oldBounds = this.getBounds();
            super.setBounds(x, y, width, height, op);
            Rectangle bounds = this.getBounds();
            XSizeHints hints = this.getHints();
            this.setSizeHints(hints.get_flags() | 4L | 8L, bounds.x, bounds.y, bounds.width, bounds.height);
            XWM.setMotifDecor(this, false, 0, 0);
            boolean isResized = !bounds.getSize().equals(oldBounds.getSize());
            boolean bl = isMoved = !bounds.getLocation().equals(oldBounds.getLocation());
            if (isMoved || isResized) {
                this.repositionSecurityWarning();
            }
            if (isResized) {
                this.postEventToEventQueue(new ComponentEvent(this.getEventSource(), 101));
            }
            if (isMoved) {
                this.postEventToEventQueue(new ComponentEvent(this.getEventSource(), 100));
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    void updateFocusability() {
        this.updateFocusableWindowState();
        XToolkit.awtLock();
        try {
            XWMHints hints = this.getWMHints();
            hints.set_flags(hints.get_flags() | 1L);
            hints.set_input(false);
            XlibWrapper.XSetWMHints(XToolkit.getDisplay(), this.getWindow(), hints.pData);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    @Override
    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public void handleIconify() {
        this.postEvent(new WindowEvent((Window)this.target, 203));
    }

    public void handleDeiconify() {
        this.postEvent(new WindowEvent((Window)this.target, 204));
    }

    public void handleStateChange(int oldState, int newState) {
        this.postEvent(new WindowEvent((Window)this.target, 209, oldState, newState));
    }

    @Override
    public Insets insets() {
        return this.getInsets();
    }

    boolean isAutoRequestFocus() {
        if (XToolkit.isToolkitThread()) {
            return AWTAccessor.getWindowAccessor().isAutoRequestFocus((Window)this.target);
        }
        return ((Window)this.target).isAutoRequestFocus();
    }

    static XWindowPeer getNativeFocusedWindowPeer() {
        XBaseWindow baseWindow = XToolkit.windowToXWindow(XWindowPeer.xGetInputFocus());
        return baseWindow instanceof XWindowPeer ? (XWindowPeer)baseWindow : (baseWindow instanceof XFocusProxyWindow ? ((XFocusProxyWindow)baseWindow).getOwner() : null);
    }

    static Window getNativeFocusedWindow() {
        XWindowPeer peer = XWindowPeer.getNativeFocusedWindowPeer();
        return peer != null ? (Window)peer.target : null;
    }

    boolean isFocusableWindow() {
        if (XToolkit.isToolkitThread() || SunToolkit.isAWTLockHeldByCurrentThread()) {
            return this.cachedFocusableWindow;
        }
        return ((Window)this.target).isFocusableWindow();
    }

    boolean isFocusedWindowModalBlocker() {
        return false;
    }

    long getFocusTargetWindow() {
        return this.getContentWindow();
    }

    boolean isNativelyNonFocusableWindow() {
        if (XToolkit.isToolkitThread() || SunToolkit.isAWTLockHeldByCurrentThread()) {
            return this.isSimpleWindow() || !this.cachedFocusableWindow;
        }
        return this.isSimpleWindow() || !((Window)this.target).isFocusableWindow();
    }

    public void handleWindowFocusIn_Dispatch() {
        if (EventQueue.isDispatchThread()) {
            XKeyboardFocusManagerPeer.getInstance().setCurrentFocusedWindow((Window)this.target);
            WindowEvent we = new WindowEvent((Window)this.target, 207);
            SunToolkit.setSystemGenerated(we);
            this.target.dispatchEvent(we);
        }
    }

    public void handleWindowFocusInSync(long serial) {
        WindowEvent we = new WindowEvent((Window)this.target, 207);
        XKeyboardFocusManagerPeer.getInstance().setCurrentFocusedWindow((Window)this.target);
        XWindowPeer.sendEvent(we);
    }

    public void handleWindowFocusIn(long serial) {
        WindowEvent we = new WindowEvent((Window)this.target, 207);
        XKeyboardFocusManagerPeer.getInstance().setCurrentFocusedWindow((Window)this.target);
        this.postEvent(XWindowPeer.wrapInSequenced(we));
    }

    public void handleWindowFocusOut(Window oppositeWindow, long serial) {
        WindowEvent we = new WindowEvent((Window)this.target, 208, oppositeWindow);
        XKeyboardFocusManagerPeer.getInstance().setCurrentFocusedWindow(null);
        XKeyboardFocusManagerPeer.getInstance().setCurrentFocusOwner(null);
        this.postEvent(XWindowPeer.wrapInSequenced(we));
    }

    public void handleWindowFocusOutSync(Window oppositeWindow, long serial) {
        WindowEvent we = new WindowEvent((Window)this.target, 208, oppositeWindow);
        XKeyboardFocusManagerPeer.getInstance().setCurrentFocusedWindow(null);
        XKeyboardFocusManagerPeer.getInstance().setCurrentFocusOwner(null);
        XWindowPeer.sendEvent(we);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkIfOnNewScreen(Rectangle newBounds) {
        if (!XToolkit.localEnv.runningXinerama()) {
            return;
        }
        if (log.isLoggable(PlatformLogger.Level.FINEST)) {
            log.finest("XWindowPeer: Check if we've been moved to a new screen since we're running in Xinerama mode");
        }
        int area = newBounds.width * newBounds.height;
        int largestAmt = 0;
        int curScreenNum = ((X11GraphicsDevice)this.getGraphicsConfiguration().getDevice()).getScreen();
        int newScreenNum = 0;
        GraphicsDevice[] gds = XToolkit.localEnv.getScreenDevices();
        GraphicsConfiguration newGC = null;
        XToolkit.awtUnlock();
        try {
            for (int i = 0; i < gds.length; ++i) {
                int vertAmt;
                Rectangle screenBounds = gds[i].getDefaultConfiguration().getBounds();
                if (!newBounds.intersects(screenBounds)) continue;
                int horizAmt = Math.min(newBounds.x + newBounds.width, screenBounds.x + screenBounds.width) - Math.max(newBounds.x, screenBounds.x);
                int intAmt = horizAmt * (vertAmt = Math.min(newBounds.y + newBounds.height, screenBounds.y + screenBounds.height) - Math.max(newBounds.y, screenBounds.y));
                if (intAmt == area) {
                    newScreenNum = i;
                    newGC = gds[i].getDefaultConfiguration();
                    break;
                }
                if (intAmt <= largestAmt) continue;
                largestAmt = intAmt;
                newScreenNum = i;
                newGC = gds[i].getDefaultConfiguration();
            }
        }
        finally {
            XToolkit.awtLock();
        }
        if (newScreenNum != curScreenNum) {
            if (log.isLoggable(PlatformLogger.Level.FINEST)) {
                log.finest("XWindowPeer: Moved to a new screen");
            }
            this.executeDisplayChangedOnEDT(newGC);
        }
    }

    private void executeDisplayChangedOnEDT(final GraphicsConfiguration gc) {
        Runnable dc = new Runnable(){

            @Override
            public void run() {
                AWTAccessor.getComponentAccessor().setGraphicsConfiguration(XWindowPeer.this.target, gc);
            }
        };
        SunToolkit.executeOnEventHandlerThread(this.target, dc);
    }

    @Override
    public void displayChanged() {
        this.executeDisplayChangedOnEDT(this.getGraphicsConfiguration());
    }

    @Override
    public void paletteChanged() {
    }

    private Point queryXLocation() {
        return XlibUtil.translateCoordinates(this.getContentWindow(), XlibWrapper.RootWindow(XToolkit.getDisplay(), this.getScreenNumber()), new Point(0, 0), this.getScale());
    }

    protected Point getNewLocation(XConfigureEvent xe, int leftInset, int topInset) {
        Rectangle targetBounds = AWTAccessor.getComponentAccessor().getBounds(this.target);
        int runningWM = XWM.getWMID();
        Point newLocation = targetBounds.getLocation();
        if (xe.get_send_event() || runningWM == 2 || XWM.isNonReparentingWM()) {
            newLocation = new Point(this.scaleDown(xe.get_x()) - leftInset, this.scaleDown(xe.get_y()) - topInset);
        } else {
            switch (runningWM) {
                case 5: 
                case 6: 
                case 9: 
                case 11: 
                case 15: {
                    Point xlocation = this.queryXLocation();
                    if (log.isLoggable(PlatformLogger.Level.FINE)) {
                        log.fine("New X location: {0}", xlocation);
                    }
                    if (xlocation == null) break;
                    newLocation = xlocation;
                    break;
                }
            }
        }
        return newLocation;
    }

    @Override
    public void handleConfigureNotifyEvent(XEvent xev) {
        XConfigureEvent xe = xev.get_xconfigure();
        Point newLocation = this.getNewLocation(xe, 0, 0);
        xe.set_x(this.scaleUp(newLocation.x));
        xe.set_y(this.scaleUp(newLocation.y));
        this.checkIfOnNewScreen(new Rectangle(newLocation.x, newLocation.y, this.scaleDown(xe.get_width()), this.scaleDown(xe.get_height())));
        super.handleConfigureNotifyEvent(xev);
        this.repositionSecurityWarning();
    }

    final void requestXFocus(long time) {
        this.requestXFocus(time, true);
    }

    final void requestXFocus() {
        this.requestXFocus(0L, false);
    }

    protected void requestXFocus(long time, boolean timeProvided) {
        if (focusLog.isLoggable(PlatformLogger.Level.FINE)) {
            focusLog.fine("Requesting window focus");
        }
        this.requestWindowFocus(time, timeProvided);
    }

    public final boolean focusAllowedFor() {
        if (this.isNativelyNonFocusableWindow()) {
            return false;
        }
        return !this.isModalBlocked();
    }

    public void handleFocusEvent(XEvent xev) {
        XFocusChangeEvent xfe = xev.get_xfocus();
        if (focusLog.isLoggable(PlatformLogger.Level.FINE)) {
            focusLog.fine("{0}", xfe);
        }
        if (this.isEventDisabled(xev)) {
            return;
        }
        if (xev.get_type() == 9) {
            if (this.focusAllowedFor() && (xfe.get_mode() == 0 || xfe.get_mode() == 3)) {
                this.handleWindowFocusIn(xfe.get_serial());
            }
        } else if (!(xfe.get_mode() != 0 && xfe.get_mode() != 3 || this.isNativelyNonFocusableWindow())) {
            XWindowPeer oppositeXWindow = XWindowPeer.getNativeFocusedWindowPeer();
            Object oppositeTarget = oppositeXWindow != null ? oppositeXWindow.getTarget() : null;
            Window oppositeWindow = null;
            if (oppositeTarget instanceof Window) {
                oppositeWindow = (Window)oppositeTarget;
            }
            if (oppositeXWindow != null && oppositeXWindow.isNativelyNonFocusableWindow()) {
                return;
            }
            if (this == oppositeXWindow) {
                oppositeWindow = null;
            } else if (oppositeXWindow instanceof XDecoratedPeer && ((XDecoratedPeer)oppositeXWindow).actualFocusedWindow != null && (oppositeTarget = (oppositeXWindow = ((XDecoratedPeer)oppositeXWindow).actualFocusedWindow).getTarget()) instanceof Window && oppositeXWindow.isVisible() && oppositeXWindow.isNativelyNonFocusableWindow()) {
                oppositeWindow = (Window)oppositeTarget;
            }
            this.handleWindowFocusOut(oppositeWindow, xfe.get_serial());
        }
    }

    void setSaveUnder(boolean state) {
    }

    @Override
    public void toFront() {
        if (this.isOverrideRedirect() && this.mustControlStackPosition) {
            this.mustControlStackPosition = false;
            this.removeRootPropertyEventDispatcher();
        }
        if (this.isVisible()) {
            super.toFront();
            if (this.isFocusableWindow() && this.isAutoRequestFocus() && !this.isModalBlocked() && !this.isWithdrawn()) {
                this.requestInitialFocus();
            }
        } else {
            this.setVisible(true);
        }
    }

    @Override
    public void toBack() {
        XToolkit.awtLock();
        try {
            if (!this.isOverrideRedirect()) {
                XlibWrapper.XLowerWindow(XToolkit.getDisplay(), this.getWindow());
            } else {
                this.lowerOverrideRedirect();
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lowerOverrideRedirect() {
        HashSet<Long> toplevels = new HashSet<Long>();
        long topl = 0L;
        long mytopl = 0L;
        for (XWindowPeer xp : windows) {
            topl = this.getToplevelWindow(xp.getWindow());
            if (xp.equals(this)) {
                mytopl = topl;
            }
            if (topl <= 0L) continue;
            toplevels.add(topl);
        }
        long wDesktop = -1L;
        long wBottom = -1L;
        int iMy = -1;
        int iDesktop = -1;
        int iBottom = -1;
        int i = 0;
        XQueryTree xqt = new XQueryTree(XToolkit.getDefaultRootWindow());
        try {
            if (xqt.execute() > 0) {
                int nchildren = xqt.get_nchildren();
                long children = xqt.get_children();
                for (i = 0; i < nchildren; ++i) {
                    long laux = Native.getWindow(children, i);
                    if (laux == mytopl) {
                        iMy = i;
                        continue;
                    }
                    if (XWindowPeer.isDesktopWindow(laux)) {
                        iDesktop = i;
                        wDesktop = laux;
                        continue;
                    }
                    if (iBottom >= 0 || !toplevels.contains(laux) || laux == mytopl) continue;
                    iBottom = i;
                    wBottom = laux;
                }
            }
            if ((iMy < iBottom || iBottom < 0) && iDesktop < iMy) {
                return;
            }
            long to_restack = Native.allocateLongArray(2);
            Native.putLong(to_restack, 0, wBottom);
            Native.putLong(to_restack, 1, mytopl);
            XlibWrapper.XRestackWindows(XToolkit.getDisplay(), to_restack, 2);
            XlibWrapper.unsafe.freeMemory(to_restack);
            if (!this.mustControlStackPosition) {
                this.mustControlStackPosition = true;
                this.addRootPropertyEventDispatcher();
            }
        }
        finally {
            xqt.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getToplevelWindow(long w) {
        long ret;
        long root;
        long wi = w;
        do {
            ret = wi;
            XQueryTree qt = new XQueryTree(wi);
            try {
                if (qt.execute() == 0) {
                    long l = 0L;
                    return l;
                }
                root = qt.get_root();
                wi = qt.get_parent();
            }
            finally {
                qt.dispose();
            }
        } while (wi != root);
        return ret;
    }

    private static boolean isDesktopWindow(long wi) {
        return XWM.getWM().isDesktopWindow(wi);
    }

    private void updateAlwaysOnTop() {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("Promoting always-on-top state {0}", this.alwaysOnTop);
        }
        XWM.getWM().setLayer(this, this.alwaysOnTop ? 1 : 0);
    }

    @Override
    public void updateAlwaysOnTopState() {
        this.alwaysOnTop = ((Window)this.target).isAlwaysOnTop();
        this.updateAlwaysOnTop();
    }

    @Override
    boolean isLocationByPlatform() {
        return this.locationByPlatform;
    }

    private void promoteDefaultPosition() {
        this.locationByPlatform = ((Window)this.target).isLocationByPlatform();
        if (this.locationByPlatform) {
            XToolkit.awtLock();
            try {
                Rectangle bounds = this.getBounds();
                XSizeHints hints = this.getHints();
                this.setSizeHints(hints.get_flags() & 0xFFFFFFFFFFFFFFFAL, bounds.x, bounds.y, bounds.width, bounds.height);
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
    }

    @Override
    public void setVisible(boolean vis) {
        if (!this.isVisible() && vis) {
            this.isBeforeFirstMapNotify = true;
            this.winAttr.initialFocus = this.isAutoRequestFocus();
            if (!this.winAttr.initialFocus) {
                this.suppressWmTakeFocus(true);
            }
        }
        this.updateFocusability();
        this.promoteDefaultPosition();
        if (!vis && this.warningWindow != null) {
            this.warningWindow.setSecurityWarningVisible(false, false);
        }
        super.setVisible(vis);
        if (!vis && !this.isWithdrawn()) {
            XToolkit.awtLock();
            try {
                XUnmapEvent unmap = new XUnmapEvent();
                unmap.set_window(this.window);
                unmap.set_event(XToolkit.getDefaultRootWindow());
                unmap.set_type(18);
                unmap.set_from_configure(false);
                XlibWrapper.XSendEvent(XToolkit.getDisplay(), XToolkit.getDefaultRootWindow(), false, 0x180000L, unmap.pData);
                unmap.dispose();
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
        if (this.isOverrideRedirect() && vis) {
            this.updateChildrenSizes();
        }
        this.repositionSecurityWarning();
    }

    protected void suppressWmTakeFocus(boolean doSuppress) {
    }

    final boolean isSimpleWindow() {
        return !(this.target instanceof Frame) && !(this.target instanceof Dialog);
    }

    boolean hasWarningWindow() {
        return ((Window)this.target).getWarningString() != null;
    }

    int getMenuBarHeight() {
        return 0;
    }

    void updateChildrenSizes() {
    }

    @Override
    public void repositionSecurityWarning() {
        if (this.warningWindow != null) {
            AWTAccessor.ComponentAccessor compAccessor = AWTAccessor.getComponentAccessor();
            int x = compAccessor.getX(this.target);
            int y = compAccessor.getY(this.target);
            int width = compAccessor.getWidth(this.target);
            int height = compAccessor.getHeight(this.target);
            this.warningWindow.reposition(x, y, width, height);
        }
    }

    @Override
    protected void setMouseAbove(boolean above) {
        super.setMouseAbove(above);
        this.updateSecurityWarningVisibility();
    }

    @Override
    public void setFullScreenExclusiveModeState(boolean state) {
        super.setFullScreenExclusiveModeState(state);
        this.updateSecurityWarningVisibility();
    }

    public void updateSecurityWarningVisibility() {
        if (this.warningWindow == null) {
            return;
        }
        if (!this.isVisible()) {
            return;
        }
        boolean show = false;
        if (!this.isFullScreenExclusiveMode()) {
            int state = this.getWMState();
            if (this.isVisible() && (state == 1 || this.isSimpleWindow())) {
                if (XKeyboardFocusManagerPeer.getInstance().getCurrentFocusedWindow() == this.getTarget()) {
                    show = true;
                }
                if (this.isMouseAbove() || this.warningWindow.isMouseAbove()) {
                    show = true;
                }
            }
        }
        this.warningWindow.setSecurityWarningVisible(show, true);
    }

    boolean isOverrideRedirect() {
        return XWM.getWMID() == 4 || XWM.getWMID() == 11 || Window.Type.POPUP.equals((Object)this.getWindowType());
    }

    final boolean isOLWMDecorBug() {
        return XWM.getWMID() == 4 && !this.winAttr.nativeDecor;
    }

    @Override
    public void dispose() {
        if (this.isGrabbed()) {
            if (grabLog.isLoggable(PlatformLogger.Level.FINE)) {
                grabLog.fine("Generating UngrabEvent on {0} because of the window disposal", this);
            }
            this.postEventToEventQueue(new UngrabEvent(this.getEventSource()));
        }
        SunToolkit.awtLock();
        try {
            windows.remove(this);
        }
        finally {
            SunToolkit.awtUnlock();
        }
        if (this.warningWindow != null) {
            this.warningWindow.destroy();
        }
        this.removeRootPropertyEventDispatcher();
        this.mustControlStackPosition = false;
        super.dispose();
        if (this.isSimpleWindow() && this.target == XKeyboardFocusManagerPeer.getInstance().getCurrentFocusedWindow()) {
            Window owner = XWindowPeer.getDecoratedOwner((Window)this.target);
            ((XWindowPeer)AWTAccessor.getComponentAccessor().getPeer(owner)).requestWindowFocus();
        }
    }

    @Override
    boolean isResizable() {
        return this.winAttr.isResizable;
    }

    @Override
    public void handleVisibilityEvent(XEvent xev) {
        super.handleVisibilityEvent(xev);
        XVisibilityEvent ve = xev.get_xvisibility();
        this.winAttr.visibilityState = ve.get_state();
        this.repositionSecurityWarning();
    }

    void handleRootPropertyNotify(XEvent xev) {
        XPropertyEvent ev = xev.get_xproperty();
        if (this.mustControlStackPosition && ev.get_atom() == XAtom.get("_NET_CLIENT_LIST_STACKING").getAtom() && this.isOverrideRedirect()) {
            this.toBack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeStartupNotification() {
        byte[] message;
        if (isStartupNotificationRemoved.getAndSet(true)) {
            return;
        }
        String desktopStartupId = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return XToolkit.getEnv("DESKTOP_STARTUP_ID");
            }
        });
        if (desktopStartupId == null) {
            return;
        }
        StringBuilder messageBuilder = new StringBuilder("remove: ID=");
        messageBuilder.append('\"');
        for (int i = 0; i < desktopStartupId.length(); ++i) {
            if (desktopStartupId.charAt(i) == '\"' || desktopStartupId.charAt(i) == '\\') {
                messageBuilder.append('\\');
            }
            messageBuilder.append(desktopStartupId.charAt(i));
        }
        messageBuilder.append('\"');
        messageBuilder.append('\u0000');
        try {
            message = messageBuilder.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException cannotHappen) {
            return;
        }
        XClientMessageEvent req = null;
        XToolkit.awtLock();
        try {
            XAtom netStartupInfoBeginAtom = XAtom.get("_NET_STARTUP_INFO_BEGIN");
            XAtom netStartupInfoAtom = XAtom.get("_NET_STARTUP_INFO");
            req = new XClientMessageEvent();
            req.set_type(33);
            req.set_window(this.getWindow());
            req.set_message_type(netStartupInfoBeginAtom.getAtom());
            req.set_format(8);
            for (int pos = 0; pos < message.length; pos += 20) {
                int i;
                int msglen = Math.min(message.length - pos, 20);
                for (i = 0; i < msglen; ++i) {
                    XlibWrapper.unsafe.putByte(req.get_data() + (long)i, message[pos + i]);
                }
                while (i < 20) {
                    XlibWrapper.unsafe.putByte(req.get_data() + (long)i, (byte)0);
                    ++i;
                }
                XlibWrapper.XSendEvent(XToolkit.getDisplay(), XlibWrapper.RootWindow(XToolkit.getDisplay(), this.getScreenNumber()), false, 0x400000L, req.pData);
                req.set_message_type(netStartupInfoAtom.getAtom());
            }
        }
        finally {
            XToolkit.awtUnlock();
            if (req != null) {
                req.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMapNotifyEvent(XEvent xev) {
        this.removeStartupNotification();
        this.isUnhiding |= this.isWMStateNetHidden();
        super.handleMapNotifyEvent(xev);
        if (!this.winAttr.initialFocus) {
            this.suppressWmTakeFocus(false);
            XToolkit.awtLock();
            try {
                XlibWrapper.XRaiseWindow(XToolkit.getDisplay(), this.getWindow());
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
        if (this.shouldFocusOnMapNotify()) {
            focusLog.fine("Automatically request focus on window");
            this.requestInitialFocus();
        }
        this.isUnhiding = false;
        this.isBeforeFirstMapNotify = false;
        this.updateAlwaysOnTop();
        Object object = this.getStateLock();
        synchronized (object) {
            if (!this.isMapped) {
                this.isMapped = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleUnmapNotifyEvent(XEvent xev) {
        super.handleUnmapNotifyEvent(xev);
        this.isUnhiding |= this.isWMStateNetHidden();
        Object object = this.getStateLock();
        synchronized (object) {
            if (this.isMapped) {
                this.isMapped = false;
            }
        }
    }

    private boolean shouldFocusOnMapNotify() {
        boolean res = false;
        res = this.isBeforeFirstMapNotify ? this.winAttr.initialFocus || this.isFocusedWindowModalBlocker() : this.isUnhiding;
        res = res && this.isFocusableWindow() && !this.isModalBlocked();
        return res;
    }

    protected boolean isWMStateNetHidden() {
        XNETProtocol protocol = XWM.getWM().getNETProtocol();
        return protocol != null && protocol.isWMStateNetHidden(this);
    }

    protected void requestInitialFocus() {
        this.requestXFocus();
    }

    public void addToplevelStateListener(ToplevelStateListener l) {
        this.toplevelStateListeners.add(l);
    }

    public void removeToplevelStateListener(ToplevelStateListener l) {
        this.toplevelStateListeners.remove(l);
    }

    @Override
    protected void stateChanged(long time, int oldState, int newState) {
        this.updateTransientFor();
        for (ToplevelStateListener topLevelListenerTmp : this.toplevelStateListeners) {
            topLevelListenerTmp.stateChangedICCCM(oldState, newState);
        }
        this.updateSecurityWarningVisibility();
    }

    boolean isWithdrawn() {
        return this.getWMState() == 0;
    }

    boolean hasDecorations(int decor) {
        boolean hasBits;
        if (!this.winAttr.nativeDecor) {
            return false;
        }
        int myDecor = this.winAttr.decorations;
        boolean bl = hasBits = (myDecor & decor) == decor;
        if ((myDecor & XWindowAttributesData.AWT_DECOR_ALL) != 0) {
            return !hasBits;
        }
        return hasBits;
    }

    @Override
    void setReparented(boolean newValue) {
        super.setReparented(newValue);
        XToolkit.awtLock();
        try {
            if (this.isReparented() && this.delayedModalBlocking) {
                this.addToTransientFors((XDialogPeer)AWTAccessor.getComponentAccessor().getPeer(this.modalBlocker));
                this.delayedModalBlocking = false;
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Vector<XWindowPeer> collectJavaToplevels() {
        Vector<XWindowPeer> javaToplevels = new Vector<XWindowPeer>();
        Vector<Long> v = new Vector<Long>();
        X11GraphicsEnvironment ge = (X11GraphicsEnvironment)GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gds = ge.getScreenDevices();
        if (!ge.runningXinerama() && gds.length > 1) {
            for (GraphicsDevice gd : gds) {
                int screen = ((X11GraphicsDevice)gd).getScreen();
                long rootWindow = XlibWrapper.RootWindow(XToolkit.getDisplay(), screen);
                v.add(rootWindow);
            }
        } else {
            v.add(XToolkit.getDefaultRootWindow());
        }
        int windowsCount = windows.size();
        while (v.size() > 0 && javaToplevels.size() < windowsCount) {
            long win = (Long)v.remove(0);
            XQueryTree qt = new XQueryTree(win);
            try {
                if (qt.execute() == 0) continue;
                int nchildren = qt.get_nchildren();
                long children = qt.get_children();
                for (int i = 0; i < nchildren; ++i) {
                    long child = Native.getWindow(children, i);
                    XBaseWindow childWindow = XToolkit.windowToXWindow(child);
                    if (childWindow != null && !(childWindow instanceof XWindowPeer)) continue;
                    v.add(child);
                    if (!(childWindow instanceof XWindowPeer)) continue;
                    XWindowPeer np = (XWindowPeer)childWindow;
                    javaToplevels.add(np);
                    int k = 0;
                    XWindowPeer toCheck = javaToplevels.get(k);
                    while (toCheck != np) {
                        XWindowPeer toCheckOwnerPeer = toCheck.getOwnerPeer();
                        if (toCheckOwnerPeer == np) {
                            javaToplevels.remove(k);
                            javaToplevels.add(toCheck);
                        } else {
                            ++k;
                        }
                        toCheck = javaToplevels.get(k);
                    }
                }
            }
            finally {
                qt.dispose();
            }
        }
        return javaToplevels;
    }

    @Override
    public void setModalBlocked(Dialog d, boolean blocked) {
        this.setModalBlocked(d, blocked, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModalBlocked(Dialog d, boolean blocked, Vector<XWindowPeer> javaToplevels) {
        XToolkit.awtLock();
        try {
            Object object = this.getStateLock();
            synchronized (object) {
                XDialogPeer blockerPeer = (XDialogPeer)AWTAccessor.getComponentAccessor().getPeer(d);
                if (blocked) {
                    if (log.isLoggable(PlatformLogger.Level.FINE)) {
                        log.fine("{0} is blocked by {1}", this, blockerPeer);
                    }
                    this.modalBlocker = d;
                    if (this.isReparented() || XWM.isNonReparentingWM()) {
                        this.addToTransientFors(blockerPeer, javaToplevels);
                    } else {
                        this.delayedModalBlocking = true;
                    }
                } else {
                    if (d != this.modalBlocker) {
                        throw new IllegalStateException("Trying to unblock window blocked by another dialog");
                    }
                    this.modalBlocker = null;
                    if (this.isReparented() || XWM.isNonReparentingWM()) {
                        this.removeFromTransientFors();
                    } else {
                        this.delayedModalBlocking = false;
                    }
                }
                this.updateTransientFor();
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    static void setToplevelTransientFor(XWindowPeer window, XWindowPeer transientForWindow, boolean updateChain, boolean allStates) {
        XLightweightFramePeer peer;
        long ownerWindowPtr;
        if (window == null || transientForWindow == null) {
            return;
        }
        if (updateChain) {
            window.prevTransientFor = transientForWindow;
            transientForWindow.nextTransientFor = window;
        }
        if (window.curRealTransientFor == transientForWindow) {
            return;
        }
        if (!allStates && window.getWMState() != transientForWindow.getWMState()) {
            return;
        }
        if (window.getScreenNumber() != transientForWindow.getScreenNumber()) {
            return;
        }
        long bpw = window.getWindow();
        while (!XlibUtil.isToplevelWindow(bpw) && !XlibUtil.isXAWTToplevelWindow(bpw)) {
            bpw = XlibUtil.getParentWindow(bpw);
        }
        long tpw = transientForWindow.getWindow();
        while (!XlibUtil.isToplevelWindow(tpw) && !XlibUtil.isXAWTToplevelWindow(tpw)) {
            tpw = XlibUtil.getParentWindow(tpw);
        }
        XWindowPeer parent = transientForWindow;
        if (parent instanceof XLightweightFramePeer && (ownerWindowPtr = (peer = (XLightweightFramePeer)parent).getOverriddenWindowHandle()) != 0L) {
            tpw = ownerWindowPtr;
        }
        XlibWrapper.XSetTransientFor(XToolkit.getDisplay(), bpw, tpw);
        window.curRealTransientFor = transientForWindow;
    }

    void updateTransientFor() {
        int state = this.getWMState();
        XWindowPeer p = this.prevTransientFor;
        while (p != null && (p.getWMState() != state || p.getScreenNumber() != this.getScreenNumber())) {
            p = p.prevTransientFor;
        }
        if (p != null) {
            XWindowPeer.setToplevelTransientFor(this, p, false, false);
        } else {
            XWindowPeer.restoreTransientFor(this);
        }
        XWindowPeer n = this.nextTransientFor;
        while (n != null && (n.getWMState() != state || n.getScreenNumber() != this.getScreenNumber())) {
            n = n.nextTransientFor;
        }
        if (n != null) {
            XWindowPeer.setToplevelTransientFor(n, this, false, false);
        }
    }

    private static void removeTransientForHint(XWindowPeer window) {
        XAtom XA_WM_TRANSIENT_FOR = XAtom.get(68L);
        long bpw = window.getWindow();
        while (!XlibUtil.isToplevelWindow(bpw) && !XlibUtil.isXAWTToplevelWindow(bpw)) {
            bpw = XlibUtil.getParentWindow(bpw);
        }
        XlibWrapper.XDeleteProperty(XToolkit.getDisplay(), bpw, XA_WM_TRANSIENT_FOR.getAtom());
        window.curRealTransientFor = null;
    }

    private void addToTransientFors(XDialogPeer blockerPeer) {
        this.addToTransientFors(blockerPeer, null);
    }

    private void addToTransientFors(XDialogPeer blockerPeer, Vector<XWindowPeer> javaToplevels) {
        XWindowPeer blockerChain = blockerPeer;
        while (blockerChain.prevTransientFor != null) {
            blockerChain = blockerChain.prevTransientFor;
        }
        XWindowPeer thisChain = this;
        while (thisChain.prevTransientFor != null) {
            thisChain = thisChain.prevTransientFor;
        }
        if (blockerChain == blockerPeer) {
            XWindowPeer.setToplevelTransientFor(blockerPeer, this, true, false);
        } else {
            if (javaToplevels == null) {
                javaToplevels = XWindowPeer.collectJavaToplevels();
            }
            XWindowPeer mergedChain = null;
            for (XWindowPeer w : javaToplevels) {
                XWindowPeer prevMergedChain = mergedChain;
                if (w == thisChain) {
                    if (thisChain == this) {
                        if (prevMergedChain != null) {
                            XWindowPeer.setToplevelTransientFor(this, prevMergedChain, true, false);
                        }
                        XWindowPeer.setToplevelTransientFor(blockerChain, this, true, false);
                        break;
                    }
                    mergedChain = thisChain;
                    thisChain = thisChain.nextTransientFor;
                } else {
                    if (w != blockerChain) continue;
                    mergedChain = blockerChain;
                    blockerChain = blockerChain.nextTransientFor;
                }
                if (prevMergedChain == null) {
                    mergedChain.prevTransientFor = null;
                } else {
                    XWindowPeer.setToplevelTransientFor(mergedChain, prevMergedChain, true, false);
                    mergedChain.updateTransientFor();
                }
                if (blockerChain != blockerPeer) continue;
                XWindowPeer.setToplevelTransientFor(thisChain, mergedChain, true, false);
                XWindowPeer.setToplevelTransientFor(blockerChain, this, true, false);
                break;
            }
        }
        XToolkit.XSync();
    }

    static void restoreTransientFor(XWindowPeer window) {
        XWindowPeer ownerPeer = window.getOwnerPeer();
        if (ownerPeer != null) {
            XWindowPeer.setToplevelTransientFor(window, ownerPeer, false, true);
        } else {
            XWindowPeer.removeTransientForHint(window);
        }
    }

    private void removeFromTransientFors() {
        XWindowPeer thisChain = this;
        XWindowPeer otherChain = this.nextTransientFor;
        HashSet<XWindowPeer> thisChainBlockers = new HashSet<XWindowPeer>();
        thisChainBlockers.add(this);
        XWindowPeer chainToSplit = this.prevTransientFor;
        while (chainToSplit != null) {
            XWindowPeer blocker = (XWindowPeer)AWTAccessor.getComponentAccessor().getPeer(chainToSplit.modalBlocker);
            if (thisChainBlockers.contains(blocker)) {
                XWindowPeer.setToplevelTransientFor(thisChain, chainToSplit, true, false);
                thisChain = chainToSplit;
                thisChainBlockers.add(chainToSplit);
            } else {
                XWindowPeer.setToplevelTransientFor(otherChain, chainToSplit, true, false);
                otherChain = chainToSplit;
            }
            chainToSplit = chainToSplit.prevTransientFor;
        }
        XWindowPeer.restoreTransientFor(thisChain);
        thisChain.prevTransientFor = null;
        XWindowPeer.restoreTransientFor(otherChain);
        otherChain.prevTransientFor = null;
        this.nextTransientFor = null;
        XToolkit.XSync();
    }

    boolean isModalBlocked() {
        return this.modalBlocker != null;
    }

    static Window getDecoratedOwner(Window window) {
        while (null != window && !(window instanceof Frame) && !(window instanceof Dialog)) {
            window = (Window)AWTAccessor.getComponentAccessor().getParent(window);
        }
        return window;
    }

    public boolean requestWindowFocus(XWindowPeer actualFocusedWindow) {
        this.setActualFocusedWindow(actualFocusedWindow);
        return this.requestWindowFocus();
    }

    public boolean requestWindowFocus() {
        return this.requestWindowFocus(0L, false);
    }

    public boolean requestWindowFocus(long time, boolean timeProvided) {
        focusLog.fine("Request for window focus");
        Window ownerWindow = XWindowPeer.getDecoratedOwner((Window)this.target);
        Window focusedWindow = XKeyboardFocusManagerPeer.getInstance().getCurrentFocusedWindow();
        Window activeWindow = XWindowPeer.getDecoratedOwner(focusedWindow);
        if (this.isWMStateNetHidden()) {
            focusLog.fine("The window is unmapped, so rejecting the request");
            return false;
        }
        if (activeWindow == ownerWindow) {
            focusLog.fine("Parent window is active - generating focus for this window");
            this.handleWindowFocusInSync(-1L);
            return true;
        }
        focusLog.fine("Parent window is not active");
        XDecoratedPeer wpeer = (XDecoratedPeer)AWTAccessor.getComponentAccessor().getPeer(ownerWindow);
        if (wpeer != null && wpeer.requestWindowFocus(this, time, timeProvided)) {
            focusLog.fine("Parent window accepted focus request - generating focus for this window");
            return true;
        }
        focusLog.fine("Denied - parent window is not active and didn't accept focus request");
        return false;
    }

    void setActualFocusedWindow(XWindowPeer actualFocusedWindow) {
    }

    private void applyWindowType() {
        XNETProtocol protocol = XWM.getWM().getNETProtocol();
        if (protocol == null) {
            return;
        }
        XAtom typeAtom = null;
        switch (this.getWindowType()) {
            case NORMAL: {
                typeAtom = this.ownerPeer == null ? protocol.XA_NET_WM_WINDOW_TYPE_NORMAL : protocol.XA_NET_WM_WINDOW_TYPE_DIALOG;
                break;
            }
            case UTILITY: {
                typeAtom = protocol.XA_NET_WM_WINDOW_TYPE_UTILITY;
                break;
            }
            case POPUP: {
                typeAtom = protocol.XA_NET_WM_WINDOW_TYPE_POPUP_MENU;
            }
        }
        if (typeAtom != null) {
            XAtomList wtype = new XAtomList();
            wtype.add(typeAtom);
            protocol.XA_NET_WM_WINDOW_TYPE.setAtomListProperty(this.getWindow(), wtype);
        } else {
            protocol.XA_NET_WM_WINDOW_TYPE.DeleteProperty(this.getWindow());
        }
    }

    @Override
    public void xSetVisible(boolean visible) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("Setting visible on " + this + " to " + visible);
        }
        XToolkit.awtLock();
        try {
            this.visible = visible;
            if (visible) {
                this.applyWindowType();
                XlibWrapper.XMapRaised(XToolkit.getDisplay(), this.getWindow());
            } else {
                XlibWrapper.XUnmapWindow(XToolkit.getDisplay(), this.getWindow());
            }
            XlibWrapper.XFlush(XToolkit.getDisplay());
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    public void addDropTarget() {
        XToolkit.awtLock();
        try {
            long window;
            if (this.dropTargetCount == 0 && (window = this.getWindow()) != 0L) {
                XDropTargetRegistry.getRegistry().registerDropSite(window);
            }
            ++this.dropTargetCount;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    public void removeDropTarget() {
        XToolkit.awtLock();
        try {
            long window;
            --this.dropTargetCount;
            if (this.dropTargetCount == 0 && (window = this.getWindow()) != 0L) {
                XDropTargetRegistry.getRegistry().unregisterDropSite(window);
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    void addRootPropertyEventDispatcher() {
        if (this.rootPropertyEventDispatcher == null) {
            this.rootPropertyEventDispatcher = new XEventDispatcher(){

                @Override
                public void dispatchEvent(XEvent ev) {
                    if (ev.get_type() == 28) {
                        XWindowPeer.this.handleRootPropertyNotify(ev);
                    }
                }
            };
            XlibWrapper.XSelectInput(XToolkit.getDisplay(), XToolkit.getDefaultRootWindow(), 0x400000L);
            XToolkit.addEventDispatcher(XToolkit.getDefaultRootWindow(), this.rootPropertyEventDispatcher);
        }
    }

    void removeRootPropertyEventDispatcher() {
        if (this.rootPropertyEventDispatcher != null) {
            XToolkit.removeEventDispatcher(XToolkit.getDefaultRootWindow(), this.rootPropertyEventDispatcher);
            this.rootPropertyEventDispatcher = null;
        }
    }

    @Override
    public void updateFocusableWindowState() {
        this.cachedFocusableWindow = this.isFocusableWindow();
    }

    public XAtomList getNETWMState() {
        if (this.net_wm_state == null) {
            this.net_wm_state = this.XA_NET_WM_STATE.getAtomListPropertyList(this);
        }
        return this.net_wm_state;
    }

    public void setNETWMState(XAtomList state) {
        this.net_wm_state = state;
        if (state != null) {
            this.XA_NET_WM_STATE.setAtomListProperty((XBaseWindow)this, state);
        }
    }

    @Override
    public PropMwmHints getMWMHints() {
        if (this.mwm_hints == null) {
            this.mwm_hints = new PropMwmHints();
            if (!XWM.XA_MWM_HINTS.getAtomData(this.getWindow(), this.mwm_hints.pData, 5)) {
                this.mwm_hints.zero();
            }
        }
        return this.mwm_hints;
    }

    @Override
    public void setMWMHints(PropMwmHints hints) {
        this.mwm_hints = hints;
        if (hints != null) {
            XWM.XA_MWM_HINTS.setAtomData(this.getWindow(), this.mwm_hints.pData, 5);
        }
    }

    protected void updateDropTarget() {
        XToolkit.awtLock();
        try {
            long window;
            if (this.dropTargetCount > 0 && (window = this.getWindow()) != 0L) {
                XDropTargetRegistry.getRegistry().unregisterDropSite(window);
                XDropTargetRegistry.getRegistry().registerDropSite(window);
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    public void setGrab(boolean grab) {
        this.grab = grab;
        if (grab) {
            this.pressTarget = this;
            this.grabInput();
        } else {
            XWindowPeer.ungrabInput();
        }
    }

    public boolean isGrabbed() {
        return this.grab && XAwtState.getGrabWindow() == this;
    }

    @Override
    public void handleXCrossingEvent(XEvent xev) {
        XCrossingEvent xce = xev.get_xcrossing();
        if (grabLog.isLoggable(PlatformLogger.Level.FINE)) {
            grabLog.fine("{0}, when grabbed {1}, contains {2}", xce, this.isGrabbed(), this.containsGlobal(this.scaleDown(xce.get_x_root()), this.scaleDown(xce.get_y_root())));
        }
        if (this.isGrabbed()) {
            XBaseWindow target = XToolkit.windowToXWindow(xce.get_window());
            if (grabLog.isLoggable(PlatformLogger.Level.FINER)) {
                grabLog.finer("  -  Grab event target {0}", target);
            }
            if (target != null && target != this) {
                target.dispatchEvent(xev);
                return;
            }
        }
        super.handleXCrossingEvent(xev);
    }

    @Override
    public void handleMotionNotify(XEvent xev) {
        XMotionEvent xme = xev.get_xmotion();
        if (grabLog.isLoggable(PlatformLogger.Level.FINER)) {
            grabLog.finer("{0}, when grabbed {1}, contains {2}", xme, this.isGrabbed(), this.containsGlobal(this.scaleDown(xme.get_x_root()), this.scaleDown(xme.get_y_root())));
        }
        if (this.isGrabbed()) {
            boolean dragging = false;
            int buttonsNumber = XToolkit.getNumberOfButtonsForMask();
            for (int i = 0; i < buttonsNumber; ++i) {
                if (i == 4 || i == 5) continue;
                dragging = dragging || (xme.get_state() & XlibUtil.getButtonMask(i + 1)) != 0;
            }
            XBaseWindow target = XToolkit.windowToXWindow(xme.get_window());
            if (dragging && this.pressTarget != target) {
                target = this.pressTarget.isVisible() ? this.pressTarget : this;
                xme.set_window(target.getWindow());
                Point localCoord = target.toLocal(this.scaleDown(xme.get_x_root()), this.scaleDown(xme.get_y_root()));
                xme.set_x(this.scaleUp(localCoord.x));
                xme.set_y(this.scaleUp(localCoord.y));
            }
            if (grabLog.isLoggable(PlatformLogger.Level.FINER)) {
                grabLog.finer("  -  Grab event target {0}", target);
            }
            if (target != null && target != this.getContentXWindow() && target != this) {
                target.dispatchEvent(xev);
                return;
            }
            if (!this.containsGlobal(this.scaleDown(xme.get_x_root()), this.scaleDown(xme.get_y_root())) && !dragging) {
                return;
            }
        }
        super.handleMotionNotify(xev);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handleButtonPressRelease(XEvent xev) {
        block42: {
            block44: {
                XWindowPeer toplevel;
                XBaseWindow target;
                XButtonEvent xbe;
                block39: {
                    block40: {
                        block43: {
                            block41: {
                                xbe = xev.get_xbutton();
                                if (xbe.get_button() > 20) {
                                    return;
                                }
                                if (grabLog.isLoggable(PlatformLogger.Level.FINE)) {
                                    grabLog.fine("{0}, when grabbed {1}, contains {2} ({3}, {4}, {5}x{6})", xbe, this.isGrabbed(), this.containsGlobal(this.scaleDown(xbe.get_x_root()), this.scaleDown(xbe.get_y_root())), this.getAbsoluteX(), this.getAbsoluteY(), this.getWidth(), this.getHeight());
                                }
                                if (!this.isGrabbed()) break block42;
                                target = XToolkit.windowToXWindow(xbe.get_window());
                                try {
                                    if (grabLog.isLoggable(PlatformLogger.Level.FINER)) {
                                        grabLog.finer("  -  Grab event target {0} (press target {1})", target, this.pressTarget);
                                    }
                                    if (xbe.get_type() == 4 && xbe.get_button() == XConstants.buttons[0]) {
                                        this.pressTarget = target;
                                    } else if (xbe.get_type() == 5 && xbe.get_button() == XConstants.buttons[0] && this.pressTarget != target) {
                                        target = this.pressTarget.isVisible() ? this.pressTarget : this;
                                        xbe.set_window(target.getWindow());
                                        Point localCoord = target.toLocal(this.scaleDown(xbe.get_x_root()), this.scaleDown(xbe.get_y_root()));
                                        xbe.set_x(this.scaleUp(localCoord.x));
                                        xbe.set_y(this.scaleUp(localCoord.y));
                                        this.pressTarget = this;
                                    }
                                    if (target == null || target == this.getContentXWindow() || target == this) break block39;
                                    target.dispatchEvent(xev);
                                    if (target == null) break block40;
                                    if (target == this) break block41;
                                }
                                catch (Throwable throwable) {
                                    if (target != null) {
                                        if (!(target != this && target != this.getContentXWindow() || this.containsGlobal(this.scaleDown(xbe.get_x_root()), this.scaleDown(xbe.get_y_root())) || xbe.get_type() != 4)) {
                                            if (grabLog.isLoggable(PlatformLogger.Level.FINE)) {
                                                grabLog.fine("Generating UngrabEvent on {0} because not inside of shell", this);
                                            }
                                            this.postEventToEventQueue(new UngrabEvent(this.getEventSource()));
                                            return;
                                        }
                                        XWindowPeer toplevel2 = target.getToplevelXWindow();
                                        if (toplevel2 != null) {
                                            Window w = (Window)toplevel2.target;
                                            while (w != null && toplevel2 != this && !(toplevel2 instanceof XDialogPeer)) {
                                                w = (Window)AWTAccessor.getComponentAccessor().getParent(w);
                                                if (w == null) continue;
                                                toplevel2 = (XWindowPeer)AWTAccessor.getComponentAccessor().getPeer(w);
                                            }
                                            if (w != null) {
                                                if (w == this.target) throw throwable;
                                                if (!(w instanceof Dialog)) throw throwable;
                                            }
                                            if (grabLog.isLoggable(PlatformLogger.Level.FINE)) {
                                                grabLog.fine("Generating UngrabEvent on {0} because hierarchy ended", this);
                                            }
                                            this.postEventToEventQueue(new UngrabEvent(this.getEventSource()));
                                            throw throwable;
                                        }
                                        if (grabLog.isLoggable(PlatformLogger.Level.FINE)) {
                                            grabLog.fine("Generating UngrabEvent on {0} because toplevel is null", this);
                                        }
                                        this.postEventToEventQueue(new UngrabEvent(this.getEventSource()));
                                        return;
                                    }
                                    if (grabLog.isLoggable(PlatformLogger.Level.FINE)) {
                                        grabLog.fine("Generating UngrabEvent on because target is null {0}", this);
                                    }
                                    this.postEventToEventQueue(new UngrabEvent(this.getEventSource()));
                                    return;
                                }
                                if (target != this.getContentXWindow()) break block43;
                            }
                            if (!this.containsGlobal(this.scaleDown(xbe.get_x_root()), this.scaleDown(xbe.get_y_root())) && xbe.get_type() == 4) {
                                if (grabLog.isLoggable(PlatformLogger.Level.FINE)) {
                                    grabLog.fine("Generating UngrabEvent on {0} because not inside of shell", this);
                                }
                                this.postEventToEventQueue(new UngrabEvent(this.getEventSource()));
                                return;
                            }
                        }
                        if ((toplevel = target.getToplevelXWindow()) != null) {
                            Window w = (Window)toplevel.target;
                            while (w != null && toplevel != this && !(toplevel instanceof XDialogPeer)) {
                                w = (Window)AWTAccessor.getComponentAccessor().getParent(w);
                                if (w == null) continue;
                                toplevel = (XWindowPeer)AWTAccessor.getComponentAccessor().getPeer(w);
                            }
                            if (w != null) {
                                if (w == this.target) return;
                                if (!(w instanceof Dialog)) return;
                            }
                            if (grabLog.isLoggable(PlatformLogger.Level.FINE)) {
                                grabLog.fine("Generating UngrabEvent on {0} because hierarchy ended", this);
                            }
                            this.postEventToEventQueue(new UngrabEvent(this.getEventSource()));
                            return;
                        }
                        if (grabLog.isLoggable(PlatformLogger.Level.FINE)) {
                            grabLog.fine("Generating UngrabEvent on {0} because toplevel is null", this);
                        }
                        this.postEventToEventQueue(new UngrabEvent(this.getEventSource()));
                        return;
                    }
                    if (grabLog.isLoggable(PlatformLogger.Level.FINE)) {
                        grabLog.fine("Generating UngrabEvent on because target is null {0}", this);
                    }
                    this.postEventToEventQueue(new UngrabEvent(this.getEventSource()));
                    return;
                }
                if (target == null) break block44;
                if (!(target != this && target != this.getContentXWindow() || this.containsGlobal(this.scaleDown(xbe.get_x_root()), this.scaleDown(xbe.get_y_root())) || xbe.get_type() != 4)) {
                    if (grabLog.isLoggable(PlatformLogger.Level.FINE)) {
                        grabLog.fine("Generating UngrabEvent on {0} because not inside of shell", this);
                    }
                    this.postEventToEventQueue(new UngrabEvent(this.getEventSource()));
                    return;
                }
                toplevel = target.getToplevelXWindow();
                if (toplevel != null) {
                    Window w = (Window)toplevel.target;
                    while (w != null && toplevel != this && !(toplevel instanceof XDialogPeer)) {
                        w = (Window)AWTAccessor.getComponentAccessor().getParent(w);
                        if (w == null) continue;
                        toplevel = (XWindowPeer)AWTAccessor.getComponentAccessor().getPeer(w);
                    }
                    if (w == null || w != this.target && w instanceof Dialog) {
                        if (grabLog.isLoggable(PlatformLogger.Level.FINE)) {
                            grabLog.fine("Generating UngrabEvent on {0} because hierarchy ended", this);
                        }
                        this.postEventToEventQueue(new UngrabEvent(this.getEventSource()));
                    }
                    break block42;
                } else {
                    if (grabLog.isLoggable(PlatformLogger.Level.FINE)) {
                        grabLog.fine("Generating UngrabEvent on {0} because toplevel is null", this);
                    }
                    this.postEventToEventQueue(new UngrabEvent(this.getEventSource()));
                    return;
                }
            }
            if (grabLog.isLoggable(PlatformLogger.Level.FINE)) {
                grabLog.fine("Generating UngrabEvent on because target is null {0}", this);
            }
            this.postEventToEventQueue(new UngrabEvent(this.getEventSource()));
            return;
        }
        super.handleButtonPressRelease(xev);
    }

    @Override
    public void print(Graphics g) {
        Shape shape = AWTAccessor.getWindowAccessor().getShape((Window)this.target);
        if (shape != null) {
            g.setClip(shape);
        }
        super.print(g);
    }

    @Override
    public void setOpacity(float opacity) {
        long maxOpacity = 0xFFFFFFFFL;
        long iOpacity = (long)(opacity * 4.2949673E9f);
        if (iOpacity < 0L) {
            iOpacity = 0L;
        }
        if (iOpacity > 0xFFFFFFFFL) {
            iOpacity = 0xFFFFFFFFL;
        }
        XAtom netWmWindowOpacityAtom = XAtom.get("_NET_WM_WINDOW_OPACITY");
        if (iOpacity == 0xFFFFFFFFL) {
            netWmWindowOpacityAtom.DeleteProperty(this.getWindow());
        } else {
            netWmWindowOpacityAtom.setCard32Property(this.getWindow(), iOpacity);
        }
    }

    @Override
    public void setOpaque(boolean isOpaque) {
    }

    @Override
    public void updateWindow() {
    }
}

