/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.dnd.peer.DropTargetPeer;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.PaintEvent;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.VolatileImage;
import java.awt.peer.ComponentPeer;
import java.awt.peer.ContainerPeer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import sun.awt.AWTAccessor;
import sun.awt.CausedFocusEvent;
import sun.awt.SunToolkit;
import sun.awt.X11.MotifColorUtilities;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XEvent;
import sun.awt.X11.XFramePeer;
import sun.awt.X11.XGlobalCursorManager;
import sun.awt.X11.XKeyboardFocusManagerPeer;
import sun.awt.X11.XMenuBarPeer;
import sun.awt.X11.XSetWindowAttributes;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindow;
import sun.awt.X11.XWindowAttributesData;
import sun.awt.X11.XWindowPeer;
import sun.awt.X11.XlibUtil;
import sun.awt.X11.XlibWrapper;
import sun.awt.X11GraphicsConfig;
import sun.awt.event.IgnorePaintEvent;
import sun.awt.image.SunVolatileImage;
import sun.awt.image.ToolkitImage;
import sun.font.FontDesignMetrics;
import sun.java2d.BackBufferCapsProvider;
import sun.java2d.pipe.Region;
import sun.util.logging.PlatformLogger;

public class XComponentPeer
extends XWindow
implements ComponentPeer,
DropTargetPeer,
BackBufferCapsProvider {
    private static final PlatformLogger log = PlatformLogger.getLogger("sun.awt.X11.XComponentPeer");
    private static final PlatformLogger buffersLog = PlatformLogger.getLogger("sun.awt.X11.XComponentPeer.multibuffer");
    private static final PlatformLogger focusLog = PlatformLogger.getLogger("sun.awt.X11.focus.XComponentPeer");
    private static final PlatformLogger fontLog = PlatformLogger.getLogger("sun.awt.X11.font.XComponentPeer");
    private static final PlatformLogger enableLog = PlatformLogger.getLogger("sun.awt.X11.enable.XComponentPeer");
    private static final PlatformLogger shapeLog = PlatformLogger.getLogger("sun.awt.X11.shape.XComponentPeer");
    boolean paintPending = false;
    boolean isLayouting = false;
    private boolean enabled;
    protected int boundsOperation;
    Color foreground;
    Color background;
    Color darkShadow;
    Color lightShadow;
    Color selectColor;
    Font font;
    private long backBuffer = 0L;
    private VolatileImage xBackBuffer = null;
    static Color[] systemColors;
    boolean bHasFocus = false;
    private static Class seClass;
    private static Constructor seCtor;
    static final int BACKGROUND_COLOR = 0;
    static final int HIGHLIGHT_COLOR = 1;
    static final int SHADOW_COLOR = 2;
    static final int FOREGROUND_COLOR = 3;
    private BufferCapabilities backBufferCaps;

    XComponentPeer() {
    }

    XComponentPeer(XCreateWindowParams params) {
        super(params);
    }

    XComponentPeer(Component target, long parentWindow, Rectangle bounds) {
        super(target, parentWindow, bounds);
    }

    XComponentPeer(Component target) {
        super(target);
    }

    @Override
    void preInit(XCreateWindowParams params) {
        super.preInit(params);
        this.boundsOperation = 3;
    }

    @Override
    void postInit(XCreateWindowParams params) {
        super.postInit(params);
        this.pSetCursor(this.target.getCursor());
        this.foreground = this.target.getForeground();
        this.background = this.target.getBackground();
        this.font = this.target.getFont();
        if (this.isInitialReshape()) {
            Rectangle r = this.target.getBounds();
            this.reshape(r.x, r.y, r.width, r.height);
        }
        this.setEnabled(this.target.isEnabled());
        if (this.target.isVisible()) {
            this.setVisible(true);
        }
    }

    protected boolean isInitialReshape() {
        return true;
    }

    @Override
    public void reparent(ContainerPeer newNativeParent) {
        XComponentPeer newPeer = (XComponentPeer)((Object)newNativeParent);
        XToolkit.awtLock();
        try {
            XlibWrapper.XReparentWindow(XToolkit.getDisplay(), this.getWindow(), newPeer.getContentWindow(), this.scaleUp(this.x), this.scaleUp(this.y));
            this.parentWindow = newPeer;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    @Override
    public boolean isReparentSupported() {
        return System.getProperty("sun.awt.X11.XComponentPeer.reparentNotSupported", "false").equals("false");
    }

    @Override
    public boolean isObscured() {
        XWindowPeer wpeer;
        Container parent;
        Container container;
        Container container2 = container = this.target instanceof Container ? (Container)this.target : this.target.getParent();
        if (container == null) {
            return true;
        }
        while ((parent = container.getParent()) != null) {
            container = parent;
        }
        if (container instanceof Window && (wpeer = (XWindowPeer)container.getPeer()) != null) {
            XWindowAttributesData cfr_ignored_0 = wpeer.winAttr;
            return wpeer.winAttr.visibilityState != XWindowAttributesData.AWT_UNOBSCURED;
        }
        return true;
    }

    @Override
    public boolean canDetermineObscurity() {
        return true;
    }

    public final boolean hasFocus() {
        return this.bHasFocus;
    }

    public void focusGained(FocusEvent e) {
        if (focusLog.isLoggable(PlatformLogger.Level.FINE)) {
            focusLog.fine("{0}", e);
        }
        this.bHasFocus = true;
    }

    public void focusLost(FocusEvent e) {
        if (focusLog.isLoggable(PlatformLogger.Level.FINE)) {
            focusLog.fine("{0}", e);
        }
        this.bHasFocus = false;
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    static final AWTEvent wrapInSequenced(AWTEvent event) {
        block10: {
            try {
                if (seClass == null) {
                    seClass = Class.forName("java.awt.SequencedEvent");
                }
                if (seCtor == null) {
                    seCtor = (Constructor)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            Constructor ctor = seClass.getConstructor(AWTEvent.class);
                            ctor.setAccessible(true);
                            return ctor;
                        }
                    });
                }
                return (AWTEvent)seCtor.newInstance(event);
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError("java.awt.SequencedEvent.");
            }
            catch (PrivilegedActionException ex) {
                throw new NoClassDefFoundError("java.awt.SequencedEvent.");
            }
            catch (InstantiationException e) {
                assert (false);
            }
            catch (IllegalAccessException e) {
                assert (false);
            }
            catch (InvocationTargetException e) {
                if ($assertionsDisabled) break block10;
                throw new AssertionError();
            }
        }
        return null;
    }

    @Override
    public final boolean requestFocus(Component lightweightChild, boolean temporary, boolean focusedWindowChangeAllowed, long time, CausedFocusEvent.Cause cause) {
        if (XKeyboardFocusManagerPeer.processSynchronousLightweightTransfer(this.target, lightweightChild, temporary, focusedWindowChangeAllowed, time)) {
            return true;
        }
        int result = XKeyboardFocusManagerPeer.shouldNativelyFocusHeavyweight(this.target, lightweightChild, temporary, focusedWindowChangeAllowed, time, cause);
        switch (result) {
            case 0: {
                return false;
            }
            case 2: {
                Window parentWindow;
                if (focusLog.isLoggable(PlatformLogger.Level.FINER)) {
                    focusLog.finer("Proceeding with request to " + lightweightChild + " in " + this.target);
                }
                if ((parentWindow = SunToolkit.getContainingWindow(this.target)) == null) {
                    return this.rejectFocusRequestHelper("WARNING: Parent window is null");
                }
                XWindowPeer wpeer = (XWindowPeer)parentWindow.getPeer();
                if (wpeer == null) {
                    return this.rejectFocusRequestHelper("WARNING: Parent window's peer is null");
                }
                boolean res = wpeer.requestWindowFocus(null);
                if (focusLog.isLoggable(PlatformLogger.Level.FINER)) {
                    focusLog.finer("Requested window focus: " + res);
                }
                if (!res || !parentWindow.isFocused()) {
                    return this.rejectFocusRequestHelper("Waiting for asynchronous processing of the request");
                }
                return XKeyboardFocusManagerPeer.deliverFocus(lightweightChild, this.target, temporary, focusedWindowChangeAllowed, time, cause);
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    private boolean rejectFocusRequestHelper(String logMsg) {
        if (focusLog.isLoggable(PlatformLogger.Level.FINER)) {
            focusLog.finer(logMsg);
        }
        XKeyboardFocusManagerPeer.removeLastFocusRequest(this.target);
        return false;
    }

    void handleJavaFocusEvent(AWTEvent e) {
        if (focusLog.isLoggable(PlatformLogger.Level.FINER)) {
            focusLog.finer(e.toString());
        }
        if (e.getID() == 1004) {
            this.focusGained((FocusEvent)e);
        } else {
            this.focusLost((FocusEvent)e);
        }
    }

    void handleJavaWindowFocusEvent(AWTEvent e) {
    }

    @Override
    public void setVisible(boolean b) {
        this.xSetVisible(b);
    }

    public void hide() {
        this.setVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEnabled(boolean value) {
        if (enableLog.isLoggable(PlatformLogger.Level.FINE)) {
            enableLog.fine("{0}ing {1}", value ? "Enabl" : "Disabl", this);
        }
        boolean status = value;
        Container cp = SunToolkit.getNativeContainer(this.target);
        if (cp != null) {
            status &= ((XComponentPeer)cp.getPeer()).isEnabled();
        }
        Object object = this.getStateLock();
        synchronized (object) {
            if (this.enabled == status) {
                return;
            }
            this.enabled = status;
        }
        if (this.target instanceof Container) {
            Component[] list;
            for (Component child : list = ((Container)this.target).getComponents()) {
                ComponentPeer p = child.getPeer();
                if (p == null) continue;
                p.setEnabled(status && child.isEnabled());
            }
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isEnabled() {
        Object object = this.getStateLock();
        synchronized (object) {
            return this.enabled;
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.target.paint(g);
    }

    @Override
    public Graphics getGraphics() {
        return this.getGraphics(this.surfaceData, this.getPeerForeground(), this.getPeerBackground(), this.getPeerFont());
    }

    @Override
    public void print(Graphics g) {
        g.setColor(this.target.getBackground());
        g.fillRect(0, 0, this.target.getWidth(), this.target.getHeight());
        g.setColor(this.target.getForeground());
        this.paintPeer(g);
        this.target.print(g);
    }

    @Override
    public void setBounds(int x, int y, int width, int height, int op) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.xSetBounds(x, y, width, height);
        this.validateSurface();
        this.layout();
    }

    @Override
    public void reshape(int x, int y, int width, int height) {
        this.setBounds(x, y, width, height, 3);
    }

    @Override
    public void coalescePaintEvent(PaintEvent e) {
        Rectangle r = e.getUpdateRect();
        if (!(e instanceof IgnorePaintEvent)) {
            this.paintArea.add(r, e.getID());
        }
        switch (e.getID()) {
            case 801: {
                if (log.isLoggable(PlatformLogger.Level.FINER)) {
                    log.finer("XCP coalescePaintEvent : UPDATE : add : x = " + r.x + ", y = " + r.y + ", width = " + r.width + ",height = " + r.height);
                }
                return;
            }
            case 800: {
                if (log.isLoggable(PlatformLogger.Level.FINER)) {
                    log.finer("XCP coalescePaintEvent : PAINT : add : x = " + r.x + ", y = " + r.y + ", width = " + r.width + ",height = " + r.height);
                }
                return;
            }
        }
    }

    XWindowPeer getParentTopLevel() {
        Container parent;
        AWTAccessor.ComponentAccessor compAccessor = AWTAccessor.getComponentAccessor();
        Container container = parent = this.target instanceof Container ? (Container)this.target : compAccessor.getParent(this.target);
        while (parent != null && !(parent instanceof Window)) {
            parent = compAccessor.getParent(parent);
        }
        if (parent != null) {
            return (XWindowPeer)compAccessor.getPeer(parent);
        }
        return null;
    }

    void handleJavaMouseEvent(MouseEvent e) {
        switch (e.getID()) {
            case 501: {
                if (this.target != e.getSource() || this.target.isFocusOwner() || !XKeyboardFocusManagerPeer.shouldFocusOnClick(this.target)) break;
                XWindowPeer parentXWindow = this.getParentTopLevel();
                Window parentWindow = (Window)parentXWindow.getTarget();
                XKeyboardFocusManagerPeer.requestFocusFor(this.target, CausedFocusEvent.Cause.MOUSE_EVENT);
            }
        }
    }

    void handleJavaKeyEvent(KeyEvent e) {
    }

    void handleJavaMouseWheelEvent(MouseWheelEvent e) {
    }

    void handleJavaInputMethodEvent(InputMethodEvent e) {
    }

    void handleF10JavaKeyEvent(KeyEvent e) {
        XMenuBarPeer mPeer;
        XWindowPeer winPeer;
        if (e.getID() == 401 && e.getKeyCode() == 121 && (winPeer = this.getToplevelXWindow()) instanceof XFramePeer && (mPeer = ((XFramePeer)winPeer).getMenubarPeer()) != null) {
            mPeer.handleF10KeyPress(e);
        }
    }

    @Override
    public void handleEvent(AWTEvent e) {
        if (e instanceof InputEvent && !((InputEvent)e).isConsumed() && this.target.isEnabled()) {
            if (e instanceof MouseEvent) {
                if (e instanceof MouseWheelEvent) {
                    this.handleJavaMouseWheelEvent((MouseWheelEvent)e);
                } else {
                    this.handleJavaMouseEvent((MouseEvent)e);
                }
            } else if (e instanceof KeyEvent) {
                this.handleF10JavaKeyEvent((KeyEvent)e);
                this.handleJavaKeyEvent((KeyEvent)e);
            }
        } else if (e instanceof KeyEvent && !((InputEvent)e).isConsumed()) {
            this.handleF10JavaKeyEvent((KeyEvent)e);
        } else if (e instanceof InputMethodEvent) {
            this.handleJavaInputMethodEvent((InputMethodEvent)e);
        }
        int id = e.getID();
        switch (id) {
            case 800: {
                this.paintPending = false;
            }
            case 801: {
                if (!this.isLayouting && !this.paintPending) {
                    this.paintArea.paint(this.target, false);
                }
                return;
            }
            case 1004: 
            case 1005: {
                this.handleJavaFocusEvent(e);
                break;
            }
            case 207: 
            case 208: {
                this.handleJavaWindowFocusEvent(e);
                break;
            }
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return this.target.getSize();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public void layout() {
    }

    void updateMotifColors(Color bg) {
        int red = bg.getRed();
        int green = bg.getGreen();
        int blue = bg.getBlue();
        this.darkShadow = new Color(MotifColorUtilities.calculateBottomShadowFromBackground(red, green, blue));
        this.lightShadow = new Color(MotifColorUtilities.calculateTopShadowFromBackground(red, green, blue));
        this.selectColor = new Color(MotifColorUtilities.calculateSelectFromBackground(red, green, blue));
    }

    public void drawMotif3DRect(Graphics g, int x, int y, int width, int height, boolean topShadow) {
        g.setColor(topShadow ? this.darkShadow : this.lightShadow);
        g.drawLine(x, y, x + width, y);
        g.drawLine(x, y + height, x, y);
        g.setColor(topShadow ? this.lightShadow : this.darkShadow);
        g.drawLine(x + 1, y + height, x + width, y + height);
        g.drawLine(x + width, y + height, x + width, y + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBackground(Color c) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("Set background to " + c);
        }
        Object object = this.getStateLock();
        synchronized (object) {
            if (Objects.equals(this.background, c)) {
                return;
            }
            this.background = c;
        }
        super.setBackground(c);
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setForeground(Color c) {
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("Set foreground to " + c);
        }
        Object object = this.getStateLock();
        synchronized (object) {
            if (Objects.equals(this.foreground, c)) {
                return;
            }
            this.foreground = c;
        }
        this.repaint();
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        if (fontLog.isLoggable(PlatformLogger.Level.FINE)) {
            fontLog.fine("Getting font metrics for " + font);
        }
        return FontDesignMetrics.getMetrics(font);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFont(Font f) {
        if (f == null) {
            f = XWindow.getDefaultFont();
        }
        Object object = this.getStateLock();
        synchronized (object) {
            if (f.equals(this.font)) {
                return;
            }
            this.font = f;
        }
        this.repaint();
    }

    public Font getFont() {
        return this.font;
    }

    @Override
    public void updateCursorImmediately() {
        XGlobalCursorManager.getCursorManager().updateCursorImmediately();
    }

    public final void pSetCursor(Cursor cursor) {
        this.pSetCursor(cursor, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pSetCursor(Cursor cursor, boolean ignoreSubComponents) {
        XToolkit.awtLock();
        try {
            long xcursor = XGlobalCursorManager.getCursor(cursor);
            XSetWindowAttributes xwa = new XSetWindowAttributes();
            xwa.set_cursor(xcursor);
            long valuemask = 16384L;
            XlibWrapper.XChangeWindowAttributes(XToolkit.getDisplay(), this.getWindow(), valuemask, xwa.pData);
            XlibWrapper.XFlush(XToolkit.getDisplay());
            xwa.dispose();
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    @Override
    public Image createImage(ImageProducer producer) {
        return new ToolkitImage(producer);
    }

    @Override
    public Image createImage(int width, int height) {
        return this.graphicsConfig.createAcceleratedImage(this.target, width, height);
    }

    @Override
    public VolatileImage createVolatileImage(int width, int height) {
        return new SunVolatileImage(this.target, width, height);
    }

    @Override
    public boolean prepareImage(Image img, int w, int h, ImageObserver o) {
        return Toolkit.getDefaultToolkit().prepareImage(img, w, h, o);
    }

    @Override
    public int checkImage(Image img, int w, int h, ImageObserver o) {
        return Toolkit.getDefaultToolkit().checkImage(img, w, h, o);
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public void beginValidate() {
    }

    public void endValidate() {
    }

    public Insets insets() {
        return this.getInsets();
    }

    public boolean isPaintPending() {
        return this.paintPending && this.isLayouting;
    }

    @Override
    public boolean handlesWheelScrolling() {
        return false;
    }

    public void beginLayout() {
        this.isLayouting = true;
    }

    public void endLayout() {
        if (!(this.paintPending || this.paintArea.isEmpty() || AWTAccessor.getComponentAccessor().getIgnoreRepaint(this.target))) {
            this.postEvent(new PaintEvent(this.target, 800, new Rectangle()));
        }
        this.isLayouting = false;
    }

    @Override
    public Color getWinBackground() {
        return this.getPeerBackground();
    }

    static int[] getRGBvals(Color c) {
        int[] rgbvals = new int[]{c.getRed(), c.getGreen(), c.getBlue()};
        return rgbvals;
    }

    public Color[] getGUIcolors() {
        Color[] c = new Color[4];
        c[0] = this.getWinBackground();
        if (c[0] == null) {
            c[0] = super.getWinBackground();
        }
        if (c[0] == null) {
            c[0] = Color.lightGray;
        }
        int[] rgb = XComponentPeer.getRGBvals(c[0]);
        float[] hsb = Color.RGBtoHSB(rgb[0], rgb[1], rgb[2], null);
        float hue = hsb[0];
        float saturation = hsb[1];
        float backb = hsb[2];
        float highb = backb + 0.2f;
        float shadowb = backb - 0.4f;
        if ((double)highb > 1.0) {
            highb = 1.0 - (double)backb < 0.05 ? shadowb + 0.25f : 1.0f;
        } else if ((double)shadowb < 0.0) {
            if ((double)backb - 0.0 < 0.25) {
                highb = backb + 0.75f;
                shadowb = highb - 0.2f;
            } else {
                shadowb = 0.0f;
            }
        }
        c[1] = Color.getHSBColor(hue, saturation, highb);
        c[2] = Color.getHSBColor(hue, saturation, shadowb);
        c[3] = this.getPeerForeground();
        if (c[3] == null) {
            c[3] = Color.black;
        }
        if (!this.isEnabled()) {
            c[0] = c[0].darker();
            Color tc = c[0];
            int bg = tc.getRed() * 30 + tc.getGreen() * 59 + tc.getBlue() * 11;
            tc = c[3];
            int fg = tc.getRed() * 30 + tc.getGreen() * 59 + tc.getBlue() * 11;
            float ave = (float)((double)(fg + bg) / 51000.0);
            Color newForeground = new Color((int)((float)tc.getRed() * ave), (int)((float)tc.getGreen() * ave), (int)((float)tc.getBlue() * ave));
            if (newForeground.equals(c[3])) {
                newForeground = new Color(ave, ave, ave);
            }
            c[3] = newForeground;
        }
        return c;
    }

    static Color[] getSystemColors() {
        if (systemColors == null) {
            systemColors = new Color[4];
            XComponentPeer.systemColors[0] = SystemColor.window;
            XComponentPeer.systemColors[1] = SystemColor.controlLtHighlight;
            XComponentPeer.systemColors[2] = SystemColor.controlShadow;
            XComponentPeer.systemColors[3] = SystemColor.windowText;
        }
        return systemColors;
    }

    public void draw3DOval(Graphics g, Color[] colors, int x, int y, int w, int h, boolean raised) {
        Color c = g.getColor();
        g.setColor(raised ? colors[1] : colors[2]);
        g.drawArc(x, y, w, h, 45, 180);
        g.setColor(raised ? colors[2] : colors[1]);
        g.drawArc(x, y, w, h, 225, 180);
        g.setColor(c);
    }

    public void draw3DRect(Graphics g, Color[] colors, int x, int y, int width, int height, boolean raised) {
        Color c = g.getColor();
        g.setColor(raised ? colors[1] : colors[2]);
        g.drawLine(x, y, x, y + height);
        g.drawLine(x + 1, y, x + width - 1, y);
        g.setColor(raised ? colors[2] : colors[1]);
        g.drawLine(x + 1, y + height, x + width, y + height);
        g.drawLine(x + width, y, x + width, y + height - 1);
        g.setColor(c);
    }

    void draw3DOval(Graphics g, Color bg, int x, int y, int w, int h, boolean raised) {
        Color c = g.getColor();
        Color shadow = bg.darker();
        Color highlight = bg.brighter();
        g.setColor(raised ? highlight : shadow);
        g.drawArc(x, y, w, h, 45, 180);
        g.setColor(raised ? shadow : highlight);
        g.drawArc(x, y, w, h, 225, 180);
        g.setColor(c);
    }

    void draw3DRect(Graphics g, Color bg, int x, int y, int width, int height, boolean raised) {
        Color c = g.getColor();
        Color shadow = bg.darker();
        Color highlight = bg.brighter();
        g.setColor(raised ? highlight : shadow);
        g.drawLine(x, y, x, y + height);
        g.drawLine(x + 1, y, x + width - 1, y);
        g.setColor(raised ? shadow : highlight);
        g.drawLine(x + 1, y + height, x + width, y + height);
        g.drawLine(x + width, y, x + width, y + height - 1);
        g.setColor(c);
    }

    void drawScrollbar(Graphics g, Color bg, int thickness, int length, int min, int max, int val, int vis, boolean horizontal) {
        Color c = g.getColor();
        double f = (double)(length - 2 * (thickness - 1)) / (double)Math.max(1, max - min + vis);
        int v1 = thickness + (int)(f * (double)(val - min));
        int v2 = (int)(f * (double)vis);
        int w2 = thickness - 4;
        int[] tpts_x = new int[3];
        int[] tpts_y = new int[3];
        if (length < 3 * w2) {
            v2 = 0;
            v1 = 0;
            if (length < 2 * w2 + 2) {
                w2 = (length - 2) / 2;
            }
        } else if (v2 < 7) {
            v1 = Math.max(0, v1 - (7 - v2 >> 1));
            v2 = 7;
        }
        int ctr = thickness / 2;
        int sbmin = ctr - w2 / 2;
        int sbmax = ctr + w2 / 2;
        Color d = new Color((int)((double)bg.getRed() * 0.85), (int)((double)bg.getGreen() * 0.85), (int)((double)bg.getBlue() * 0.85));
        g.setColor(d);
        if (horizontal) {
            g.fillRect(0, 0, length, thickness);
        } else {
            g.fillRect(0, 0, thickness, length);
        }
        g.setColor(bg);
        if (v1 > 0) {
            if (horizontal) {
                g.fillRect(v1, 3, v2, thickness - 3);
            } else {
                g.fillRect(3, v1, thickness - 3, v2);
            }
        }
        tpts_x[0] = ctr;
        tpts_y[0] = 2;
        tpts_x[1] = sbmin;
        tpts_y[1] = w2;
        tpts_x[2] = sbmax;
        tpts_y[2] = w2;
        if (horizontal) {
            g.fillPolygon(tpts_y, tpts_x, 3);
        } else {
            g.fillPolygon(tpts_x, tpts_y, 3);
        }
        tpts_y[0] = length - 2;
        tpts_y[1] = length - w2;
        tpts_y[2] = length - w2;
        if (horizontal) {
            g.fillPolygon(tpts_y, tpts_x, 3);
        } else {
            g.fillPolygon(tpts_x, tpts_y, 3);
        }
        Color highlight = bg.brighter();
        g.setColor(highlight);
        if (horizontal) {
            g.drawLine(1, thickness, length - 1, thickness);
            g.drawLine(length - 1, 1, length - 1, thickness);
            g.drawLine(1, ctr, w2, sbmin);
            g.drawLine(length - w2, sbmin, length - w2, sbmax);
            g.drawLine(length - w2, sbmin, length - 2, ctr);
        } else {
            g.drawLine(thickness, 1, thickness, length - 1);
            g.drawLine(1, length - 1, thickness, length - 1);
            g.drawLine(ctr, 1, sbmin, w2);
            g.drawLine(sbmin, length - w2, sbmax, length - w2);
            g.drawLine(sbmin, length - w2, ctr, length - 2);
        }
        if (v1 > 0) {
            if (horizontal) {
                g.drawLine(v1, 2, v1 + v2, 2);
                g.drawLine(v1, 2, v1, thickness - 3);
            } else {
                g.drawLine(2, v1, 2, v1 + v2);
                g.drawLine(2, v1, thickness - 3, v1);
            }
        }
        Color shadow = bg.darker();
        g.setColor(shadow);
        if (horizontal) {
            g.drawLine(0, 0, 0, thickness);
            g.drawLine(0, 0, length - 1, 0);
            g.drawLine(w2, sbmin, w2, sbmax);
            g.drawLine(w2, sbmax, 1, ctr);
            g.drawLine(length - 2, ctr, length - w2, sbmax);
        } else {
            g.drawLine(0, 0, thickness, 0);
            g.drawLine(0, 0, 0, length - 1);
            g.drawLine(sbmin, w2, sbmax, w2);
            g.drawLine(sbmax, w2, ctr, 1);
            g.drawLine(ctr, length - 2, sbmax, length - w2);
        }
        if (v1 > 0) {
            if (horizontal) {
                g.drawLine(v1 + v2, 2, v1 + v2, thickness - 2);
                g.drawLine(v1, thickness - 2, v1 + v2, thickness - 2);
            } else {
                g.drawLine(2, v1 + v2, thickness - 2, v1 + v2);
                g.drawLine(thickness - 2, v1, thickness - 2, v1 + v2);
            }
        }
        g.setColor(c);
    }

    @Override
    public void createBuffers(int numBuffers, BufferCapabilities caps) throws AWTException {
        if (buffersLog.isLoggable(PlatformLogger.Level.FINE)) {
            buffersLog.fine("createBuffers(" + numBuffers + ", " + caps + ")");
        }
        this.backBufferCaps = caps;
        this.backBuffer = this.graphicsConfig.createBackBuffer(this, numBuffers, caps);
        this.xBackBuffer = this.graphicsConfig.createBackBufferImage(this.target, this.backBuffer);
    }

    @Override
    public BufferCapabilities getBackBufferCaps() {
        return this.backBufferCaps;
    }

    @Override
    public void flip(int x1, int y1, int x2, int y2, BufferCapabilities.FlipContents flipAction) {
        if (buffersLog.isLoggable(PlatformLogger.Level.FINE)) {
            buffersLog.fine("flip(" + flipAction + ")");
        }
        if (this.backBuffer == 0L) {
            throw new IllegalStateException("Buffers have not been created");
        }
        this.graphicsConfig.flip(this, this.target, this.xBackBuffer, x1, y1, x2, y2, flipAction);
    }

    @Override
    public Image getBackBuffer() {
        if (buffersLog.isLoggable(PlatformLogger.Level.FINE)) {
            buffersLog.fine("getBackBuffer()");
        }
        if (this.backBuffer == 0L) {
            throw new IllegalStateException("Buffers have not been created");
        }
        return this.xBackBuffer;
    }

    @Override
    public void destroyBuffers() {
        if (buffersLog.isLoggable(PlatformLogger.Level.FINE)) {
            buffersLog.fine("destroyBuffers()");
        }
        this.graphicsConfig.destroyBackBuffer(this.backBuffer);
        this.backBuffer = 0L;
        this.xBackBuffer = null;
    }

    public void notifyTextComponentChange(boolean add) {
        Container parent = AWTAccessor.getComponentAccessor().getParent(this.target);
        while (parent != null && !(parent instanceof Frame) && !(parent instanceof Dialog)) {
            parent = AWTAccessor.getComponentAccessor().getParent(parent);
        }
    }

    @Override
    protected boolean isEventDisabled(XEvent e) {
        if (enableLog.isLoggable(PlatformLogger.Level.FINEST)) {
            enableLog.finest("Component is {1}, checking for disabled event {0}", e, this.isEnabled() ? "enabled" : "disable");
        }
        if (!this.isEnabled()) {
            switch (e.get_type()) {
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    if (enableLog.isLoggable(PlatformLogger.Level.FINER)) {
                        enableLog.finer("Event {0} is disable", e);
                    }
                    return true;
                }
            }
        }
        switch (e.get_type()) {
            case 18: 
            case 19: {
                return true;
            }
        }
        return super.isEventDisabled(e);
    }

    Color getPeerBackground() {
        return this.background;
    }

    Color getPeerForeground() {
        return this.foreground;
    }

    Font getPeerFont() {
        return this.font;
    }

    Dimension getPeerSize() {
        return new Dimension(this.width, this.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBoundsOperation(int operation) {
        Object object = this.getStateLock();
        synchronized (object) {
            if (this.boundsOperation == 3) {
                this.boundsOperation = operation;
            } else if (operation == 5) {
                this.boundsOperation = 3;
            }
        }
    }

    static String operationToString(int operation) {
        switch (operation) {
            case 1: {
                return "SET_LOCATION";
            }
            case 2: {
                return "SET_SIZE";
            }
            case 4: {
                return "SET_CLIENT_SIZE";
            }
        }
        return "SET_BOUNDS";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setZOrder(ComponentPeer above) {
        long aboveWindow = above != null ? ((XComponentPeer)above).getWindow() : 0L;
        XToolkit.awtLock();
        try {
            XlibWrapper.SetZOrder(XToolkit.getDisplay(), this.getWindow(), aboveWindow);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    private void addTree(Collection order, Set set, Container cont) {
        for (int i = 0; i < cont.getComponentCount(); ++i) {
            Component comp = cont.getComponent(i);
            ComponentPeer peer = comp.getPeer();
            if (peer instanceof XComponentPeer) {
                Long window = ((XComponentPeer)peer).getWindow();
                if (set.contains(window)) continue;
                set.add(window);
                order.add(window);
                continue;
            }
            if (!(comp instanceof Container)) continue;
            this.addTree(order, set, (Container)comp);
        }
    }

    @Override
    public void addDropTarget(DropTarget dt) {
        XWindowPeer wpeer;
        Component comp;
        for (comp = this.target; comp != null && !(comp instanceof Window); comp = comp.getParent()) {
        }
        if (comp instanceof Window && (wpeer = (XWindowPeer)comp.getPeer()) != null) {
            wpeer.addDropTarget();
        }
    }

    @Override
    public void removeDropTarget(DropTarget dt) {
        XWindowPeer wpeer;
        Component comp;
        for (comp = this.target; comp != null && !(comp instanceof Window); comp = comp.getParent()) {
        }
        if (comp instanceof Window && (wpeer = (XWindowPeer)comp.getPeer()) != null) {
            wpeer.removeDropTarget();
        }
    }

    @Override
    public void applyShape(Region shape) {
        if (XlibUtil.isShapingSupported()) {
            if (shapeLog.isLoggable(PlatformLogger.Level.FINER)) {
                shapeLog.finer("*** INFO: Setting shape: PEER: " + this + "; WINDOW: " + this.getWindow() + "; TARGET: " + this.target + "; SHAPE: " + shape);
            }
            XToolkit.awtLock();
            try {
                if (shape != null) {
                    int scale = this.getScale();
                    if (scale != 1) {
                        shape = shape.getScaledRegion(scale, scale);
                    }
                    XlibWrapper.SetRectangularShape(XToolkit.getDisplay(), this.getWindow(), shape.getLoX(), shape.getLoY(), shape.getHiX(), shape.getHiY(), shape.isRectangular() ? null : shape);
                }
                XlibWrapper.SetRectangularShape(XToolkit.getDisplay(), this.getWindow(), 0, 0, 0, 0, null);
            }
            finally {
                XToolkit.awtUnlock();
            }
        } else if (shapeLog.isLoggable(PlatformLogger.Level.FINER)) {
            shapeLog.finer("*** WARNING: Shaping is NOT supported!");
        }
    }

    @Override
    public boolean updateGraphicsData(GraphicsConfiguration gc) {
        int oldVisual = -1;
        int newVisual = -1;
        if (this.graphicsConfig != null) {
            oldVisual = this.graphicsConfig.getVisual();
        }
        if (gc != null && gc instanceof X11GraphicsConfig) {
            newVisual = ((X11GraphicsConfig)gc).getVisual();
        }
        if (oldVisual != -1 && oldVisual != newVisual) {
            return true;
        }
        this.initGraphicsConfiguration();
        this.doValidateSurface();
        return false;
    }
}

