/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.platform.cgroupv1;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Stream;
import jdk.internal.platform.cgroupv1.Metrics;

public class SubSystem {
    String root;
    String mountPoint;
    String path;

    public SubSystem(String root, String mountPoint) {
        this.root = root;
        this.mountPoint = mountPoint;
    }

    public void setPath(String cgroupPath) {
        if (this.root != null && cgroupPath != null) {
            if (this.root.equals("/")) {
                this.path = cgroupPath.equals("/") ? this.mountPoint + cgroupPath : this.mountPoint;
            } else if (this.root.equals(cgroupPath)) {
                this.path = this.mountPoint;
            } else if (this.root.indexOf(cgroupPath) == 0 && cgroupPath.length() > this.root.length()) {
                String cgroupSubstr = cgroupPath.substring(this.root.length());
                this.path = this.mountPoint + cgroupSubstr;
            }
        }
    }

    public String path() {
        return this.path;
    }

    public static String getStringValue(SubSystem subsystem, String parm) {
        if (subsystem == null) {
            return null;
        }
        try {
            return subsystem.readStringValue(parm);
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readStringValue(String param) throws IOException {
        PrivilegedExceptionAction<BufferedReader> pea = () -> Files.newBufferedReader(Paths.get(this.path(), param));
        try (BufferedReader bufferedReader = AccessController.doPrivileged(pea);){
            String line;
            String string = line = bufferedReader.readLine();
            return string;
        }
        catch (PrivilegedActionException e) {
            Metrics.unwrapIOExceptionAndRethrow(e);
            throw new InternalError(e.getCause());
        }
    }

    public static long getLongValue(SubSystem subsystem, String parm) {
        String strval = SubSystem.getStringValue(subsystem, parm);
        if (strval == null) {
            return 0L;
        }
        long retval = Long.parseLong(strval);
        return retval;
    }

    public static double getDoubleValue(SubSystem subsystem, String parm) {
        String strval = SubSystem.getStringValue(subsystem, parm);
        if (strval == null) {
            return 0.0;
        }
        double retval = Double.parseDouble(strval);
        return retval;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getLongEntry(SubSystem subsystem, String parm, String entryname) {
        Object val = null;
        if (subsystem == null) {
            return 0L;
        }
        try (Stream<String> lines = Metrics.readFilePrivileged(Paths.get(subsystem.path(), parm));){
            Optional<String> result = lines.map(line -> line.split(" ")).filter(line -> ((String[])line).length == 2 && line[0].equals(entryname)).map(line -> line[1]).findFirst();
            long l = result.isPresent() ? Long.parseLong(result.get()) : 0L;
            return l;
        }
        catch (IOException e) {
            return 0L;
        }
    }

    public static int getIntValue(SubSystem subsystem, String parm) {
        String val = SubSystem.getStringValue(subsystem, parm);
        if (val == null) {
            return 0;
        }
        return Integer.parseInt(val);
    }

    public static int[] StringRangeToIntArray(String range) {
        String[] strs;
        int[] ints = new int[]{};
        if (range == null) {
            return ints;
        }
        ArrayList<Integer> results = new ArrayList<Integer>();
        for (String str : strs = range.split(",")) {
            if (str.contains("-")) {
                String[] lohi = str.split("-");
                if (lohi.length != 2) continue;
                int lo = Integer.parseInt(lohi[0]);
                int hi = Integer.parseInt(lohi[1]);
                for (int i = lo; i <= hi; ++i) {
                    results.add(i);
                }
                continue;
            }
            results.add(Integer.parseInt(str));
        }
        results.sort(null);
        ints = new int[results.size()];
        int i = 0;
        for (Integer n : results) {
            ints[i++] = n;
        }
        return ints;
    }
}

