/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.platform.cgroupv1;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.stream.Stream;
import jdk.internal.platform.cgroupv1.SubSystem;

public class Metrics
implements jdk.internal.platform.Metrics {
    private SubSystem memory;
    private SubSystem cpu;
    private SubSystem cpuacct;
    private SubSystem cpuset;
    private SubSystem blkio;
    private boolean activeSubSystems = false;
    static long unlimited_minimum = 0x7FFFFFFFFF000000L;
    private static final Metrics INSTANCE = Metrics.initContainerSubSystems();
    private static final String PROVIDER_NAME = "cgroupv1";

    private Metrics() {
    }

    public static Metrics getInstance() {
        return INSTANCE;
    }

    private static Metrics initContainerSubSystems() {
        Throwable throwable;
        Stream<String> lines;
        if (!Metrics.isUseContainerSupport()) {
            return null;
        }
        Metrics metrics = new Metrics();
        try {
            lines = Metrics.readFilePrivileged(Paths.get("/proc/self/mountinfo", new String[0]));
            throwable = null;
            try {
                lines.filter(line -> line.contains(" - cgroup ")).map(line -> line.split(" ")).forEach(entry -> Metrics.createSubSystem(metrics, entry));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (lines != null) {
                    if (throwable != null) {
                        try {
                            lines.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        lines.close();
                    }
                }
            }
        }
        catch (IOException e) {
            return null;
        }
        try {
            lines = Metrics.readFilePrivileged(Paths.get("/proc/self/cgroup", new String[0]));
            throwable = null;
            try {
                lines.map(line -> line.split(":")).filter(line -> ((String[])line).length >= 3).forEach(line -> Metrics.setSubSystemPath(metrics, line));
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (lines != null) {
                    if (throwable != null) {
                        try {
                            lines.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        lines.close();
                    }
                }
            }
        }
        catch (IOException e) {
            return null;
        }
        if (metrics.activeSubSystems()) {
            return metrics;
        }
        return null;
    }

    static Stream<String> readFilePrivileged(Path path) throws IOException {
        try {
            PrivilegedExceptionAction<Stream> pea = () -> Files.lines(path);
            return AccessController.doPrivileged(pea);
        }
        catch (PrivilegedActionException e) {
            Metrics.unwrapIOExceptionAndRethrow(e);
            throw new InternalError(e.getCause());
        }
    }

    static void unwrapIOExceptionAndRethrow(PrivilegedActionException pae) throws IOException {
        Throwable x = pae.getCause();
        if (x instanceof IOException) {
            throw (IOException)x;
        }
        if (x instanceof RuntimeException) {
            throw (RuntimeException)x;
        }
        if (x instanceof Error) {
            throw (Error)x;
        }
    }

    private static void createSubSystem(Metrics metric, String[] mountentry) {
        if (mountentry.length < 5) {
            return;
        }
        Path p = Paths.get(mountentry[4], new String[0]);
        String subsystemName = p.getFileName().toString();
        if (subsystemName != null) {
            switch (subsystemName) {
                case "memory": {
                    metric.setMemorySubSystem(new SubSystem(mountentry[3], mountentry[4]));
                    break;
                }
                case "cpuset": {
                    metric.setCpuSetSubSystem(new SubSystem(mountentry[3], mountentry[4]));
                    break;
                }
                case "cpu,cpuacct": 
                case "cpuacct,cpu": {
                    metric.setCpuSubSystem(new SubSystem(mountentry[3], mountentry[4]));
                    metric.setCpuAcctSubSystem(new SubSystem(mountentry[3], mountentry[4]));
                    break;
                }
                case "cpuacct": {
                    metric.setCpuAcctSubSystem(new SubSystem(mountentry[3], mountentry[4]));
                    break;
                }
                case "cpu": {
                    metric.setCpuSubSystem(new SubSystem(mountentry[3], mountentry[4]));
                    break;
                }
                case "blkio": {
                    metric.setBlkIOSubSystem(new SubSystem(mountentry[3], mountentry[4]));
                    break;
                }
            }
        }
    }

    private static void setSubSystemPath(Metrics metric, String[] entry) {
        SubSystem subsystem = null;
        SubSystem subsystem2 = null;
        String controller = entry[1];
        String base = entry[2];
        if (controller != null && base != null) {
            switch (controller) {
                case "memory": {
                    subsystem = metric.MemorySubSystem();
                    break;
                }
                case "cpuset": {
                    subsystem = metric.CpuSetSubSystem();
                    break;
                }
                case "cpu,cpuacct": 
                case "cpuacct,cpu": {
                    subsystem = metric.CpuSubSystem();
                    subsystem2 = metric.CpuAcctSubSystem();
                    break;
                }
                case "cpuacct": {
                    subsystem = metric.CpuAcctSubSystem();
                    break;
                }
                case "cpu": {
                    subsystem = metric.CpuSubSystem();
                    break;
                }
                case "blkio": {
                    subsystem = metric.BlkIOSubSystem();
                    break;
                }
            }
        }
        if (subsystem != null) {
            subsystem.setPath(base);
            metric.setActiveSubSystems();
        }
        if (subsystem2 != null) {
            subsystem2.setPath(base);
        }
    }

    private void setActiveSubSystems() {
        this.activeSubSystems = true;
    }

    private boolean activeSubSystems() {
        return this.activeSubSystems;
    }

    private void setMemorySubSystem(SubSystem memory) {
        this.memory = memory;
    }

    private void setCpuSubSystem(SubSystem cpu) {
        this.cpu = cpu;
    }

    private void setCpuAcctSubSystem(SubSystem cpuacct) {
        this.cpuacct = cpuacct;
    }

    private void setCpuSetSubSystem(SubSystem cpuset) {
        this.cpuset = cpuset;
    }

    private void setBlkIOSubSystem(SubSystem blkio) {
        this.blkio = blkio;
    }

    private SubSystem MemorySubSystem() {
        return this.memory;
    }

    private SubSystem CpuSubSystem() {
        return this.cpu;
    }

    private SubSystem CpuAcctSubSystem() {
        return this.cpuacct;
    }

    private SubSystem CpuSetSubSystem() {
        return this.cpuset;
    }

    private SubSystem BlkIOSubSystem() {
        return this.blkio;
    }

    @Override
    public String getProvider() {
        return PROVIDER_NAME;
    }

    @Override
    public long getCpuUsage() {
        return SubSystem.getLongValue(this.cpuacct, "cpuacct.usage");
    }

    @Override
    public long[] getPerCpuUsage() {
        String usagelist = SubSystem.getStringValue(this.cpuacct, "cpuacct.usage_percpu");
        if (usagelist == null) {
            return new long[0];
        }
        String[] list = usagelist.split(" ");
        long[] percpu = new long[list.length];
        for (int i = 0; i < list.length; ++i) {
            percpu[i] = Long.parseLong(list[i]);
        }
        return percpu;
    }

    @Override
    public long getCpuUserUsage() {
        return SubSystem.getLongEntry(this.cpuacct, "cpuacct.stat", "user");
    }

    @Override
    public long getCpuSystemUsage() {
        return SubSystem.getLongEntry(this.cpuacct, "cpuacct.stat", "system");
    }

    @Override
    public long getCpuPeriod() {
        return SubSystem.getLongValue(this.cpuacct, "cpu.cfs_period_us");
    }

    @Override
    public long getCpuQuota() {
        return SubSystem.getLongValue(this.cpuacct, "cpu.cfs_quota_us");
    }

    @Override
    public long getCpuShares() {
        long retval = SubSystem.getLongValue(this.cpuacct, "cpu.shares");
        if (retval == 0L || retval == 1024L) {
            return -1L;
        }
        return retval;
    }

    @Override
    public long getCpuNumPeriods() {
        return SubSystem.getLongEntry(this.cpuacct, "cpu.stat", "nr_periods");
    }

    @Override
    public long getCpuNumThrottled() {
        return SubSystem.getLongEntry(this.cpuacct, "cpu.stat", "nr_throttled");
    }

    @Override
    public long getCpuThrottledTime() {
        return SubSystem.getLongEntry(this.cpuacct, "cpu.stat", "throttled_time");
    }

    @Override
    public long getEffectiveCpuCount() {
        return Runtime.getRuntime().availableProcessors();
    }

    @Override
    public int[] getCpuSetCpus() {
        return SubSystem.StringRangeToIntArray(SubSystem.getStringValue(this.cpuset, "cpuset.cpus"));
    }

    @Override
    public int[] getEffectiveCpuSetCpus() {
        return SubSystem.StringRangeToIntArray(SubSystem.getStringValue(this.cpuset, "cpuset.effective_cpus"));
    }

    @Override
    public int[] getCpuSetMems() {
        return SubSystem.StringRangeToIntArray(SubSystem.getStringValue(this.cpuset, "cpuset.mems"));
    }

    @Override
    public int[] getEffectiveCpuSetMems() {
        return SubSystem.StringRangeToIntArray(SubSystem.getStringValue(this.cpuset, "cpuset.effective_mems"));
    }

    @Override
    public double getCpuSetMemoryPressure() {
        return SubSystem.getDoubleValue(this.cpuset, "cpuset.memory_pressure");
    }

    @Override
    public boolean isCpuSetMemoryPressureEnabled() {
        long val = SubSystem.getLongValue(this.cpuset, "cpuset.memory_pressure_enabled");
        return val == 1L;
    }

    @Override
    public long getMemoryFailCount() {
        return SubSystem.getLongValue(this.memory, "memory.failcnt");
    }

    @Override
    public long getMemoryLimit() {
        long retval = SubSystem.getLongValue(this.memory, "memory.limit_in_bytes");
        return retval > unlimited_minimum ? -1L : retval;
    }

    @Override
    public long getMemoryMaxUsage() {
        return SubSystem.getLongValue(this.memory, "memory.max_usage_in_bytes");
    }

    @Override
    public long getMemoryUsage() {
        return SubSystem.getLongValue(this.memory, "memory.usage_in_bytes");
    }

    @Override
    public long getKernelMemoryFailCount() {
        return SubSystem.getLongValue(this.memory, "memory.kmem.failcnt");
    }

    @Override
    public long getKernelMemoryLimit() {
        long retval = SubSystem.getLongValue(this.memory, "memory.kmem.limit_in_bytes");
        return retval > unlimited_minimum ? -1L : retval;
    }

    @Override
    public long getKernelMemoryMaxUsage() {
        return SubSystem.getLongValue(this.memory, "memory.kmem.max_usage_in_bytes");
    }

    @Override
    public long getKernelMemoryUsage() {
        return SubSystem.getLongValue(this.memory, "memory.kmem.usage_in_bytes");
    }

    @Override
    public long getTcpMemoryFailCount() {
        return SubSystem.getLongValue(this.memory, "memory.kmem.tcp.failcnt");
    }

    @Override
    public long getTcpMemoryLimit() {
        long retval = SubSystem.getLongValue(this.memory, "memory.kmem.tcp.limit_in_bytes");
        return retval > unlimited_minimum ? -1L : retval;
    }

    @Override
    public long getTcpMemoryMaxUsage() {
        return SubSystem.getLongValue(this.memory, "memory.kmem.tcp.max_usage_in_bytes");
    }

    @Override
    public long getTcpMemoryUsage() {
        return SubSystem.getLongValue(this.memory, "memory.kmem.tcp.usage_in_bytes");
    }

    @Override
    public long getMemoryAndSwapFailCount() {
        return SubSystem.getLongValue(this.memory, "memory.memsw.failcnt");
    }

    @Override
    public long getMemoryAndSwapLimit() {
        long retval = SubSystem.getLongValue(this.memory, "memory.memsw.limit_in_bytes");
        return retval > unlimited_minimum ? -1L : retval;
    }

    @Override
    public long getMemoryAndSwapMaxUsage() {
        return SubSystem.getLongValue(this.memory, "memory.memsw.max_usage_in_bytes");
    }

    @Override
    public long getMemoryAndSwapUsage() {
        return SubSystem.getLongValue(this.memory, "memory.memsw.usage_in_bytes");
    }

    @Override
    public boolean isMemoryOOMKillEnabled() {
        long val = SubSystem.getLongEntry(this.memory, "memory.oom_control", "oom_kill_disable");
        return val == 0L;
    }

    @Override
    public long getMemorySoftLimit() {
        long retval = SubSystem.getLongValue(this.memory, "memory.soft_limit_in_bytes");
        return retval > unlimited_minimum ? -1L : retval;
    }

    @Override
    public long getBlkIOServiceCount() {
        return SubSystem.getLongEntry(this.blkio, "blkio.throttle.io_service_bytes", "Total");
    }

    @Override
    public long getBlkIOServiced() {
        return SubSystem.getLongEntry(this.blkio, "blkio.throttle.io_serviced", "Total");
    }

    private static native boolean isUseContainerSupport();
}

