/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.platform;

import java.lang.reflect.Method;

public interface Metrics {
    public static Metrics systemMetrics() {
        try {
            Class<?> c = Class.forName("jdk.internal.platform.cgroupv1.Metrics");
            Method m = c.getMethod("getInstance", new Class[0]);
            return (Metrics)m.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (ReflectiveOperationException e) {
            throw new InternalError(e);
        }
    }

    public String getProvider();

    public long getCpuUsage();

    public long[] getPerCpuUsage();

    public long getCpuUserUsage();

    public long getCpuSystemUsage();

    public long getCpuPeriod();

    public long getCpuQuota();

    public long getCpuShares();

    public long getCpuNumPeriods();

    public long getCpuNumThrottled();

    public long getCpuThrottledTime();

    public long getEffectiveCpuCount();

    public int[] getCpuSetCpus();

    public int[] getEffectiveCpuSetCpus();

    public int[] getCpuSetMems();

    public int[] getEffectiveCpuSetMems();

    public double getCpuSetMemoryPressure();

    public boolean isCpuSetMemoryPressureEnabled();

    public long getMemoryFailCount();

    public long getMemoryLimit();

    public long getMemoryMaxUsage();

    public long getMemoryUsage();

    public long getKernelMemoryFailCount();

    public long getKernelMemoryLimit();

    public long getKernelMemoryMaxUsage();

    public long getKernelMemoryUsage();

    public long getTcpMemoryFailCount();

    public long getTcpMemoryLimit();

    public long getTcpMemoryMaxUsage();

    public long getTcpMemoryUsage();

    public long getMemoryAndSwapFailCount();

    public long getMemoryAndSwapLimit();

    public long getMemoryAndSwapMaxUsage();

    public long getMemoryAndSwapUsage();

    public boolean isMemoryOOMKillEnabled();

    public long getMemorySoftLimit();

    public long getBlkIOServiceCount();

    public long getBlkIOServiced();
}

