/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.PlainSocketImpl;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketInputStream;
import java.net.SocketTimeoutException;
import java.net.SocksConsts;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import sun.net.SocksProxy;
import sun.net.www.ParseUtil;
import sun.security.action.GetPropertyAction;

class SocksSocketImpl
extends PlainSocketImpl
implements SocksConsts {
    private String server = null;
    private int serverPort = 1080;
    private InetSocketAddress external_address;
    private boolean useV4 = false;
    private Socket cmdsock = null;
    private InputStream cmdIn = null;
    private OutputStream cmdOut = null;
    private boolean applicationSetProxy;

    SocksSocketImpl() {
    }

    SocksSocketImpl(String server, int port) {
        this.server = server;
        this.serverPort = port == -1 ? 1080 : port;
    }

    SocksSocketImpl(Proxy proxy) {
        SocketAddress a = proxy.address();
        if (a instanceof InetSocketAddress) {
            InetSocketAddress ad = (InetSocketAddress)a;
            this.server = ad.getHostString();
            this.serverPort = ad.getPort();
            this.applicationSetProxy = true;
        }
    }

    void setV4() {
        this.useV4 = true;
    }

    private synchronized void privilegedConnect(final String host, final int port, final int timeout) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    SocksSocketImpl.this.superConnectServer(host, port, timeout);
                    SocksSocketImpl.this.cmdIn = SocksSocketImpl.this.getInputStream();
                    SocksSocketImpl.this.cmdOut = SocksSocketImpl.this.getOutputStream();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getException();
        }
    }

    private void superConnectServer(String host, int port, int timeout) throws IOException {
        super.connect(new InetSocketAddress(host, port), timeout);
    }

    private static int remainingMillis(long deadlineMillis) throws IOException {
        if (deadlineMillis == 0L) {
            return 0;
        }
        long remaining = deadlineMillis - System.currentTimeMillis();
        if (remaining > 0L) {
            return (int)remaining;
        }
        throw new SocketTimeoutException();
    }

    private int readSocksReply(InputStream in, byte[] data) throws IOException {
        return this.readSocksReply(in, data, 0L);
    }

    private int readSocksReply(InputStream in, byte[] data, long deadlineMillis) throws IOException {
        int received;
        int count;
        int len = data.length;
        for (received = 0; received < len; received += count) {
            try {
                count = ((SocketInputStream)in).read(data, received, len - received, SocksSocketImpl.remainingMillis(deadlineMillis));
            }
            catch (SocketTimeoutException e) {
                throw new SocketTimeoutException("Connect timed out");
            }
            if (count >= 0) continue;
            throw new SocketException("Malformed reply from SOCKS server");
        }
        return received;
    }

    private boolean authenticate(byte method, InputStream in, BufferedOutputStream out) throws IOException {
        return this.authenticate(method, in, out, 0L);
    }

    private boolean authenticate(byte method, InputStream in, BufferedOutputStream out, long deadlineMillis) throws IOException {
        if (method == 0) {
            return true;
        }
        if (method == 2) {
            String password;
            block13: {
                String userName;
                password = null;
                final InetAddress addr = InetAddress.getByName(this.server);
                PasswordAuthentication pw = AccessController.doPrivileged(new PrivilegedAction<PasswordAuthentication>(){

                    @Override
                    public PasswordAuthentication run() {
                        return Authenticator.requestPasswordAuthentication(SocksSocketImpl.this.server, addr, SocksSocketImpl.this.serverPort, "SOCKS5", "SOCKS authentication", null);
                    }
                });
                if (pw != null) {
                    userName = pw.getUserName();
                    password = new String(pw.getPassword());
                } else {
                    userName = this.getUserName();
                }
                if (userName == null) {
                    return false;
                }
                out.write(1);
                out.write(userName.length());
                try {
                    out.write(userName.getBytes("ISO-8859-1"));
                }
                catch (UnsupportedEncodingException uee) {
                    if ($assertionsDisabled) break block13;
                    throw new AssertionError();
                }
            }
            if (password != null) {
                out.write(password.length());
                try {
                    out.write(password.getBytes("ISO-8859-1"));
                }
                catch (UnsupportedEncodingException uee) {
                    assert (false);
                }
            } else {
                out.write(0);
            }
            out.flush();
            byte[] data = new byte[2];
            int i = this.readSocksReply(in, data, deadlineMillis);
            if (i != 2 || data[1] != 0) {
                out.close();
                in.close();
                return false;
            }
            return true;
        }
        return false;
    }

    private void connectV4(InputStream in, OutputStream out, InetSocketAddress endpoint, long deadlineMillis) throws IOException {
        block12: {
            if (!(endpoint.getAddress() instanceof Inet4Address)) {
                throw new SocketException("SOCKS V4 requires IPv4 only addresses");
            }
            out.write(4);
            out.write(1);
            out.write(endpoint.getPort() >> 8 & 0xFF);
            out.write(endpoint.getPort() >> 0 & 0xFF);
            out.write(endpoint.getAddress().getAddress());
            String userName = this.getUserName();
            try {
                out.write(userName.getBytes("ISO-8859-1"));
            }
            catch (UnsupportedEncodingException uee) {
                if ($assertionsDisabled) break block12;
                throw new AssertionError();
            }
        }
        out.write(0);
        out.flush();
        byte[] data = new byte[8];
        int n = this.readSocksReply(in, data, deadlineMillis);
        if (n != 8) {
            throw new SocketException("Reply from SOCKS server has bad length: " + n);
        }
        if (data[0] != 0 && data[0] != 4) {
            throw new SocketException("Reply from SOCKS server has bad version");
        }
        SocketException ex = null;
        switch (data[1]) {
            case 90: {
                this.external_address = endpoint;
                break;
            }
            case 91: {
                ex = new SocketException("SOCKS request rejected");
                break;
            }
            case 92: {
                ex = new SocketException("SOCKS server couldn't reach destination");
                break;
            }
            case 93: {
                ex = new SocketException("SOCKS authentication failed");
                break;
            }
            default: {
                ex = new SocketException("Reply from SOCKS server contains bad status");
            }
        }
        if (ex != null) {
            in.close();
            out.close();
            throw ex;
        }
    }

    @Override
    protected void connect(SocketAddress endpoint, int timeout) throws IOException {
        long finish;
        long deadlineMillis = timeout == 0 ? 0L : ((finish = System.currentTimeMillis() + (long)timeout) < 0L ? Long.MAX_VALUE : finish);
        SecurityManager security = System.getSecurityManager();
        if (endpoint == null || !(endpoint instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type");
        }
        InetSocketAddress epoint = (InetSocketAddress)endpoint;
        if (security != null) {
            if (epoint.isUnresolved()) {
                security.checkConnect(epoint.getHostName(), epoint.getPort());
            } else {
                security.checkConnect(epoint.getAddress().getHostAddress(), epoint.getPort());
            }
        }
        if (this.server == null) {
            URI uri;
            ProxySelector sel = AccessController.doPrivileged(new PrivilegedAction<ProxySelector>(){

                @Override
                public ProxySelector run() {
                    return ProxySelector.getDefault();
                }
            });
            if (sel == null) {
                super.connect(epoint, SocksSocketImpl.remainingMillis(deadlineMillis));
                return;
            }
            String host = epoint.getHostString();
            if (epoint.getAddress() instanceof Inet6Address && !host.startsWith("[") && host.indexOf(":") >= 0) {
                host = "[" + host + "]";
            }
            try {
                uri = new URI("socket://" + ParseUtil.encodePath(host) + ":" + epoint.getPort());
            }
            catch (URISyntaxException e) {
                assert (false) : e;
                uri = null;
            }
            Proxy p = null;
            Throwable savedExc = null;
            Iterator<Proxy> iProxy = null;
            iProxy = sel.select(uri).iterator();
            if (iProxy == null || !iProxy.hasNext()) {
                super.connect(epoint, SocksSocketImpl.remainingMillis(deadlineMillis));
                return;
            }
            while (iProxy.hasNext()) {
                p = iProxy.next();
                if (p == null || p.type() != Proxy.Type.SOCKS) {
                    super.connect(epoint, SocksSocketImpl.remainingMillis(deadlineMillis));
                    return;
                }
                if (!(p.address() instanceof InetSocketAddress)) {
                    throw new SocketException("Unknown address type for proxy: " + p);
                }
                this.server = ((InetSocketAddress)p.address()).getHostString();
                this.serverPort = ((InetSocketAddress)p.address()).getPort();
                if (p instanceof SocksProxy && ((SocksProxy)p).protocolVersion() == 4) {
                    this.useV4 = true;
                }
                try {
                    this.privilegedConnect(this.server, this.serverPort, SocksSocketImpl.remainingMillis(deadlineMillis));
                    break;
                }
                catch (IOException e) {
                    sel.connectFailed(uri, p.address(), e);
                    this.server = null;
                    this.serverPort = -1;
                    savedExc = e;
                }
            }
            if (this.server == null) {
                throw new SocketException("Can't connect to SOCKS proxy:" + savedExc.getMessage());
            }
        } else {
            try {
                this.privilegedConnect(this.server, this.serverPort, SocksSocketImpl.remainingMillis(deadlineMillis));
            }
            catch (IOException e) {
                throw new SocketException(e.getMessage());
            }
        }
        BufferedOutputStream out = new BufferedOutputStream(this.cmdOut, 512);
        InputStream in = this.cmdIn;
        if (this.useV4) {
            if (epoint.isUnresolved()) {
                throw new UnknownHostException(epoint.toString());
            }
            this.connectV4(in, out, epoint, deadlineMillis);
            return;
        }
        out.write(5);
        out.write(2);
        out.write(0);
        out.write(2);
        out.flush();
        byte[] data = new byte[2];
        int i = this.readSocksReply(in, data, deadlineMillis);
        if (i != 2 || data[0] != 5) {
            if (epoint.isUnresolved()) {
                throw new UnknownHostException(epoint.toString());
            }
            this.connectV4(in, out, epoint, deadlineMillis);
            return;
        }
        if (data[1] == -1) {
            throw new SocketException("SOCKS : No acceptable methods");
        }
        if (!this.authenticate(data[1], in, out, deadlineMillis)) {
            throw new SocketException("SOCKS : authentication failed");
        }
        out.write(5);
        out.write(1);
        out.write(0);
        if (epoint.isUnresolved()) {
            block55: {
                out.write(3);
                out.write(epoint.getHostName().length());
                try {
                    out.write(epoint.getHostName().getBytes("ISO-8859-1"));
                }
                catch (UnsupportedEncodingException uee) {
                    if ($assertionsDisabled) break block55;
                    throw new AssertionError();
                }
            }
            out.write(epoint.getPort() >> 8 & 0xFF);
            out.write(epoint.getPort() >> 0 & 0xFF);
        } else if (epoint.getAddress() instanceof Inet6Address) {
            out.write(4);
            out.write(epoint.getAddress().getAddress());
            out.write(epoint.getPort() >> 8 & 0xFF);
            out.write(epoint.getPort() >> 0 & 0xFF);
        } else {
            out.write(1);
            out.write(epoint.getAddress().getAddress());
            out.write(epoint.getPort() >> 8 & 0xFF);
            out.write(epoint.getPort() >> 0 & 0xFF);
        }
        out.flush();
        data = new byte[4];
        i = this.readSocksReply(in, data, deadlineMillis);
        if (i != 4) {
            throw new SocketException("Reply from SOCKS server has bad length");
        }
        SocketException ex = null;
        block4 : switch (data[1]) {
            case 0: {
                switch (data[3]) {
                    case 1: {
                        byte[] addr = new byte[4];
                        i = this.readSocksReply(in, addr, deadlineMillis);
                        if (i != 4) {
                            throw new SocketException("Reply from SOCKS server badly formatted");
                        }
                        data = new byte[2];
                        i = this.readSocksReply(in, data, deadlineMillis);
                        if (i == 2) break block4;
                        throw new SocketException("Reply from SOCKS server badly formatted");
                    }
                    case 3: {
                        byte[] lenByte = new byte[1];
                        i = this.readSocksReply(in, lenByte, deadlineMillis);
                        if (i != 1) {
                            throw new SocketException("Reply from SOCKS server badly formatted");
                        }
                        int len = lenByte[0] & 0xFF;
                        byte[] host = new byte[len];
                        i = this.readSocksReply(in, host, deadlineMillis);
                        if (i != len) {
                            throw new SocketException("Reply from SOCKS server badly formatted");
                        }
                        data = new byte[2];
                        i = this.readSocksReply(in, data, deadlineMillis);
                        if (i == 2) break block4;
                        throw new SocketException("Reply from SOCKS server badly formatted");
                    }
                    case 4: {
                        int len = 16;
                        byte[] addr = new byte[len];
                        i = this.readSocksReply(in, addr, deadlineMillis);
                        if (i != len) {
                            throw new SocketException("Reply from SOCKS server badly formatted");
                        }
                        data = new byte[2];
                        i = this.readSocksReply(in, data, deadlineMillis);
                        if (i == 2) break block4;
                        throw new SocketException("Reply from SOCKS server badly formatted");
                    }
                }
                ex = new SocketException("Reply from SOCKS server contains wrong code");
                break;
            }
            case 1: {
                ex = new SocketException("SOCKS server general failure");
                break;
            }
            case 2: {
                ex = new SocketException("SOCKS: Connection not allowed by ruleset");
                break;
            }
            case 3: {
                ex = new SocketException("SOCKS: Network unreachable");
                break;
            }
            case 4: {
                ex = new SocketException("SOCKS: Host unreachable");
                break;
            }
            case 5: {
                ex = new SocketException("SOCKS: Connection refused");
                break;
            }
            case 6: {
                ex = new SocketException("SOCKS: TTL expired");
                break;
            }
            case 7: {
                ex = new SocketException("SOCKS: Command not supported");
                break;
            }
            case 8: {
                ex = new SocketException("SOCKS: address type not supported");
            }
        }
        if (ex != null) {
            in.close();
            out.close();
            throw ex;
        }
        this.external_address = epoint;
    }

    private void bindV4(InputStream in, OutputStream out, InetAddress baddr, int lport) throws IOException {
        block13: {
            if (!(baddr instanceof Inet4Address)) {
                throw new SocketException("SOCKS V4 requires IPv4 only addresses");
            }
            super.bind(baddr, lport);
            byte[] addr1 = baddr.getAddress();
            InetAddress naddr = baddr;
            if (naddr.isAnyLocalAddress()) {
                naddr = AccessController.doPrivileged(new PrivilegedAction<InetAddress>(){

                    @Override
                    public InetAddress run() {
                        return SocksSocketImpl.this.cmdsock.getLocalAddress();
                    }
                });
                addr1 = naddr.getAddress();
            }
            out.write(4);
            out.write(2);
            out.write(super.getLocalPort() >> 8 & 0xFF);
            out.write(super.getLocalPort() >> 0 & 0xFF);
            out.write(addr1);
            String userName = this.getUserName();
            try {
                out.write(userName.getBytes("ISO-8859-1"));
            }
            catch (UnsupportedEncodingException uee) {
                if ($assertionsDisabled) break block13;
                throw new AssertionError();
            }
        }
        out.write(0);
        out.flush();
        byte[] data = new byte[8];
        int n = this.readSocksReply(in, data);
        if (n != 8) {
            throw new SocketException("Reply from SOCKS server has bad length: " + n);
        }
        if (data[0] != 0 && data[0] != 4) {
            throw new SocketException("Reply from SOCKS server has bad version");
        }
        SocketException ex = null;
        switch (data[1]) {
            case 90: {
                this.external_address = new InetSocketAddress(baddr, lport);
                break;
            }
            case 91: {
                ex = new SocketException("SOCKS request rejected");
                break;
            }
            case 92: {
                ex = new SocketException("SOCKS server couldn't reach destination");
                break;
            }
            case 93: {
                ex = new SocketException("SOCKS authentication failed");
                break;
            }
            default: {
                ex = new SocketException("Reply from SOCKS server contains bad status");
            }
        }
        if (ex != null) {
            in.close();
            out.close();
            throw ex;
        }
    }

    protected synchronized void socksBind(InetSocketAddress saddr) throws IOException {
        byte[] addr1;
        if (this.socket != null) {
            return;
        }
        if (this.server == null) {
            URI uri;
            ProxySelector sel = AccessController.doPrivileged(new PrivilegedAction<ProxySelector>(){

                @Override
                public ProxySelector run() {
                    return ProxySelector.getDefault();
                }
            });
            if (sel == null) {
                return;
            }
            String host = saddr.getHostString();
            if (saddr.getAddress() instanceof Inet6Address && !host.startsWith("[") && host.indexOf(":") >= 0) {
                host = "[" + host + "]";
            }
            try {
                uri = new URI("serversocket://" + ParseUtil.encodePath(host) + ":" + saddr.getPort());
            }
            catch (URISyntaxException e) {
                assert (false) : e;
                uri = null;
            }
            Proxy p = null;
            Throwable savedExc = null;
            Iterator<Proxy> iProxy = null;
            iProxy = sel.select(uri).iterator();
            if (iProxy == null || !iProxy.hasNext()) {
                return;
            }
            while (iProxy.hasNext()) {
                p = iProxy.next();
                if (p == null || p.type() != Proxy.Type.SOCKS) {
                    return;
                }
                if (!(p.address() instanceof InetSocketAddress)) {
                    throw new SocketException("Unknown address type for proxy: " + p);
                }
                this.server = ((InetSocketAddress)p.address()).getHostString();
                this.serverPort = ((InetSocketAddress)p.address()).getPort();
                if (p instanceof SocksProxy && ((SocksProxy)p).protocolVersion() == 4) {
                    this.useV4 = true;
                }
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                        @Override
                        public Void run() throws Exception {
                            SocksSocketImpl.this.cmdsock = new Socket(new PlainSocketImpl());
                            SocksSocketImpl.this.cmdsock.connect(new InetSocketAddress(SocksSocketImpl.this.server, SocksSocketImpl.this.serverPort));
                            SocksSocketImpl.this.cmdIn = SocksSocketImpl.this.cmdsock.getInputStream();
                            SocksSocketImpl.this.cmdOut = SocksSocketImpl.this.cmdsock.getOutputStream();
                            return null;
                        }
                    });
                }
                catch (Exception e) {
                    sel.connectFailed(uri, p.address(), new SocketException(e.getMessage()));
                    this.server = null;
                    this.serverPort = -1;
                    this.cmdsock = null;
                    savedExc = e;
                }
            }
            if (this.server == null || this.cmdsock == null) {
                throw new SocketException("Can't connect to SOCKS proxy:" + savedExc.getMessage());
            }
        } else {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        SocksSocketImpl.this.cmdsock = new Socket(new PlainSocketImpl());
                        SocksSocketImpl.this.cmdsock.connect(new InetSocketAddress(SocksSocketImpl.this.server, SocksSocketImpl.this.serverPort));
                        SocksSocketImpl.this.cmdIn = SocksSocketImpl.this.cmdsock.getInputStream();
                        SocksSocketImpl.this.cmdOut = SocksSocketImpl.this.cmdsock.getOutputStream();
                        return null;
                    }
                });
            }
            catch (Exception e) {
                throw new SocketException(e.getMessage());
            }
        }
        BufferedOutputStream out = new BufferedOutputStream(this.cmdOut, 512);
        InputStream in = this.cmdIn;
        if (this.useV4) {
            this.bindV4(in, out, saddr.getAddress(), saddr.getPort());
            return;
        }
        out.write(5);
        out.write(2);
        out.write(0);
        out.write(2);
        out.flush();
        byte[] data = new byte[2];
        int i = this.readSocksReply(in, data);
        if (i != 2 || data[0] != 5) {
            this.bindV4(in, out, saddr.getAddress(), saddr.getPort());
            return;
        }
        if (data[1] == -1) {
            throw new SocketException("SOCKS : No acceptable methods");
        }
        if (!this.authenticate(data[1], in, out)) {
            throw new SocketException("SOCKS : authentication failed");
        }
        out.write(5);
        out.write(2);
        out.write(0);
        int lport = saddr.getPort();
        if (saddr.isUnresolved()) {
            block53: {
                out.write(3);
                out.write(saddr.getHostName().length());
                try {
                    out.write(saddr.getHostName().getBytes("ISO-8859-1"));
                }
                catch (UnsupportedEncodingException uee) {
                    if ($assertionsDisabled) break block53;
                    throw new AssertionError();
                }
            }
            out.write(lport >> 8 & 0xFF);
            out.write(lport >> 0 & 0xFF);
        } else if (saddr.getAddress() instanceof Inet4Address) {
            addr1 = saddr.getAddress().getAddress();
            out.write(1);
            out.write(addr1);
            out.write(lport >> 8 & 0xFF);
            out.write(lport >> 0 & 0xFF);
            out.flush();
        } else if (saddr.getAddress() instanceof Inet6Address) {
            addr1 = saddr.getAddress().getAddress();
            out.write(4);
            out.write(addr1);
            out.write(lport >> 8 & 0xFF);
            out.write(lport >> 0 & 0xFF);
            out.flush();
        } else {
            this.cmdsock.close();
            throw new SocketException("unsupported address type : " + saddr);
        }
        data = new byte[4];
        i = this.readSocksReply(in, data);
        SocketException ex = null;
        switch (data[1]) {
            case 0: {
                switch (data[3]) {
                    case 1: {
                        byte[] addr = new byte[4];
                        i = this.readSocksReply(in, addr);
                        if (i != 4) {
                            throw new SocketException("Reply from SOCKS server badly formatted");
                        }
                        data = new byte[2];
                        i = this.readSocksReply(in, data);
                        if (i != 2) {
                            throw new SocketException("Reply from SOCKS server badly formatted");
                        }
                        int nport = (data[0] & 0xFF) << 8;
                        this.external_address = new InetSocketAddress(new Inet4Address("", addr), nport += data[1] & 0xFF);
                        break;
                    }
                    case 3: {
                        byte len = data[1];
                        byte[] host = new byte[len];
                        i = this.readSocksReply(in, host);
                        if (i != len) {
                            throw new SocketException("Reply from SOCKS server badly formatted");
                        }
                        data = new byte[2];
                        i = this.readSocksReply(in, data);
                        if (i != 2) {
                            throw new SocketException("Reply from SOCKS server badly formatted");
                        }
                        int nport = (data[0] & 0xFF) << 8;
                        this.external_address = new InetSocketAddress(new String(host), nport += data[1] & 0xFF);
                        break;
                    }
                    case 4: {
                        byte len = data[1];
                        byte[] addr = new byte[len];
                        i = this.readSocksReply(in, addr);
                        if (i != len) {
                            throw new SocketException("Reply from SOCKS server badly formatted");
                        }
                        data = new byte[2];
                        i = this.readSocksReply(in, data);
                        if (i != 2) {
                            throw new SocketException("Reply from SOCKS server badly formatted");
                        }
                        int nport = (data[0] & 0xFF) << 8;
                        this.external_address = new InetSocketAddress(new Inet6Address("", addr), nport += data[1] & 0xFF);
                    }
                }
                break;
            }
            case 1: {
                ex = new SocketException("SOCKS server general failure");
                break;
            }
            case 2: {
                ex = new SocketException("SOCKS: Bind not allowed by ruleset");
                break;
            }
            case 3: {
                ex = new SocketException("SOCKS: Network unreachable");
                break;
            }
            case 4: {
                ex = new SocketException("SOCKS: Host unreachable");
                break;
            }
            case 5: {
                ex = new SocketException("SOCKS: Connection refused");
                break;
            }
            case 6: {
                ex = new SocketException("SOCKS: TTL expired");
                break;
            }
            case 7: {
                ex = new SocketException("SOCKS: Command not supported");
                break;
            }
            case 8: {
                ex = new SocketException("SOCKS: address type not supported");
            }
        }
        if (ex != null) {
            in.close();
            out.close();
            this.cmdsock.close();
            this.cmdsock = null;
            throw ex;
        }
        this.cmdIn = in;
        this.cmdOut = out;
    }

    protected void acceptFrom(SocketImpl s, InetSocketAddress saddr) throws IOException {
        if (this.cmdsock == null) {
            return;
        }
        InputStream in = this.cmdIn;
        this.socksBind(saddr);
        in.read();
        int i = in.read();
        in.read();
        SocketException ex = null;
        InetSocketAddress real_end = null;
        switch (i) {
            case 0: {
                i = in.read();
                switch (i) {
                    case 1: {
                        byte[] addr = new byte[4];
                        this.readSocksReply(in, addr);
                        int nport = in.read() << 8;
                        real_end = new InetSocketAddress(new Inet4Address("", addr), nport += in.read());
                        break;
                    }
                    case 3: {
                        int len = in.read();
                        byte[] addr = new byte[len];
                        this.readSocksReply(in, addr);
                        int nport = in.read() << 8;
                        real_end = new InetSocketAddress(new String(addr), nport += in.read());
                        break;
                    }
                    case 4: {
                        byte[] addr = new byte[16];
                        this.readSocksReply(in, addr);
                        int nport = in.read() << 8;
                        real_end = new InetSocketAddress(new Inet6Address("", addr), nport += in.read());
                    }
                }
                break;
            }
            case 1: {
                ex = new SocketException("SOCKS server general failure");
                break;
            }
            case 2: {
                ex = new SocketException("SOCKS: Accept not allowed by ruleset");
                break;
            }
            case 3: {
                ex = new SocketException("SOCKS: Network unreachable");
                break;
            }
            case 4: {
                ex = new SocketException("SOCKS: Host unreachable");
                break;
            }
            case 5: {
                ex = new SocketException("SOCKS: Connection refused");
                break;
            }
            case 6: {
                ex = new SocketException("SOCKS: TTL expired");
                break;
            }
            case 7: {
                ex = new SocketException("SOCKS: Command not supported");
                break;
            }
            case 8: {
                ex = new SocketException("SOCKS: address type not supported");
            }
        }
        if (ex != null) {
            this.cmdIn.close();
            this.cmdOut.close();
            this.cmdsock.close();
            this.cmdsock = null;
            throw ex;
        }
        if (s instanceof SocksSocketImpl) {
            ((SocksSocketImpl)s).external_address = real_end;
        }
        if (s instanceof PlainSocketImpl) {
            PlainSocketImpl psi = (PlainSocketImpl)s;
            psi.setInputStream((SocketInputStream)in);
            psi.setFileDescriptor(this.cmdsock.getImpl().getFileDescriptor());
            psi.setAddress(this.cmdsock.getImpl().getInetAddress());
            psi.setPort(this.cmdsock.getImpl().getPort());
            psi.setLocalPort(this.cmdsock.getImpl().getLocalPort());
        } else {
            s.fd = this.cmdsock.getImpl().fd;
            s.address = this.cmdsock.getImpl().address;
            s.port = this.cmdsock.getImpl().port;
            s.localport = this.cmdsock.getImpl().localport;
        }
        this.cmdsock = null;
    }

    @Override
    protected InetAddress getInetAddress() {
        if (this.external_address != null) {
            return this.external_address.getAddress();
        }
        return super.getInetAddress();
    }

    @Override
    protected int getPort() {
        if (this.external_address != null) {
            return this.external_address.getPort();
        }
        return super.getPort();
    }

    @Override
    protected int getLocalPort() {
        if (this.socket != null) {
            return super.getLocalPort();
        }
        if (this.external_address != null) {
            return this.external_address.getPort();
        }
        return super.getLocalPort();
    }

    @Override
    protected void close() throws IOException {
        if (this.cmdsock != null) {
            this.cmdsock.close();
        }
        this.cmdsock = null;
        super.close();
    }

    private String getUserName() {
        String userName = "";
        if (this.applicationSetProxy) {
            try {
                userName = System.getProperty("user.name");
            }
            catch (SecurityException securityException) {}
        } else {
            userName = AccessController.doPrivileged(new GetPropertyAction("user.name"));
        }
        return userName;
    }
}

