/*
 * Decompiled with CFR 0.152.
 */
package java.lang.ref;

import java.lang.ref.Finalizer;
import java.lang.ref.ReferenceQueue;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;

final class FinalizerHistogram {
    FinalizerHistogram() {
    }

    static Entry[] getFinalizerHistogram() {
        HashMap countMap = new HashMap();
        ReferenceQueue<Object> queue = Finalizer.getQueue();
        queue.forEach(r -> {
            Object referent = r.get();
            if (referent != null) {
                countMap.computeIfAbsent(referent.getClass().getName(), Entry::new).increment();
                referent = null;
            }
        });
        Entry[] fhe = countMap.values().toArray(new Entry[countMap.size()]);
        Arrays.sort(fhe, Comparator.comparingInt(Entry::getInstanceCount).reversed());
        return fhe;
    }

    private static final class Entry {
        private int instanceCount;
        private final String className;

        int getInstanceCount() {
            return this.instanceCount;
        }

        void increment() {
            ++this.instanceCount;
        }

        Entry(String className) {
            this.className = className;
        }
    }
}

