/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.ntlm;

import com.sun.security.ntlm.NTLMException;
import com.sun.security.ntlm.Version;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Locale;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.SecretKeySpec;
import sun.misc.HexDumpEncoder;
import sun.security.provider.MD4;

class NTLM {
    private final SecretKeyFactory fac;
    private final Cipher cipher;
    private final MessageDigest md4;
    private final Mac hmac;
    private final MessageDigest md5;
    private static final boolean DEBUG = System.getProperty("ntlm.debug") != null;
    final Version v;
    final boolean writeLM;
    final boolean writeNTLM;

    protected NTLM(String version) throws NTLMException {
        if (version == null) {
            version = "LMv2/NTLMv2";
        }
        switch (version) {
            case "LM": {
                this.v = Version.NTLM;
                this.writeLM = true;
                this.writeNTLM = false;
                break;
            }
            case "NTLM": {
                this.v = Version.NTLM;
                this.writeLM = false;
                this.writeNTLM = true;
                break;
            }
            case "LM/NTLM": {
                this.v = Version.NTLM;
                this.writeNTLM = true;
                this.writeLM = true;
                break;
            }
            case "NTLM2": {
                this.v = Version.NTLM2;
                this.writeNTLM = true;
                this.writeLM = true;
                break;
            }
            case "LMv2": {
                this.v = Version.NTLMv2;
                this.writeLM = true;
                this.writeNTLM = false;
                break;
            }
            case "NTLMv2": {
                this.v = Version.NTLMv2;
                this.writeLM = false;
                this.writeNTLM = true;
                break;
            }
            case "LMv2/NTLMv2": {
                this.v = Version.NTLMv2;
                this.writeNTLM = true;
                this.writeLM = true;
                break;
            }
            default: {
                throw new NTLMException(5, "Unknown version " + version);
            }
        }
        try {
            this.fac = SecretKeyFactory.getInstance("DES");
            this.cipher = Cipher.getInstance("DES/ECB/NoPadding");
            this.md4 = MD4.getInstance();
            this.hmac = Mac.getInstance("HmacMD5");
            this.md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchPaddingException e) {
            throw new AssertionError();
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError();
        }
    }

    public void debug(String format, Object ... args) {
        if (DEBUG) {
            System.out.printf(format, args);
        }
    }

    public void debug(byte[] bytes) {
        if (DEBUG) {
            try {
                new HexDumpEncoder().encodeBuffer(bytes, (OutputStream)System.out);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    byte[] makeDesKey(byte[] input, int off) {
        int[] in = new int[input.length];
        for (int i = 0; i < in.length; ++i) {
            in[i] = input[i] < 0 ? input[i] + 256 : input[i];
        }
        byte[] out = new byte[]{(byte)in[off + 0], (byte)(in[off + 0] << 7 & 0xFF | in[off + 1] >> 1), (byte)(in[off + 1] << 6 & 0xFF | in[off + 2] >> 2), (byte)(in[off + 2] << 5 & 0xFF | in[off + 3] >> 3), (byte)(in[off + 3] << 4 & 0xFF | in[off + 4] >> 4), (byte)(in[off + 4] << 3 & 0xFF | in[off + 5] >> 5), (byte)(in[off + 5] << 2 & 0xFF | in[off + 6] >> 6), (byte)(in[off + 6] << 1 & 0xFF)};
        return out;
    }

    byte[] calcLMHash(byte[] pwb) {
        block9: {
            byte[] magic = new byte[]{75, 71, 83, 33, 64, 35, 36, 37};
            byte[] pwb1 = new byte[14];
            int len = pwb.length;
            if (len > 14) {
                len = 14;
            }
            System.arraycopy(pwb, 0, pwb1, 0, len);
            try {
                DESKeySpec dks1 = new DESKeySpec(this.makeDesKey(pwb1, 0));
                DESKeySpec dks2 = new DESKeySpec(this.makeDesKey(pwb1, 7));
                SecretKey key1 = this.fac.generateSecret(dks1);
                SecretKey key2 = this.fac.generateSecret(dks2);
                this.cipher.init(1, key1);
                byte[] out1 = this.cipher.doFinal(magic, 0, 8);
                this.cipher.init(1, key2);
                byte[] out2 = this.cipher.doFinal(magic, 0, 8);
                byte[] result = new byte[21];
                System.arraycopy(out1, 0, result, 0, 8);
                System.arraycopy(out2, 0, result, 8, 8);
                return result;
            }
            catch (InvalidKeyException ive) {
                assert (false);
            }
            catch (InvalidKeySpecException ikse) {
                assert (false);
            }
            catch (IllegalBlockSizeException ibse) {
                assert (false);
            }
            catch (BadPaddingException bpe) {
                if ($assertionsDisabled) break block9;
                throw new AssertionError();
            }
        }
        return null;
    }

    byte[] calcNTHash(byte[] pw) {
        byte[] out = this.md4.digest(pw);
        byte[] result = new byte[21];
        System.arraycopy(out, 0, result, 0, 16);
        return result;
    }

    byte[] calcResponse(byte[] key, byte[] text) {
        block9: {
            try {
                assert (key.length == 21);
                DESKeySpec dks1 = new DESKeySpec(this.makeDesKey(key, 0));
                DESKeySpec dks2 = new DESKeySpec(this.makeDesKey(key, 7));
                DESKeySpec dks3 = new DESKeySpec(this.makeDesKey(key, 14));
                SecretKey key1 = this.fac.generateSecret(dks1);
                SecretKey key2 = this.fac.generateSecret(dks2);
                SecretKey key3 = this.fac.generateSecret(dks3);
                this.cipher.init(1, key1);
                byte[] out1 = this.cipher.doFinal(text, 0, 8);
                this.cipher.init(1, key2);
                byte[] out2 = this.cipher.doFinal(text, 0, 8);
                this.cipher.init(1, key3);
                byte[] out3 = this.cipher.doFinal(text, 0, 8);
                byte[] result = new byte[24];
                System.arraycopy(out1, 0, result, 0, 8);
                System.arraycopy(out2, 0, result, 8, 8);
                System.arraycopy(out3, 0, result, 16, 8);
                return result;
            }
            catch (IllegalBlockSizeException ex) {
                assert (false);
            }
            catch (BadPaddingException ex) {
                assert (false);
            }
            catch (InvalidKeySpecException ex) {
                assert (false);
            }
            catch (InvalidKeyException ex) {
                if ($assertionsDisabled) break block9;
                throw new AssertionError();
            }
        }
        return null;
    }

    byte[] hmacMD5(byte[] key, byte[] text) {
        block4: {
            try {
                SecretKeySpec skey = new SecretKeySpec(Arrays.copyOf(key, 16), "HmacMD5");
                this.hmac.init(skey);
                return this.hmac.doFinal(text);
            }
            catch (InvalidKeyException ex) {
                assert (false);
            }
            catch (RuntimeException e) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
        return null;
    }

    byte[] calcV2(byte[] nthash, String text, byte[] blob, byte[] challenge) {
        try {
            byte[] ntlmv2hash = this.hmacMD5(nthash, text.getBytes("UnicodeLittleUnmarked"));
            byte[] cn = new byte[blob.length + 8];
            System.arraycopy(challenge, 0, cn, 0, 8);
            System.arraycopy(blob, 0, cn, 8, blob.length);
            byte[] result = new byte[16 + blob.length];
            System.arraycopy(this.hmacMD5(ntlmv2hash, cn), 0, result, 0, 16);
            System.arraycopy(blob, 0, result, 16, blob.length);
            return result;
        }
        catch (UnsupportedEncodingException ex) {
            assert (false);
            return null;
        }
    }

    static byte[] ntlm2LM(byte[] nonce) {
        return Arrays.copyOf(nonce, 24);
    }

    byte[] ntlm2NTLM(byte[] ntlmHash, byte[] nonce, byte[] challenge) {
        byte[] b = Arrays.copyOf(challenge, 16);
        System.arraycopy(nonce, 0, b, 8, 8);
        byte[] sesshash = Arrays.copyOf(this.md5.digest(b), 8);
        return this.calcResponse(ntlmHash, sesshash);
    }

    static byte[] getP1(char[] password) {
        try {
            return new String(password).toUpperCase(Locale.ENGLISH).getBytes("ISO8859_1");
        }
        catch (UnsupportedEncodingException ex) {
            return null;
        }
    }

    static byte[] getP2(char[] password) {
        try {
            return new String(password).getBytes("UnicodeLittleUnmarked");
        }
        catch (UnsupportedEncodingException ex) {
            return null;
        }
    }

    static class Writer {
        private byte[] internal;
        private int current;

        Writer(int type, int len) {
            assert (len < 256);
            this.internal = new byte[256];
            this.current = len;
            System.arraycopy(new byte[]{78, 84, 76, 77, 83, 83, 80, 0, (byte)type}, 0, this.internal, 0, 9);
        }

        void writeShort(int offset, int number) {
            this.internal[offset] = (byte)number;
            this.internal[offset + 1] = (byte)(number >> 8);
        }

        void writeInt(int offset, int number) {
            this.internal[offset] = (byte)number;
            this.internal[offset + 1] = (byte)(number >> 8);
            this.internal[offset + 2] = (byte)(number >> 16);
            this.internal[offset + 3] = (byte)(number >> 24);
        }

        void writeBytes(int offset, byte[] data) {
            System.arraycopy(data, 0, this.internal, offset, data.length);
        }

        void writeSecurityBuffer(int offset, byte[] data) {
            if (data == null) {
                this.writeShort(offset + 4, this.current);
            } else {
                int len = data.length;
                if (this.current + len > this.internal.length) {
                    this.internal = Arrays.copyOf(this.internal, this.current + len + 256);
                }
                this.writeShort(offset, len);
                this.writeShort(offset + 2, len);
                this.writeShort(offset + 4, this.current);
                System.arraycopy(data, 0, this.internal, this.current, len);
                this.current += len;
            }
        }

        void writeSecurityBuffer(int offset, String str, boolean unicode) {
            block2: {
                try {
                    this.writeSecurityBuffer(offset, str == null ? null : str.getBytes(unicode ? "UnicodeLittleUnmarked" : "ISO8859_1"));
                }
                catch (UnsupportedEncodingException ex) {
                    if ($assertionsDisabled) break block2;
                    throw new AssertionError();
                }
            }
        }

        byte[] getBytes() {
            return Arrays.copyOf(this.internal, this.current);
        }
    }

    static class Reader {
        private final byte[] internal;

        Reader(byte[] data) {
            this.internal = data;
        }

        int readInt(int offset) throws NTLMException {
            try {
                return (this.internal[offset] & 0xFF) + ((this.internal[offset + 1] & 0xFF) << 8) + ((this.internal[offset + 2] & 0xFF) << 16) + ((this.internal[offset + 3] & 0xFF) << 24);
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                throw new NTLMException(1, "Input message incorrect size");
            }
        }

        int readShort(int offset) throws NTLMException {
            try {
                return (this.internal[offset] & 0xFF) + (this.internal[offset + 1] & 0xFF00);
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                throw new NTLMException(1, "Input message incorrect size");
            }
        }

        byte[] readBytes(int offset, int len) throws NTLMException {
            try {
                return Arrays.copyOfRange(this.internal, offset, offset + len);
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                throw new NTLMException(1, "Input message incorrect size");
            }
        }

        byte[] readSecurityBuffer(int offset) throws NTLMException {
            int pos = this.readInt(offset + 4);
            if (pos == 0) {
                return new byte[0];
            }
            try {
                return Arrays.copyOfRange(this.internal, pos, pos + this.readShort(offset));
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                throw new NTLMException(1, "Input message incorrect size");
            }
        }

        String readSecurityBuffer(int offset, boolean unicode) throws NTLMException {
            byte[] raw = this.readSecurityBuffer(offset);
            try {
                return raw == null ? null : new String(raw, unicode ? "UnicodeLittleUnmarked" : "ISO8859_1");
            }
            catch (UnsupportedEncodingException ex) {
                throw new NTLMException(1, "Invalid input encoding");
            }
        }
    }
}

