/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.keyresolver;

import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverException;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolver;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public abstract class KeyResolverSpi {
    protected Map<String, String> properties;
    protected boolean globalResolver = false;
    protected boolean secureValidation;

    public void setSecureValidation(boolean secureValidation) {
        this.secureValidation = secureValidation;
    }

    public boolean engineCanResolve(Element element, String baseURI, StorageResolver storage) {
        throw new UnsupportedOperationException();
    }

    public PublicKey engineResolvePublicKey(Element element, String baseURI, StorageResolver storage) throws KeyResolverException {
        throw new UnsupportedOperationException();
    }

    public PublicKey engineLookupAndResolvePublicKey(Element element, String baseURI, StorageResolver storage) throws KeyResolverException {
        KeyResolverSpi tmp = this.cloneIfNeeded();
        if (!tmp.engineCanResolve(element, baseURI, storage)) {
            return null;
        }
        return tmp.engineResolvePublicKey(element, baseURI, storage);
    }

    private KeyResolverSpi cloneIfNeeded() throws KeyResolverException {
        if (this.globalResolver) {
            try {
                KeyResolverSpi tmp = (KeyResolverSpi)this.getClass().newInstance();
                return tmp;
            }
            catch (InstantiationException e) {
                throw new KeyResolverException(e, "");
            }
            catch (IllegalAccessException e) {
                throw new KeyResolverException(e, "");
            }
        }
        return this;
    }

    public X509Certificate engineResolveX509Certificate(Element element, String baseURI, StorageResolver storage) throws KeyResolverException {
        throw new UnsupportedOperationException();
    }

    public X509Certificate engineLookupResolveX509Certificate(Element element, String baseURI, StorageResolver storage) throws KeyResolverException {
        KeyResolverSpi tmp = this.cloneIfNeeded();
        if (!tmp.engineCanResolve(element, baseURI, storage)) {
            return null;
        }
        return tmp.engineResolveX509Certificate(element, baseURI, storage);
    }

    public SecretKey engineResolveSecretKey(Element element, String baseURI, StorageResolver storage) throws KeyResolverException {
        throw new UnsupportedOperationException();
    }

    public SecretKey engineLookupAndResolveSecretKey(Element element, String baseURI, StorageResolver storage) throws KeyResolverException {
        KeyResolverSpi tmp = this.cloneIfNeeded();
        if (!tmp.engineCanResolve(element, baseURI, storage)) {
            return null;
        }
        return tmp.engineResolveSecretKey(element, baseURI, storage);
    }

    public PrivateKey engineLookupAndResolvePrivateKey(Element element, String baseURI, StorageResolver storage) throws KeyResolverException {
        return null;
    }

    public void engineSetProperty(String key, String value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(key, value);
    }

    public String engineGetProperty(String key) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(key);
    }

    public boolean understandsProperty(String propertyToTest) {
        if (this.properties == null) {
            return false;
        }
        return this.properties.get(propertyToTest) != null;
    }

    public void setGlobalResolver(boolean globalResolver) {
        this.globalResolver = globalResolver;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static Element getDocFromBytes(byte[] bytes, boolean secureValidation) throws KeyResolverException {
        DocumentBuilder db = null;
        try (ByteArrayInputStream is = new ByteArrayInputStream(bytes);){
            db = XMLUtils.createDocumentBuilder(false, secureValidation);
            Document doc = db.parse(is);
            Element element = doc.getDocumentElement();
            return element;
        }
        catch (SAXException ex) {
            throw new KeyResolverException(ex);
        }
        catch (IOException ex) {
            throw new KeyResolverException(ex);
        }
        catch (ParserConfigurationException ex) {
            throw new KeyResolverException(ex);
        }
    }
}

