/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.LdapCtx;
import com.sun.jndi.ldap.LdapSchemaParser;
import com.sun.jndi.toolkit.dir.HierMemDirCtx;
import java.util.Hashtable;
import javax.naming.CompositeName;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SchemaViolationException;

final class LdapSchemaCtx
extends HierMemDirCtx {
    private static final boolean debug = false;
    private static final int LEAF = 0;
    private static final int SCHEMA_ROOT = 1;
    static final int OBJECTCLASS_ROOT = 2;
    static final int ATTRIBUTE_ROOT = 3;
    static final int SYNTAX_ROOT = 4;
    static final int MATCHRULE_ROOT = 5;
    static final int OBJECTCLASS = 6;
    static final int ATTRIBUTE = 7;
    static final int SYNTAX = 8;
    static final int MATCHRULE = 9;
    private SchemaInfo info = null;
    private boolean setupMode = true;
    private int objectType;

    static DirContext createSchemaTree(Hashtable<String, Object> env, String subschemasubentry, LdapCtx schemaEntry, Attributes schemaAttrs, boolean netscapeBug) throws NamingException {
        try {
            LdapSchemaParser parser = new LdapSchemaParser(netscapeBug);
            SchemaInfo allinfo = new SchemaInfo(subschemasubentry, schemaEntry, parser);
            LdapSchemaCtx root = new LdapSchemaCtx(1, env, allinfo);
            LdapSchemaParser.LDAP2JNDISchema(schemaAttrs, root);
            return root;
        }
        catch (NamingException e) {
            schemaEntry.close();
            throw e;
        }
    }

    private LdapSchemaCtx(int objectType, Hashtable<String, Object> environment, SchemaInfo info) {
        super(environment, true);
        this.objectType = objectType;
        this.info = info;
    }

    @Override
    public void close() throws NamingException {
        this.info.close();
    }

    @Override
    public final void bind(Name name, Object obj, Attributes attrs) throws NamingException {
        if (!this.setupMode) {
            if (obj != null) {
                throw new IllegalArgumentException("obj must be null");
            }
            this.addServerSchema(attrs);
        }
        LdapSchemaCtx newEntry = (LdapSchemaCtx)super.doCreateSubcontext(name, attrs);
    }

    @Override
    protected final void doBind(Name name, Object obj, Attributes attrs, boolean useFactory) throws NamingException {
        if (!this.setupMode) {
            throw new SchemaViolationException("Cannot bind arbitrary object; use createSubcontext()");
        }
        super.doBind(name, obj, attrs, false);
    }

    @Override
    public final void rebind(Name name, Object obj, Attributes attrs) throws NamingException {
        try {
            this.doLookup(name, false);
            throw new SchemaViolationException("Cannot replace existing schema object");
        }
        catch (NameNotFoundException e) {
            this.bind(name, obj, attrs);
            return;
        }
    }

    @Override
    protected final void doRebind(Name name, Object obj, Attributes attrs, boolean useFactory) throws NamingException {
        if (!this.setupMode) {
            throw new SchemaViolationException("Cannot bind arbitrary object; use createSubcontext()");
        }
        super.doRebind(name, obj, attrs, false);
    }

    @Override
    protected final void doUnbind(Name name) throws NamingException {
        if (!this.setupMode) {
            try {
                LdapSchemaCtx target = (LdapSchemaCtx)this.doLookup(name, false);
                this.deleteServerSchema(target.attrs);
            }
            catch (NameNotFoundException e) {
                return;
            }
        }
        super.doUnbind(name);
    }

    @Override
    protected final void doRename(Name oldname, Name newname) throws NamingException {
        if (!this.setupMode) {
            throw new SchemaViolationException("Cannot rename a schema object");
        }
        super.doRename(oldname, newname);
    }

    @Override
    protected final void doDestroySubcontext(Name name) throws NamingException {
        if (!this.setupMode) {
            try {
                LdapSchemaCtx target = (LdapSchemaCtx)this.doLookup(name, false);
                this.deleteServerSchema(target.attrs);
            }
            catch (NameNotFoundException e) {
                return;
            }
        }
        super.doDestroySubcontext(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final LdapSchemaCtx setup(int objectType, String name, Attributes attrs) throws NamingException {
        try {
            this.setupMode = true;
            LdapSchemaCtx answer = (LdapSchemaCtx)super.doCreateSubcontext(new CompositeName(name), attrs);
            answer.objectType = objectType;
            answer.setupMode = false;
            LdapSchemaCtx ldapSchemaCtx = answer;
            return ldapSchemaCtx;
        }
        finally {
            this.setupMode = false;
        }
    }

    @Override
    protected final DirContext doCreateSubcontext(Name name, Attributes attrs) throws NamingException {
        if (attrs == null || attrs.size() == 0) {
            throw new SchemaViolationException("Must supply attributes describing schema");
        }
        if (!this.setupMode) {
            this.addServerSchema(attrs);
        }
        LdapSchemaCtx newEntry = (LdapSchemaCtx)super.doCreateSubcontext(name, attrs);
        return newEntry;
    }

    private static final Attributes deepClone(Attributes orig) throws NamingException {
        BasicAttributes copy = new BasicAttributes(true);
        NamingEnumeration<? extends Attribute> attrs = orig.getAll();
        while (attrs.hasMore()) {
            copy.put((Attribute)attrs.next().clone());
        }
        return copy;
    }

    @Override
    protected final void doModifyAttributes(ModificationItem[] mods) throws NamingException {
        if (this.setupMode) {
            super.doModifyAttributes(mods);
        } else {
            Attributes copy = LdapSchemaCtx.deepClone(this.attrs);
            LdapSchemaCtx.applyMods(mods, copy);
            this.modifyServerSchema(this.attrs, copy);
            this.attrs = copy;
        }
    }

    @Override
    protected final HierMemDirCtx createNewCtx() {
        LdapSchemaCtx ctx = new LdapSchemaCtx(0, this.myEnv, this.info);
        return ctx;
    }

    private final void addServerSchema(Attributes attrs) throws NamingException {
        Attribute schemaAttr;
        switch (this.objectType) {
            case 2: {
                schemaAttr = this.info.parser.stringifyObjDesc(attrs);
                break;
            }
            case 3: {
                schemaAttr = this.info.parser.stringifyAttrDesc(attrs);
                break;
            }
            case 4: {
                schemaAttr = this.info.parser.stringifySyntaxDesc(attrs);
                break;
            }
            case 5: {
                schemaAttr = this.info.parser.stringifyMatchRuleDesc(attrs);
                break;
            }
            case 1: {
                throw new SchemaViolationException("Cannot create new entry under schema root");
            }
            default: {
                throw new SchemaViolationException("Cannot create child of schema object");
            }
        }
        BasicAttributes holder = new BasicAttributes(true);
        holder.put(schemaAttr);
        this.info.modifyAttributes(this.myEnv, 1, holder);
    }

    private final void deleteServerSchema(Attributes origAttrs) throws NamingException {
        Attribute origAttrVal;
        switch (this.objectType) {
            case 2: {
                origAttrVal = this.info.parser.stringifyObjDesc(origAttrs);
                break;
            }
            case 3: {
                origAttrVal = this.info.parser.stringifyAttrDesc(origAttrs);
                break;
            }
            case 4: {
                origAttrVal = this.info.parser.stringifySyntaxDesc(origAttrs);
                break;
            }
            case 5: {
                origAttrVal = this.info.parser.stringifyMatchRuleDesc(origAttrs);
                break;
            }
            case 1: {
                throw new SchemaViolationException("Cannot delete schema root");
            }
            default: {
                throw new SchemaViolationException("Cannot delete child of schema object");
            }
        }
        ModificationItem[] mods = new ModificationItem[]{new ModificationItem(3, origAttrVal)};
        this.info.modifyAttributes(this.myEnv, mods);
    }

    private final void modifyServerSchema(Attributes origAttrs, Attributes newAttrs) throws NamingException {
        Attribute newAttrVal;
        Attribute origAttrVal;
        switch (this.objectType) {
            case 6: {
                origAttrVal = this.info.parser.stringifyObjDesc(origAttrs);
                newAttrVal = this.info.parser.stringifyObjDesc(newAttrs);
                break;
            }
            case 7: {
                origAttrVal = this.info.parser.stringifyAttrDesc(origAttrs);
                newAttrVal = this.info.parser.stringifyAttrDesc(newAttrs);
                break;
            }
            case 8: {
                origAttrVal = this.info.parser.stringifySyntaxDesc(origAttrs);
                newAttrVal = this.info.parser.stringifySyntaxDesc(newAttrs);
                break;
            }
            case 9: {
                origAttrVal = this.info.parser.stringifyMatchRuleDesc(origAttrs);
                newAttrVal = this.info.parser.stringifyMatchRuleDesc(newAttrs);
                break;
            }
            default: {
                throw new SchemaViolationException("Cannot modify schema root");
            }
        }
        ModificationItem[] mods = new ModificationItem[]{new ModificationItem(3, origAttrVal), new ModificationItem(1, newAttrVal)};
        this.info.modifyAttributes(this.myEnv, mods);
    }

    private static final class SchemaInfo {
        private LdapCtx schemaEntry;
        private String schemaEntryName;
        LdapSchemaParser parser;
        private String host;
        private int port;
        private boolean hasLdapsScheme;

        SchemaInfo(String schemaEntryName, LdapCtx schemaEntry, LdapSchemaParser parser) {
            this.schemaEntryName = schemaEntryName;
            this.schemaEntry = schemaEntry;
            this.parser = parser;
            this.port = schemaEntry.port_number;
            this.host = schemaEntry.hostname;
            this.hasLdapsScheme = schemaEntry.hasLdapsScheme;
        }

        synchronized void close() throws NamingException {
            if (this.schemaEntry != null) {
                this.schemaEntry.close();
                this.schemaEntry = null;
            }
        }

        private LdapCtx reopenEntry(Hashtable<?, ?> env) throws NamingException {
            return new LdapCtx(this.schemaEntryName, this.host, this.port, env, this.hasLdapsScheme);
        }

        synchronized void modifyAttributes(Hashtable<?, ?> env, ModificationItem[] mods) throws NamingException {
            if (this.schemaEntry == null) {
                this.schemaEntry = this.reopenEntry(env);
            }
            this.schemaEntry.modifyAttributes("", mods);
        }

        synchronized void modifyAttributes(Hashtable<?, ?> env, int mod, Attributes attrs) throws NamingException {
            if (this.schemaEntry == null) {
                this.schemaEntry = this.reopenEntry(env);
            }
            this.schemaEntry.modifyAttributes("", mod, attrs);
        }
    }
}

