/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.GTKColorType;
import com.sun.java.swing.plaf.gtk.GTKConstants;
import com.sun.java.swing.plaf.gtk.GTKEngine;
import com.sun.java.swing.plaf.gtk.GTKGraphicsUtils;
import com.sun.java.swing.plaf.gtk.GTKLookAndFeel;
import com.sun.java.swing.plaf.gtk.GTKPainter;
import com.sun.java.swing.plaf.gtk.Metacity;
import com.sun.java.swing.plaf.gtk.PangoFonts;
import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthGraphicsUtils;
import javax.swing.plaf.synth.SynthPainter;
import javax.swing.plaf.synth.SynthStyle;
import sun.awt.AppContext;
import sun.awt.UNIXToolkit;
import sun.swing.SwingUtilities2;
import sun.swing.plaf.synth.SynthIcon;

class GTKStyle
extends SynthStyle
implements GTKConstants {
    private static final String ICON_PROPERTY_PREFIX = "gtk.icon.";
    static final Color BLACK_COLOR = new ColorUIResource(Color.BLACK);
    static final Color WHITE_COLOR = new ColorUIResource(Color.WHITE);
    static final Font DEFAULT_FONT = new FontUIResource("sansserif", 0, 10);
    static final Insets BUTTON_DEFAULT_BORDER_INSETS = new Insets(1, 1, 1, 1);
    private static final GTKGraphicsUtils GTK_GRAPHICS = new GTKGraphicsUtils();
    private static final Map<String, String> CLASS_SPECIFIC_MAP = new HashMap<String, String>();
    private static final Map<String, GTKStockIcon> ICONS_MAP;
    private final Font font;
    private final int widgetType;
    private final int xThickness;
    private final int yThickness;

    private static native int nativeGetXThickness(int var0);

    private static native int nativeGetYThickness(int var0);

    private static native int nativeGetColorForState(int var0, int var1, int var2);

    private static native Object nativeGetClassValue(int var0, String var1);

    private static native String nativeGetPangoFontName(int var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GTKStyle(Font userFont, GTKEngine.WidgetType widgetType) {
        String pangoFontName;
        this.widgetType = widgetType.ordinal();
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            this.xThickness = GTKStyle.nativeGetXThickness(this.widgetType);
            this.yThickness = GTKStyle.nativeGetYThickness(this.widgetType);
            pangoFontName = GTKStyle.nativeGetPangoFontName(this.widgetType);
        }
        Font pangoFont = null;
        if (pangoFontName != null) {
            pangoFont = PangoFonts.lookupFont(pangoFontName);
        }
        this.font = pangoFont != null ? pangoFont : (userFont != null ? userFont : DEFAULT_FONT);
    }

    @Override
    public void installDefaults(SynthContext context) {
        super.installDefaults(context);
        if (!context.getRegion().isSubregion()) {
            context.getComponent().putClientProperty(SwingUtilities2.AA_TEXT_PROPERTY_KEY, GTKLookAndFeel.aaTextInfo);
        }
    }

    @Override
    public SynthGraphicsUtils getGraphicsUtils(SynthContext context) {
        return GTK_GRAPHICS;
    }

    @Override
    public SynthPainter getPainter(SynthContext state) {
        return GTKPainter.INSTANCE;
    }

    @Override
    protected Color getColorForState(SynthContext context, ColorType type) {
        if (type == ColorType.FOCUS || type == GTKColorType.BLACK) {
            return BLACK_COLOR;
        }
        if (type == GTKColorType.WHITE) {
            return WHITE_COLOR;
        }
        Region id = context.getRegion();
        int state = context.getComponentState();
        state = GTKLookAndFeel.synthStateToGTKState(id, state);
        if (type == ColorType.TEXT_FOREGROUND && (id == Region.BUTTON || id == Region.CHECK_BOX || id == Region.CHECK_BOX_MENU_ITEM || id == Region.MENU || id == Region.MENU_ITEM || id == Region.RADIO_BUTTON || id == Region.RADIO_BUTTON_MENU_ITEM || id == Region.TABBED_PANE_TAB || id == Region.TOGGLE_BUTTON || id == Region.TOOL_TIP || id == Region.MENU_ITEM_ACCELERATOR || id == Region.TABBED_PANE_TAB)) {
            type = ColorType.FOREGROUND;
        } else if (id == Region.TABLE || id == Region.LIST || id == Region.TREE || id == Region.TREE_CELL) {
            if (type == ColorType.FOREGROUND) {
                type = ColorType.TEXT_FOREGROUND;
                if (state == 4) {
                    state = 512;
                }
            } else if (type == ColorType.BACKGROUND) {
                type = ColorType.TEXT_BACKGROUND;
            }
        }
        return this.getStyleSpecificColor(context, state, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Color getStyleSpecificColor(SynthContext context, int state, ColorType type) {
        state = GTKLookAndFeel.synthStateToGTKStateType(state).ordinal();
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            int rgb = GTKStyle.nativeGetColorForState(this.widgetType, state, type.getID());
            return new ColorUIResource(rgb);
        }
    }

    Color getGTKColor(int state, ColorType type) {
        return this.getGTKColor(null, state, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Color getGTKColor(int widgetType, int state, int colorType) {
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            int rgb = GTKStyle.nativeGetColorForState(widgetType, state, colorType);
            return new ColorUIResource(rgb);
        }
    }

    Color getGTKColor(SynthContext context, int state, ColorType type) {
        if (context != null) {
            JComponent c = context.getComponent();
            Region id = context.getRegion();
            state = GTKLookAndFeel.synthStateToGTKState(id, state);
            if (!id.isSubregion() && (state & 1) != 0) {
                Color fg;
                if (type == ColorType.BACKGROUND || type == ColorType.TEXT_BACKGROUND) {
                    Color bg = c.getBackground();
                    if (!(bg instanceof UIResource)) {
                        return bg;
                    }
                } else if (!(type != ColorType.FOREGROUND && type != ColorType.TEXT_FOREGROUND || (fg = c.getForeground()) instanceof UIResource)) {
                    return fg;
                }
            }
        }
        return this.getStyleSpecificColor(context, state, type);
    }

    @Override
    public Color getColor(SynthContext context, ColorType type) {
        JComponent c = context.getComponent();
        Region id = context.getRegion();
        int state = context.getComponentState();
        if (c.getName() == "Table.cellRenderer") {
            if (type == ColorType.BACKGROUND) {
                return c.getBackground();
            }
            if (type == ColorType.FOREGROUND) {
                return c.getForeground();
            }
        }
        if (id == Region.LABEL && type == ColorType.TEXT_FOREGROUND) {
            type = ColorType.FOREGROUND;
        }
        if (!id.isSubregion() && (state & 1) != 0) {
            Color color;
            if (type == ColorType.BACKGROUND) {
                return c.getBackground();
            }
            if (type == ColorType.FOREGROUND) {
                return c.getForeground();
            }
            if (type == ColorType.TEXT_FOREGROUND && (color = c.getForeground()) != null && !(color instanceof UIResource)) {
                return color;
            }
        }
        return this.getColorForState(context, type);
    }

    Font getDefaultFont() {
        return this.font;
    }

    @Override
    protected Font getFontForState(SynthContext context) {
        Font propFont = UIManager.getFont(context.getRegion().getName() + ".font");
        if (propFont != null) {
            return propFont;
        }
        return this.font;
    }

    int getXThickness() {
        return this.xThickness;
    }

    int getYThickness() {
        return this.yThickness;
    }

    @Override
    public Insets getInsets(SynthContext state, Insets insets) {
        String name;
        Region id = state.getRegion();
        JComponent component = state.getComponent();
        String string = name = id.isSubregion() ? null : component.getName();
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        } else {
            insets.right = 0;
            insets.left = 0;
            insets.bottom = 0;
            insets.top = 0;
        }
        if (id == Region.ARROW_BUTTON || id == Region.BUTTON || id == Region.TOGGLE_BUTTON) {
            if ("Spinner.previousButton" == name || "Spinner.nextButton" == name) {
                return this.getSimpleInsets(state, insets, 1);
            }
            return this.getButtonInsets(state, insets);
        }
        if (id == Region.CHECK_BOX || id == Region.RADIO_BUTTON) {
            return this.getRadioInsets(state, insets);
        }
        if (id == Region.MENU_BAR) {
            return this.getMenuBarInsets(state, insets);
        }
        if (id == Region.MENU || id == Region.MENU_ITEM || id == Region.CHECK_BOX_MENU_ITEM || id == Region.RADIO_BUTTON_MENU_ITEM) {
            return this.getMenuItemInsets(state, insets);
        }
        if (id == Region.FORMATTED_TEXT_FIELD) {
            return this.getTextFieldInsets(state, insets);
        }
        if (id == Region.INTERNAL_FRAME) {
            insets = Metacity.INSTANCE.getBorderInsets(state, insets);
        } else if (id == Region.LABEL) {
            if ("TableHeader.renderer" == name) {
                return this.getButtonInsets(state, insets);
            }
            if (component instanceof ListCellRenderer) {
                return this.getTextFieldInsets(state, insets);
            }
            if ("Tree.cellRenderer" == name) {
                return this.getSimpleInsets(state, insets, 1);
            }
        } else {
            if (id == Region.OPTION_PANE) {
                return this.getSimpleInsets(state, insets, 6);
            }
            if (id == Region.POPUP_MENU) {
                return this.getSimpleInsets(state, insets, 2);
            }
            if (id == Region.PROGRESS_BAR || id == Region.SLIDER || id == Region.TABBED_PANE || id == Region.TABBED_PANE_CONTENT || id == Region.TOOL_BAR || id == Region.TOOL_BAR_DRAG_WINDOW || id == Region.TOOL_TIP) {
                return this.getThicknessInsets(state, insets);
            }
            if (id == Region.SCROLL_BAR) {
                return this.getScrollBarInsets(state, insets);
            }
            if (id == Region.SLIDER_TRACK) {
                return this.getSliderTrackInsets(state, insets);
            }
            if (id == Region.TABBED_PANE_TAB) {
                return this.getTabbedPaneTabInsets(state, insets);
            }
            if (id == Region.TEXT_FIELD || id == Region.PASSWORD_FIELD) {
                if (name == "Tree.cellEditor") {
                    return this.getSimpleInsets(state, insets, 1);
                }
                return this.getTextFieldInsets(state, insets);
            }
            if (id == Region.SEPARATOR || id == Region.POPUP_MENU_SEPARATOR || id == Region.TOOL_BAR_SEPARATOR) {
                return this.getSeparatorInsets(state, insets);
            }
            if (id == GTKEngine.CustomRegion.TITLED_BORDER) {
                return this.getThicknessInsets(state, insets);
            }
        }
        return insets;
    }

    private Insets getButtonInsets(SynthContext context, Insets insets) {
        int CHILD_SPACING = 1;
        int focusSize = this.getClassSpecificIntValue(context, "focus-line-width", 1);
        int focusPad = this.getClassSpecificIntValue(context, "focus-padding", 1);
        int xThickness = this.getXThickness();
        int yThickness = this.getYThickness();
        int w = focusSize + focusPad + xThickness + CHILD_SPACING;
        int h = focusSize + focusPad + yThickness + CHILD_SPACING;
        insets.left = insets.right = w;
        insets.top = insets.bottom = h;
        JComponent component = context.getComponent();
        if (component instanceof JButton && !(component.getParent() instanceof JToolBar) && ((JButton)component).isDefaultCapable()) {
            Insets defaultInsets = this.getClassSpecificInsetsValue(context, "default-border", BUTTON_DEFAULT_BORDER_INSETS);
            insets.left += defaultInsets.left;
            insets.right += defaultInsets.right;
            insets.top += defaultInsets.top;
            insets.bottom += defaultInsets.bottom;
        }
        return insets;
    }

    private Insets getRadioInsets(SynthContext context, Insets insets) {
        int totalFocus;
        int focusSize = this.getClassSpecificIntValue(context, "focus-line-width", 1);
        int focusPad = this.getClassSpecificIntValue(context, "focus-padding", 1);
        insets.top = totalFocus = focusSize + focusPad;
        insets.bottom = totalFocus;
        if (context.getComponent().getComponentOrientation().isLeftToRight()) {
            insets.left = 0;
            insets.right = totalFocus;
        } else {
            insets.left = totalFocus;
            insets.right = 0;
        }
        return insets;
    }

    private Insets getMenuBarInsets(SynthContext context, Insets insets) {
        int internalPadding = this.getClassSpecificIntValue(context, "internal-padding", 1);
        int xThickness = this.getXThickness();
        int yThickness = this.getYThickness();
        insets.left = insets.right = xThickness + internalPadding;
        insets.top = insets.bottom = yThickness + internalPadding;
        return insets;
    }

    private Insets getMenuItemInsets(SynthContext context, Insets insets) {
        int horizPadding = this.getClassSpecificIntValue(context, "horizontal-padding", 3);
        int xThickness = this.getXThickness();
        int yThickness = this.getYThickness();
        insets.left = insets.right = xThickness + horizPadding;
        insets.top = insets.bottom = yThickness;
        return insets;
    }

    private Insets getThicknessInsets(SynthContext context, Insets insets) {
        insets.left = insets.right = this.getXThickness();
        insets.top = insets.bottom = this.getYThickness();
        return insets;
    }

    private Insets getSeparatorInsets(SynthContext context, Insets insets) {
        int horizPadding = 0;
        if (context.getRegion() == Region.POPUP_MENU_SEPARATOR) {
            horizPadding = this.getClassSpecificIntValue(context, "horizontal-padding", 3);
        }
        insets.right = insets.left = this.getXThickness() + horizPadding;
        insets.top = insets.bottom = this.getYThickness();
        return insets;
    }

    private Insets getSliderTrackInsets(SynthContext context, Insets insets) {
        int focusSize = this.getClassSpecificIntValue(context, "focus-line-width", 1);
        int focusPad = this.getClassSpecificIntValue(context, "focus-padding", 1);
        insets.left = insets.right = focusSize + focusPad;
        insets.bottom = insets.right;
        insets.top = insets.right;
        return insets;
    }

    private Insets getSimpleInsets(SynthContext context, Insets insets, int n) {
        insets.right = insets.left = n;
        insets.bottom = insets.left;
        insets.top = insets.left;
        return insets;
    }

    private Insets getTabbedPaneTabInsets(SynthContext context, Insets insets) {
        int xThickness = this.getXThickness();
        int yThickness = this.getYThickness();
        int focusSize = this.getClassSpecificIntValue(context, "focus-line-width", 1);
        int pad = 2;
        insets.left = insets.right = focusSize + pad + xThickness;
        insets.top = insets.bottom = focusSize + pad + yThickness;
        return insets;
    }

    private Insets getTextFieldInsets(SynthContext context, Insets insets) {
        insets = this.getClassSpecificInsetsValue(context, "inner-border", this.getSimpleInsets(context, insets, 2));
        int xThickness = this.getXThickness();
        int yThickness = this.getYThickness();
        boolean interiorFocus = this.getClassSpecificBoolValue(context, "interior-focus", true);
        int focusSize = 0;
        if (!interiorFocus) {
            focusSize = this.getClassSpecificIntValue(context, "focus-line-width", 1);
        }
        insets.left += focusSize + xThickness;
        insets.right += focusSize + xThickness;
        insets.top += focusSize + yThickness;
        insets.bottom += focusSize + yThickness;
        return insets;
    }

    private Insets getScrollBarInsets(SynthContext context, Insets insets) {
        int troughBorder;
        insets.top = insets.bottom = (troughBorder = this.getClassSpecificIntValue(context, "trough-border", 1));
        insets.right = insets.bottom;
        insets.left = insets.bottom;
        JComponent c = context.getComponent();
        if (c.getParent() instanceof JScrollPane) {
            int spacing = GTKStyle.getClassSpecificIntValue(GTKEngine.WidgetType.SCROLL_PANE, "scrollbar-spacing", 3);
            if (((JScrollBar)c).getOrientation() == 0) {
                insets.top += spacing;
            } else if (c.getComponentOrientation().isLeftToRight()) {
                insets.left += spacing;
            } else {
                insets.right += spacing;
            }
        } else if (c.isFocusable()) {
            int focusSize = this.getClassSpecificIntValue(context, "focus-line-width", 1);
            int focusPad = this.getClassSpecificIntValue(context, "focus-padding", 1);
            int totalFocus = focusSize + focusPad;
            insets.left += totalFocus;
            insets.right += totalFocus;
            insets.top += totalFocus;
            insets.bottom += totalFocus;
        }
        return insets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getClassSpecificValue(GTKEngine.WidgetType wt, String key) {
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            return GTKStyle.nativeGetClassValue(wt.ordinal(), key);
        }
    }

    private static int getClassSpecificIntValue(GTKEngine.WidgetType wt, String key, int defaultValue) {
        Object value = GTKStyle.getClassSpecificValue(wt, key);
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getClassSpecificValue(String key) {
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            return GTKStyle.nativeGetClassValue(this.widgetType, key);
        }
    }

    int getClassSpecificIntValue(SynthContext context, String key, int defaultValue) {
        Object value = this.getClassSpecificValue(key);
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return defaultValue;
    }

    Insets getClassSpecificInsetsValue(SynthContext context, String key, Insets defaultValue) {
        Object value = this.getClassSpecificValue(key);
        if (value instanceof Insets) {
            return (Insets)value;
        }
        return defaultValue;
    }

    boolean getClassSpecificBoolValue(SynthContext context, String key, boolean defaultValue) {
        Object value = this.getClassSpecificValue(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return defaultValue;
    }

    @Override
    public boolean isOpaque(SynthContext context) {
        Region region = context.getRegion();
        if (region == Region.COMBO_BOX || region == Region.DESKTOP_PANE || region == Region.DESKTOP_ICON || region == Region.INTERNAL_FRAME || region == Region.LIST || region == Region.MENU_BAR || region == Region.PANEL || region == Region.POPUP_MENU || region == Region.PROGRESS_BAR || region == Region.ROOT_PANE || region == Region.SCROLL_PANE || region == Region.SPLIT_PANE_DIVIDER || region == Region.TABLE || region == Region.TEXT_AREA || region == Region.TOOL_BAR_DRAG_WINDOW || region == Region.TOOL_TIP || region == Region.TREE || region == Region.VIEWPORT || region == Region.TEXT_PANE) {
            return true;
        }
        if (!(GTKLookAndFeel.is3() || region != Region.EDITOR_PANE && region != Region.FORMATTED_TEXT_FIELD && region != Region.PASSWORD_FIELD && region != Region.SPINNER && region != Region.TEXT_FIELD)) {
            return true;
        }
        JComponent c = context.getComponent();
        String name = c.getName();
        return name == "ComboBox.renderer" || name == "ComboBox.listRenderer";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(SynthContext context, Object key) {
        Object value;
        String classKey = CLASS_SPECIFIC_MAP.get(key);
        if (classKey != null && (value = this.getClassSpecificValue(classKey)) != null) {
            if ("Slider.thumbWidth".equals(key) && value.equals(31)) {
                return 14;
            }
            return value;
        }
        if (key == "ScrollPane.viewportBorderInsets") {
            return this.getThicknessInsets(context, new Insets(0, 0, 0, 0));
        }
        if (key == "Slider.tickColor") {
            return this.getColorForState(context, ColorType.FOREGROUND);
        }
        if (key == "ScrollBar.minimumThumbSize") {
            JScrollBar sb;
            int len = this.getClassSpecificIntValue(context, "min-slider-length", 21);
            if (len == 21) {
                len = 40;
            }
            if ((sb = (JScrollBar)context.getComponent()).getOrientation() == 0) {
                return new DimensionUIResource(len, 0);
            }
            return new DimensionUIResource(0, len);
        }
        if (key == "Separator.thickness") {
            JSeparator sep = (JSeparator)context.getComponent();
            if (sep.getOrientation() == 0) {
                return this.getYThickness();
            }
            return this.getXThickness();
        }
        if (key == "ToolBar.separatorSize") {
            int size = GTKStyle.getClassSpecificIntValue(GTKEngine.WidgetType.TOOL_BAR, "space-size", 12);
            return new DimensionUIResource(size, size);
        }
        if (key == "ScrollBar.buttonSize") {
            JScrollBar sb = (JScrollBar)context.getComponent().getParent();
            boolean horiz = sb.getOrientation() == 0;
            GTKEngine.WidgetType wt = horiz ? GTKEngine.WidgetType.HSCROLL_BAR : GTKEngine.WidgetType.VSCROLL_BAR;
            int sliderWidth = GTKStyle.getClassSpecificIntValue(wt, "slider-width", 14);
            int stepperSize = GTKStyle.getClassSpecificIntValue(wt, "stepper-size", 14);
            return horiz ? new DimensionUIResource(stepperSize, sliderWidth) : new DimensionUIResource(sliderWidth, stepperSize);
        }
        if (key == "ArrowButton.size") {
            String name = context.getComponent().getName();
            if (name != null && name.startsWith("Spinner")) {
                String pangoFontName;
                Object wt = UNIXToolkit.GTK_LOCK;
                synchronized (wt) {
                    pangoFontName = GTKStyle.nativeGetPangoFontName(GTKEngine.WidgetType.SPINNER.ordinal());
                }
                int arrowSize = pangoFontName != null ? PangoFonts.getFontSize(pangoFontName) : 10;
                return arrowSize + this.getXThickness() * 2;
            }
        } else {
            if ("CheckBox.iconTextGap".equals(key) || "RadioButton.iconTextGap".equals(key)) {
                int indicatorSpacing = this.getClassSpecificIntValue(context, "indicator-spacing", 2);
                int focusSize = this.getClassSpecificIntValue(context, "focus-line-width", 1);
                int focusPad = this.getClassSpecificIntValue(context, "focus-padding", 1);
                return indicatorSpacing + focusSize + focusPad;
            }
            if (GTKLookAndFeel.is3() && "ComboBox.forceOpaque".equals(key)) {
                return true;
            }
            if ("Tree.expanderSize".equals(key)) {
                value = this.getClassSpecificValue("expander-size");
                if (value instanceof Integer) {
                    return (Integer)value + 4;
                }
                return null;
            }
        }
        GTKStockIcon stockIcon = null;
        Map<String, GTKStockIcon> focusSize = ICONS_MAP;
        synchronized (focusSize) {
            stockIcon = ICONS_MAP.get(key);
        }
        if (stockIcon != null) {
            return stockIcon;
        }
        if (key != "engine") {
            Object value2 = UIManager.get(key);
            if (key == "Table.rowHeight") {
                int focusLineWidth = this.getClassSpecificIntValue(context, "focus-line-width", 0);
                if (value2 == null && focusLineWidth > 0) {
                    value2 = 16 + 2 * focusLineWidth;
                }
            }
            return value2;
        }
        return null;
    }

    private Icon getStockIcon(SynthContext context, String key, int type) {
        Icon icon;
        ComponentOrientation co;
        GTKConstants.TextDirection direction = GTKConstants.TextDirection.LTR;
        if (context != null && (co = context.getComponent().getComponentOrientation()) != null && !co.isLeftToRight()) {
            direction = GTKConstants.TextDirection.RTL;
        }
        if ((icon = this.getStyleSpecificIcon(key, direction, type)) != null) {
            return icon;
        }
        String propName = ICON_PROPERTY_PREFIX + key + '.' + type + '.' + (direction == GTKConstants.TextDirection.RTL ? "rtl" : "ltr");
        Image img = (Image)Toolkit.getDefaultToolkit().getDesktopProperty(propName);
        if (img != null) {
            return new ImageIcon(img);
        }
        return null;
    }

    private Icon getStyleSpecificIcon(String key, GTKConstants.TextDirection direction, int type) {
        UNIXToolkit tk = (UNIXToolkit)Toolkit.getDefaultToolkit();
        BufferedImage img = tk.getStockIcon(this.widgetType, key, type, direction.ordinal(), null);
        return img != null ? new ImageIcon(img) : null;
    }

    static {
        CLASS_SPECIFIC_MAP.put("Slider.thumbHeight", "slider-width");
        CLASS_SPECIFIC_MAP.put("Slider.thumbWidth", "slider-length");
        CLASS_SPECIFIC_MAP.put("Slider.trackBorder", "trough-border");
        CLASS_SPECIFIC_MAP.put("SplitPane.size", "handle-size");
        CLASS_SPECIFIC_MAP.put("ScrollBar.thumbHeight", "slider-width");
        CLASS_SPECIFIC_MAP.put("ScrollBar.width", "slider-width");
        CLASS_SPECIFIC_MAP.put("TextArea.caretForeground", "cursor-color");
        CLASS_SPECIFIC_MAP.put("TextArea.caretAspectRatio", "cursor-aspect-ratio");
        CLASS_SPECIFIC_MAP.put("TextField.caretForeground", "cursor-color");
        CLASS_SPECIFIC_MAP.put("TextField.caretAspectRatio", "cursor-aspect-ratio");
        CLASS_SPECIFIC_MAP.put("PasswordField.caretForeground", "cursor-color");
        CLASS_SPECIFIC_MAP.put("PasswordField.caretAspectRatio", "cursor-aspect-ratio");
        CLASS_SPECIFIC_MAP.put("FormattedTextField.caretForeground", "cursor-color");
        CLASS_SPECIFIC_MAP.put("FormattedTextField.caretAspectRatio", "cursor-aspect-");
        CLASS_SPECIFIC_MAP.put("TextPane.caretForeground", "cursor-color");
        CLASS_SPECIFIC_MAP.put("TextPane.caretAspectRatio", "cursor-aspect-ratio");
        CLASS_SPECIFIC_MAP.put("EditorPane.caretForeground", "cursor-color");
        CLASS_SPECIFIC_MAP.put("EditorPane.caretAspectRatio", "cursor-aspect-ratio");
        ICONS_MAP = new HashMap<String, GTKStockIcon>();
        ICONS_MAP.put("FileChooser.cancelIcon", new GTKStockIcon("gtk-cancel", 4));
        ICONS_MAP.put("FileChooser.okIcon", new GTKStockIcon("gtk-ok", 4));
        ICONS_MAP.put("OptionPane.yesIcon", new GTKStockIcon("gtk-yes", 4));
        ICONS_MAP.put("OptionPane.noIcon", new GTKStockIcon("gtk-no", 4));
        ICONS_MAP.put("OptionPane.cancelIcon", new GTKStockIcon("gtk-cancel", 4));
        ICONS_MAP.put("OptionPane.okIcon", new GTKStockIcon("gtk-ok", 4));
        UNIXToolkit tk = (UNIXToolkit)Toolkit.getDefaultToolkit();
        if (tk.checkGtkVersion(3, 10, 0)) {
            ICONS_MAP.put("OptionPane.errorIcon", new GTKStockIcon("dialog-error", 6));
            ICONS_MAP.put("OptionPane.informationIcon", new GTKStockIcon("dialog-information", 6));
            ICONS_MAP.put("OptionPane.warningIcon", new GTKStockIcon("dialog-warning", 6));
            ICONS_MAP.put("OptionPane.questionIcon", new GTKStockIcon("dialog-question", 6));
        } else {
            ICONS_MAP.put("OptionPane.errorIcon", new GTKStockIcon("gtk-dialog-error", 6));
            ICONS_MAP.put("OptionPane.informationIcon", new GTKStockIcon("gtk-dialog-info", 6));
            ICONS_MAP.put("OptionPane.warningIcon", new GTKStockIcon("gtk-dialog-warning", 6));
            ICONS_MAP.put("OptionPane.questionIcon", new GTKStockIcon("gtk-dialog-question", 6));
        }
    }

    static class GTKLazyValue
    implements UIDefaults.LazyValue {
        private String className;
        private String methodName;

        GTKLazyValue(String name) {
            this(name, null);
        }

        GTKLazyValue(String name, String methodName) {
            this.className = name;
            this.methodName = methodName;
        }

        @Override
        public Object createValue(UIDefaults table) {
            try {
                Class<?> c = Class.forName(this.className, true, Thread.currentThread().getContextClassLoader());
                if (this.methodName == null) {
                    return c.newInstance();
                }
                Method m = c.getMethod(this.methodName, null);
                return m.invoke(c, null);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (InstantiationException instantiationException) {
                // empty catch block
            }
            return null;
        }
    }

    private static class GTKStockIcon
    extends SynthIcon {
        private String key;
        private int size;
        private boolean loadedLTR;
        private boolean loadedRTL;
        private Icon ltrIcon;
        private Icon rtlIcon;
        private SynthStyle style;

        GTKStockIcon(String key, int size) {
            this.key = key;
            this.size = size;
        }

        @Override
        public void paintIcon(SynthContext context, Graphics g, int x, int y, int w, int h) {
            Icon icon = this.getIcon(context);
            if (icon != null) {
                if (context == null) {
                    icon.paintIcon(null, g, x, y);
                } else {
                    icon.paintIcon(context.getComponent(), g, x, y);
                }
            }
        }

        @Override
        public int getIconWidth(SynthContext context) {
            Icon icon = this.getIcon(context);
            if (icon != null) {
                return icon.getIconWidth();
            }
            return 0;
        }

        @Override
        public int getIconHeight(SynthContext context) {
            Icon icon = this.getIcon(context);
            if (icon != null) {
                return icon.getIconHeight();
            }
            return 0;
        }

        private Icon getIcon(SynthContext context) {
            if (context != null) {
                ComponentOrientation co = context.getComponent().getComponentOrientation();
                SynthStyle style = context.getStyle();
                if (style != this.style) {
                    this.style = style;
                    this.loadedRTL = false;
                    this.loadedLTR = false;
                }
                if (co == null || co.isLeftToRight()) {
                    if (!this.loadedLTR) {
                        this.loadedLTR = true;
                        this.ltrIcon = ((GTKStyle)context.getStyle()).getStockIcon(context, this.key, this.size);
                    }
                    return this.ltrIcon;
                }
                if (!this.loadedRTL) {
                    this.loadedRTL = true;
                    this.rtlIcon = ((GTKStyle)context.getStyle()).getStockIcon(context, this.key, this.size);
                }
                return this.rtlIcon;
            }
            return this.ltrIcon;
        }
    }

    static class GTKStockIconInfo {
        private static Map<String, Integer> ICON_TYPE_MAP;
        private static final Object ICON_SIZE_KEY;

        GTKStockIconInfo() {
        }

        private static Dimension[] getIconSizesMap() {
            AppContext appContext = AppContext.getAppContext();
            Dimension[] iconSizes = (Dimension[])appContext.get(ICON_SIZE_KEY);
            if (iconSizes == null) {
                iconSizes = new Dimension[]{null, new Dimension(16, 16), new Dimension(18, 18), new Dimension(24, 24), new Dimension(20, 20), new Dimension(32, 32), new Dimension(48, 48)};
                appContext.put(ICON_SIZE_KEY, iconSizes);
            }
            return iconSizes;
        }

        public static Dimension getIconSize(int type) {
            Dimension[] iconSizes = GTKStockIconInfo.getIconSizesMap();
            return type >= 0 && type < iconSizes.length ? iconSizes[type] : null;
        }

        public static void setIconSize(int type, int w, int h) {
            Dimension[] iconSizes = GTKStockIconInfo.getIconSizesMap();
            if (type >= 0 && type < iconSizes.length) {
                iconSizes[type] = new Dimension(w, h);
            }
        }

        public static int getIconType(String size) {
            Integer n;
            if (size == null) {
                return -100;
            }
            if (ICON_TYPE_MAP == null) {
                GTKStockIconInfo.initIconTypeMap();
            }
            return (n = ICON_TYPE_MAP.get(size)) != null ? n : -100;
        }

        private static void initIconTypeMap() {
            ICON_TYPE_MAP = new HashMap<String, Integer>();
            ICON_TYPE_MAP.put("gtk-menu", 1);
            ICON_TYPE_MAP.put("gtk-small-toolbar", 2);
            ICON_TYPE_MAP.put("gtk-large-toolbar", 3);
            ICON_TYPE_MAP.put("gtk-button", 4);
            ICON_TYPE_MAP.put("gtk-dnd", 5);
            ICON_TYPE_MAP.put("gtk-dialog", 6);
        }

        static {
            ICON_SIZE_KEY = new Object();
        }
    }
}

