/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.tool;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.channels.FileChannel;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import jdk.jfr.internal.tool.Command;
import jdk.jfr.internal.tool.UserDataException;
import jdk.jfr.internal.tool.UserSyntaxException;

final class Assemble
extends Command {
    Assemble() {
    }

    @Override
    public String getName() {
        return "assemble";
    }

    @Override
    public List<String> getOptionSyntax() {
        return Collections.singletonList("<repository> <file>");
    }

    @Override
    public String getDescription() {
        return "Assemble leftover chunks from a disk repository into a recording file";
    }

    @Override
    public void displayOptionUsage(PrintStream stream) {
        stream.println("  <repository>   Directory where the repository is located");
        stream.println();
        stream.println("  <file>         Name of the recording file (.jfr) to create");
    }

    @Override
    public void execute(Deque<String> options) throws UserSyntaxException, UserDataException {
        this.ensureMinArgumentCount(options, 2);
        this.ensureMaxArgumentCount(options, 2);
        Path repository = this.getDirectory(options.pop());
        Path file = Paths.get(options.pop(), new String[0]);
        this.ensureFileDoesNotExist(file);
        this.ensureJFRFile(file);
        try (FileOutputStream fos = new FileOutputStream(file.toFile());){
            List<Path> files = this.listJFRFiles(repository);
            if (files.isEmpty()) {
                throw new UserDataException("no *.jfr files found at " + repository);
            }
            this.println();
            this.println("Assembling files... ");
            this.println();
            this.transferTo(files, file, fos.getChannel());
            this.println();
            this.println("Finished.");
        }
        catch (IOException e) {
            throw new UserDataException("could not open destination file " + file + ". " + e.getMessage());
        }
    }

    private List<Path> listJFRFiles(Path path) throws UserDataException {
        try {
            ArrayList<Path> files = new ArrayList<Path>();
            if (Files.isDirectory(path, new LinkOption[0])) {
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(path, "*.jfr");){
                    for (Path p : stream) {
                        if (Files.isDirectory(p, new LinkOption[0]) || !Files.isReadable(p)) continue;
                        files.add(p);
                    }
                }
            }
            files.sort((u, v) -> u.getFileName().compareTo(v.getFileName()));
            return files;
        }
        catch (IOException ioe) {
            throw new UserDataException("could not list *.jfr for directory " + path + ". " + ioe.getMessage());
        }
    }

    private void transferTo(List<Path> sourceFiles, Path output, FileChannel out) throws UserDataException {
        long pos = 0L;
        for (Path p : sourceFiles) {
            this.println(" " + p.toString());
            try {
                FileChannel sourceChannel = FileChannel.open(p, new OpenOption[0]);
                Throwable throwable = null;
                try {
                    long w;
                    for (long rem = Files.size(p); rem > 0L; rem -= w) {
                        long n = Math.min(rem, 0x100000L);
                        w = out.transferFrom(sourceChannel, pos, n);
                        pos += w;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (sourceChannel == null) continue;
                    if (throwable != null) {
                        try {
                            sourceChannel.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    sourceChannel.close();
                }
            }
            catch (IOException ioe) {
                throw new UserDataException("could not copy recording chunk " + p + " to new file. " + ioe.getMessage());
            }
        }
    }
}

