/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.settings;

import java.util.Objects;
import java.util.Set;
import jdk.jfr.BooleanFlag;
import jdk.jfr.Description;
import jdk.jfr.Label;
import jdk.jfr.MetadataDefinition;
import jdk.jfr.Name;
import jdk.jfr.internal.Control;
import jdk.jfr.internal.PlatformEventType;
import jdk.jfr.internal.Type;
import jdk.jfr.internal.settings.BooleanValue;

@MetadataDefinition
@Label(value="Stack Trace")
@Name(value="jdk.settings.StackTrace")
@Description(value="Record stack traces")
@BooleanFlag
public final class StackTraceSetting
extends Control {
    private static final long typeId = Type.getTypeId(StackTraceSetting.class);
    private final BooleanValue booleanValue;
    private final PlatformEventType eventType;

    public StackTraceSetting(PlatformEventType eventType, String defaultValue) {
        super(defaultValue);
        this.booleanValue = BooleanValue.valueOf(defaultValue);
        this.eventType = Objects.requireNonNull(eventType);
    }

    @Override
    public String combine(Set<String> values) {
        return this.booleanValue.union(values);
    }

    @Override
    public void setValue(String value) {
        this.booleanValue.setValue(value);
        this.eventType.setStackTraceEnabled(this.booleanValue.getBoolean());
    }

    @Override
    public String getValue() {
        return this.booleanValue.getValue();
    }

    public static boolean isType(long typeId) {
        return StackTraceSetting.typeId == typeId;
    }
}

