/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.settings;

import java.util.Objects;
import java.util.Set;
import jdk.jfr.Description;
import jdk.jfr.Label;
import jdk.jfr.MetadataDefinition;
import jdk.jfr.Name;
import jdk.jfr.Timespan;
import jdk.jfr.internal.Control;
import jdk.jfr.internal.PlatformEventType;
import jdk.jfr.internal.Type;
import jdk.jfr.internal.Utils;

@MetadataDefinition
@Label(value="Cutoff")
@Description(value="Limit running time of event")
@Name(value="jdk.settings.Cutoff")
@Timespan
public final class CutoffSetting
extends Control {
    private static final long typeId = Type.getTypeId(CutoffSetting.class);
    private String value = "0 ns";
    private final PlatformEventType eventType;

    public CutoffSetting(PlatformEventType eventType, String defaultValue) {
        super(defaultValue);
        this.eventType = Objects.requireNonNull(eventType);
    }

    @Override
    public String combine(Set<String> values) {
        long max = 0L;
        String text = "0 ns";
        for (String value : values) {
            long l = Utils.parseTimespanWithInfinity(value);
            if (l <= max) continue;
            text = value;
            max = l;
        }
        return text;
    }

    @Override
    public void setValue(String value) {
        long l = Utils.parseTimespanWithInfinity(value);
        this.value = value;
        this.eventType.setCutoff(l);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public static boolean isType(long typeId) {
        return CutoffSetting.typeId == typeId;
    }

    public static long parseValueSafe(String value) {
        if (value == null) {
            return 0L;
        }
        try {
            return Utils.parseTimespanWithInfinity(value);
        }
        catch (NumberFormatException nfe) {
            return 0L;
        }
    }
}

