/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.instrument;

import java.util.ArrayList;
import java.util.List;
import jdk.internal.org.objectweb.asm.Label;
import jdk.internal.org.objectweb.asm.MethodVisitor;
import jdk.internal.org.objectweb.asm.commons.LocalVariablesSorter;
import jdk.internal.org.objectweb.asm.commons.Remapper;
import jdk.internal.org.objectweb.asm.commons.SimpleRemapper;
import jdk.internal.org.objectweb.asm.tree.MethodNode;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;
import jdk.jfr.internal.Logger;
import jdk.jfr.internal.instrument.JIMethodInliningAdapter;

@Deprecated
final class JIMethodCallInliner
extends LocalVariablesSorter {
    private final String oldClass;
    private final String newClass;
    private final MethodNode inlineTarget;
    private final List<CatchBlock> blocks = new ArrayList<CatchBlock>();
    private boolean inlining;

    public JIMethodCallInliner(int access, String desc, MethodVisitor mv, MethodNode inlineTarget, String oldClass, String newClass) {
        super(327680, access, desc, mv);
        this.oldClass = oldClass;
        this.newClass = newClass;
        this.inlineTarget = inlineTarget;
        Logger.log(LogTag.JFR_SYSTEM_BYTECODE, LogLevel.DEBUG, "MethodCallInliner: targetMethod=" + newClass + "." + inlineTarget.name + inlineTarget.desc);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        if (!this.shouldBeInlined(owner, name, desc)) {
            this.mv.visitMethodInsn(opcode, owner, name, desc, itf);
            return;
        }
        Logger.log(LogTag.JFR_SYSTEM_BYTECODE, LogLevel.DEBUG, "Inlining call to " + name + desc);
        SimpleRemapper remapper = new SimpleRemapper(this.oldClass, this.newClass);
        Label end = new Label();
        this.inlining = true;
        this.inlineTarget.instructions.resetLabels();
        JIMethodInliningAdapter mia = new JIMethodInliningAdapter(this, end, opcode == 184 ? 8 : 0, desc, (Remapper)remapper);
        this.inlineTarget.accept(mia);
        this.inlining = false;
        super.visitLabel(end);
    }

    private boolean shouldBeInlined(String owner, String name, String desc) {
        return this.inlineTarget.desc.equals(desc) && this.inlineTarget.name.equals(name) && owner.equals(this.newClass.replace('.', '/'));
    }

    @Override
    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        if (!this.inlining) {
            this.blocks.add(new CatchBlock(start, end, handler, type));
        } else {
            super.visitTryCatchBlock(start, end, handler, type);
        }
    }

    @Override
    public void visitMaxs(int stack, int locals) {
        for (CatchBlock b : this.blocks) {
            super.visitTryCatchBlock(b.start, b.end, b.handler, b.type);
        }
        super.visitMaxs(stack, locals);
    }

    static final class CatchBlock {
        final Label start;
        final Label end;
        final Label handler;
        final String type;

        CatchBlock(Label start, Label end, Label handler, String type) {
            this.start = start;
            this.end = end;
            this.handler = handler;
            this.type = type;
        }
    }
}

