/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal.instrument;

import java.io.IOException;
import java.nio.ByteBuffer;
import jdk.jfr.events.FileForceEvent;
import jdk.jfr.events.FileReadEvent;
import jdk.jfr.events.FileWriteEvent;
import jdk.jfr.internal.instrument.JIInstrumentationMethod;
import jdk.jfr.internal.instrument.JIInstrumentationTarget;

@JIInstrumentationTarget(value="sun.nio.ch.FileChannelImpl")
final class FileChannelImplInstrumentor {
    private String path;

    private FileChannelImplInstrumentor() {
    }

    @JIInstrumentationMethod
    public void force(boolean metaData) throws IOException {
        FileForceEvent event = FileForceEvent.EVENT.get();
        if (!event.isEnabled()) {
            this.force(metaData);
            return;
        }
        try {
            event.begin();
            this.force(metaData);
        }
        finally {
            event.path = this.path;
            event.metaData = metaData;
            event.commit();
            event.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JIInstrumentationMethod
    public int read(ByteBuffer dst) throws IOException {
        FileReadEvent event = FileReadEvent.EVENT.get();
        if (!event.isEnabled()) {
            return this.read(dst);
        }
        int bytesRead = 0;
        try {
            event.begin();
            bytesRead = this.read(dst);
        }
        finally {
            if (bytesRead < 0) {
                event.endOfFile = true;
            } else {
                event.bytesRead = bytesRead;
            }
            event.path = this.path;
            event.commit();
            event.reset();
        }
        return bytesRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JIInstrumentationMethod
    public int read(ByteBuffer dst, long position) throws IOException {
        FileReadEvent event = FileReadEvent.EVENT.get();
        if (!event.isEnabled()) {
            return this.read(dst, position);
        }
        int bytesRead = 0;
        try {
            event.begin();
            bytesRead = this.read(dst, position);
        }
        finally {
            if (bytesRead < 0) {
                event.endOfFile = true;
            } else {
                event.bytesRead = bytesRead;
            }
            event.path = this.path;
            event.commit();
            event.reset();
        }
        return bytesRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JIInstrumentationMethod
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        FileReadEvent event = FileReadEvent.EVENT.get();
        if (!event.isEnabled()) {
            return this.read(dsts, offset, length);
        }
        long bytesRead = 0L;
        try {
            event.begin();
            bytesRead = this.read(dsts, offset, length);
        }
        finally {
            if (bytesRead < 0L) {
                event.endOfFile = true;
            } else {
                event.bytesRead = bytesRead;
            }
            event.path = this.path;
            event.commit();
            event.reset();
        }
        return bytesRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JIInstrumentationMethod
    public int write(ByteBuffer src) throws IOException {
        long l;
        FileWriteEvent event = FileWriteEvent.EVENT.get();
        if (!event.isEnabled()) {
            return this.write(src);
        }
        int bytesWritten = 0;
        try {
            event.begin();
            bytesWritten = this.write(src);
            l = bytesWritten > 0 ? (long)bytesWritten : 0L;
        }
        catch (Throwable throwable) {
            event.bytesWritten = bytesWritten > 0 ? (long)bytesWritten : 0L;
            event.path = this.path;
            event.commit();
            event.reset();
            throw throwable;
        }
        event.bytesWritten = l;
        event.path = this.path;
        event.commit();
        event.reset();
        return bytesWritten;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JIInstrumentationMethod
    public int write(ByteBuffer src, long position) throws IOException {
        long l;
        FileWriteEvent event = FileWriteEvent.EVENT.get();
        if (!event.isEnabled()) {
            return this.write(src, position);
        }
        int bytesWritten = 0;
        try {
            event.begin();
            bytesWritten = this.write(src, position);
            l = bytesWritten > 0 ? (long)bytesWritten : 0L;
        }
        catch (Throwable throwable) {
            event.bytesWritten = bytesWritten > 0 ? (long)bytesWritten : 0L;
            event.path = this.path;
            event.commit();
            event.reset();
            throw throwable;
        }
        event.bytesWritten = l;
        event.path = this.path;
        event.commit();
        event.reset();
        return bytesWritten;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JIInstrumentationMethod
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        FileWriteEvent event = FileWriteEvent.EVENT.get();
        if (!event.isEnabled()) {
            return this.write(srcs, offset, length);
        }
        long bytesWritten = 0L;
        try {
            event.begin();
            bytesWritten = this.write(srcs, offset, length);
            event.bytesWritten = bytesWritten > 0L ? bytesWritten : 0L;
        }
        catch (Throwable throwable) {
            event.bytesWritten = bytesWritten > 0L ? bytesWritten : 0L;
            event.path = this.path;
            event.commit();
            event.reset();
            throw throwable;
        }
        event.path = this.path;
        event.commit();
        event.reset();
        return bytesWritten;
    }
}

