/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import jdk.jfr.AnnotationElement;
import jdk.jfr.SettingDescriptor;
import jdk.jfr.ValueDescriptor;
import jdk.jfr.internal.MetadataDescriptor;
import jdk.jfr.internal.PlatformEventType;
import jdk.jfr.internal.PrivateAccess;
import jdk.jfr.internal.Type;

final class MetadataWriter {
    private final MetadataDescriptor.Element metadata = new MetadataDescriptor.Element("metadata");
    private final MetadataDescriptor.Element root = new MetadataDescriptor.Element("root");

    public MetadataWriter(MetadataDescriptor descriptor) {
        descriptor.getTypes().forEach(type -> this.makeTypeElement(this.metadata, (Type)type));
        this.root.add(this.metadata);
        MetadataDescriptor.Element region = new MetadataDescriptor.Element("region");
        region.addAttribute("locale", descriptor.locale);
        region.addAttribute("gmtOffset", descriptor.gmtOffset);
        this.root.add(region);
    }

    public void writeBinary(DataOutput output) throws IOException {
        HashSet<String> stringPool = new HashSet<String>(1000);
        this.buildStringPool(this.root, stringPool);
        LinkedHashMap<String, Integer> lookup = new LinkedHashMap<String, Integer>(stringPool.size());
        int index = 0;
        int poolSize = stringPool.size();
        this.writeInt(output, poolSize);
        for (String s : stringPool) {
            lookup.put(s, index);
            this.writeString(output, s);
            ++index;
        }
        this.write(output, this.root, lookup);
    }

    private void writeString(DataOutput out, String s) throws IOException {
        if (s == null) {
            out.writeByte(0);
            return;
        }
        out.writeByte(4);
        int length = s.length();
        this.writeInt(out, length);
        for (int i = 0; i < length; ++i) {
            this.writeInt(out, s.charAt(i));
        }
    }

    private void writeInt(DataOutput out, int v) throws IOException {
        long s = (long)v & 0xFFFFFFFFL;
        if (s < 128L) {
            out.write((byte)s);
            return;
        }
        out.write((byte)(s | 0x80L));
        if ((s >>= 7) < 128L) {
            out.write((byte)s);
            return;
        }
        out.write((byte)(s | 0x80L));
        if ((s >>= 7) < 128L) {
            out.write((byte)s);
            return;
        }
        out.write((byte)(s | 0x80L));
        if ((s >>= 7) < 128L) {
            out.write((byte)s);
            return;
        }
        out.write((byte)(s >>= 7));
    }

    private void buildStringPool(MetadataDescriptor.Element element, Set<String> pool) {
        pool.add(element.name);
        for (MetadataDescriptor.Attribute a : element.attributes) {
            pool.add(a.name);
            pool.add(a.value);
        }
        for (MetadataDescriptor.Element child : element.elements) {
            this.buildStringPool(child, pool);
        }
    }

    private void write(DataOutput output, MetadataDescriptor.Element element, HashMap<String, Integer> lookup) throws IOException {
        this.writeInt(output, lookup.get(element.name));
        this.writeInt(output, element.attributes.size());
        for (MetadataDescriptor.Attribute a : element.attributes) {
            this.writeInt(output, lookup.get(a.name));
            this.writeInt(output, lookup.get(a.value));
        }
        this.writeInt(output, element.elements.size());
        for (MetadataDescriptor.Element child : element.elements) {
            this.write(output, child, lookup);
        }
    }

    private void makeTypeElement(MetadataDescriptor.Element root, Type type) {
        MetadataDescriptor.Element element = root.newChild("class");
        element.addAttribute("name", type.getName());
        String superType = type.getSuperType();
        if (superType != null) {
            element.addAttribute("superType", superType);
        }
        if (type.isSimpleType()) {
            element.addAttribute("simpleType", true);
        }
        element.addAttribute("id", type.getId());
        if (type instanceof PlatformEventType) {
            for (SettingDescriptor settingDescriptor : ((PlatformEventType)type).getSettings()) {
                this.makeSettingElement(element, settingDescriptor);
            }
        }
        for (ValueDescriptor valueDescriptor : type.getFields()) {
            this.makeFieldElement(element, valueDescriptor);
        }
        for (AnnotationElement annotationElement : type.getAnnotationElements()) {
            this.makeAnnotation(element, annotationElement);
        }
    }

    private void makeSettingElement(MetadataDescriptor.Element typeElement, SettingDescriptor s) {
        MetadataDescriptor.Element element = typeElement.newChild("setting");
        element.addAttribute("name", s.getName());
        element.addAttribute("class", s.getTypeId());
        element.addAttribute("defaultValue", s.getDefaultValue());
        for (AnnotationElement a : s.getAnnotationElements()) {
            this.makeAnnotation(element, a);
        }
    }

    private void makeFieldElement(MetadataDescriptor.Element typeElement, ValueDescriptor v) {
        MetadataDescriptor.Element element = typeElement.newChild("field");
        element.addAttribute("name", v.getName());
        element.addAttribute("class", v.getTypeId());
        if (v.isArray()) {
            element.addAttribute("dimension", 1);
        }
        if (PrivateAccess.getInstance().isConstantPool(v)) {
            element.addAttribute("constantPool", true);
        }
        for (AnnotationElement a : v.getAnnotationElements()) {
            this.makeAnnotation(element, a);
        }
    }

    private void makeAnnotation(MetadataDescriptor.Element entity, AnnotationElement annotation) {
        MetadataDescriptor.Element element = entity.newChild("annotation");
        element.addAttribute("class", annotation.getTypeId());
        List<Object> values = annotation.getValues();
        int index = 0;
        for (ValueDescriptor v : annotation.getValueDescriptors()) {
            Object value = values.get(index++);
            if (v.isArray()) {
                element.addArrayAttribute(element, v.getName(), value);
                continue;
            }
            element.addAttribute(v.getName(), value);
        }
    }
}

