/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.internal;

import java.util.function.Supplier;
import jdk.jfr.internal.JVM;
import jdk.jfr.internal.JVMSupport;
import jdk.jfr.internal.LogLevel;
import jdk.jfr.internal.LogTag;

public final class Logger {
    private static final int MAX_SIZE = 10000;

    public static void log(LogTag logTag, LogLevel logLevel, String message) {
        if (Logger.shouldLog(logTag, logLevel)) {
            Logger.logInternal(logTag, logLevel, message);
        }
    }

    public static void log(LogTag logTag, LogLevel logLevel, Supplier<String> messageSupplier) {
        if (Logger.shouldLog(logTag, logLevel)) {
            Logger.logInternal(logTag, logLevel, messageSupplier.get());
        }
    }

    private static void logInternal(LogTag logTag, LogLevel logLevel, String message) {
        if (message == null || message.length() < 10000) {
            JVM.log(logTag.id, logLevel.level, message);
        } else {
            JVM.log(logTag.id, logLevel.level, message.substring(0, 10000));
        }
    }

    public static boolean shouldLog(LogTag tag, LogLevel level) {
        return true;
    }

    static {
        JVMSupport.tryToInitializeJVM();
    }
}

