/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import jdk.jfr.internal.JVMSupport;
import jdk.jfr.internal.jfc.JFC;

public final class Configuration {
    private final Map<String, String> settings;
    private final String label;
    private final String description;
    private final String provider;
    private final String contents;
    private final String name;

    Configuration(String name, String label, String description, String provider, Map<String, String> settings, String contents) {
        this.name = name;
        this.label = label;
        this.description = description;
        this.provider = provider;
        this.settings = settings;
        this.contents = contents;
    }

    public Map<String, String> getSettings() {
        return new LinkedHashMap<String, String>(this.settings);
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public String getProvider() {
        return this.provider;
    }

    public String getContents() {
        return this.contents;
    }

    public static Configuration create(Path path) throws IOException, ParseException {
        Objects.requireNonNull(path);
        JVMSupport.ensureWithIOException();
        try (BufferedReader reader = Files.newBufferedReader(path);){
            Configuration configuration = JFC.create(JFC.nameFromPath(path), reader);
            return configuration;
        }
    }

    public static Configuration create(Reader reader) throws IOException, ParseException {
        Objects.requireNonNull(reader);
        JVMSupport.ensureWithIOException();
        return JFC.create(null, reader);
    }

    public static Configuration getConfiguration(String name) throws IOException, ParseException {
        JVMSupport.ensureWithIOException();
        return JFC.getPredefined(name);
    }

    public static List<Configuration> getConfigurations() {
        if (JVMSupport.isNotAvailable()) {
            return new ArrayList<Configuration>();
        }
        return Collections.unmodifiableList(JFC.getConfigurations());
    }
}

