/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.util.AbstractMap;
import java.util.Map;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509ExtendedKeyManager;
import sun.security.ssl.ClientHandshakeContext;
import sun.security.ssl.HandshakeContext;
import sun.security.ssl.HandshakeProducer;
import sun.security.ssl.SSLAuthentication;
import sun.security.ssl.SSLCredentials;
import sun.security.ssl.SSLEngineImpl;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SSLPossession;
import sun.security.ssl.SSLPossessionGenerator;
import sun.security.ssl.SSLSocketImpl;
import sun.security.ssl.ServerHandshakeContext;
import sun.security.ssl.SignatureScheme;
import sun.security.ssl.SupportedGroupsExtension;

enum X509Authentication implements SSLAuthentication
{
    RSA("RSA", new X509PossessionGenerator(new String[]{"RSA"})),
    RSASSA_PSS("RSASSA-PSS", new X509PossessionGenerator(new String[]{"RSASSA-PSS"})),
    RSA_OR_PSS("RSA_OR_PSS", new X509PossessionGenerator(new String[]{"RSA", "RSASSA-PSS"})),
    DSA("DSA", new X509PossessionGenerator(new String[]{"DSA"})),
    EC("EC", new X509PossessionGenerator(new String[]{"EC"}));

    final String keyType;
    final SSLPossessionGenerator possessionGenerator;

    private X509Authentication(String keyType, SSLPossessionGenerator possessionGenerator) {
        this.keyType = keyType;
        this.possessionGenerator = possessionGenerator;
    }

    static X509Authentication valueOf(SignatureScheme signatureScheme) {
        for (X509Authentication au : X509Authentication.values()) {
            if (!au.keyType.equals(signatureScheme.keyAlgorithm)) continue;
            return au;
        }
        return null;
    }

    @Override
    public SSLPossession createPossession(HandshakeContext handshakeContext) {
        return this.possessionGenerator.createPossession(handshakeContext);
    }

    @Override
    public SSLHandshake[] getRelatedHandshakers(HandshakeContext handshakeContext) {
        if (!handshakeContext.negotiatedProtocol.useTLS13PlusSpec()) {
            return new SSLHandshake[]{SSLHandshake.CERTIFICATE, SSLHandshake.CERTIFICATE_REQUEST};
        }
        return new SSLHandshake[0];
    }

    @Override
    public Map.Entry<Byte, HandshakeProducer>[] getHandshakeProducers(HandshakeContext handshakeContext) {
        if (!handshakeContext.negotiatedProtocol.useTLS13PlusSpec()) {
            return new Map.Entry[]{new AbstractMap.SimpleImmutableEntry<Byte, SSLHandshake>(SSLHandshake.CERTIFICATE.id, SSLHandshake.CERTIFICATE)};
        }
        return new Map.Entry[0];
    }

    private static final class X509PossessionGenerator
    implements SSLPossessionGenerator {
        private final String[] keyTypes;

        private X509PossessionGenerator(String[] keyTypes) {
            this.keyTypes = keyTypes;
        }

        @Override
        public SSLPossession createPossession(HandshakeContext context) {
            if (context.sslConfig.isClientMode) {
                for (String keyType : this.keyTypes) {
                    SSLPossession poss = this.createClientPossession((ClientHandshakeContext)context, keyType);
                    if (poss == null) continue;
                    return poss;
                }
            } else {
                for (String keyType : this.keyTypes) {
                    SSLPossession poss = this.createServerPossession((ServerHandshakeContext)context, keyType);
                    if (poss == null) continue;
                    return poss;
                }
            }
            return null;
        }

        private SSLPossession createClientPossession(ClientHandshakeContext chc, String keyType) {
            X509ExtendedKeyManager km = chc.sslContext.getX509KeyManager();
            String clientAlias = null;
            if (chc.conContext.transport instanceof SSLSocketImpl) {
                clientAlias = km.chooseClientAlias(new String[]{keyType}, chc.peerSupportedAuthorities, (SSLSocket)((Object)chc.conContext.transport));
            } else if (chc.conContext.transport instanceof SSLEngineImpl) {
                clientAlias = km.chooseEngineClientAlias(new String[]{keyType}, chc.peerSupportedAuthorities, (SSLEngine)((Object)chc.conContext.transport));
            }
            if (clientAlias == null) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                    SSLLogger.finest("No X.509 cert selected for " + keyType, new Object[0]);
                }
                return null;
            }
            PrivateKey clientPrivateKey = km.getPrivateKey(clientAlias);
            if (clientPrivateKey == null) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                    SSLLogger.finest(clientAlias + " is not a private key entry", new Object[0]);
                }
                return null;
            }
            X509Certificate[] clientCerts = km.getCertificateChain(clientAlias);
            if (clientCerts == null || clientCerts.length == 0) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                    SSLLogger.finest(clientAlias + " is a private key entry with no cert chain stored", new Object[0]);
                }
                return null;
            }
            PublicKey clientPublicKey = clientCerts[0].getPublicKey();
            if (!clientPrivateKey.getAlgorithm().equals(keyType) || !clientPublicKey.getAlgorithm().equals(keyType)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                    SSLLogger.fine(clientAlias + " private or public key is not of " + keyType + " algorithm", new Object[0]);
                }
                return null;
            }
            return new X509Possession(clientPrivateKey, clientCerts);
        }

        private SSLPossession createServerPossession(ServerHandshakeContext shc, String keyType) {
            X509ExtendedKeyManager km = shc.sslContext.getX509KeyManager();
            String serverAlias = null;
            if (shc.conContext.transport instanceof SSLSocketImpl) {
                serverAlias = km.chooseServerAlias(keyType, null, (SSLSocket)((Object)shc.conContext.transport));
            } else if (shc.conContext.transport instanceof SSLEngineImpl) {
                serverAlias = km.chooseEngineServerAlias(keyType, null, (SSLEngine)((Object)shc.conContext.transport));
            }
            if (serverAlias == null) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                    SSLLogger.finest("No X.509 cert selected for " + keyType, new Object[0]);
                }
                return null;
            }
            PrivateKey serverPrivateKey = km.getPrivateKey(serverAlias);
            if (serverPrivateKey == null) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                    SSLLogger.finest(serverAlias + " is not a private key entry", new Object[0]);
                }
                return null;
            }
            X509Certificate[] serverCerts = km.getCertificateChain(serverAlias);
            if (serverCerts == null || serverCerts.length == 0) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                    SSLLogger.finest(serverAlias + " is not a certificate entry", new Object[0]);
                }
                return null;
            }
            PublicKey serverPublicKey = serverCerts[0].getPublicKey();
            if (!serverPrivateKey.getAlgorithm().equals(keyType) || !serverPublicKey.getAlgorithm().equals(keyType)) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                    SSLLogger.fine(serverAlias + " private or public key is not of " + keyType + " algorithm", new Object[0]);
                }
                return null;
            }
            if (!shc.negotiatedProtocol.useTLS13PlusSpec() && keyType.equals("EC")) {
                if (!(serverPublicKey instanceof ECPublicKey)) {
                    if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                        SSLLogger.warning(serverAlias + " public key is not an instance of ECPublicKey", new Object[0]);
                    }
                    return null;
                }
                ECParameterSpec params = ((ECPublicKey)serverPublicKey).getParams();
                SupportedGroupsExtension.NamedGroup namedGroup = SupportedGroupsExtension.NamedGroup.valueOf(params);
                if (namedGroup == null || !SupportedGroupsExtension.SupportedGroups.isSupported(namedGroup) || shc.clientRequestedNamedGroups != null && !shc.clientRequestedNamedGroups.contains((Object)namedGroup)) {
                    if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                        SSLLogger.warning("Unsupported named group (" + (Object)((Object)namedGroup) + ") used in the " + serverAlias + " certificate", new Object[0]);
                    }
                    return null;
                }
            }
            return new X509Possession(serverPrivateKey, serverCerts);
        }
    }

    static final class X509Credentials
    implements SSLCredentials {
        final X509Certificate[] popCerts;
        final PublicKey popPublicKey;

        X509Credentials(PublicKey popPublicKey, X509Certificate[] popCerts) {
            this.popCerts = popCerts;
            this.popPublicKey = popPublicKey;
        }
    }

    static final class X509Possession
    implements SSLPossession {
        final X509Certificate[] popCerts;
        final PrivateKey popPrivateKey;

        X509Possession(PrivateKey popPrivateKey, X509Certificate[] popCerts) {
            this.popCerts = popCerts;
            this.popPrivateKey = popPrivateKey;
        }

        ECParameterSpec getECParameterSpec() {
            PublicKey publicKey;
            if (this.popPrivateKey == null || !"EC".equals(this.popPrivateKey.getAlgorithm())) {
                return null;
            }
            if (this.popPrivateKey instanceof ECKey) {
                return ((ECKey)((Object)this.popPrivateKey)).getParams();
            }
            if (this.popCerts != null && this.popCerts.length != 0 && (publicKey = this.popCerts[0].getPublicKey()) instanceof ECKey) {
                return ((ECKey)((Object)publicKey)).getParams();
            }
            return null;
        }
    }
}

