/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import javax.crypto.BadPaddingException;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLProtocolException;
import sun.security.ssl.ContentType;
import sun.security.ssl.HandshakeHash;
import sun.security.ssl.InputRecord;
import sun.security.ssl.Plaintext;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.Record;
import sun.security.ssl.SSLCipher;
import sun.security.ssl.SSLConfiguration;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SSLRecord;

final class SSLSocketInputRecord
extends InputRecord
implements SSLRecord {
    private InputStream is = null;
    private OutputStream os = null;
    private final byte[] temporary = new byte[1024];
    private boolean formatVerified = false;
    private ByteBuffer handshakeBuffer = null;
    private boolean hasHeader = false;

    SSLSocketInputRecord(HandshakeHash handshakeHash) {
        super(handshakeHash, SSLCipher.SSLReadCipher.nullTlsReadCipher());
    }

    @Override
    int bytesInCompletePacket() throws IOException {
        if (!this.hasHeader) {
            try {
                int really = SSLSocketInputRecord.read(this.is, this.temporary, 0, 5);
                if (really < 0) {
                    return -1;
                }
            }
            catch (EOFException eofe) {
                return -1;
            }
            this.hasHeader = true;
        }
        byte byteZero = this.temporary[0];
        int len = 0;
        if (this.formatVerified || byteZero == ContentType.HANDSHAKE.id || byteZero == ContentType.ALERT.id) {
            if (!ProtocolVersion.isNegotiable(this.temporary[1], this.temporary[2], false)) {
                throw new SSLException("Unrecognized record version " + ProtocolVersion.nameOf(this.temporary[1], this.temporary[2]) + " , plaintext connection?");
            }
            this.formatVerified = true;
            len = ((this.temporary[3] & 0xFF) << 8) + (this.temporary[4] & 0xFF) + 5;
        } else {
            boolean isShort;
            boolean bl = isShort = (byteZero & 0x80) != 0;
            if (isShort && (this.temporary[2] == 1 || this.temporary[2] == 4)) {
                if (!ProtocolVersion.isNegotiable(this.temporary[3], this.temporary[4], false)) {
                    throw new SSLException("Unrecognized record version " + ProtocolVersion.nameOf(this.temporary[3], this.temporary[4]) + " , plaintext connection?");
                }
                len = ((byteZero & 0x7F) << 8) + (this.temporary[1] & 0xFF) + 2;
            } else {
                throw new SSLException("Unrecognized SSL message, plaintext connection?");
            }
        }
        return len;
    }

    @Override
    Plaintext[] decode(ByteBuffer[] srcs, int srcsOffset, int srcsLength) throws IOException, BadPaddingException {
        if (this.isClosed) {
            return null;
        }
        if (!this.hasHeader) {
            int really = SSLSocketInputRecord.read(this.is, this.temporary, 0, 5);
            if (really < 0) {
                throw new EOFException("SSL peer shut down incorrectly");
            }
            this.hasHeader = true;
        }
        Object plaintext = null;
        if (!this.formatVerified) {
            this.formatVerified = true;
            if (this.temporary[0] != ContentType.HANDSHAKE.id && this.temporary[0] != ContentType.ALERT.id) {
                this.hasHeader = false;
                return this.handleUnknownRecord(this.temporary);
            }
        }
        this.hasHeader = false;
        return this.decodeInputRecord(this.temporary);
    }

    @Override
    void setReceiverStream(InputStream inputStream) {
        this.is = inputStream;
    }

    @Override
    void setDeliverStream(OutputStream outputStream) {
        this.os = outputStream;
    }

    private Plaintext[] decodeInputRecord(byte[] header) throws IOException, BadPaddingException {
        ByteBuffer fragment;
        byte contentType = header[0];
        byte majorVersion = header[1];
        byte minorVersion = header[2];
        int contentLen = ((header[3] & 0xFF) << 8) + (header[4] & 0xFF);
        if (SSLLogger.isOn && SSLLogger.isOn("record")) {
            SSLLogger.fine("READ: " + ProtocolVersion.nameOf(majorVersion, minorVersion) + " " + ContentType.nameOf(contentType) + ", length = " + contentLen, new Object[0]);
        }
        if (contentLen < 0 || contentLen > 33088) {
            throw new SSLProtocolException("Bad input record size, TLSCiphertext.length = " + contentLen);
        }
        ByteBuffer destination = ByteBuffer.allocate(5 + contentLen);
        int dstPos = destination.position();
        destination.put(this.temporary, 0, 5);
        while (contentLen > 0) {
            int howmuch = Math.min(this.temporary.length, contentLen);
            int really = SSLSocketInputRecord.read(this.is, this.temporary, 0, howmuch);
            if (really < 0) {
                throw new EOFException("SSL peer shut down incorrectly");
            }
            destination.put(this.temporary, 0, howmuch);
            contentLen -= howmuch;
        }
        destination.flip();
        destination.position(dstPos + 5);
        if (SSLLogger.isOn && SSLLogger.isOn("record")) {
            SSLLogger.fine("READ: " + ProtocolVersion.nameOf(majorVersion, minorVersion) + " " + ContentType.nameOf(contentType) + ", length = " + destination.remaining(), new Object[0]);
        }
        try {
            Plaintext plaintext = this.readCipher.decrypt(contentType, destination, null);
            fragment = plaintext.fragment;
            contentType = plaintext.contentType;
        }
        catch (BadPaddingException bpe) {
            throw bpe;
        }
        catch (GeneralSecurityException gse) {
            throw (SSLProtocolException)new SSLProtocolException("Unexpected exception").initCause(gse);
        }
        if (contentType != ContentType.HANDSHAKE.id && this.handshakeBuffer != null && this.handshakeBuffer.hasRemaining()) {
            throw new SSLProtocolException("Expecting a handshake fragment, but received " + ContentType.nameOf(contentType));
        }
        if (contentType == ContentType.HANDSHAKE.id) {
            ByteBuffer handshakeFrag = fragment;
            if (this.handshakeBuffer != null && this.handshakeBuffer.remaining() != 0) {
                ByteBuffer bb = ByteBuffer.wrap(new byte[this.handshakeBuffer.remaining() + fragment.remaining()]);
                bb.put(this.handshakeBuffer);
                bb.put(fragment);
                handshakeFrag = (ByteBuffer)bb.rewind();
                this.handshakeBuffer = null;
            }
            ArrayList<Plaintext> plaintexts = new ArrayList<Plaintext>(5);
            while (handshakeFrag.hasRemaining()) {
                int remaining = handshakeFrag.remaining();
                if (remaining < 4) {
                    this.handshakeBuffer = ByteBuffer.wrap(new byte[remaining]);
                    this.handshakeBuffer.put(handshakeFrag);
                    this.handshakeBuffer.rewind();
                    break;
                }
                handshakeFrag.mark();
                byte handshakeType = handshakeFrag.get();
                int handshakeBodyLen = Record.getInt24(handshakeFrag);
                if (handshakeBodyLen > SSLConfiguration.maxHandshakeMessageSize) {
                    throw new SSLProtocolException("The size of the handshake message (" + handshakeBodyLen + ") exceeds the maximum allowed size (" + SSLConfiguration.maxHandshakeMessageSize + ")");
                }
                handshakeFrag.reset();
                int handshakeMessageLen = 4 + handshakeBodyLen;
                if (remaining < handshakeMessageLen) {
                    this.handshakeBuffer = ByteBuffer.wrap(new byte[remaining]);
                    this.handshakeBuffer.put(handshakeFrag);
                    this.handshakeBuffer.rewind();
                    break;
                }
                if (remaining == handshakeMessageLen) {
                    if (this.handshakeHash.isHashable(handshakeType)) {
                        this.handshakeHash.receive(handshakeFrag);
                    }
                    plaintexts.add(new Plaintext(contentType, majorVersion, minorVersion, -1, -1L, handshakeFrag));
                    break;
                }
                int fragPos = handshakeFrag.position();
                int fragLim = handshakeFrag.limit();
                int nextPos = fragPos + handshakeMessageLen;
                handshakeFrag.limit(nextPos);
                if (this.handshakeHash.isHashable(handshakeType)) {
                    this.handshakeHash.receive(handshakeFrag);
                }
                plaintexts.add(new Plaintext(contentType, majorVersion, minorVersion, -1, -1L, handshakeFrag.slice()));
                handshakeFrag.position(nextPos);
                handshakeFrag.limit(fragLim);
            }
            return plaintexts.toArray(new Plaintext[0]);
        }
        return new Plaintext[]{new Plaintext(contentType, majorVersion, minorVersion, -1, -1L, fragment)};
    }

    private Plaintext[] handleUnknownRecord(byte[] header) throws IOException, BadPaddingException {
        byte firstByte = header[0];
        byte thirdByte = header[2];
        if ((firstByte & 0x80) != 0 && thirdByte == 1) {
            if (this.helloVersion != ProtocolVersion.SSL20Hello) {
                throw new SSLHandshakeException("SSLv2Hello is not enabled");
            }
            byte majorVersion = header[3];
            byte minorVersion = header[4];
            if (majorVersion == ProtocolVersion.SSL20Hello.major && minorVersion == ProtocolVersion.SSL20Hello.minor) {
                this.os.write(SSLRecord.v2NoCipher);
                if (SSLLogger.isOn) {
                    if (SSLLogger.isOn("record")) {
                        SSLLogger.fine("Requested to negotiate unsupported SSLv2!", new Object[0]);
                    }
                    if (SSLLogger.isOn("packet")) {
                        SSLLogger.fine("Raw write", new Object[]{SSLRecord.v2NoCipher});
                    }
                }
                throw new SSLException("Unsupported SSL v2.0 ClientHello");
            }
            int msgLen = (header[0] & 0x7F) << 8 | header[1] & 0xFF;
            ByteBuffer destination = ByteBuffer.allocate(5 + msgLen);
            destination.put(this.temporary, 0, 5);
            msgLen -= 3;
            while (msgLen > 0) {
                int howmuch = Math.min(this.temporary.length, msgLen);
                int really = SSLSocketInputRecord.read(this.is, this.temporary, 0, howmuch);
                if (really < 0) {
                    throw new EOFException("SSL peer shut down incorrectly");
                }
                destination.put(this.temporary, 0, howmuch);
                msgLen -= howmuch;
            }
            destination.flip();
            destination.position(2);
            this.handshakeHash.receive(destination);
            destination.position(0);
            ByteBuffer converted = SSLSocketInputRecord.convertToClientHello(destination);
            if (SSLLogger.isOn && SSLLogger.isOn("packet")) {
                SSLLogger.fine("[Converted] ClientHello", converted);
            }
            return new Plaintext[]{new Plaintext(ContentType.HANDSHAKE.id, majorVersion, minorVersion, -1, -1L, converted)};
        }
        if ((firstByte & 0x80) != 0 && thirdByte == 4) {
            throw new SSLException("SSL V2.0 servers are not supported.");
        }
        throw new SSLException("Unsupported or unrecognized SSL message");
    }

    private static int read(InputStream is, byte[] buffer, int offset, int len) throws IOException {
        int n;
        int readLen;
        for (n = 0; n < len; n += readLen) {
            readLen = is.read(buffer, offset + n, len - n);
            if (readLen < 0) {
                if (SSLLogger.isOn && SSLLogger.isOn("packet")) {
                    SSLLogger.fine("Raw read: EOF", new Object[0]);
                }
                return -1;
            }
            if (!SSLLogger.isOn || !SSLLogger.isOn("packet")) continue;
            ByteBuffer bb = ByteBuffer.wrap(buffer, offset + n, readLen);
            SSLLogger.fine("Raw read", bb);
        }
        return n;
    }
}

