/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.RSAKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.util.Hashtable;
import sun.nio.ch.DirectBuffer;
import sun.security.pkcs11.P11Key;
import sun.security.pkcs11.P11KeyFactory;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.CK_MECHANISM_INFO;
import sun.security.pkcs11.wrapper.CK_RSA_PKCS_PSS_PARAMS;
import sun.security.pkcs11.wrapper.PKCS11Exception;

final class P11PSSSignature
extends SignatureSpi {
    private static final boolean DEBUG = false;
    private static final Hashtable<String, Integer> DIGEST_LENGTHS = new Hashtable();
    private final Token token;
    private final String algorithm;
    private static final String KEY_ALGO = "RSA";
    private final CK_MECHANISM mechanism;
    private final int type;
    private P11Key p11Key = null;
    private PSSParameterSpec sigParams = null;
    private boolean isActive = false;
    private final String mdAlg;
    private MessageDigest md = null;
    private Session session;
    private int mode;
    private boolean initialized = false;
    private final byte[] buffer = new byte[1];
    private int bytesProcessed = 0;
    private static final int M_SIGN = 1;
    private static final int M_VERIFY = 2;
    private static final int T_DIGEST = 1;
    private static final int T_UPDATE = 2;

    private static boolean isDigestEqual(String stdAlg, String givenAlg) {
        if (stdAlg == null || givenAlg == null) {
            return false;
        }
        if (givenAlg.indexOf("-") != -1) {
            return stdAlg.equalsIgnoreCase(givenAlg);
        }
        if (stdAlg.equals("SHA-1")) {
            return givenAlg.equalsIgnoreCase("SHA") || givenAlg.equalsIgnoreCase("SHA1");
        }
        StringBuilder sb = new StringBuilder(givenAlg);
        if (givenAlg.regionMatches(true, 0, "SHA", 0, 3)) {
            givenAlg = sb.insert(3, "-").toString();
            return stdAlg.equalsIgnoreCase(givenAlg);
        }
        throw new ProviderException("Unsupported digest algorithm " + givenAlg);
    }

    P11PSSSignature(Token token, String algorithm, long mechId) throws NoSuchAlgorithmException, PKCS11Exception {
        this.token = token;
        this.algorithm = algorithm;
        this.mechanism = new CK_MECHANISM(mechId);
        int idx = algorithm.indexOf("with");
        this.mdAlg = idx == -1 ? null : algorithm.substring(0, idx);
        switch ((int)mechId) {
            case 14: 
            case 67: 
            case 68: 
            case 69: 
            case 71: {
                this.type = 2;
                break;
            }
            case 13: {
                this.type = 1;
                break;
            }
            default: {
                throw new ProviderException("Unsupported mechanism: " + mechId);
            }
        }
        this.md = null;
    }

    private void ensureInitialized() throws SignatureException {
        this.token.ensureValid();
        if (this.p11Key == null) {
            throw new SignatureException("Missing key");
        }
        if (this.sigParams == null) {
            if (this.mdAlg == null) {
                throw new SignatureException("Parameters required for RSASSA-PSS signature");
            }
            int saltLen = DIGEST_LENGTHS.get(this.mdAlg);
            this.sigParams = new PSSParameterSpec(this.mdAlg, "MGF1", new MGF1ParameterSpec(this.mdAlg), saltLen, 1);
            this.mechanism.setParameter(new CK_RSA_PKCS_PSS_PARAMS(this.mdAlg, "MGF1", this.mdAlg, DIGEST_LENGTHS.get(this.mdAlg)));
        }
        if (!this.initialized) {
            this.initialize();
        }
    }

    private void reset(boolean doCancel) {
        if (!this.initialized) {
            return;
        }
        this.initialized = false;
        try {
            if (this.session == null) {
                return;
            }
            if (doCancel && this.token.explicitCancel) {
                this.cancelOperation();
            }
        }
        finally {
            this.p11Key.releaseKeyID();
            this.mechanism.freeHandle();
            this.session = this.token.releaseSession(this.session);
            this.isActive = false;
        }
    }

    private void cancelOperation() {
        block8: {
            this.token.ensureValid();
            try {
                if (this.mode == 1) {
                    if (this.type == 2) {
                        this.token.p11.C_SignFinal(this.session.id(), 0);
                    } else {
                        byte[] digest = this.md == null ? new byte[]{} : this.md.digest();
                        this.token.p11.C_Sign(this.session.id(), digest);
                    }
                } else {
                    byte[] signature = new byte[this.p11Key.length() + 7 >> 3];
                    if (this.type == 2) {
                        this.token.p11.C_VerifyFinal(this.session.id(), signature);
                    } else {
                        byte[] digest = this.md == null ? new byte[]{} : this.md.digest();
                        this.token.p11.C_Verify(this.session.id(), digest, signature);
                    }
                }
            }
            catch (PKCS11Exception e) {
                if (this.mode != 1) break block8;
                throw new ProviderException("cancel failed", e);
            }
        }
    }

    private void initialize() {
        if (this.p11Key == null) {
            throw new ProviderException("No Key found, call initSign/initVerify first");
        }
        long keyID = this.p11Key.getKeyID();
        try {
            if (this.session == null) {
                this.session = this.token.getOpSession();
            }
            if (this.mode == 1) {
                this.token.p11.C_SignInit(this.session.id(), this.mechanism, keyID);
            } else {
                this.token.p11.C_VerifyInit(this.session.id(), this.mechanism, keyID);
            }
        }
        catch (PKCS11Exception e) {
            this.p11Key.releaseKeyID();
            this.session = this.token.releaseSession(this.session);
            throw new ProviderException("Initialization failed", e);
        }
        if (this.bytesProcessed != 0) {
            this.bytesProcessed = 0;
            if (this.md != null) {
                this.md.reset();
            }
        }
        this.initialized = true;
        this.isActive = false;
    }

    private void checkKeySize(Key key) throws InvalidKeyException {
        if (!key.getAlgorithm().equals(KEY_ALGO)) {
            throw new InvalidKeyException("Only RSA keys are supported");
        }
        CK_MECHANISM_INFO mechInfo = null;
        try {
            mechInfo = this.token.getMechanismInfo(this.mechanism.mechanism);
        }
        catch (PKCS11Exception pKCS11Exception) {
            // empty catch block
        }
        int keySize = 0;
        if (mechInfo != null) {
            int minKeySize = (int)mechInfo.ulMinKeySize;
            int maxKeySize = (int)mechInfo.ulMaxKeySize;
            if (key instanceof P11Key) {
                keySize = ((P11Key)key).length() + 7 >> 3;
            } else if (key instanceof RSAKey) {
                keySize = ((RSAKey)((Object)key)).getModulus().bitLength() >> 3;
            } else {
                throw new InvalidKeyException("Unrecognized key type " + key);
            }
            if (minKeySize != -1 && keySize < minKeySize) {
                throw new InvalidKeyException("RSA key must be at least " + minKeySize + " bytes");
            }
            if (maxKeySize != -1 && keySize > maxKeySize) {
                throw new InvalidKeyException("RSA key must be at most " + maxKeySize + " bytes");
            }
        }
        if (this.sigParams != null) {
            int hLen;
            String digestAlg = this.sigParams.getDigestAlgorithm();
            int sLen = this.sigParams.getSaltLength();
            int minKeyLen = Math.addExact(Math.addExact(sLen, hLen = DIGEST_LENGTHS.get(digestAlg).intValue()), 2);
            if (keySize < minKeyLen) {
                throw new InvalidKeyException("Key is too short for current params, need min " + minKeyLen);
            }
        }
    }

    private void setSigParams(AlgorithmParameterSpec p) throws InvalidAlgorithmParameterException {
        int maxSaltLen;
        if (p == null) {
            throw new InvalidAlgorithmParameterException("PSS Parameter required");
        }
        if (!(p instanceof PSSParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Only PSSParameterSpec is supported");
        }
        PSSParameterSpec params = (PSSParameterSpec)p;
        if (params == this.sigParams) {
            return;
        }
        String digestAlgorithm = params.getDigestAlgorithm();
        if (this.mdAlg != null && !P11PSSSignature.isDigestEqual(digestAlgorithm, this.mdAlg)) {
            throw new InvalidAlgorithmParameterException("Digest algorithm in Signature parameters must be " + this.mdAlg);
        }
        Integer digestLen = DIGEST_LENGTHS.get(digestAlgorithm);
        if (digestLen == null) {
            throw new InvalidAlgorithmParameterException("Unsupported digest algorithm in Signature parameters: " + digestAlgorithm);
        }
        if (!params.getMGFAlgorithm().equalsIgnoreCase("MGF1")) {
            throw new InvalidAlgorithmParameterException("Only supports MGF1");
        }
        if (params.getTrailerField() != 1) {
            throw new InvalidAlgorithmParameterException("Only supports TrailerFieldBC(1)");
        }
        int saltLen = params.getSaltLength();
        if (this.p11Key != null && ((maxSaltLen = (this.p11Key.length() + 7 >> 3) - digestLen - 2) < 0 || saltLen > maxSaltLen)) {
            throw new InvalidAlgorithmParameterException("Invalid with current key size");
        }
        try {
            this.mechanism.setParameter(new CK_RSA_PKCS_PSS_PARAMS(digestAlgorithm, "MGF1", digestAlgorithm, saltLen));
            this.sigParams = params;
        }
        catch (IllegalArgumentException iae) {
            throw new InvalidAlgorithmParameterException(iae);
        }
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (publicKey == null) {
            throw new InvalidKeyException("Key must not be null");
        }
        if (publicKey != this.p11Key) {
            this.checkKeySize(publicKey);
        }
        this.reset(true);
        this.mode = 2;
        this.p11Key = P11KeyFactory.convertKey(this.token, publicKey, KEY_ALGO);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (privateKey == null) {
            throw new InvalidKeyException("Key must not be null");
        }
        if (privateKey != this.p11Key) {
            this.checkKeySize(privateKey);
        }
        this.reset(true);
        this.mode = 1;
        this.p11Key = P11KeyFactory.convertKey(this.token, privateKey, KEY_ALGO);
    }

    @Override
    protected void engineUpdate(byte b) throws SignatureException {
        this.ensureInitialized();
        this.isActive = true;
        this.buffer[0] = b;
        this.engineUpdate(this.buffer, 0, 1);
    }

    @Override
    protected void engineUpdate(byte[] b, int ofs, int len) throws SignatureException {
        this.ensureInitialized();
        if (len == 0) {
            return;
        }
        if (len + this.bytesProcessed < 0) {
            throw new ProviderException("Processed bytes limits exceeded.");
        }
        this.isActive = true;
        switch (this.type) {
            case 2: {
                try {
                    if (this.mode == 1) {
                        System.out.println(this + ": Calling C_SignUpdate");
                        this.token.p11.C_SignUpdate(this.session.id(), 0L, b, ofs, len);
                    } else {
                        System.out.println(this + ": Calling C_VerfifyUpdate");
                        this.token.p11.C_VerifyUpdate(this.session.id(), 0L, b, ofs, len);
                    }
                    this.bytesProcessed += len;
                    break;
                }
                catch (PKCS11Exception e) {
                    this.reset(false);
                    throw new ProviderException(e);
                }
            }
            case 1: {
                if (this.md == null) {
                    throw new ProviderException("PSS Parameters required");
                }
                this.md.update(b, ofs, len);
                this.bytesProcessed += len;
                break;
            }
            default: {
                throw new ProviderException("Internal error");
            }
        }
    }

    @Override
    protected void engineUpdate(ByteBuffer byteBuffer) {
        try {
            this.ensureInitialized();
        }
        catch (SignatureException se) {
            throw new ProviderException(se);
        }
        int len = byteBuffer.remaining();
        if (len <= 0) {
            return;
        }
        this.isActive = true;
        switch (this.type) {
            case 2: {
                if (!(byteBuffer instanceof DirectBuffer)) {
                    super.engineUpdate(byteBuffer);
                    return;
                }
                long addr = ((DirectBuffer)((Object)byteBuffer)).address();
                int ofs = byteBuffer.position();
                try {
                    if (this.mode == 1) {
                        System.out.println(this + ": Calling C_SignUpdate");
                        this.token.p11.C_SignUpdate(this.session.id(), addr + (long)ofs, null, 0, len);
                    } else {
                        System.out.println(this + ": Calling C_VerifyUpdate");
                        this.token.p11.C_VerifyUpdate(this.session.id(), addr + (long)ofs, null, 0, len);
                    }
                    this.bytesProcessed += len;
                    byteBuffer.position(ofs + len);
                    break;
                }
                catch (PKCS11Exception e) {
                    this.reset(false);
                    throw new ProviderException("Update failed", e);
                }
            }
            case 1: {
                if (this.md == null) {
                    throw new ProviderException("PSS Parameters required");
                }
                this.md.update(byteBuffer);
                this.bytesProcessed += len;
                break;
            }
            default: {
                this.reset(false);
                throw new ProviderException("Internal error");
            }
        }
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        this.ensureInitialized();
        boolean doCancel = true;
        try {
            byte[] signature;
            if (this.type == 2) {
                signature = this.token.p11.C_SignFinal(this.session.id(), 0);
            } else {
                if (this.md == null) {
                    throw new ProviderException("PSS Parameters required");
                }
                byte[] digest = this.md.digest();
                signature = this.token.p11.C_Sign(this.session.id(), digest);
            }
            doCancel = false;
            byte[] byArray = signature;
            return byArray;
        }
        catch (PKCS11Exception pe) {
            doCancel = false;
            throw new ProviderException(pe);
        }
        catch (ProviderException e) {
            throw e;
        }
        finally {
            this.reset(doCancel);
        }
    }

    @Override
    protected boolean engineVerify(byte[] signature) throws SignatureException {
        this.ensureInitialized();
        boolean doCancel = true;
        try {
            if (this.type == 2) {
                this.token.p11.C_VerifyFinal(this.session.id(), signature);
            } else {
                if (this.md == null) {
                    throw new ProviderException("PSS Parameters required");
                }
                byte[] digest = this.md.digest();
                this.token.p11.C_Verify(this.session.id(), digest, signature);
            }
            doCancel = false;
            boolean digest = true;
            return digest;
        }
        catch (PKCS11Exception pe) {
            doCancel = false;
            long errorCode = pe.getErrorCode();
            if (errorCode == 192L) {
                boolean bl = false;
                return bl;
            }
            if (errorCode == 193L) {
                boolean bl = false;
                return bl;
            }
            if (errorCode == 33L) {
                boolean bl = false;
                return bl;
            }
            throw new ProviderException(pe);
        }
        catch (ProviderException e) {
            throw e;
        }
        finally {
            this.reset(doCancel);
        }
    }

    @Override
    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
        throw new UnsupportedOperationException("setParameter() not supported");
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        if (this.isActive) {
            throw new ProviderException("Cannot set parameters during operations");
        }
        this.setSigParams(params);
        if (this.type == 1) {
            try {
                this.md = MessageDigest.getInstance(this.sigParams.getDigestAlgorithm());
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new InvalidAlgorithmParameterException(nsae);
            }
        }
    }

    @Override
    protected Object engineGetParameter(String param) throws InvalidParameterException {
        throw new UnsupportedOperationException("getParameter() not supported");
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        if (this.sigParams != null) {
            try {
                AlgorithmParameters ap = AlgorithmParameters.getInstance("RSASSA-PSS");
                ap.init(this.sigParams);
                return ap;
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    static {
        DIGEST_LENGTHS.put("SHA-1", 20);
        DIGEST_LENGTHS.put("SHA", 20);
        DIGEST_LENGTHS.put("SHA1", 20);
        DIGEST_LENGTHS.put("SHA-224", 28);
        DIGEST_LENGTHS.put("SHA224", 28);
        DIGEST_LENGTHS.put("SHA-256", 32);
        DIGEST_LENGTHS.put("SHA256", 32);
        DIGEST_LENGTHS.put("SHA-384", 48);
        DIGEST_LENGTHS.put("SHA384", 48);
        DIGEST_LENGTHS.put("SHA-512", 64);
        DIGEST_LENGTHS.put("SHA512", 64);
        DIGEST_LENGTHS.put("SHA-512/224", 28);
        DIGEST_LENGTHS.put("SHA512/224", 28);
        DIGEST_LENGTHS.put("SHA-512/256", 32);
        DIGEST_LENGTHS.put("SHA512/256", 32);
    }
}

