/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.ProviderException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.MacSpi;
import sun.nio.ch.DirectBuffer;
import sun.security.pkcs11.P11Key;
import sun.security.pkcs11.P11SecretKeyFactory;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.CK_MECHANISM;
import sun.security.pkcs11.wrapper.PKCS11Exception;

final class P11Mac
extends MacSpi {
    private final Token token;
    private final String algorithm;
    private final CK_MECHANISM ckMechanism;
    private final int macLength;
    private P11Key p11Key;
    private Session session;
    private boolean initialized;
    private byte[] oneByte;

    P11Mac(Token token, String algorithm, long mechanism) throws PKCS11Exception {
        this.token = token;
        this.algorithm = algorithm;
        Long params = null;
        switch ((int)mechanism) {
            case 529: {
                this.macLength = 16;
                break;
            }
            case 545: {
                this.macLength = 20;
                break;
            }
            case 598: {
                this.macLength = 28;
                break;
            }
            case 593: {
                this.macLength = 32;
                break;
            }
            case 609: {
                this.macLength = 48;
                break;
            }
            case 625: {
                this.macLength = 64;
                break;
            }
            case 896: {
                this.macLength = 16;
                params = 16L;
                break;
            }
            case 897: {
                this.macLength = 20;
                params = 20L;
                break;
            }
            default: {
                throw new ProviderException("Unknown mechanism: " + mechanism);
            }
        }
        this.ckMechanism = new CK_MECHANISM(mechanism, params);
    }

    private void reset(boolean doCancel) {
        if (!this.initialized) {
            return;
        }
        this.initialized = false;
        try {
            if (this.session == null) {
                return;
            }
            if (doCancel && this.token.explicitCancel) {
                this.cancelOperation();
            }
        }
        finally {
            this.p11Key.releaseKeyID();
            this.session = this.token.releaseSession(this.session);
        }
    }

    private void cancelOperation() {
        this.token.ensureValid();
        try {
            this.token.p11.C_SignFinal(this.session.id(), 0);
        }
        catch (PKCS11Exception e) {
            throw new ProviderException("Cancel failed", e);
        }
    }

    private void ensureInitialized() throws PKCS11Exception {
        if (!this.initialized) {
            this.initialize();
        }
    }

    private void initialize() throws PKCS11Exception {
        if (this.p11Key == null) {
            throw new ProviderException("Operation cannot be performed without calling engineInit first");
        }
        this.token.ensureValid();
        long p11KeyID = this.p11Key.getKeyID();
        try {
            if (this.session == null) {
                this.session = this.token.getOpSession();
            }
            this.token.p11.C_SignInit(this.session.id(), this.ckMechanism, p11KeyID);
        }
        catch (PKCS11Exception e) {
            this.p11Key.releaseKeyID();
            this.session = this.token.releaseSession(this.session);
            throw e;
        }
        this.initialized = true;
    }

    @Override
    protected int engineGetMacLength() {
        return this.macLength;
    }

    @Override
    protected void engineReset() {
        this.reset(true);
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (params != null) {
            throw new InvalidAlgorithmParameterException("Parameters not supported");
        }
        this.reset(true);
        this.p11Key = P11SecretKeyFactory.convertKey(this.token, key, this.algorithm);
        try {
            this.initialize();
        }
        catch (PKCS11Exception e) {
            throw new InvalidKeyException("init() failed", e);
        }
    }

    @Override
    protected byte[] engineDoFinal() {
        try {
            this.ensureInitialized();
            byte[] byArray = this.token.p11.C_SignFinal(this.session.id(), 0);
            return byArray;
        }
        catch (PKCS11Exception e) {
            throw new ProviderException("doFinal() failed", e);
        }
        finally {
            this.reset(false);
        }
    }

    @Override
    protected void engineUpdate(byte input) {
        if (this.oneByte == null) {
            this.oneByte = new byte[1];
        }
        this.oneByte[0] = input;
        this.engineUpdate(this.oneByte, 0, 1);
    }

    @Override
    protected void engineUpdate(byte[] b, int ofs, int len) {
        try {
            this.ensureInitialized();
            this.token.p11.C_SignUpdate(this.session.id(), 0L, b, ofs, len);
        }
        catch (PKCS11Exception e) {
            throw new ProviderException("update() failed", e);
        }
    }

    @Override
    protected void engineUpdate(ByteBuffer byteBuffer) {
        try {
            this.ensureInitialized();
            int len = byteBuffer.remaining();
            if (len <= 0) {
                return;
            }
            if (!(byteBuffer instanceof DirectBuffer)) {
                super.engineUpdate(byteBuffer);
                return;
            }
            long addr = ((DirectBuffer)((Object)byteBuffer)).address();
            int ofs = byteBuffer.position();
            this.token.p11.C_SignUpdate(this.session.id(), addr + (long)ofs, null, 0, len);
            byteBuffer.position(ofs + len);
        }
        catch (PKCS11Exception e) {
            throw new ProviderException("update() failed", e);
        }
    }
}

