/**
 * @license Angular UI Tree v2.4.0
 * (c) 2010-2015. https://github.com/angular-ui-tree/angular-ui-tree
 * License: MIT
 */
!function(){"use strict";angular.module("ui.tree",[]).constant("treeConfig",{treeClass:"angular-ui-tree",emptyTreeClass:"angular-ui-tree-empty",hiddenClass:"angular-ui-tree-hidden",nodesClass:"angular-ui-tree-nodes",nodeClass:"angular-ui-tree-node",handleClass:"angular-ui-tree-handle",placeHolderClass:"angular-ui-tree-placeholder",dragClass:"angular-ui-tree-drag",dragThreshold:3,levelThreshold:30})}(),function(){"use strict";angular.module("ui.tree").controller("TreeHandleController",["$scope","$element",function(e,n){this.scope=e,e.$element=n,e.$nodeScope=null,e.$type="uiTreeHandle"}])}(),function(){"use strict";angular.module("ui.tree").controller("TreeNodeController",["$scope","$element",function(e,n){function t(e){var n,l,r=0,i=e.childNodes();for(n=0;n<i.length;n++)l=i[n].$childNodesScope,l&&(r=1,t(l));o+=r}this.scope=e,e.$element=n,e.$modelValue=null,e.$parentNodeScope=null,e.$childNodesScope=null,e.$parentNodesScope=null,e.$treeScope=null,e.$handleScope=null,e.$type="uiTreeNode",e.$$apply=!1,e.collapsed=!1,e.init=function(t){var o=t[0];e.$treeScope=t[1]?t[1].scope:null,e.$parentNodeScope=o.scope.$nodeScope,e.$modelValue=o.scope.$modelValue[e.$index],e.$parentNodesScope=o.scope,o.scope.initSubNode(e),n.on("$destroy",function(){o.scope.destroySubNode(e)})},e.index=function(){return e.$parentNodesScope.$modelValue.indexOf(e.$modelValue)},e.dragEnabled=function(){return!(e.$treeScope&&!e.$treeScope.dragEnabled)},e.isSibling=function(n){return e.$parentNodesScope==n.$parentNodesScope},e.isChild=function(n){var t=e.childNodes();return t&&t.indexOf(n)>-1},e.prev=function(){var n=e.index();return n>0?e.siblings()[n-1]:null},e.siblings=function(){return e.$parentNodesScope.childNodes()},e.childNodesCount=function(){return e.childNodes()?e.childNodes().length:0},e.hasChild=function(){return e.childNodesCount()>0},e.childNodes=function(){return e.$childNodesScope&&e.$childNodesScope.$modelValue?e.$childNodesScope.childNodes():null},e.accept=function(n,t){return e.$childNodesScope&&e.$childNodesScope.$modelValue&&e.$childNodesScope.accept(n,t)},e.removeNode=function(){var n=e.remove();return e.$callbacks.removed(n),n},e.remove=function(){return e.$parentNodesScope.removeNode(e)},e.toggle=function(){e.collapsed=!e.collapsed},e.collapse=function(){e.collapsed=!0},e.expand=function(){e.collapsed=!1},e.depth=function(){var n=e.$parentNodeScope;return n?n.depth()+1:1};var o=0;e.maxSubDepth=function(){return o=0,e.$childNodesScope&&t(e.$childNodesScope),o}}])}(),function(){"use strict";angular.module("ui.tree").controller("TreeNodesController",["$scope","$element",function(e,n){this.scope=e,e.$element=n,e.$modelValue=null,e.$nodeScope=null,e.$treeScope=null,e.$type="uiTreeNodes",e.$nodesMap={},e.nodropEnabled=!1,e.maxDepth=0,e.cloneEnabled=!1,e.initSubNode=function(n){return n.$modelValue?void(e.$nodesMap[n.$modelValue.$$hashKey]=n):null},e.destroySubNode=function(n){return n.$modelValue?void(e.$nodesMap[n.$modelValue.$$hashKey]=null):null},e.accept=function(n,t){return e.$treeScope.$callbacks.accept(n,e,t)},e.beforeDrag=function(n){return e.$treeScope.$callbacks.beforeDrag(n)},e.isParent=function(n){return n.$parentNodesScope==e},e.hasChild=function(){return e.$modelValue.length>0},e.safeApply=function(e){var n=this.$root.$$phase;"$apply"==n||"$digest"==n?e&&"function"==typeof e&&e():this.$apply(e)},e.removeNode=function(n){var t=e.$modelValue.indexOf(n.$modelValue);return t>-1?(e.safeApply(function(){e.$modelValue.splice(t,1)[0]}),n):null},e.insertNode=function(n,t){e.safeApply(function(){e.$modelValue.splice(n,0,t)})},e.childNodes=function(){var n,t=[];if(e.$modelValue)for(n=0;n<e.$modelValue.length;n++)t.push(e.$nodesMap[e.$modelValue[n].$$hashKey]);return t},e.depth=function(){return e.$nodeScope?e.$nodeScope.depth():0},e.outOfDepth=function(n){var t=e.maxDepth||e.$treeScope.maxDepth;return t>0?e.depth()+n.maxSubDepth()+1>t:!1}}])}(),function(){"use strict";angular.module("ui.tree").controller("TreeController",["$scope","$element",function(e,n){this.scope=e,e.$element=n,e.$nodesScope=null,e.$type="uiTree",e.$emptyElm=null,e.$callbacks=null,e.dragEnabled=!0,e.emptyPlaceHolderEnabled=!0,e.maxDepth=0,e.dragDelay=0,e.cloneEnabled=!1,e.nodropEnabled=!1,e.isEmpty=function(){return e.$nodesScope&&e.$nodesScope.$modelValue&&0===e.$nodesScope.$modelValue.length},e.place=function(n){e.$nodesScope.$element.append(n),e.$emptyElm.remove()},e.resetEmptyElement=function(){0===e.$nodesScope.$modelValue.length&&e.emptyPlaceHolderEnabled?n.append(e.$emptyElm):e.$emptyElm.remove()};var t=function(e,n){var o,l,r=e.childNodes();for(o=0;o<r.length;o++)n?r[o].collapse():r[o].expand(),l=r[o].$childNodesScope,l&&t(l,n)};e.collapseAll=function(){t(e.$nodesScope,!0)},e.expandAll=function(){t(e.$nodesScope,!1)}}])}(),function(){"use strict";angular.module("ui.tree").directive("uiTree",["treeConfig","$window",function(e,n){return{restrict:"A",scope:!0,controller:"TreeController",link:function(t,o,l){var r={accept:null,beforeDrag:null},i={};angular.extend(i,e),i.treeClass&&o.addClass(i.treeClass),t.$emptyElm=angular.element(n.document.createElement("div")),i.emptyTreeClass&&t.$emptyElm.addClass(i.emptyTreeClass),t.$watch("$nodesScope.$modelValue.length",function(){t.$nodesScope.$modelValue&&t.resetEmptyElement()},!0),t.$watch(l.dragEnabled,function(e){"boolean"==typeof e&&(t.dragEnabled=e)}),t.$watch(l.emptyPlaceHolderEnabled,function(e){"boolean"==typeof e&&(t.emptyPlaceHolderEnabled=e)}),t.$watch(l.nodropEnabled,function(e){"boolean"==typeof e&&(t.nodropEnabled=e)}),t.$watch(l.cloneEnabled,function(e){"boolean"==typeof e&&(t.cloneEnabled=e)}),t.$watch(l.maxDepth,function(e){"number"==typeof e&&(t.maxDepth=e)}),t.$watch(l.dragDelay,function(e){"number"==typeof e&&(t.dragDelay=e)}),r.accept=function(e,n,t){return n.nodropEnabled||n.outOfDepth(e)?!1:!0},r.beforeDrag=function(e){return!0},r.removed=function(e){},r.dropped=function(e){},r.dragStart=function(e){},r.dragMove=function(e){},r.dragStop=function(e){},r.beforeDrop=function(e){},t.$watch(l.uiTree,function(e,n){angular.forEach(e,function(e,n){r[n]&&"function"==typeof e&&(r[n]=e)}),t.$callbacks=r},!0)}}}])}(),function(){"use strict";angular.module("ui.tree").directive("uiTreeHandle",["treeConfig",function(e){return{require:"^uiTreeNode",restrict:"A",scope:!0,controller:"TreeHandleController",link:function(n,t,o,l){var r={};angular.extend(r,e),r.handleClass&&t.addClass(r.handleClass),n!=l.scope&&(n.$nodeScope=l.scope,l.scope.$handleScope=n)}}}])}(),function(){"use strict";angular.module("ui.tree").directive("uiTreeNode",["treeConfig","$uiTreeHelper","$window","$document","$timeout",function(e,n,t,o,l){return{require:["^uiTreeNodes","^uiTree"],restrict:"A",controller:"TreeNodeController",link:function(r,i,a,d){var c,s,u,p,f,$,m,h,g,b,y,S,v,N,x,C,E,T,w,D={},X="ontouchstart"in window,Y=null,A=document.body,V=document.documentElement;angular.extend(D,e),D.nodeClass&&i.addClass(D.nodeClass),r.init(d),r.collapsed=!!n.getNodeAttribute(r,"collapsed"),r.$watch(a.collapsed,function(e){"boolean"==typeof e&&(r.collapsed=e)}),r.$watch("collapsed",function(e){n.setNodeAttribute(r,"collapsed",e),a.$set("collapsed",e)}),b=function(e){if((X||2!=e.button&&3!=e.which)&&!(e.uiTreeDragging||e.originalEvent&&e.originalEvent.uiTreeDragging)){var l,a,d,b,y,S=angular.element(e.target),v=S.scope();if(v&&v.$type&&!("uiTreeNode"!=v.$type&&"uiTreeHandle"!=v.$type||"uiTreeNode"==v.$type&&v.$handleScope||(l=S.prop("tagName").toLowerCase(),"input"==l||"textarea"==l||"button"==l||"select"==l))){for(;S&&S[0]&&S[0]!=i;){if(n.nodrag(S))return;S=S.parent()}r.beforeDrag(r)&&(e.uiTreeDragging=!0,e.originalEvent&&(e.originalEvent.uiTreeDragging=!0),e.preventDefault(),d=n.eventObj(e),c=!0,s=n.dragInfo(r),r.$apply(function(){r.$treeScope.$callbacks.dragStart(s.eventArgs(m,u))}),a=r.$element.prop("tagName"),"tr"===a.toLowerCase()?(p=angular.element(t.document.createElement(a)),b=angular.element(t.document.createElement("td")).addClass(D.placeHolderClass),p.append(b)):p=angular.element(t.document.createElement(a)).addClass(D.placeHolderClass),f=angular.element(t.document.createElement(a)),D.hiddenClass&&f.addClass(D.hiddenClass),u=n.positionStarted(d,r.$element),p.css("height",n.height(r.$element)+"px"),$=angular.element(t.document.createElement(r.$parentNodesScope.$element.prop("tagName"))).addClass(r.$parentNodesScope.$element.attr("class")).addClass(D.dragClass),$.css("width",n.width(r.$element)+"px"),$.css("z-index",9999),y=(r.$element[0].querySelector(".angular-ui-tree-handle")||r.$element[0]).currentStyle,y&&(document.body.setAttribute("ui-tree-cursor",o.find("body").css("cursor")||""),o.find("body").css({cursor:y.cursor+"!important"})),r.$element.after(p),r.$element.after(f),$.append(r.$element),o.find("body").append($),$.css({left:d.pageX-u.offsetX+"px",top:d.pageY-u.offsetY+"px"}),m={placeholder:p,dragging:$},angular.element(o).bind("touchend",x),angular.element(o).bind("touchcancel",x),angular.element(o).bind("touchmove",N),angular.element(o).bind("mouseup",x),angular.element(o).bind("mousemove",N),angular.element(o).bind("mouseleave",C),h=Math.max(A.scrollHeight,A.offsetHeight,V.clientHeight,V.scrollHeight,V.offsetHeight),g=Math.max(A.scrollWidth,A.offsetWidth,V.clientWidth,V.scrollWidth,V.offsetWidth))}}},y=function(e){var o,l,i,a,d,f,b,y,S,v,N,x,C,E,T,w,X=n.eventObj(e);if($){if(e.preventDefault(),t.getSelection?t.getSelection().removeAllRanges():t.document.selection&&t.document.selection.empty(),i=X.pageX-u.offsetX,a=X.pageY-u.offsetY,0>i&&(i=0),0>a&&(a=0),a+10>h&&(a=h-10),i+10>g&&(i=g-10),$.css({left:i+"px",top:a+"px"}),d=window.pageYOffset||t.document.documentElement.scrollTop,f=d+(window.innerHeight||t.document.clientHeight||t.document.clientHeight),f<X.pageY&&h>=f&&window.scrollBy(0,10),d>X.pageY&&window.scrollBy(0,-10),n.positionMoved(e,u,c),c)return void(c=!1);if(u.dirAx&&u.distAxX>=D.levelThreshold&&(u.distAxX=0,u.distX>0&&(o=s.prev(),o&&!o.collapsed&&o.accept(r,o.childNodesCount())&&(o.$childNodesScope.$element.append(p),s.moveTo(o.$childNodesScope,o.childNodes(),o.childNodesCount()))),u.distX<0&&(l=s.next(),l||(b=s.parentNode(),b&&b.$parentNodesScope.accept(r,b.index()+1)&&(b.$element.after(p),s.moveTo(b.$parentNodesScope,b.siblings(),b.index()+1))))),y=n.offset($).left-n.offset(p).left>=D.threshold,S=X.pageX-t.document.body.scrollLeft,v=X.pageY-(window.pageYOffset||t.document.documentElement.scrollTop),angular.isFunction($.hide)?$.hide():(N=$[0].style.display,$[0].style.display="none"),t.document.elementFromPoint(S,v),C=angular.element(t.document.elementFromPoint(S,v)),angular.isFunction($.show)?$.show():$[0].style.display=N,!u.dirAx){if(x=C.scope(),E=!1,!x)return;if("uiTree"==x.$type&&x.dragEnabled&&(E=x.isEmpty()),"uiTreeHandle"==x.$type&&(x=x.$nodeScope),"uiTreeNode"!=x.$type&&!E)return;Y&&p.parent()[0]!=Y.$element[0]&&(Y.resetEmptyElement(),Y=null),E?(Y=x,x.$nodesScope.accept(r,0)&&(x.place(p),s.moveTo(x.$nodesScope,x.$nodesScope.childNodes(),0))):x.dragEnabled()&&(C=x.$element,T=n.offset(C),w=x.horizontal?X.pageX<T.left+n.width(C)/2:X.pageY<T.top+n.height(C)/2,x.$parentNodesScope.accept(r,x.index())?w?(C[0].parentNode.insertBefore(p[0],C[0]),s.moveTo(x.$parentNodesScope,x.siblings(),x.index())):(C.after(p),s.moveTo(x.$parentNodesScope,x.siblings(),x.index()+1)):!w&&x.accept(r,x.childNodesCount())&&(x.$childNodesScope.$element.append(p),s.moveTo(x.$childNodesScope,x.childNodes(),x.childNodesCount())))}r.$apply(function(){r.$treeScope.$callbacks.dragMove(s.eventArgs(m,u))})}},S=function(e){e.preventDefault(),$&&(r.$treeScope.$apply(function(){r.$treeScope.$callbacks.beforeDrop(s.eventArgs(m,u))}),f.replaceWith(r.$element),p.remove(),$.remove(),$=null,r.$$apply?r.$treeScope.$apply(function(){s.apply(),r.$treeScope.$callbacks.dropped(s.eventArgs(m,u))}):T(),r.$treeScope.$apply(function(){r.$treeScope.$callbacks.dragStop(s.eventArgs(m,u))}),r.$$apply=!1,s=null);var n=document.body.getAttribute("ui-tree-cursor");null!==n&&(o.find("body").css({cursor:n}),document.body.removeAttribute("ui-tree-cursor")),angular.element(o).unbind("touchend",x),angular.element(o).unbind("touchcancel",x),angular.element(o).unbind("touchmove",N),angular.element(o).unbind("mouseup",x),angular.element(o).unbind("mousemove",N),angular.element(t.document.body).unbind("mouseleave",C)},v=function(e){r.dragEnabled()&&b(e)},N=function(e){y(e)},x=function(e){r.$$apply=!0,S(e)},C=function(e){S(e)},E=function(){var e;return{exec:function(n,t){t||(t=0),this.cancel(),e=l(n,t)},cancel:function(){l.cancel(e)}}}(),T=function(){i.bind("touchstart mousedown",function(e){E.exec(function(){v(e)},r.dragDelay||0)}),i.bind("touchend touchcancel mouseup",function(){E.cancel()})},T(),w=function(e){27==e.keyCode&&(r.$$apply=!1,S(e))},angular.element(t.document.body).bind("keydown",w),r.$on("$destroy",function(){angular.element(t.document.body).unbind("keydown",w)})}}}])}(),function(){"use strict";angular.module("ui.tree").directive("uiTreeNodes",["treeConfig","$window",function(e){return{require:["ngModel","?^uiTreeNode","^uiTree"],restrict:"A",scope:!0,controller:"TreeNodesController",link:function(n,t,o,l){var r={},i=l[0],a=l[1],d=l[2];angular.extend(r,e),r.nodesClass&&t.addClass(r.nodesClass),a?(a.scope.$childNodesScope=n,n.$nodeScope=a.scope):d.scope.$nodesScope=n,n.$treeScope=d.scope,i&&(i.$render=function(){i.$modelValue&&angular.isArray(i.$modelValue)||(n.$modelValue=[]),n.$modelValue=i.$modelValue}),n.$watch(o.maxDepth,function(e){"number"==typeof e&&(n.maxDepth=e)}),n.$watch(function(){return o.nodropEnabled},function(e){"undefined"!=typeof e&&(n.nodropEnabled=!0)},!0),o.$observe("horizontal",function(e){n.horizontal="undefined"!=typeof e})}}}])}(),function(){"use strict";angular.module("ui.tree").factory("$uiTreeHelper",["$document","$window",function(e,n){return{nodesData:{},setNodeAttribute:function(e,n,t){if(!e.$modelValue)return null;var o=this.nodesData[e.$modelValue.$$hashKey];o||(o={},this.nodesData[e.$modelValue.$$hashKey]=o),o[n]=t},getNodeAttribute:function(e,n){if(!e.$modelValue)return null;var t=this.nodesData[e.$modelValue.$$hashKey];return t?t[n]:null},nodrag:function(e){return"undefined"!=typeof e.attr("data-nodrag")?"false"===e.attr("data-nodrag")?!1:!0:!1},eventObj:function(e){var n=e;return void 0!==e.targetTouches?n=e.targetTouches.item(0):void 0!==e.originalEvent&&void 0!==e.originalEvent.targetTouches&&(n=e.originalEvent.targetTouches.item(0)),n},dragInfo:function(e){return{source:e,sourceInfo:{nodeScope:e,index:e.index(),nodesScope:e.$parentNodesScope},index:e.index(),siblings:e.siblings().slice(0),parent:e.$parentNodesScope,moveTo:function(e,n,t){this.parent=e,this.siblings=n.slice(0);var o=this.siblings.indexOf(this.source);o>-1&&(this.siblings.splice(o,1),this.source.index()<t&&t--),this.siblings.splice(t,0,this.source),this.index=t},parentNode:function(){return this.parent.$nodeScope},prev:function(){return this.index>0?this.siblings[this.index-1]:null},next:function(){return this.index<this.siblings.length-1?this.siblings[this.index+1]:null},isDirty:function(){return this.source.$parentNodesScope!=this.parent||this.source.index()!=this.index},eventArgs:function(e,n){return{source:this.sourceInfo,dest:{index:this.index,nodesScope:this.parent},elements:e,pos:n}},apply:function(){if(this.parent.$treeScope.nodropEnabled!==!0){var e=this.source.$modelValue;if(this.source.$treeScope.cloneEnabled!==!0&&this.source.remove(),this.source.$treeScope.cloneEnabled===!0&&this.source.$treeScope===this.parent.$treeScope)return!1;this.parent.insertNode(this.index,e)}}}},height:function(e){return e.prop("scrollHeight")},width:function(e){return e.prop("scrollWidth")},offset:function(t){var o=t[0].getBoundingClientRect();return{width:t.prop("offsetWidth"),height:t.prop("offsetHeight"),top:o.top+(n.pageYOffset||e[0].body.scrollTop||e[0].documentElement.scrollTop),left:o.left+(n.pageXOffset||e[0].body.scrollLeft||e[0].documentElement.scrollLeft)}},positionStarted:function(e,n){var t={};return t.offsetX=e.pageX-this.offset(n).left,t.offsetY=e.pageY-this.offset(n).top,t.startX=t.lastX=e.pageX,t.startY=t.lastY=e.pageY,t.nowX=t.nowY=t.distX=t.distY=t.dirAx=0,t.dirX=t.dirY=t.lastDirX=t.lastDirY=t.distAxX=t.distAxY=0,t},positionMoved:function(e,n,t){n.lastX=n.nowX,n.lastY=n.nowY,n.nowX=e.pageX,n.nowY=e.pageY,n.distX=n.nowX-n.lastX,n.distY=n.nowY-n.lastY,n.lastDirX=n.dirX,n.lastDirY=n.dirY,n.dirX=0===n.distX?0:n.distX>0?1:-1,n.dirY=0===n.distY?0:n.distY>0?1:-1;var o=Math.abs(n.distX)>Math.abs(n.distY)?1:0;return t?(n.dirAx=o,void(n.moving=!0)):(n.dirAx!==o?(n.distAxX=0,n.distAxY=0):(n.distAxX+=Math.abs(n.distX),0!==n.dirX&&n.dirX!==n.lastDirX&&(n.distAxX=0),n.distAxY+=Math.abs(n.distY),0!==n.dirY&&n.dirY!==n.lastDirY&&(n.distAxY=0)),void(n.dirAx=o))}}}])}();