/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.store;

import java.io.IOException;
import java.io.Serializable;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.XPackClientActionPlugin;
import org.elasticsearch.xpack.core.security.ScrollHelper;
import org.elasticsearch.xpack.core.security.SecurityField;
import org.elasticsearch.xpack.core.security.action.role.ClearRolesCacheRequest;
import org.elasticsearch.xpack.core.security.action.role.ClearRolesCacheResponse;
import org.elasticsearch.xpack.core.security.action.role.DeleteRoleRequest;
import org.elasticsearch.xpack.core.security.action.role.PutRoleRequest;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.client.SecurityClient;
import org.elasticsearch.xpack.security.support.SecurityIndexManager;

public class NativeRolesStore
extends AbstractComponent {
    private static final Setting<Integer> CACHE_SIZE_SETTING = Setting.intSetting((String)SecurityField.setting((String)"authz.store.roles.index.cache.max_size"), (int)10000, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Deprecated});
    private static final Setting<TimeValue> CACHE_TTL_SETTING = Setting.timeSetting((String)SecurityField.setting((String)"authz.store.roles.index.cache.ttl"), (TimeValue)TimeValue.timeValueMinutes((long)20L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Deprecated});
    private static final String ROLE_DOC_TYPE = "doc";
    private final Client client;
    private final XPackLicenseState licenseState;
    private final boolean isTribeNode;
    private SecurityClient securityClient;
    private final SecurityIndexManager securityIndex;

    public NativeRolesStore(Settings settings, Client client, XPackLicenseState licenseState, SecurityIndexManager securityIndex) {
        super(settings);
        this.client = client;
        this.isTribeNode = XPackClientActionPlugin.isTribeNode((Settings)settings);
        this.securityClient = new SecurityClient((ElasticsearchClient)client);
        this.licenseState = licenseState;
        this.securityIndex = securityIndex;
    }

    public void getRoleDescriptors(String[] names, ActionListener<Collection<RoleDescriptor>> listener) {
        if (!this.securityIndex.indexExists()) {
            listener.onResponse(Collections.emptyList());
        } else if (names != null && names.length == 1) {
            this.getRoleDescriptor(Objects.requireNonNull(names[0]), (ActionListener<RoleDescriptor>)ActionListener.wrap(roleDescriptor -> listener.onResponse(roleDescriptor == null ? Collections.emptyList() : Collections.singletonList(roleDescriptor)), arg_0 -> listener.onFailure(arg_0)));
        } else {
            this.securityIndex.prepareIndexIfNeededThenExecute(arg_0 -> listener.onFailure(arg_0), () -> {
                TermQueryBuilder query;
                if (names == null || names.length == 0) {
                    query = QueryBuilders.termQuery((String)RoleDescriptor.Fields.TYPE.getPreferredName(), (String)"role");
                } else {
                    String[] roleNames = (String[])Arrays.stream(names).map(s -> NativeRolesStore.getIdForUser(s)).toArray(String[]::new);
                    query = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.idsQuery((String[])new String[]{ROLE_DOC_TYPE}).addIds(roleNames));
                }
                Supplier supplier = this.client.threadPool().getThreadContext().newRestorableContext(false);
                try (ThreadContext.StoredContext ignore = ClientHelper.stashWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security");){
                    SearchRequest request = (SearchRequest)this.client.prepareSearch(new String[]{".security"}).setScroll((TimeValue)SearchService.DEFAULT_KEEPALIVE_SETTING.get(this.settings)).setQuery((QueryBuilder)query).setSize(1000).setFetchSource(true).request();
                    request.indicesOptions().ignoreUnavailable();
                    ScrollHelper.fetchAllByEntity((Client)this.client, (SearchRequest)request, (ActionListener)new ContextPreservingActionListener(supplier, listener), hit -> NativeRolesStore.transformRole(hit.getId(), hit.getSourceRef(), this.logger, this.licenseState));
                }
            });
        }
    }

    public void deleteRole(final DeleteRoleRequest deleteRoleRequest, final ActionListener<Boolean> listener) {
        if (this.isTribeNode) {
            listener.onFailure((Exception)new UnsupportedOperationException("roles may not be deleted using a tribe node"));
        } else {
            this.securityIndex.prepareIndexIfNeededThenExecute(arg_0 -> listener.onFailure(arg_0), () -> {
                DeleteRequest request = (DeleteRequest)this.client.prepareDelete(".security", ROLE_DOC_TYPE, NativeRolesStore.getIdForUser(deleteRoleRequest.name())).request();
                request.setRefreshPolicy(deleteRoleRequest.getRefreshPolicy());
                ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (ActionRequest)request, (ActionListener)new ActionListener<DeleteResponse>(){

                    public void onResponse(DeleteResponse deleteResponse) {
                        NativeRolesStore.this.clearRoleCache(deleteRoleRequest.name(), listener, deleteResponse.getResult() == DocWriteResponse.Result.DELETED);
                    }

                    public void onFailure(Exception e) {
                        NativeRolesStore.this.logger.error("failed to delete role from the index", (Throwable)e);
                        listener.onFailure(e);
                    }
                }, (arg_0, arg_1) -> ((Client)this.client).delete(arg_0, arg_1));
            });
        }
    }

    public void putRole(PutRoleRequest request, RoleDescriptor role, ActionListener<Boolean> listener) {
        if (this.isTribeNode) {
            listener.onFailure((Exception)new UnsupportedOperationException("roles may not be created or modified using a tribe node"));
        } else if (this.licenseState.isDocumentAndFieldLevelSecurityAllowed()) {
            this.innerPutRole(request, role, listener);
        } else if (role.isUsingDocumentOrFieldLevelSecurity()) {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"field and document level security"));
        } else {
            this.innerPutRole(request, role, listener);
        }
    }

    void innerPutRole(final PutRoleRequest request, final RoleDescriptor role, final ActionListener<Boolean> listener) {
        this.securityIndex.prepareIndexIfNeededThenExecute(arg_0 -> listener.onFailure(arg_0), () -> {
            XContentBuilder xContentBuilder;
            try {
                xContentBuilder = role.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS, true);
            }
            catch (IOException e) {
                listener.onFailure((Exception)e);
                return;
            }
            final IndexRequest indexRequest = (IndexRequest)((IndexRequestBuilder)this.client.prepareIndex(".security", ROLE_DOC_TYPE, NativeRolesStore.getIdForUser(role.getName())).setSource(xContentBuilder).setRefreshPolicy(request.getRefreshPolicy())).request();
            ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (ActionRequest)indexRequest, (ActionListener)new ActionListener<IndexResponse>(){

                public void onResponse(IndexResponse indexResponse) {
                    boolean created = indexResponse.getResult() == DocWriteResponse.Result.CREATED;
                    NativeRolesStore.this.logger.trace("Created role: [{}]", (Object)indexRequest);
                    NativeRolesStore.this.clearRoleCache(role.getName(), listener, created);
                }

                public void onFailure(Exception e) {
                    NativeRolesStore.this.logger.error((Message)new ParameterizedMessage("failed to put role [{}]", (Object)request.name()), (Throwable)e);
                    listener.onFailure(e);
                }
            }, (arg_0, arg_1) -> ((Client)this.client).index(arg_0, arg_1));
        });
    }

    public void usageStats(final ActionListener<Map<String, Object>> listener) {
        final HashMap<String, Constable> usageStats = new HashMap<String, Constable>(3);
        if (!this.securityIndex.indexExists()) {
            usageStats.put("size", Long.valueOf(0L));
            usageStats.put("fls", Boolean.valueOf(false));
            usageStats.put("dls", Boolean.valueOf(false));
            listener.onResponse(usageStats);
        } else {
            this.securityIndex.prepareIndexIfNeededThenExecute(arg_0 -> listener.onFailure(arg_0), () -> ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (ActionRequest)((MultiSearchRequest)this.client.prepareMultiSearch().add(this.client.prepareSearch(new String[]{".security"}).setQuery((QueryBuilder)QueryBuilders.termQuery((String)RoleDescriptor.Fields.TYPE.getPreferredName(), (String)"role")).setSize(0)).add(this.client.prepareSearch(new String[]{".security"}).setQuery((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)RoleDescriptor.Fields.TYPE.getPreferredName(), (String)"role")).must((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.existsQuery((String)"indices.field_security.grant")).should((QueryBuilder)QueryBuilders.existsQuery((String)"indices.field_security.except")).should((QueryBuilder)QueryBuilders.existsQuery((String)"indices.fields")))).setSize(0).setTerminateAfter(1)).add(this.client.prepareSearch(new String[]{".security"}).setQuery((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)RoleDescriptor.Fields.TYPE.getPreferredName(), (String)"role")).filter((QueryBuilder)QueryBuilders.existsQuery((String)"indices.query"))).setSize(0).setTerminateAfter(1)).request()), (ActionListener)new ActionListener<MultiSearchResponse>(){

                public void onResponse(MultiSearchResponse items) {
                    MultiSearchResponse.Item[] responses = items.getResponses();
                    if (responses[0].isFailure()) {
                        usageStats.put("size", 0);
                    } else {
                        usageStats.put("size", responses[0].getResponse().getHits().getTotalHits());
                    }
                    if (responses[1].isFailure()) {
                        usageStats.put("fls", false);
                    } else {
                        usageStats.put("fls", responses[1].getResponse().getHits().getTotalHits() > 0L);
                    }
                    if (responses[2].isFailure()) {
                        usageStats.put("dls", false);
                    } else {
                        usageStats.put("dls", responses[2].getResponse().getHits().getTotalHits() > 0L);
                    }
                    listener.onResponse((Object)usageStats);
                }

                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            }, (arg_0, arg_1) -> ((Client)this.client).multiSearch(arg_0, arg_1)));
        }
    }

    private void getRoleDescriptor(final String roleId, final ActionListener<RoleDescriptor> roleActionListener) {
        if (!this.securityIndex.indexExists()) {
            roleActionListener.onResponse(null);
        } else {
            this.securityIndex.prepareIndexIfNeededThenExecute(arg_0 -> roleActionListener.onFailure(arg_0), () -> this.executeGetRoleRequest(roleId, new ActionListener<GetResponse>(){

                public void onResponse(GetResponse response) {
                    RoleDescriptor descriptor = NativeRolesStore.this.transformRole(response);
                    roleActionListener.onResponse((Object)descriptor);
                }

                public void onFailure(Exception e) {
                    if (TransportActions.isShardNotAvailableException((Throwable)e)) {
                        NativeRolesStore.this.logger.warn(() -> new ParameterizedMessage("failed to load role [{}] index not available", (Object)roleId), (Throwable)e);
                        roleActionListener.onResponse(null);
                    } else {
                        NativeRolesStore.this.logger.error((Message)new ParameterizedMessage("failed to load role [{}]", (Object)roleId), (Throwable)e);
                        roleActionListener.onFailure(e);
                    }
                }
            }));
        }
    }

    private void executeGetRoleRequest(String role, ActionListener<GetResponse> listener) {
        this.securityIndex.prepareIndexIfNeededThenExecute(arg_0 -> listener.onFailure(arg_0), () -> ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (ActionRequest)((GetRequest)this.client.prepareGet(".security", ROLE_DOC_TYPE, NativeRolesStore.getIdForUser(role)).request()), (ActionListener)listener, (arg_0, arg_1) -> ((Client)this.client).get(arg_0, arg_1)));
    }

    private <Response> void clearRoleCache(final String role, final ActionListener<Response> listener, final Response response) {
        ClearRolesCacheRequest request = new ClearRolesCacheRequest().names(new String[]{role});
        ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (ActionRequest)request, (ActionListener)new ActionListener<ClearRolesCacheResponse>(){

            public void onResponse(ClearRolesCacheResponse nodes) {
                listener.onResponse(response);
            }

            public void onFailure(Exception e) {
                NativeRolesStore.this.logger.error((Message)new ParameterizedMessage("unable to clear cache for role [{}]", (Object)role), (Throwable)e);
                ElasticsearchException exception = new ElasticsearchException("clearing the cache for [" + role + "] failed. please clear the role cache manually", (Throwable)e, new Object[0]);
                listener.onFailure((Exception)exception);
            }
        }, (arg_0, arg_1) -> ((SecurityClient)this.securityClient).clearRolesCache(arg_0, arg_1));
    }

    @Nullable
    private RoleDescriptor transformRole(GetResponse response) {
        if (!response.isExists()) {
            return null;
        }
        return NativeRolesStore.transformRole(response.getId(), response.getSourceAsBytesRef(), this.logger, this.licenseState);
    }

    @Nullable
    static RoleDescriptor transformRole(String id, BytesReference sourceBytes, Logger logger, XPackLicenseState licenseState) {
        assert (id.startsWith("role")) : "[" + id + "] does not have role prefix";
        String name = id.substring("role".length() + 1);
        try {
            RoleDescriptor roleDescriptor = RoleDescriptor.parse((String)name, (BytesReference)sourceBytes, (boolean)true, (XContentType)XContentType.JSON);
            if (licenseState.isDocumentAndFieldLevelSecurityAllowed()) {
                return roleDescriptor;
            }
            boolean dlsEnabled = Arrays.stream(roleDescriptor.getIndicesPrivileges()).anyMatch(RoleDescriptor.IndicesPrivileges::isUsingDocumentLevelSecurity);
            boolean flsEnabled = Arrays.stream(roleDescriptor.getIndicesPrivileges()).anyMatch(RoleDescriptor.IndicesPrivileges::isUsingFieldLevelSecurity);
            if (dlsEnabled || flsEnabled) {
                ArrayList<String> unlicensedFeatures = new ArrayList<String>(2);
                if (flsEnabled) {
                    unlicensedFeatures.add("fls");
                }
                if (dlsEnabled) {
                    unlicensedFeatures.add("dls");
                }
                HashMap<String, Serializable> transientMap = new HashMap<String, Serializable>(2);
                transientMap.put("unlicensed_features", unlicensedFeatures);
                transientMap.put("enabled", Boolean.valueOf(false));
                return new RoleDescriptor(roleDescriptor.getName(), roleDescriptor.getClusterPrivileges(), roleDescriptor.getIndicesPrivileges(), roleDescriptor.getRunAs(), roleDescriptor.getMetadata(), transientMap);
            }
            return roleDescriptor;
        }
        catch (Exception e) {
            logger.error((Message)new ParameterizedMessage("error in the format of data for role [{}]", (Object)name), (Throwable)e);
            return null;
        }
    }

    public static void addSettings(List<Setting<?>> settings) {
        settings.add(CACHE_SIZE_SETTING);
        settings.add(CACHE_TTL_SETTING);
    }

    private static String getIdForUser(String roleName) {
        return "role-" + roleName;
    }
}

