/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.support;

import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.LDAPException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.env.Environment;
import org.elasticsearch.watcher.FileChangesListener;
import org.elasticsearch.watcher.FileWatcher;
import org.elasticsearch.watcher.ResourceWatcher;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.support.CachingRealm;
import org.elasticsearch.xpack.core.security.authc.support.DnRoleMapperSettings;
import org.elasticsearch.xpack.security.Security;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapUtils;
import org.elasticsearch.xpack.security.authc.support.UserRoleMapper;

public class DnRoleMapper
implements UserRoleMapper {
    protected final Logger logger;
    protected final RealmConfig config;
    private final Path file;
    private final boolean useUnmappedGroupsAsRoles;
    private final CopyOnWriteArrayList<Runnable> listeners = new CopyOnWriteArrayList();
    private volatile Map<DN, Set<String>> dnRoles;

    public DnRoleMapper(RealmConfig config, ResourceWatcherService watcherService) {
        this.config = config;
        this.logger = config.logger(this.getClass());
        this.useUnmappedGroupsAsRoles = (Boolean)DnRoleMapperSettings.USE_UNMAPPED_GROUPS_AS_ROLES_SETTING.get(config.settings());
        this.file = DnRoleMapper.resolveFile(config.settings(), config.env());
        this.dnRoles = DnRoleMapper.parseFileLenient(this.file, this.logger, config.type(), config.name());
        FileWatcher watcher = new FileWatcher(this.file.getParent());
        watcher.addListener((Object)new FileListener());
        try {
            watcherService.add((ResourceWatcher)watcher, ResourceWatcherService.Frequency.HIGH);
        }
        catch (IOException e) {
            throw new ElasticsearchException("failed to start file watcher for role mapping file [" + this.file.toAbsolutePath() + "]", (Throwable)e, new Object[0]);
        }
    }

    @Override
    public void refreshRealmOnChange(CachingRealm realm) {
        this.addListener(() -> ((CachingRealm)realm).expireAll());
    }

    synchronized void addListener(Runnable listener) {
        this.listeners.add(Objects.requireNonNull(listener, "listener cannot be null"));
    }

    public static Path resolveFile(Settings settings, Environment env) {
        String location = (String)DnRoleMapperSettings.ROLE_MAPPING_FILE_SETTING.get(settings);
        return Security.resolveConfigFile(env, location);
    }

    public static Map<DN, Set<String>> parseFileLenient(Path path, Logger logger, String realmType, String realmName) {
        try {
            return DnRoleMapper.parseFile(path, logger, realmType, realmName, false);
        }
        catch (Exception e) {
            logger.error(() -> new ParameterizedMessage("failed to parse role mappings file [{}]. skipping/removing all mappings...", (Object)path.toAbsolutePath()), (Throwable)e);
            return Collections.emptyMap();
        }
    }

    public static Map<DN, Set<String>> parseFile(Path path, Logger logger, String realmType, String realmName, boolean strict) {
        logger.trace("reading realm [{}/{}] role mappings file [{}]...", (Object)realmType, (Object)realmName, (Object)path.toAbsolutePath());
        if (!Files.exists(path, new LinkOption[0])) {
            ParameterizedMessage message = new ParameterizedMessage("Role mapping file [{}] for realm [{}] does not exist.", (Object)path.toAbsolutePath(), (Object)realmName);
            if (strict) {
                throw new ElasticsearchException(message.getFormattedMessage(), new Object[0]);
            }
            logger.warn(message.getFormattedMessage() + " Role mapping will be skipped.");
            return Collections.emptyMap();
        }
        try {
            Settings settings = Settings.builder().loadFromPath(path).build();
            HashMap<DN, HashSet<String>> dnToRoles = new HashMap<DN, HashSet<String>>();
            Set roles = settings.names();
            for (String role : roles) {
                for (String providedDn : settings.getAsList(role)) {
                    try {
                        DN dn = new DN(providedDn);
                        HashSet<String> dnRoles = (HashSet<String>)dnToRoles.get(dn);
                        if (dnRoles == null) {
                            dnRoles = new HashSet<String>();
                            dnToRoles.put(dn, dnRoles);
                        }
                        dnRoles.add(role);
                    }
                    catch (LDAPException e) {
                        ParameterizedMessage message = new ParameterizedMessage("invalid DN [{}] found in [{}] role mappings [{}] for realm [{}/{}].", new Object[]{providedDn, realmType, path.toAbsolutePath(), realmType, realmName});
                        if (strict) {
                            throw new ElasticsearchException(message.getFormattedMessage(), (Throwable)e, new Object[0]);
                        }
                        logger.error(message.getFormattedMessage() + " skipping...", (Throwable)e);
                    }
                }
            }
            logger.debug("[{}] role mappings found in file [{}] for realm [{}/{}]", (Object)dnToRoles.size(), (Object)path.toAbsolutePath(), (Object)realmType, (Object)realmName);
            return Collections.unmodifiableMap(dnToRoles);
        }
        catch (IOException | SettingsException e) {
            throw new ElasticsearchException("could not read realm [" + realmType + "/" + realmName + "] role mappings file [" + path.toAbsolutePath() + "]", e, new Object[0]);
        }
    }

    int mappingsCount() {
        return this.dnRoles.size();
    }

    @Override
    public void resolveRoles(UserRoleMapper.UserData user, ActionListener<Set<String>> listener) {
        try {
            listener.onResponse(this.resolveRoles(user.getDn(), user.getGroups()));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    public Set<String> resolveRoles(String userDnString, Collection<String> groupDns) {
        DN userDn;
        Set<String> rolesMappedToUserDn;
        HashSet<String> roles = new HashSet<String>();
        for (String groupDnString : groupDns) {
            DN groupDn = LdapUtils.dn(groupDnString);
            if (this.dnRoles.containsKey(groupDn)) {
                roles.addAll((Collection)this.dnRoles.get(groupDn));
                continue;
            }
            if (!this.useUnmappedGroupsAsRoles) continue;
            roles.add(LdapUtils.relativeName(groupDn));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("the roles [{}], are mapped from these [{}] groups [{}] using file [{}] for realm [{}/{}]", roles, (Object)this.config.type(), groupDns, (Object)this.file.getFileName(), (Object)this.config.type(), (Object)this.config.name());
        }
        if ((rolesMappedToUserDn = this.dnRoles.get(userDn = LdapUtils.dn(userDnString))) != null) {
            roles.addAll(rolesMappedToUserDn);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("the roles [{}], are mapped from the user [{}] using file [{}] for realm [{}/{}]", rolesMappedToUserDn == null ? Collections.emptySet() : rolesMappedToUserDn, (Object)userDnString, (Object)this.file.getFileName(), (Object)this.config.type(), (Object)this.config.name());
        }
        return roles;
    }

    public void notifyRefresh() {
        this.listeners.forEach(Runnable::run);
    }

    private class FileListener
    implements FileChangesListener {
        private FileListener() {
        }

        public void onFileCreated(Path file) {
            this.onFileChanged(file);
        }

        public void onFileDeleted(Path file) {
            this.onFileChanged(file);
        }

        public void onFileChanged(Path file) {
            if (file.equals(DnRoleMapper.this.file)) {
                DnRoleMapper.this.logger.info("role mappings file [{}] changed for realm [{}/{}]. updating mappings...", (Object)file.toAbsolutePath(), (Object)DnRoleMapper.this.config.type(), (Object)DnRoleMapper.this.config.name());
                DnRoleMapper.this.dnRoles = DnRoleMapper.parseFileLenient(file, DnRoleMapper.this.logger, DnRoleMapper.this.config.type(), DnRoleMapper.this.config.name());
                DnRoleMapper.this.notifyRefresh();
            }
        }
    }
}

