/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.protocol;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Buffer;
import com.unboundid.asn1.ASN1BufferSequence;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.asn1.ASN1StreamReader;
import com.unboundid.asn1.ASN1StreamReaderSequence;
import com.unboundid.ldap.protocol.ProtocolMessages;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ModifyDNRequest;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@InternalUseOnly
@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ModifyDNRequestProtocolOp
implements ProtocolOp {
    public static final byte TYPE_NEW_SUPERIOR = -128;
    private static final long serialVersionUID = 7514385089303489375L;
    private final boolean deleteOldRDN;
    private final String dn;
    private final String newRDN;
    private final String newSuperiorDN;

    public ModifyDNRequestProtocolOp(String dn, String newRDN, boolean deleteOldRDN, String newSuperiorDN) {
        this.dn = dn;
        this.newRDN = newRDN;
        this.deleteOldRDN = deleteOldRDN;
        this.newSuperiorDN = newSuperiorDN;
    }

    public ModifyDNRequestProtocolOp(ModifyDNRequest request) {
        this.dn = request.getDN();
        this.newRDN = request.getNewRDN();
        this.deleteOldRDN = request.deleteOldRDN();
        this.newSuperiorDN = request.getNewSuperiorDN();
    }

    ModifyDNRequestProtocolOp(ASN1StreamReader reader) throws LDAPException {
        try {
            ASN1StreamReaderSequence opSequence = reader.beginSequence();
            this.dn = reader.readString();
            this.newRDN = reader.readString();
            this.deleteOldRDN = reader.readBoolean();
            this.newSuperiorDN = opSequence.hasMoreElements() ? reader.readString() : null;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_MODIFY_DN_REQUEST_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    public String getDN() {
        return this.dn;
    }

    public String getNewRDN() {
        return this.newRDN;
    }

    public boolean deleteOldRDN() {
        return this.deleteOldRDN;
    }

    public String getNewSuperiorDN() {
        return this.newSuperiorDN;
    }

    public byte getProtocolOpType() {
        return 108;
    }

    public ASN1Element encodeProtocolOp() {
        if (this.newSuperiorDN == null) {
            return new ASN1Sequence(108, new ASN1OctetString(this.dn), new ASN1OctetString(this.newRDN), new ASN1Boolean(this.deleteOldRDN));
        }
        return new ASN1Sequence(108, new ASN1OctetString(this.dn), new ASN1OctetString(this.newRDN), new ASN1Boolean(this.deleteOldRDN), new ASN1OctetString(-128, this.newSuperiorDN));
    }

    public static ModifyDNRequestProtocolOp decodeProtocolOp(ASN1Element element) throws LDAPException {
        try {
            ASN1Element[] elements = ASN1Sequence.decodeAsSequence(element).elements();
            String dn = ASN1OctetString.decodeAsOctetString(elements[0]).stringValue();
            String newRDN = ASN1OctetString.decodeAsOctetString(elements[1]).stringValue();
            boolean deleteOldRDN = ASN1Boolean.decodeAsBoolean(elements[2]).booleanValue();
            String newSuperiorDN = elements.length > 3 ? ASN1OctetString.decodeAsOctetString(elements[3]).stringValue() : null;
            return new ModifyDNRequestProtocolOp(dn, newRDN, deleteOldRDN, newSuperiorDN);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ProtocolMessages.ERR_MODIFY_DN_REQUEST_CANNOT_DECODE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    public void writeTo(ASN1Buffer buffer) {
        ASN1BufferSequence opSequence = buffer.beginSequence((byte)108);
        buffer.addOctetString(this.dn);
        buffer.addOctetString(this.newRDN);
        buffer.addBoolean(this.deleteOldRDN);
        if (this.newSuperiorDN != null) {
            buffer.addOctetString((byte)-128, this.newSuperiorDN);
        }
        opSequence.end();
    }

    public ModifyDNRequest toModifyDNRequest(Control ... controls) {
        return new ModifyDNRequest(this.dn, this.newRDN, this.deleteOldRDN, this.newSuperiorDN, controls);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(StringBuilder buffer) {
        buffer.append("ModifyDNRequestProtocolOp(dn='");
        buffer.append(this.dn);
        buffer.append("', newRDN='");
        buffer.append(this.newRDN);
        buffer.append("', deleteOldRDN=");
        buffer.append(this.deleteOldRDN);
        if (this.newSuperiorDN != null) {
            buffer.append(", newSuperiorDN='");
            buffer.append(this.newSuperiorDN);
            buffer.append('\'');
        }
        buffer.append(')');
    }
}

