/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.math;

import java.io.IOException;
import java.util.Random;
import java.util.function.DoubleFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.elasticsearch.common.Randomness;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.expression.function.scalar.processor.runtime.Processor;

public class MathProcessor
implements Processor {
    public static final String NAME = "m";
    private final MathOperation processor;

    public MathProcessor(MathOperation processor) {
        this.processor = processor;
    }

    public MathProcessor(StreamInput in) throws IOException {
        this.processor = (MathOperation)in.readEnum(MathOperation.class);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum((Enum)this.processor);
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    public Object process(Object input) {
        if (input != null && !(input instanceof Number)) {
            throw new SqlIllegalArgumentException("A number is required; received [{}]", input);
        }
        return this.processor.apply(input);
    }

    MathOperation processor() {
        return this.processor;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        MathProcessor other = (MathProcessor)obj;
        return this.processor == other.processor;
    }

    public int hashCode() {
        return this.processor.hashCode();
    }

    public String toString() {
        return this.processor.toString();
    }

    public static enum MathOperation {
        ABS(l -> {
            if (l instanceof Float) {
                return Float.valueOf(Math.abs(((Float)l).floatValue()));
            }
            if (l instanceof Double) {
                return Math.abs((Double)l);
            }
            long lo = ((Number)l).longValue();
            return lo >= 0L ? lo : (lo == Long.MIN_VALUE ? Long.MAX_VALUE : -lo);
        }),
        ACOS(Math::acos),
        ASIN(Math::asin),
        ATAN(Math::atan),
        CBRT(Math::cbrt),
        CEIL(Math::ceil),
        COS(Math::cos),
        COSH(Math::cosh),
        COT(l -> 1.0 / Math.tan(((Number)l).doubleValue())),
        DEGREES(Math::toDegrees),
        E(() -> Math.E),
        EXP(Math::exp),
        EXPM1(Math::expm1),
        FLOOR(Math::floor),
        LOG(Math::log),
        LOG10(Math::log10),
        PI(() -> Math.PI),
        RADIANS(Math::toRadians),
        RANDOM(l -> l != null ? new Random(((Number)l).longValue()).nextDouble() : Randomness.get().nextDouble(), true),
        ROUND(Math::round),
        SIGN(Math::signum),
        SIN(Math::sin),
        SINH(Math::sinh),
        SQRT(Math::sqrt),
        TAN(Math::tan);

        private final Function<Object, Object> apply;

        private MathOperation(Function<Object, Object> apply) {
            this(apply, false);
        }

        private MathOperation(Function<Object, Object> apply, boolean nullAware) {
            this.apply = nullAware ? apply : l -> l == null ? null : apply.apply(l);
        }

        private MathOperation(DoubleFunction<Object> apply) {
            this.apply = l -> l == null ? null : apply.apply(((Number)l).doubleValue());
        }

        private MathOperation(Supplier<Double> supplier) {
            this.apply = l -> (Double)supplier.get();
        }

        public final Object apply(Object l) {
            return this.apply.apply(l);
        }
    }
}

