# Patchwork - automated patch tracking system
# Copyright (C) 2011 Jeremy Kerr <jk@ozlabs.org>
#
# This file is part of the Patchwork package.
#
# Patchwork is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Patchwork is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Patchwork; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

from django.test import TestCase

from patchwork.compat import reverse
from patchwork.models import EmailConfirmation
from patchwork.tests.utils import create_user


def _confirmation_url(conf):
    return reverse('confirm', kwargs={'key': conf.key})


def _generate_secondary_email(user):
    return 'secondary_%d@example.com' % user.id


class InvalidConfirmationTest(TestCase):

    def setUp(self):
        self.user = create_user()
        self.secondary_email = _generate_secondary_email(self.user)

        self.conf = EmailConfirmation(type='userperson',
                                      email=self.secondary_email,
                                      user=self.user)
        self.conf.save()

    def test_inactive_confirmation(self):
        self.conf.active = False
        self.conf.save()
        response = self.client.get(_confirmation_url(self.conf))
        self.assertEqual(response.status_code, 200)
        self.assertTemplateUsed(response, 'patchwork/confirm-error.html')
        self.assertEqual(response.context['error'], 'inactive')
        self.assertEqual(response.context['conf'], self.conf)

    def test_expired_confirmation(self):
        self.conf.date -= self.conf.validity
        self.conf.save()
        response = self.client.get(_confirmation_url(self.conf))
        self.assertEqual(response.status_code, 200)
        self.assertTemplateUsed(response, 'patchwork/confirm-error.html')
        self.assertEqual(response.context['error'], 'expired')
        self.assertEqual(response.context['conf'], self.conf)
