/*
 * Decompiled with CFR 0.152.
 */
package com.sun.demo.scripting.jconsole;

import com.sun.demo.scripting.jconsole.EditableAtEndDocument;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class ScriptShellPanel
extends JPanel {
    private static final long serialVersionUID = 4116273141148726319L;
    private CommandProcessor commandProcessor;
    private JTextComponent editor;
    private final ExecutorService commandExecutor = Executors.newSingleThreadExecutor();
    private boolean updating;

    public ScriptShellPanel(CommandProcessor cmdProc) {
        this.setLayout(new BorderLayout());
        this.commandProcessor = cmdProc;
        this.editor = new JTextArea();
        this.editor.setDocument(new EditableAtEndDocument());
        JScrollPane scroller = new JScrollPane();
        scroller.getViewport().add(this.editor);
        this.add((Component)scroller, "Center");
        this.editor.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (ScriptShellPanel.this.updating) {
                    return;
                }
                ScriptShellPanel.this.beginUpdate();
                ScriptShellPanel.this.editor.setCaretPosition(ScriptShellPanel.this.editor.getDocument().getLength());
                if (ScriptShellPanel.this.insertContains(e, '\n')) {
                    String cmd = ScriptShellPanel.this.getMarkedText();
                    if (cmd.length() == 0 || cmd.charAt(cmd.length() - 1) != '\\') {
                        final String cmd1 = ScriptShellPanel.this.trimContinuations(cmd);
                        ScriptShellPanel.this.commandExecutor.execute(new Runnable(){

                            @Override
                            public void run() {
                                final String result = ScriptShellPanel.this.executeCommand(cmd1);
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (result != null) {
                                            ScriptShellPanel.this.print(result + "\n");
                                        }
                                        ScriptShellPanel.this.printPrompt();
                                        ScriptShellPanel.this.setMark();
                                        ScriptShellPanel.this.endUpdate();
                                    }
                                });
                            }
                        });
                    } else {
                        ScriptShellPanel.this.endUpdate();
                    }
                } else {
                    ScriptShellPanel.this.endUpdate();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
            }
        });
        this.editor.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                int len = ScriptShellPanel.this.editor.getDocument().getLength();
                if (e.getDot() > len) {
                    ScriptShellPanel.this.editor.setCaretPosition(len);
                }
            }
        });
        Box hbox = Box.createHorizontalBox();
        hbox.add(Box.createGlue());
        JButton button = new JButton("Clear");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptShellPanel.this.clear();
            }
        });
        hbox.add(button);
        hbox.add(Box.createGlue());
        this.add((Component)hbox, "South");
        this.clear();
    }

    public void dispose() {
        this.commandExecutor.shutdown();
    }

    @Override
    public void requestFocus() {
        this.editor.requestFocus();
    }

    public void clear() {
        this.clear(true);
    }

    public void clear(boolean prompt) {
        EditableAtEndDocument d = (EditableAtEndDocument)this.editor.getDocument();
        d.clear();
        if (prompt) {
            this.printPrompt();
        }
        this.setMark();
        this.editor.requestFocus();
    }

    public void setMark() {
        ((EditableAtEndDocument)this.editor.getDocument()).setMark();
    }

    public String getMarkedText() {
        try {
            int i;
            String s = ((EditableAtEndDocument)this.editor.getDocument()).getMarkedText();
            for (i = s.length(); i > 0 && s.charAt(i - 1) == '\n'; --i) {
            }
            return s.substring(0, i);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void print(String s) {
        Document d = this.editor.getDocument();
        try {
            d.insertString(d.getLength(), s, null);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private String executeCommand(String cmd) {
        return this.commandProcessor.executeCommand(cmd);
    }

    private String getPrompt() {
        return this.commandProcessor.getPrompt();
    }

    private void beginUpdate() {
        this.editor.setEditable(false);
        this.updating = true;
    }

    private void endUpdate() {
        this.editor.setEditable(true);
        this.updating = false;
    }

    private void printPrompt() {
        this.print(this.getPrompt());
    }

    private boolean insertContains(DocumentEvent e, char c) {
        String s = null;
        try {
            s = this.editor.getText(e.getOffset(), e.getLength());
            for (int i = 0; i < e.getLength(); ++i) {
                if (s.charAt(i) != c) continue;
                return true;
            }
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
        return false;
    }

    private String trimContinuations(String text) {
        int i;
        while ((i = text.indexOf("\\\n")) >= 0) {
            text = text.substring(0, i) + text.substring(i + 1, text.length());
        }
        return text;
    }

    static interface CommandProcessor {
        public String executeCommand(String var1);

        public String getPrompt();
    }
}

