#!/usr/bin/lua
--
-- Check if the user is a member of a specific Group
-- It works recursively if find an object group instead of a user. Then
-- search inside groups looking for users.
--

-- Brings up the main module used on this script to talk to AD Server
require "lualdap"

-- Brings up the configuration file
dofile("openvpnadcheck.conf")

-- If the user and/or the password is wrong, at this point the script stops and returns the error code (code 1)
-- The username and password variables are sent by OpenVPN. We can read them here. (it is possible thanks to the
-- option "script-security 3" on server side configuration file).
local ld = assert (lualdap.open_simple (AD_server,os.getenv("username").."@"..AD_domain,os.getenv("password")))

-- Here we'll put all goups and subgoups in the Base DN
listOfGoups = {}

function isItAGroup(inspec)
   if inspec ~= nil then
      for objn, obja in pairs (inspec) do
         if obja == "group" then
            return true
         end
      end
      return false
   end
end

function huntGroups(atDN)
   for dn1, attribs1 in ld:search { base = atDN, scope = "subtree", attrs = "member"} do
      for attrName, attrvalue in pairs (attribs1) do
         local NumberOfElements = # attrvalue
         for z = 1, NumberOfElements do
            -- If there are more than one object in the group, lets check each one
            if type(attrvalue) == "table" then
               AD_dn=attrvalue[z]
               -- In the other hand, lets check the only object
            else
               AD_dn=attrvalue
            end
            if AD_dn ~= nil then
               for dn2, attribs2 in ld:search { base = AD_dn, scope = "subtree"} do
                  if attribs2.objectClass ~= nil then
                     if isItAGroup(attribs2.objectClass) then
                        listOfGoups[#listOfGoups+1] = dn2
                     end
                  end
               end
            end
         end
      end
   end
end



function searchInGroup(DNg)
   io.write("GRUPO: "..DNg.."\n")
   for dn1, attribs1 in ld:search { base = DNg, scope = "subtree", attrs = "member"} do
      for attrName, attrvalue in pairs (attribs1) do
         local NumberOfElements = # attrvalue
         for z = 1, NumberOfElements do
         
            -- If there are more than one object in the group, lets check each one
            if type(attrvalue) == "table" then
               AD_dn=attrvalue[z]
               
            -- In the other hand, lets check the only object
            else
               AD_dn=attrvalue
            end
            
            if AD_dn ~= nil then
               for dn2, attribs2 in ld:search { base = AD_dn, scope = "subtree"} do
                  if attribs2.objectClass ~= nil then
                     if isItAGroup(attribs2.objectClass) then
                        listOfGoups[#listOfGoups+1] = dn2
                     else
                        searchInPerson(dn2)
                     end
                  end
               end
            end
         end   
      end
   end
end



function searchInPerson(DNp)
   for dn2, attribs2 in ld:search { base = DNp, scope = "subtree", attrs = "sAMAccountName"} do
      if attribs2.sAMAccountName ~= nil then
         if string.lower(attribs2.sAMAccountName) == string.lower(os.getenv("username")) then
            ld:close()
            os.exit(0)
            break
         end
      end
   end
end



-- If the user authenticate successfully, we still have to check if he/she is in the allowed Organizational Unit
for dn, attribs in ld:search { base = AD_dn, scope = "subtree"} do
   found=0
   searchInGroup(dn)
   l = listOfGoups
   n = # listOfGoups
   for i=1, n do
      searchInGroup(listOfGoups[i])
      i = i + 1
   end
end


ld:close()
os.exit(1)
