local mymodule = {}

-- Load libraries
modelfunctions = require("modelfunctions")
fs = require("acf.fs")
format = require("acf.format")

-- Set variables
local configfile = "/etc/unbound/unbound.conf"
local processname = "unbound"
local packagename = "unbound"

local config

-- ################################################################################
-- LOCAL FUNCTIONS

-- ################################################################################
-- PUBLIC FUNCTIONS

function mymodule.get_startstop(self, clientdata)
        return modelfunctions.get_startstop(processname)
end
	
function mymodule.startstop_service(self, startstop, action)
        return modelfunctions.startstop_service(startstop, action)
end

function mymodule.getstatus()
	return modelfunctions.getstatus(processname, packagename, "Unbound Status")
end

function mymodule.get_filedetails()
	return modelfunctions.getfiledetails(configfile)
end

function mymodule.update_filedetails(self, filedetails)
	return modelfunctions.setfiledetails(self, filedetails, {configfile})
end

function mymodule.get_logfile(f)
	-- Determine the log file from the config file
	-- TODO determine how best to parse the file
--[[
	config = config or format.parse_ini_file(fs.read_file(configfile) or "", "")
	local files = {}
	if config and config.logfile then
		files[#files+1] = {path = config.logfile}
	end
--]]
	if 0 == #files then
		files[#files+1] = {path = "/var/log/messages", grep = "unbound"}
	end
	return cfe({ value=files, label="Unbound Log Files" })
end

return mymodule
