
module MenhirBasics = struct
  
  exception Error
  
  let _eRR =
    fun _s ->
      raise Error
  
  type token = 
    | UIDENT of (
# 18 "atd/src/parser.mly"
       ( string )
# 15 "atd/src/parser.ml"
  )
    | TYPE
    | TILDE
    | TIDENT of (
# 18 "atd/src/parser.mly"
       ( string )
# 22 "atd/src/parser.ml"
  )
    | STRING of (
# 18 "atd/src/parser.mly"
       ( string )
# 27 "atd/src/parser.ml"
  )
    | STAR
    | SEMICOLON
    | QUESTION
    | OP_PAREN
    | OP_CURL
    | OP_BRACK
    | OF
    | LT
    | LIDENT of (
# 18 "atd/src/parser.mly"
       ( string )
# 40 "atd/src/parser.ml"
  )
    | INHERIT
    | GT
    | EQ
    | EOF
    | DOT
    | COMMA
    | COLON
    | CL_PAREN
    | CL_CURL
    | CL_BRACK
    | BAR
  
end

include MenhirBasics

# 6 "atd/src/parser.mly"
  
  open Import
  open Ast

  let syntax_error s pos1 pos2 =
    let msg = sprintf "%s:\n%s" (string_of_loc (pos1, pos2)) s in
    error msg

# 67 "atd/src/parser.ml"

type ('s, 'r) _menhir_state = 
  | MenhirState000 : ('s, _menhir_box_full_module) _menhir_state
    (** State 000.
        Stack shape : .
        Start symbol: full_module. *)

  | MenhirState003 : (('s, _menhir_box_full_module) _menhir_cell1_LT _menhir_cell0_LIDENT, _menhir_box_full_module) _menhir_state
    (** State 003.
        Stack shape : LT LIDENT.
        Start symbol: full_module. *)

  | MenhirState005 : (('s, _menhir_box_full_module) _menhir_cell1_LIDENT, _menhir_box_full_module) _menhir_state
    (** State 005.
        Stack shape : LIDENT.
        Start symbol: full_module. *)

  | MenhirState013 : (('s, _menhir_box_full_module) _menhir_cell1_afield, _menhir_box_full_module) _menhir_state
    (** State 013.
        Stack shape : afield.
        Start symbol: full_module. *)

  | MenhirState016 : (('s, _menhir_box_full_module) _menhir_cell1_asection, _menhir_box_full_module) _menhir_state
    (** State 016.
        Stack shape : asection.
        Start symbol: full_module. *)

  | MenhirState018 : (('s, _menhir_box_full_module) _menhir_cell1_annot, _menhir_box_full_module) _menhir_state
    (** State 018.
        Stack shape : annot.
        Start symbol: full_module. *)

  | MenhirState023 : (('s, _menhir_box_full_module) _menhir_cell1_TYPE _menhir_cell0_OP_PAREN, _menhir_box_full_module) _menhir_state
    (** State 023.
        Stack shape : TYPE OP_PAREN.
        Start symbol: full_module. *)

  | MenhirState025 : (('s, _menhir_box_full_module) _menhir_cell1_TIDENT, _menhir_box_full_module) _menhir_state
    (** State 025.
        Stack shape : TIDENT.
        Start symbol: full_module. *)

  | MenhirState031 : (('s, _menhir_box_full_module) _menhir_cell1_TYPE _menhir_cell0_type_param _menhir_cell0_LIDENT, _menhir_box_full_module) _menhir_state
    (** State 031.
        Stack shape : TYPE type_param LIDENT.
        Start symbol: full_module. *)

  | MenhirState034 : ((('s, _menhir_box_full_module) _menhir_cell1_TYPE _menhir_cell0_type_param _menhir_cell0_LIDENT, _menhir_box_full_module) _menhir_cell1_annot, _menhir_box_full_module) _menhir_state
    (** State 034.
        Stack shape : TYPE type_param LIDENT annot.
        Start symbol: full_module. *)

  | MenhirState037 : (('s, _menhir_box_full_module) _menhir_cell1_OP_PAREN, _menhir_box_full_module) _menhir_state
    (** State 037.
        Stack shape : OP_PAREN.
        Start symbol: full_module. *)

  | MenhirState039 : (('s, _menhir_box_full_module) _menhir_cell1_OP_PAREN, _menhir_box_full_module) _menhir_state
    (** State 039.
        Stack shape : OP_PAREN.
        Start symbol: full_module. *)

  | MenhirState040 : (('s, _menhir_box_full_module) _menhir_cell1_OP_CURL, _menhir_box_full_module) _menhir_state
    (** State 040.
        Stack shape : OP_CURL.
        Start symbol: full_module. *)

  | MenhirState046 : (('s, _menhir_box_full_module) _menhir_cell1_INHERIT, _menhir_box_full_module) _menhir_state
    (** State 046.
        Stack shape : INHERIT.
        Start symbol: full_module. *)

  | MenhirState047 : (('s, _menhir_box_full_module) _menhir_cell1_OP_CURL, _menhir_box_full_module) _menhir_state
    (** State 047.
        Stack shape : OP_CURL.
        Start symbol: full_module. *)

  | MenhirState048 : ((('s, _menhir_box_full_module) _menhir_cell1_OP_CURL, _menhir_box_full_module) _menhir_cell1_CL_CURL, _menhir_box_full_module) _menhir_state
    (** State 048.
        Stack shape : OP_CURL CL_CURL.
        Start symbol: full_module. *)

  | MenhirState050 : (('s, _menhir_box_full_module) _menhir_cell1_field_name, _menhir_box_full_module) _menhir_state
    (** State 050.
        Stack shape : field_name.
        Start symbol: full_module. *)

  | MenhirState053 : ((('s, _menhir_box_full_module) _menhir_cell1_field_name, _menhir_box_full_module) _menhir_cell1_annot, _menhir_box_full_module) _menhir_state
    (** State 053.
        Stack shape : field_name annot.
        Start symbol: full_module. *)

  | MenhirState055 : (('s, _menhir_box_full_module) _menhir_cell1_OP_BRACK, _menhir_box_full_module) _menhir_state
    (** State 055.
        Stack shape : OP_BRACK.
        Start symbol: full_module. *)

  | MenhirState056 : (('s, _menhir_box_full_module) _menhir_cell1_UIDENT, _menhir_box_full_module) _menhir_state
    (** State 056.
        Stack shape : UIDENT.
        Start symbol: full_module. *)

  | MenhirState058 : ((('s, _menhir_box_full_module) _menhir_cell1_UIDENT, _menhir_box_full_module) _menhir_cell1_annot, _menhir_box_full_module) _menhir_state
    (** State 058.
        Stack shape : UIDENT annot.
        Start symbol: full_module. *)

  | MenhirState060 : (('s, _menhir_box_full_module) _menhir_cell1_type_inst, _menhir_box_full_module) _menhir_state
    (** State 060.
        Stack shape : type_inst.
        Start symbol: full_module. *)

  | MenhirState065 : (('s, _menhir_box_full_module) _menhir_cell1_INHERIT, _menhir_box_full_module) _menhir_state
    (** State 065.
        Stack shape : INHERIT.
        Start symbol: full_module. *)

  | MenhirState067 : ((('s, _menhir_box_full_module) _menhir_cell1_OP_BRACK, _menhir_box_full_module) _menhir_cell1_CL_BRACK, _menhir_box_full_module) _menhir_state
    (** State 067.
        Stack shape : OP_BRACK CL_BRACK.
        Start symbol: full_module. *)

  | MenhirState069 : ((('s, _menhir_box_full_module) _menhir_cell1_OP_BRACK, _menhir_box_full_module) _menhir_cell1_BAR, _menhir_box_full_module) _menhir_state
    (** State 069.
        Stack shape : OP_BRACK BAR.
        Start symbol: full_module. *)

  | MenhirState072 : (('s, _menhir_box_full_module) _menhir_cell1_variant, _menhir_box_full_module) _menhir_state
    (** State 072.
        Stack shape : variant.
        Start symbol: full_module. *)

  | MenhirState077 : ((('s, _menhir_box_full_module) _menhir_cell1_OP_BRACK, _menhir_box_full_module) _menhir_cell1_variant_list, _menhir_box_full_module) _menhir_state
    (** State 077.
        Stack shape : OP_BRACK variant_list.
        Start symbol: full_module. *)

  | MenhirState082 : ((('s, _menhir_box_full_module) _menhir_cell1_OP_CURL, _menhir_box_full_module) _menhir_cell1_field_list, _menhir_box_full_module) _menhir_state
    (** State 082.
        Stack shape : OP_CURL field_list.
        Start symbol: full_module. *)

  | MenhirState085 : (('s, _menhir_box_full_module) _menhir_cell1_field, _menhir_box_full_module) _menhir_state
    (** State 085.
        Stack shape : field.
        Start symbol: full_module. *)

  | MenhirState088 : ((('s, _menhir_box_full_module) _menhir_cell1_OP_CURL, _menhir_box_full_module) _menhir_cell1_CL_CURL, _menhir_box_full_module) _menhir_state
    (** State 088.
        Stack shape : OP_CURL CL_CURL.
        Start symbol: full_module. *)

  | MenhirState091 : (('s, _menhir_box_full_module) _menhir_cell1_LT _menhir_cell0_LIDENT, _menhir_box_full_module) _menhir_state
    (** State 091.
        Stack shape : LT LIDENT.
        Start symbol: full_module. *)

  | MenhirState095 : (('s, _menhir_box_full_module) _menhir_cell1_asection, _menhir_box_full_module) _menhir_state
    (** State 095.
        Stack shape : asection.
        Start symbol: full_module. *)

  | MenhirState100 : ((('s, _menhir_box_full_module) _menhir_cell1_OP_CURL, _menhir_box_full_module) _menhir_cell1_field_list, _menhir_box_full_module) _menhir_state
    (** State 100.
        Stack shape : OP_CURL field_list.
        Start symbol: full_module. *)

  | MenhirState102 : (('s, _menhir_box_full_module) _menhir_cell1_OP_BRACK, _menhir_box_full_module) _menhir_state
    (** State 102.
        Stack shape : OP_BRACK.
        Start symbol: full_module. *)

  | MenhirState103 : ((('s, _menhir_box_full_module) _menhir_cell1_OP_BRACK, _menhir_box_full_module) _menhir_cell1_CL_BRACK, _menhir_box_full_module) _menhir_state
    (** State 103.
        Stack shape : OP_BRACK CL_BRACK.
        Start symbol: full_module. *)

  | MenhirState107 : ((('s, _menhir_box_full_module) _menhir_cell1_OP_BRACK, _menhir_box_full_module) _menhir_cell1_variant_list, _menhir_box_full_module) _menhir_state
    (** State 107.
        Stack shape : OP_BRACK variant_list.
        Start symbol: full_module. *)

  | MenhirState109 : (('s, _menhir_box_full_module) _menhir_cell1_type_inst, _menhir_box_full_module) _menhir_state
    (** State 109.
        Stack shape : type_inst.
        Start symbol: full_module. *)

  | MenhirState112 : (('s, _menhir_box_full_module) _menhir_cell1_type_expr, _menhir_box_full_module) _menhir_state
    (** State 112.
        Stack shape : type_expr.
        Start symbol: full_module. *)

  | MenhirState122 : ((('s, _menhir_box_full_module) _menhir_cell1_OP_PAREN, _menhir_box_full_module) _menhir_cell1_cartesian_product, _menhir_box_full_module) _menhir_state
    (** State 122.
        Stack shape : OP_PAREN cartesian_product.
        Start symbol: full_module. *)

  | MenhirState125 : (('s, _menhir_box_full_module) _menhir_cell1_annot_expr, _menhir_box_full_module) _menhir_state
    (** State 125.
        Stack shape : annot_expr.
        Start symbol: full_module. *)

  | MenhirState130 : (('s, _menhir_box_full_module) _menhir_cell1_annot, _menhir_box_full_module) _menhir_state
    (** State 130.
        Stack shape : annot.
        Start symbol: full_module. *)

  | MenhirState132 : ((('s, _menhir_box_full_module) _menhir_cell1_OP_PAREN, _menhir_box_full_module) _menhir_cell1_annot_expr, _menhir_box_full_module) _menhir_state
    (** State 132.
        Stack shape : OP_PAREN annot_expr.
        Start symbol: full_module. *)

  | MenhirState135 : (('s, _menhir_box_full_module) _menhir_cell1_annot, _menhir_box_full_module) _menhir_state
    (** State 135.
        Stack shape : annot.
        Start symbol: full_module. *)

  | MenhirState139 : ((('s, _menhir_box_full_module) _menhir_cell1_OP_PAREN, _menhir_box_full_module) _menhir_cell1_cartesian_product, _menhir_box_full_module) _menhir_state
    (** State 139.
        Stack shape : OP_PAREN cartesian_product.
        Start symbol: full_module. *)

  | MenhirState142 : ((('s, _menhir_box_full_module) _menhir_cell1_OP_PAREN, _menhir_box_full_module) _menhir_cell1_annot_expr, _menhir_box_full_module) _menhir_state
    (** State 142.
        Stack shape : OP_PAREN annot_expr.
        Start symbol: full_module. *)

  | MenhirState146 : (('s, _menhir_box_full_module) _menhir_cell1_module_item, _menhir_box_full_module) _menhir_state
    (** State 146.
        Stack shape : module_item.
        Start symbol: full_module. *)


and ('s, 'r) _menhir_cell1_afield = 
  | MenhirCell1_afield of 's * ('s, 'r) _menhir_state * (Ast.annot_field)

and ('s, 'r) _menhir_cell1_afield_list = 
  | MenhirCell1_afield_list of 's * ('s, 'r) _menhir_state * (Ast.annot_field list)

and ('s, 'r) _menhir_cell1_annot = 
  | MenhirCell1_annot of 's * ('s, 'r) _menhir_state * (Ast.annot) * Lexing.position * Lexing.position

and ('s, 'r) _menhir_cell1_annot_expr = 
  | MenhirCell1_annot_expr of 's * ('s, 'r) _menhir_state * (Ast.cell)

and ('s, 'r) _menhir_cell1_asection = 
  | MenhirCell1_asection of 's * ('s, 'r) _menhir_state * (Ast.annot_section) * Lexing.position

and ('s, 'r) _menhir_cell1_cartesian_product = 
  | MenhirCell1_cartesian_product of 's * ('s, 'r) _menhir_state * (Ast.cell list)

and ('s, 'r) _menhir_cell1_field = 
  | MenhirCell1_field of 's * ('s, 'r) _menhir_state * (Ast.field)

and ('s, 'r) _menhir_cell1_field_list = 
  | MenhirCell1_field_list of 's * ('s, 'r) _menhir_state * (Ast.field list)

and ('s, 'r) _menhir_cell1_field_name = 
  | MenhirCell1_field_name of 's * ('s, 'r) _menhir_state * (string * Ast.field_kind) * Lexing.position

and ('s, 'r) _menhir_cell1_module_item = 
  | MenhirCell1_module_item of 's * ('s, 'r) _menhir_state * (Ast.module_item)

and ('s, 'r) _menhir_cell1_type_arg_list = 
  | MenhirCell1_type_arg_list of 's * ('s, 'r) _menhir_state * (Ast.type_expr list)

and ('s, 'r) _menhir_cell1_type_expr = 
  | MenhirCell1_type_expr of 's * ('s, 'r) _menhir_state * (Ast.type_expr) * Lexing.position * Lexing.position

and ('s, 'r) _menhir_cell1_type_inst = 
  | MenhirCell1_type_inst of 's * ('s, 'r) _menhir_state * (Ast.type_inst) * Lexing.position

and 's _menhir_cell0_type_param = 
  | MenhirCell0_type_param of 's * (Ast.type_param)

and ('s, 'r) _menhir_cell1_type_var_list = 
  | MenhirCell1_type_var_list of 's * ('s, 'r) _menhir_state * (Ast.type_param)

and ('s, 'r) _menhir_cell1_variant = 
  | MenhirCell1_variant of 's * ('s, 'r) _menhir_state * (Ast.variant)

and ('s, 'r) _menhir_cell1_variant_list = 
  | MenhirCell1_variant_list of 's * ('s, 'r) _menhir_state * (Ast.variant list)

and ('s, 'r) _menhir_cell1_BAR = 
  | MenhirCell1_BAR of 's * ('s, 'r) _menhir_state

and ('s, 'r) _menhir_cell1_CL_BRACK = 
  | MenhirCell1_CL_BRACK of 's * ('s, 'r) _menhir_state

and ('s, 'r) _menhir_cell1_CL_CURL = 
  | MenhirCell1_CL_CURL of 's * ('s, 'r) _menhir_state

and ('s, 'r) _menhir_cell1_INHERIT = 
  | MenhirCell1_INHERIT of 's * ('s, 'r) _menhir_state * Lexing.position

and ('s, 'r) _menhir_cell1_LIDENT = 
  | MenhirCell1_LIDENT of 's * ('s, 'r) _menhir_state * (
# 18 "atd/src/parser.mly"
       ( string )
# 368 "atd/src/parser.ml"
) * Lexing.position * Lexing.position

and 's _menhir_cell0_LIDENT = 
  | MenhirCell0_LIDENT of 's * (
# 18 "atd/src/parser.mly"
       ( string )
# 375 "atd/src/parser.ml"
) * Lexing.position * Lexing.position

and ('s, 'r) _menhir_cell1_LT = 
  | MenhirCell1_LT of 's * ('s, 'r) _menhir_state * Lexing.position

and ('s, 'r) _menhir_cell1_OP_BRACK = 
  | MenhirCell1_OP_BRACK of 's * ('s, 'r) _menhir_state * Lexing.position

and ('s, 'r) _menhir_cell1_OP_CURL = 
  | MenhirCell1_OP_CURL of 's * ('s, 'r) _menhir_state * Lexing.position

and ('s, 'r) _menhir_cell1_OP_PAREN = 
  | MenhirCell1_OP_PAREN of 's * ('s, 'r) _menhir_state * Lexing.position

and 's _menhir_cell0_OP_PAREN = 
  | MenhirCell0_OP_PAREN of 's * Lexing.position

and ('s, 'r) _menhir_cell1_TIDENT = 
  | MenhirCell1_TIDENT of 's * ('s, 'r) _menhir_state * (
# 18 "atd/src/parser.mly"
       ( string )
# 397 "atd/src/parser.ml"
) * Lexing.position * Lexing.position

and ('s, 'r) _menhir_cell1_TYPE = 
  | MenhirCell1_TYPE of 's * ('s, 'r) _menhir_state * Lexing.position

and ('s, 'r) _menhir_cell1_UIDENT = 
  | MenhirCell1_UIDENT of 's * ('s, 'r) _menhir_state * (
# 18 "atd/src/parser.mly"
       ( string )
# 407 "atd/src/parser.ml"
) * Lexing.position

and _menhir_box_full_module = 
  | MenhirBox_full_module of (Ast.full_module) [@@unboxed]

let _menhir_action_01 =
  fun _1 _3 _endpos__3_ _startpos__1_ ->
    let _endpos = _endpos__3_ in
    let _startpos = _startpos__1_ in
    (
# 55 "atd/src/parser.mly"
                         ( (String.concat "." _1,
                           ((_startpos, _endpos), Some _3)) )
# 421 "atd/src/parser.ml"
     : (Ast.annot_field))

let _menhir_action_02 =
  fun _1 _endpos__1_ _startpos__1_ ->
    let _endpos = _endpos__1_ in
    let _startpos = _startpos__1_ in
    (
# 57 "atd/src/parser.mly"
                         ( (String.concat "." _1,
                           ((_startpos, _endpos), None)) )
# 432 "atd/src/parser.ml"
     : (Ast.annot_field))

let _menhir_action_03 =
  fun l x ->
    (
# 50 "atd/src/parser.mly"
                              ( x :: l )
# 440 "atd/src/parser.ml"
     : (Ast.annot_field list))

let _menhir_action_04 =
  fun () ->
    (
# 51 "atd/src/parser.mly"
                              ( [] )
# 448 "atd/src/parser.ml"
     : (Ast.annot_field list))

let _menhir_action_05 =
  fun l x ->
    (
# 35 "atd/src/parser.mly"
                         ( x :: l )
# 456 "atd/src/parser.ml"
     : (Ast.annot))

let _menhir_action_06 =
  fun () ->
    (
# 36 "atd/src/parser.mly"
                         ( ([] : annot) )
# 464 "atd/src/parser.ml"
     : (Ast.annot))

let _menhir_action_07 =
  fun _endpos_x_ _startpos_a_ a x ->
    let _endpos = _endpos_x_ in
    let _startpos = _startpos_a_ in
    (
# 152 "atd/src/parser.mly"
                                   ( ((_startpos, _endpos), x, a) )
# 474 "atd/src/parser.ml"
     : (Ast.cell))

let _menhir_action_08 =
  fun _endpos_x_ _startpos_x_ x ->
    let _endpos = _endpos_x_ in
    let _startpos = _startpos_x_ in
    (
# 153 "atd/src/parser.mly"
                                   ( ((_startpos, _endpos), x, []) )
# 484 "atd/src/parser.ml"
     : (Ast.cell))

let _menhir_action_09 =
  fun _endpos__4_ _startpos__1_ l x ->
    let _endpos = _endpos__4_ in
    let _startpos = _startpos__1_ in
    (
# 40 "atd/src/parser.mly"
                                    ( (x, ((_startpos, _endpos), l)) )
# 494 "atd/src/parser.ml"
     : (Ast.annot_section))

let _menhir_action_10 =
  fun _e _endpos__e_ _startpos__e_ ->
    let _ = (
# 41 "atd/src/parser.mly"
                                    ( syntax_error
                                        "Expecting '>'"
                                        _startpos__e_ _endpos__e_ )
# 504 "atd/src/parser.ml"
     : (Ast.annot_section)) in
    prerr_string "Menhir: misuse: the semantic action associated with the production\nasection -> LT LIDENT afield_list error\nis expected to abort the parser, but does not do so.\n";
    assert false

let _menhir_action_11 =
  fun _e _endpos__e_ _startpos__e_ ->
    let _ = (
# 44 "atd/src/parser.mly"
                                    ( syntax_error
                                        "Expecting lowercase identifier"
                                        _startpos__e_ _endpos__e_ )
# 516 "atd/src/parser.ml"
     : (Ast.annot_section)) in
    prerr_string "Menhir: misuse: the semantic action associated with the production\nasection -> LT error\nis expected to abort the parser, but does not do so.\n";
    assert false

let _menhir_action_12 =
  fun l x ->
    (
# 146 "atd/src/parser.mly"
                                              ( x :: l )
# 526 "atd/src/parser.ml"
     : (Ast.cell list))

let _menhir_action_13 =
  fun x y ->
    (
# 147 "atd/src/parser.mly"
                                              ( [ x; y ] )
# 534 "atd/src/parser.ml"
     : (Ast.cell list))

let _menhir_action_14 =
  fun () ->
    (
# 148 "atd/src/parser.mly"
                                              ( [] )
# 542 "atd/src/parser.ml"
     : (Ast.cell list))

let _menhir_action_15 =
  fun _endpos_t_ _startpos_fn_ a fn t ->
    let _endpos = _endpos_t_ in
    let _startpos = _startpos_fn_ in
    (
# 203 "atd/src/parser.mly"
    ( let k, fk = fn in
      `Field ((_startpos, _endpos), (k, fk, a), t) )
# 553 "atd/src/parser.ml"
     : (Ast.field))

let _menhir_action_16 =
  fun _endpos_t_ _startpos__1_ t ->
    let _endpos = _endpos_t_ in
    let _startpos = _startpos__1_ in
    (
# 206 "atd/src/parser.mly"
    ( `Inherit ((_startpos, _endpos), t) )
# 563 "atd/src/parser.ml"
     : (Ast.field))

let _menhir_action_17 =
  fun _e _endpos__e_ _startpos__e_ ->
    let _ = (
# 208 "atd/src/parser.mly"
    ( syntax_error "Expecting type expression after ':'"
        _startpos__e_ _endpos__e_ )
# 572 "atd/src/parser.ml"
     : (Ast.field)) in
    prerr_string "Menhir: misuse: the semantic action associated with the production\nfield -> field_name annot COLON error\nis expected to abort the parser, but does not do so.\n";
    assert false

let _menhir_action_18 =
  fun _e _endpos__e_ _startpos__e_ ->
    let _ = (
# 211 "atd/src/parser.mly"
    ( syntax_error "Expecting ':'" _startpos__e_ _endpos__e_ )
# 582 "atd/src/parser.ml"
     : (Ast.field)) in
    prerr_string "Menhir: misuse: the semantic action associated with the production\nfield -> field_name annot error\nis expected to abort the parser, but does not do so.\n";
    assert false

let _menhir_action_19 =
  fun l x ->
    (
# 196 "atd/src/parser.mly"
                                       ( x :: l )
# 592 "atd/src/parser.ml"
     : (Ast.field list))

let _menhir_action_20 =
  fun x ->
    (
# 197 "atd/src/parser.mly"
                                       ( [ x ] )
# 600 "atd/src/parser.ml"
     : (Ast.field list))

let _menhir_action_21 =
  fun x ->
    (
# 198 "atd/src/parser.mly"
                                       ( [ x ] )
# 608 "atd/src/parser.ml"
     : (Ast.field list))

let _menhir_action_22 =
  fun k ->
    (
# 215 "atd/src/parser.mly"
                         ( (k, Required) )
# 616 "atd/src/parser.ml"
     : (string * Ast.field_kind))

let _menhir_action_23 =
  fun k ->
    (
# 216 "atd/src/parser.mly"
                         ( (k, Optional) )
# 624 "atd/src/parser.ml"
     : (string * Ast.field_kind))

let _menhir_action_24 =
  fun k ->
    (
# 217 "atd/src/parser.mly"
                         ( (k, With_default) )
# 632 "atd/src/parser.ml"
     : (string * Ast.field_kind))

let _menhir_action_25 =
  fun _endpos_x_ _startpos_x_ x y ->
    (
# 25 "atd/src/parser.mly"
                             ( (((_startpos_x_, _endpos_x_), x), y) )
# 640 "atd/src/parser.ml"
     : (Ast.full_module))

let _menhir_action_26 =
  fun _1 _3 ->
    (
# 62 "atd/src/parser.mly"
                         ( _1 :: _3 )
# 648 "atd/src/parser.ml"
     : (string list))

let _menhir_action_27 =
  fun _1 ->
    (
# 63 "atd/src/parser.mly"
                         ( [_1] )
# 656 "atd/src/parser.ml"
     : (string list))

let _menhir_action_28 =
  fun _1 _2 ->
    (
# 29 "atd/src/parser.mly"
                            ( _1 :: _2 )
# 664 "atd/src/parser.ml"
     : (Ast.module_body))

let _menhir_action_29 =
  fun () ->
    (
# 30 "atd/src/parser.mly"
                            ( [] )
# 672 "atd/src/parser.ml"
     : (Ast.module_body))

let _menhir_action_30 =
  fun _e _endpos__e_ _startpos__e_ ->
    let _ = (
# 31 "atd/src/parser.mly"
               ( syntax_error "Syntax error" _startpos__e_ _endpos__e_ )
# 680 "atd/src/parser.ml"
     : (Ast.module_body)) in
    prerr_string "Menhir: misuse: the semantic action associated with the production\nmodule_body -> error\nis expected to abort the parser, but does not do so.\n";
    assert false

let _menhir_action_31 =
  fun _endpos_t_ _startpos__1_ a p s t ->
    let _endpos = _endpos_t_ in
    let _startpos = _startpos__1_ in
    (
# 69 "atd/src/parser.mly"
                               ( Type ((_startpos, _endpos), (s, p, a), t) )
# 692 "atd/src/parser.ml"
     : (Ast.module_item))

let _menhir_action_32 =
  fun _e _endpos__e_ _startpos__e_ ->
    let _ = (
# 72 "atd/src/parser.mly"
    ( syntax_error "Expecting type expression" _startpos__e_ _endpos__e_ )
# 700 "atd/src/parser.ml"
     : (Ast.module_item)) in
    prerr_string "Menhir: misuse: the semantic action associated with the production\nmodule_item -> TYPE type_param LIDENT annot EQ error\nis expected to abort the parser, but does not do so.\n";
    assert false

let _menhir_action_33 =
  fun _e _endpos__e_ _startpos__e_ ->
    let _ = (
# 74 "atd/src/parser.mly"
    ( syntax_error "Expecting '='" _startpos__e_ _endpos__e_ )
# 710 "atd/src/parser.ml"
     : (Ast.module_item)) in
    prerr_string "Menhir: misuse: the semantic action associated with the production\nmodule_item -> TYPE type_param LIDENT annot error\nis expected to abort the parser, but does not do so.\n";
    assert false

let _menhir_action_34 =
  fun _e _endpos__e_ _startpos__e_ ->
    let _ = (
# 76 "atd/src/parser.mly"
    ( syntax_error "Expecting type name" _startpos__e_ _endpos__e_ )
# 720 "atd/src/parser.ml"
     : (Ast.module_item)) in
    prerr_string "Menhir: misuse: the semantic action associated with the production\nmodule_item -> TYPE error\nis expected to abort the parser, but does not do so.\n";
    assert false

let _menhir_action_35 =
  fun _1 _3 ->
    (
# 169 "atd/src/parser.mly"
                                 ( _1 :: _3 )
# 730 "atd/src/parser.ml"
     : (Ast.type_expr list))

let _menhir_action_36 =
  fun _1 _3 ->
    (
# 170 "atd/src/parser.mly"
                                 ( [ _1; _3 ] )
# 738 "atd/src/parser.ml"
     : (Ast.type_expr list))

let _menhir_action_37 =
  fun _1 ->
    (
# 161 "atd/src/parser.mly"
                                    ( [ _1 ] )
# 746 "atd/src/parser.ml"
     : (Ast.type_expr list))

let _menhir_action_38 =
  fun _2 ->
    (
# 162 "atd/src/parser.mly"
                                    ( _2 )
# 754 "atd/src/parser.ml"
     : (Ast.type_expr list))

let _menhir_action_39 =
  fun () ->
    (
# 163 "atd/src/parser.mly"
                                    ( [] )
# 762 "atd/src/parser.ml"
     : (Ast.type_expr list))

let _menhir_action_40 =
  fun _e _endpos__e_ _startpos__e_ ->
    let _ = (
# 165 "atd/src/parser.mly"
     ( syntax_error "Expecting ')'" _startpos__e_ _endpos__e_ )
# 770 "atd/src/parser.ml"
     : (Ast.type_expr list)) in
    prerr_string "Menhir: misuse: the semantic action associated with the production\ntype_args -> OP_PAREN type_arg_list error\nis expected to abort the parser, but does not do so.\n";
    assert false

let _menhir_action_41 =
  fun _endpos_a_ _startpos__1_ a l ->
    let _endpos = _endpos_a_ in
    let _startpos = _startpos__1_ in
    (
# 94 "atd/src/parser.mly"
     ( Sum ((_startpos, _endpos), l, a) )
# 782 "atd/src/parser.ml"
     : (Ast.type_expr))

let _menhir_action_42 =
  fun _endpos_a_ _startpos__1_ a ->
    let _endpos = _endpos_a_ in
    let _startpos = _startpos__1_ in
    (
# 96 "atd/src/parser.mly"
     ( Sum ((_startpos, _endpos), [], a) )
# 792 "atd/src/parser.ml"
     : (Ast.type_expr))

let _menhir_action_43 =
  fun _endpos_a_ _startpos__1_ a l ->
    let _endpos = _endpos_a_ in
    let _startpos = _startpos__1_ in
    (
# 99 "atd/src/parser.mly"
     ( Record ((_startpos, _endpos), l, a) )
# 802 "atd/src/parser.ml"
     : (Ast.type_expr))

let _menhir_action_44 =
  fun _endpos_a_ _startpos__1_ a ->
    let _endpos = _endpos_a_ in
    let _startpos = _startpos__1_ in
    (
# 101 "atd/src/parser.mly"
     ( Record ((_startpos, _endpos), [], a) )
# 812 "atd/src/parser.ml"
     : (Ast.type_expr))

let _menhir_action_45 =
  fun _endpos_a_ _startpos__1_ a x ->
    let _endpos = _endpos_a_ in
    let _startpos = _startpos__1_ in
    (
# 104 "atd/src/parser.mly"
     ( Tuple ((_startpos, _endpos), [x], a) )
# 822 "atd/src/parser.ml"
     : (Ast.type_expr))

let _menhir_action_46 =
  fun _endpos_a_ _startpos__1_ a l ->
    let _endpos = _endpos_a_ in
    let _startpos = _startpos__1_ in
    (
# 107 "atd/src/parser.mly"
     ( Tuple ((_startpos, _endpos), l, a) )
# 832 "atd/src/parser.ml"
     : (Ast.type_expr))

let _menhir_action_47 =
  fun _endpos_a_ _startpos_x_ a x ->
    let _endpos = _endpos_a_ in
    let _startpos = _startpos_x_ in
    (
# 110 "atd/src/parser.mly"
     ( let pos1 = _startpos in
       let pos2 = _endpos in
       let loc = (pos1, pos2) in
       let _, name, args = x in
       match name, args with
           "list", [x] -> List (loc, x, a)
         | "option", [x] -> Option (loc, x, a)
         | "nullable", [x] -> Nullable (loc, x, a)
         | "shared", [x] ->
             let a =
               if Annot.has_field ~sections:["share"] ~field:"id" a then
                 (* may cause ID clashes if not used properly *)
                 a
               else
                 Annot.set_field ~loc
                   ~section:"share" ~field:"id" (Some (Annot.create_id ())) a
             in
             Shared (loc, x, a)
         | "wrap", [x] -> Wrap (loc, x, a)

         | ("list"|"option"|"nullable"|"shared"|"wrap"), _ ->
             syntax_error (sprintf "%s expects one argument" name) pos1 pos2

         | _ -> (Name (loc, x, a) : type_expr) )
# 865 "atd/src/parser.ml"
     : (Ast.type_expr))

let _menhir_action_48 =
  fun _endpos_x_ _startpos_x_ x ->
    let _endpos = _endpos_x_ in
    let _startpos = _startpos_x_ in
    (
# 136 "atd/src/parser.mly"
     ( Tvar ((_startpos, _endpos), x) )
# 875 "atd/src/parser.ml"
     : (Ast.type_expr))

let _menhir_action_49 =
  fun _e _endpos__e_ _startpos__e_ ->
    let _ = (
# 138 "atd/src/parser.mly"
     ( syntax_error "Expecting ']'" _startpos__e_ _endpos__e_ )
# 883 "atd/src/parser.ml"
     : (Ast.type_expr)) in
    prerr_string "Menhir: misuse: the semantic action associated with the production\ntype_expr -> OP_BRACK variant_list error\nis expected to abort the parser, but does not do so.\n";
    assert false

let _menhir_action_50 =
  fun _e _endpos__e_ _startpos__e_ ->
    let _ = (
# 140 "atd/src/parser.mly"
     ( syntax_error "Expecting '}'" _startpos__e_ _endpos__e_ )
# 893 "atd/src/parser.ml"
     : (Ast.type_expr)) in
    prerr_string "Menhir: misuse: the semantic action associated with the production\ntype_expr -> OP_CURL field_list error\nis expected to abort the parser, but does not do so.\n";
    assert false

let _menhir_action_51 =
  fun _e _endpos__e_ _startpos__e_ ->
    let _ = (
# 142 "atd/src/parser.mly"
     ( syntax_error "Expecting ')'" _startpos__e_ _endpos__e_ )
# 903 "atd/src/parser.ml"
     : (Ast.type_expr)) in
    prerr_string "Menhir: misuse: the semantic action associated with the production\ntype_expr -> OP_PAREN cartesian_product error\nis expected to abort the parser, but does not do so.\n";
    assert false

let _menhir_action_52 =
  fun _endpos_s_ _startpos_l_ l s ->
    let _endpos = _endpos_s_ in
    let _startpos = _startpos_l_ in
    (
# 157 "atd/src/parser.mly"
                            ( ((_startpos, _endpos), s, l) )
# 915 "atd/src/parser.ml"
     : (Ast.type_inst))

let _menhir_action_53 =
  fun _1 ->
    (
# 80 "atd/src/parser.mly"
                                    ( [ _1 ] )
# 923 "atd/src/parser.ml"
     : (Ast.type_param))

let _menhir_action_54 =
  fun _2 ->
    (
# 81 "atd/src/parser.mly"
                                    ( _2 )
# 931 "atd/src/parser.ml"
     : (Ast.type_param))

let _menhir_action_55 =
  fun () ->
    (
# 82 "atd/src/parser.mly"
                                    ( [] )
# 939 "atd/src/parser.ml"
     : (Ast.type_param))

let _menhir_action_56 =
  fun _e _endpos__e_ _startpos__e_ ->
    let _ = (
# 84 "atd/src/parser.mly"
    ( syntax_error "Expecting ')'" _startpos__e_ _endpos__e_ )
# 947 "atd/src/parser.ml"
     : (Ast.type_param)) in
    prerr_string "Menhir: misuse: the semantic action associated with the production\ntype_param -> OP_PAREN type_var_list error\nis expected to abort the parser, but does not do so.\n";
    assert false

let _menhir_action_57 =
  fun _1 _3 ->
    (
# 88 "atd/src/parser.mly"
                               ( _1 :: _3 )
# 957 "atd/src/parser.ml"
     : (Ast.type_param))

let _menhir_action_58 =
  fun _1 ->
    (
# 89 "atd/src/parser.mly"
                               ( [ _1 ] )
# 965 "atd/src/parser.ml"
     : (Ast.type_param))

let _menhir_action_59 =
  fun _endpos_t_ _startpos_x_ a t x ->
    let _endpos = _endpos_t_ in
    let _startpos = _startpos_x_ in
    (
# 185 "atd/src/parser.mly"
     ( Variant ((_startpos, _endpos), (x, a), Some t) )
# 975 "atd/src/parser.ml"
     : (Ast.variant))

let _menhir_action_60 =
  fun _endpos_a_ _startpos_x_ a x ->
    let _endpos = _endpos_a_ in
    let _startpos = _startpos_x_ in
    (
# 187 "atd/src/parser.mly"
     ( Variant ((_startpos, _endpos), (x, a), None) )
# 985 "atd/src/parser.ml"
     : (Ast.variant))

let _menhir_action_61 =
  fun _endpos_t_ _startpos__1_ t ->
    let _endpos = _endpos_t_ in
    let _startpos = _startpos__1_ in
    (
# 189 "atd/src/parser.mly"
     ( Inherit ((_startpos, _endpos), t) )
# 995 "atd/src/parser.ml"
     : (Ast.variant))

let _menhir_action_62 =
  fun _e _endpos__e_ _startpos__e_ ->
    let _ = (
# 191 "atd/src/parser.mly"
     ( syntax_error "Expecting type expression after 'of'"
         _startpos__e_ _endpos__e_ )
# 1004 "atd/src/parser.ml"
     : (Ast.variant)) in
    prerr_string "Menhir: misuse: the semantic action associated with the production\nvariant -> UIDENT annot OF error\nis expected to abort the parser, but does not do so.\n";
    assert false

let _menhir_action_63 =
  fun _2 ->
    (
# 174 "atd/src/parser.mly"
                    ( _2 )
# 1014 "atd/src/parser.ml"
     : (Ast.variant list))

let _menhir_action_64 =
  fun _1 ->
    (
# 175 "atd/src/parser.mly"
                    ( _1 )
# 1022 "atd/src/parser.ml"
     : (Ast.variant list))

let _menhir_action_65 =
  fun _1 _3 ->
    (
# 179 "atd/src/parser.mly"
                             ( _1 :: _3 )
# 1030 "atd/src/parser.ml"
     : (Ast.variant list))

let _menhir_action_66 =
  fun _1 ->
    (
# 180 "atd/src/parser.mly"
                             ( ([ _1 ] : variant list) )
# 1038 "atd/src/parser.ml"
     : (Ast.variant list))

let _menhir_print_token : token -> string =
  fun _tok ->
    match _tok with
    | BAR ->
        "BAR"
    | CL_BRACK ->
        "CL_BRACK"
    | CL_CURL ->
        "CL_CURL"
    | CL_PAREN ->
        "CL_PAREN"
    | COLON ->
        "COLON"
    | COMMA ->
        "COMMA"
    | DOT ->
        "DOT"
    | EOF ->
        "EOF"
    | EQ ->
        "EQ"
    | GT ->
        "GT"
    | INHERIT ->
        "INHERIT"
    | LIDENT _ ->
        "LIDENT"
    | LT ->
        "LT"
    | OF ->
        "OF"
    | OP_BRACK ->
        "OP_BRACK"
    | OP_CURL ->
        "OP_CURL"
    | OP_PAREN ->
        "OP_PAREN"
    | QUESTION ->
        "QUESTION"
    | SEMICOLON ->
        "SEMICOLON"
    | STAR ->
        "STAR"
    | STRING _ ->
        "STRING"
    | TIDENT _ ->
        "TIDENT"
    | TILDE ->
        "TILDE"
    | TYPE ->
        "TYPE"
    | UIDENT _ ->
        "UIDENT"

let _menhir_fail : unit -> 'a =
  fun () ->
    Printf.eprintf "Internal failure -- please contact the parser generator's developers.\n%!";
    assert false

include struct
  
  [@@@ocaml.warning "-4-37-39"]
  
  let rec _menhir_error_run_095 : type  ttv_stack. ttv_stack -> _menhir_box_full_module =
    fun _menhir_stack ->
      _eRR ()
  
  let rec _menhir_error_run_148 : type  ttv_stack. (ttv_stack, _menhir_box_full_module) _menhir_cell1_annot -> _ -> _menhir_box_full_module =
    fun _menhir_stack _v ->
      let MenhirCell1_annot (_menhir_stack, _, x, _startpos_x_, _endpos_x_) = _menhir_stack in
      let y = _v in
      let _v = _menhir_action_25 _endpos_x_ _startpos_x_ x y in
      MenhirBox_full_module _v
  
  let rec _menhir_error_goto_module_body : type  ttv_stack. ttv_stack -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _v _menhir_s ->
      match _menhir_s with
      | MenhirState018 ->
          _menhir_error_run_148 _menhir_stack _v
      | MenhirState146 ->
          _menhir_error_run_147 _menhir_stack _v
      | _ ->
          _menhir_fail ()
  
  and _menhir_error_run_147 : type  ttv_stack. (ttv_stack, _menhir_box_full_module) _menhir_cell1_module_item -> _ -> _menhir_box_full_module =
    fun _menhir_stack _v ->
      let MenhirCell1_module_item (_menhir_stack, _menhir_s, _1) = _menhir_stack in
      let _2 = _v in
      let _v = _menhir_action_28 _1 _2 in
      _menhir_error_goto_module_body _menhir_stack _v _menhir_s
  
  let rec _menhir_error_run_019 : type  ttv_stack. ttv_stack -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let (_endpos__e_, _startpos__e_, _e) = (_endpos, _startpos, ()) in
      let _v = _menhir_action_30 _e _endpos__e_ _startpos__e_ in
      _menhir_error_goto_module_body _menhir_stack _v _menhir_s
  
  let rec _menhir_error_goto_module_item : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _v _menhir_s ->
      let _menhir_stack = MenhirCell1_module_item (_menhir_stack, _menhir_s, _v) in
      _menhir_error_run_019 _menhir_stack _menhir_lexbuf MenhirState146
  
  let rec _menhir_error_run_144 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_TYPE _menhir_cell0_type_param _menhir_cell0_LIDENT, _menhir_box_full_module) _menhir_cell1_annot -> _ -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _endpos _v ->
      let MenhirCell1_annot (_menhir_stack, _, a, _, _) = _menhir_stack in
      let MenhirCell0_LIDENT (_menhir_stack, s, _, _) = _menhir_stack in
      let MenhirCell0_type_param (_menhir_stack, p) = _menhir_stack in
      let MenhirCell1_TYPE (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos_t_, t) = (_endpos, _v) in
      let _v = _menhir_action_31 _endpos_t_ _startpos__1_ a p s t in
      _menhir_error_goto_module_item _menhir_stack _menhir_lexbuf _v _menhir_s
  
  let rec _menhir_error_run_136 : type  ttv_stack. (ttv_stack, _menhir_box_full_module) _menhir_cell1_annot -> _menhir_box_full_module =
    fun _menhir_stack ->
      _eRR ()
  
  let rec _menhir_error_run_141 : type  ttv_stack. (ttv_stack, _menhir_box_full_module) _menhir_cell1_OP_PAREN -> _menhir_box_full_module =
    fun _menhir_stack ->
      _eRR ()
  
  let rec _menhir_error_run_124 : type  ttv_stack. (ttv_stack, _menhir_box_full_module) _menhir_cell1_OP_PAREN -> _menhir_box_full_module =
    fun _menhir_stack ->
      _eRR ()
  
  let rec _menhir_error_run_115 : type  ttv_stack. ttv_stack -> _menhir_box_full_module =
    fun _menhir_stack ->
      _eRR ()
  
  let rec _menhir_error_run_063 : type  ttv_stack. ttv_stack -> _menhir_box_full_module =
    fun _menhir_stack ->
      _eRR ()
  
  let rec _menhir_error_goto_type_args : type  ttv_stack. ttv_stack -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_s ->
      match _menhir_s with
      | MenhirState037 ->
          _menhir_error_run_115 _menhir_stack
      | MenhirState135 ->
          _menhir_error_run_115 _menhir_stack
      | MenhirState039 ->
          _menhir_error_run_115 _menhir_stack
      | MenhirState034 ->
          _menhir_error_run_063 _menhir_stack
      | MenhirState130 ->
          _menhir_error_run_063 _menhir_stack
      | MenhirState125 ->
          _menhir_error_run_063 _menhir_stack
      | MenhirState112 ->
          _menhir_error_run_063 _menhir_stack
      | MenhirState046 ->
          _menhir_error_run_063 _menhir_stack
      | MenhirState053 ->
          _menhir_error_run_063 _menhir_stack
      | MenhirState065 ->
          _menhir_error_run_063 _menhir_stack
      | MenhirState058 ->
          _menhir_error_run_063 _menhir_stack
      | _ ->
          _menhir_fail ()
  
  let rec _menhir_error_run_117 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_OP_PAREN as 'stack) -> _ -> _ -> ('stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _v _menhir_s ->
      let _menhir_stack = MenhirCell1_type_arg_list (_menhir_stack, _menhir_s, _v) in
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let MenhirCell1_type_arg_list (_menhir_stack, _, _) = _menhir_stack in
      let MenhirCell1_OP_PAREN (_menhir_stack, _menhir_s, _) = _menhir_stack in
      let (_endpos__e_, _startpos__e_, _e) = (_endpos, _startpos, ()) in
      let _ = _menhir_action_40 _e _endpos__e_ _startpos__e_ in
      _menhir_error_goto_type_args _menhir_stack _menhir_s
  
  let rec _menhir_error_goto_type_arg_list : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _v _menhir_s ->
      match _menhir_s with
      | MenhirState037 ->
          _menhir_error_run_117 _menhir_stack _menhir_lexbuf _v _menhir_s
      | MenhirState039 ->
          _menhir_error_run_117 _menhir_stack _menhir_lexbuf _v _menhir_s
      | MenhirState112 ->
          _menhir_error_run_114 _menhir_stack _menhir_lexbuf _v
      | _ ->
          _menhir_fail ()
  
  and _menhir_error_run_114 : type  ttv_stack. (ttv_stack, _menhir_box_full_module) _menhir_cell1_type_expr -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _v ->
      let MenhirCell1_type_expr (_menhir_stack, _menhir_s, _1, _, _) = _menhir_stack in
      let _3 = _v in
      let _v = _menhir_action_35 _1 _3 in
      _menhir_error_goto_type_arg_list _menhir_stack _menhir_lexbuf _v _menhir_s
  
  let rec _menhir_error_run_113 : type  ttv_stack. (ttv_stack, _menhir_box_full_module) _menhir_cell1_type_expr -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _v ->
      let MenhirCell1_type_expr (_menhir_stack, _menhir_s, _1, _, _) = _menhir_stack in
      let _3 = _v in
      let _v = _menhir_action_36 _1 _3 in
      _menhir_error_goto_type_arg_list _menhir_stack _menhir_lexbuf _v _menhir_s
  
  let rec _menhir_error_run_111 : type  ttv_stack. (ttv_stack, _menhir_box_full_module) _menhir_cell1_OP_PAREN -> _menhir_box_full_module =
    fun _menhir_stack ->
      _eRR ()
  
  let rec _menhir_error_goto_type_expr : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _endpos _startpos _v _menhir_s ->
      match _menhir_s with
      | MenhirState034 ->
          _menhir_error_run_144 _menhir_stack _menhir_lexbuf _endpos _v
      | MenhirState135 ->
          _menhir_error_run_136 _menhir_stack
      | MenhirState130 ->
          _menhir_error_run_131 _menhir_stack _menhir_lexbuf _endpos _v
      | MenhirState125 ->
          _menhir_error_run_126 _menhir_stack _menhir_lexbuf _endpos _startpos _v _menhir_s
      | MenhirState112 ->
          _menhir_error_run_113 _menhir_stack _menhir_lexbuf _v
      | MenhirState037 ->
          _menhir_error_run_111 _menhir_stack
      | MenhirState039 ->
          _menhir_error_run_111 _menhir_stack
      | MenhirState046 ->
          _menhir_error_run_087 _menhir_stack _menhir_lexbuf _endpos _v
      | MenhirState053 ->
          _menhir_error_run_079 _menhir_stack _menhir_lexbuf _endpos _v
      | MenhirState065 ->
          _menhir_error_run_066 _menhir_stack _menhir_lexbuf _endpos _v
      | MenhirState058 ->
          _menhir_error_run_062 _menhir_stack _menhir_lexbuf _endpos _v
      | _ ->
          _menhir_fail ()
  
  and _menhir_error_run_131 : type  ttv_stack. (ttv_stack, _menhir_box_full_module) _menhir_cell1_annot -> _ -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _endpos _v ->
      let MenhirCell1_annot (_menhir_stack, _menhir_s, a, _startpos_a_, _) = _menhir_stack in
      let (_endpos_x_, x) = (_endpos, _v) in
      let _v = _menhir_action_07 _endpos_x_ _startpos_a_ a x in
      _menhir_error_goto_annot_expr _menhir_stack _menhir_lexbuf _v _menhir_s
  
  and _menhir_error_goto_annot_expr : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _v _menhir_s ->
      match _menhir_s with
      | MenhirState037 ->
          _menhir_error_run_141 _menhir_stack
      | MenhirState125 ->
          _menhir_error_run_128 _menhir_stack _menhir_lexbuf _v
      | MenhirState039 ->
          _menhir_error_run_124 _menhir_stack
      | _ ->
          _menhir_fail ()
  
  and _menhir_error_run_128 : type  ttv_stack. (ttv_stack, _menhir_box_full_module) _menhir_cell1_annot_expr -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _v ->
      let MenhirCell1_annot_expr (_menhir_stack, _menhir_s, x) = _menhir_stack in
      let y = _v in
      let _v = _menhir_action_13 x y in
      _menhir_error_goto_cartesian_product _menhir_stack _menhir_lexbuf _v _menhir_s
  
  and _menhir_error_goto_cartesian_product : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _v _menhir_s ->
      match _menhir_s with
      | MenhirState037 ->
          _menhir_error_run_137 _menhir_stack _menhir_lexbuf _v _menhir_s
      | MenhirState125 ->
          _menhir_error_run_127 _menhir_stack _menhir_lexbuf _v
      | MenhirState039 ->
          _menhir_error_run_120 _menhir_stack _menhir_lexbuf _v _menhir_s
      | _ ->
          _menhir_fail ()
  
  and _menhir_error_run_137 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_OP_PAREN as 'stack) -> _ -> _ -> ('stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _v _menhir_s ->
      let _menhir_stack = MenhirCell1_cartesian_product (_menhir_stack, _menhir_s, _v) in
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let MenhirCell1_cartesian_product (_menhir_stack, _, _) = _menhir_stack in
      let MenhirCell1_OP_PAREN (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos__e_, _startpos__e_, _e) = (_endpos, _startpos, ()) in
      let _v = _menhir_action_51 _e _endpos__e_ _startpos__e_ in
      _menhir_error_goto_type_expr _menhir_stack _menhir_lexbuf _endpos__e_ _startpos__1_ _v _menhir_s
  
  and _menhir_error_run_127 : type  ttv_stack. (ttv_stack, _menhir_box_full_module) _menhir_cell1_annot_expr -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _v ->
      let MenhirCell1_annot_expr (_menhir_stack, _menhir_s, x) = _menhir_stack in
      let l = _v in
      let _v = _menhir_action_12 l x in
      _menhir_error_goto_cartesian_product _menhir_stack _menhir_lexbuf _v _menhir_s
  
  and _menhir_error_run_120 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_OP_PAREN as 'stack) -> _ -> _ -> ('stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _v _menhir_s ->
      let _menhir_stack = MenhirCell1_cartesian_product (_menhir_stack, _menhir_s, _v) in
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let MenhirCell1_cartesian_product (_menhir_stack, _, _) = _menhir_stack in
      let MenhirCell1_OP_PAREN (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos__e_, _startpos__e_, _e) = (_endpos, _startpos, ()) in
      let _v = _menhir_action_51 _e _endpos__e_ _startpos__e_ in
      _menhir_error_goto_type_expr _menhir_stack _menhir_lexbuf _endpos__e_ _startpos__1_ _v _menhir_s
  
  and _menhir_error_run_126 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_annot_expr as 'stack) -> _ -> _ -> _ -> _ -> ('stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _endpos _startpos _v _menhir_s ->
      let (_endpos_x_, _startpos_x_, x) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_08 _endpos_x_ _startpos_x_ x in
      _menhir_error_goto_annot_expr _menhir_stack _menhir_lexbuf _v _menhir_s
  
  and _menhir_error_run_087 : type  ttv_stack. (ttv_stack, _menhir_box_full_module) _menhir_cell1_INHERIT -> _ -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _endpos _v ->
      let MenhirCell1_INHERIT (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos_t_, t) = (_endpos, _v) in
      let _v = _menhir_action_16 _endpos_t_ _startpos__1_ t in
      _menhir_error_goto_field _menhir_stack _menhir_lexbuf _v _menhir_s
  
  and _menhir_error_goto_field : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _v _menhir_s ->
      let x = _v in
      let _v = _menhir_action_21 x in
      _menhir_error_goto_field_list _menhir_stack _menhir_lexbuf _v _menhir_s
  
  and _menhir_error_goto_field_list : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _v _menhir_s ->
      match _menhir_s with
      | MenhirState040 ->
          _menhir_error_run_098 _menhir_stack _menhir_lexbuf _v _menhir_s
      | MenhirState085 ->
          _menhir_error_run_086 _menhir_stack _menhir_lexbuf _v
      | MenhirState047 ->
          _menhir_error_run_080 _menhir_stack _menhir_lexbuf _v _menhir_s
      | _ ->
          _menhir_fail ()
  
  and _menhir_error_run_098 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_OP_CURL as 'stack) -> _ -> _ -> ('stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _v _menhir_s ->
      let _menhir_stack = MenhirCell1_field_list (_menhir_stack, _menhir_s, _v) in
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let MenhirCell1_field_list (_menhir_stack, _, _) = _menhir_stack in
      let MenhirCell1_OP_CURL (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos__e_, _startpos__e_, _e) = (_endpos, _startpos, ()) in
      let _v = _menhir_action_50 _e _endpos__e_ _startpos__e_ in
      _menhir_error_goto_type_expr _menhir_stack _menhir_lexbuf _endpos__e_ _startpos__1_ _v _menhir_s
  
  and _menhir_error_run_086 : type  ttv_stack. (ttv_stack, _menhir_box_full_module) _menhir_cell1_field -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _v ->
      let MenhirCell1_field (_menhir_stack, _menhir_s, x) = _menhir_stack in
      let l = _v in
      let _v = _menhir_action_19 l x in
      _menhir_error_goto_field_list _menhir_stack _menhir_lexbuf _v _menhir_s
  
  and _menhir_error_run_080 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_OP_CURL as 'stack) -> _ -> _ -> ('stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _v _menhir_s ->
      let _menhir_stack = MenhirCell1_field_list (_menhir_stack, _menhir_s, _v) in
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let MenhirCell1_field_list (_menhir_stack, _, _) = _menhir_stack in
      let MenhirCell1_OP_CURL (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos__e_, _startpos__e_, _e) = (_endpos, _startpos, ()) in
      let _v = _menhir_action_50 _e _endpos__e_ _startpos__e_ in
      _menhir_error_goto_type_expr _menhir_stack _menhir_lexbuf _endpos__e_ _startpos__1_ _v _menhir_s
  
  and _menhir_error_run_079 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_field_name, _menhir_box_full_module) _menhir_cell1_annot -> _ -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _endpos _v ->
      let MenhirCell1_annot (_menhir_stack, _, a, _, _) = _menhir_stack in
      let MenhirCell1_field_name (_menhir_stack, _menhir_s, fn, _startpos_fn_) = _menhir_stack in
      let (_endpos_t_, t) = (_endpos, _v) in
      let _v = _menhir_action_15 _endpos_t_ _startpos_fn_ a fn t in
      _menhir_error_goto_field _menhir_stack _menhir_lexbuf _v _menhir_s
  
  and _menhir_error_run_066 : type  ttv_stack. (ttv_stack, _menhir_box_full_module) _menhir_cell1_INHERIT -> _ -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _endpos _v ->
      let MenhirCell1_INHERIT (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos_t_, t) = (_endpos, _v) in
      let _v = _menhir_action_61 _endpos_t_ _startpos__1_ t in
      _menhir_error_goto_variant _menhir_stack _menhir_lexbuf _v _menhir_s
  
  and _menhir_error_goto_variant : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _v _menhir_s ->
      let _1 = _v in
      let _v = _menhir_action_66 _1 in
      _menhir_error_goto_variant_list0 _menhir_stack _menhir_lexbuf _v _menhir_s
  
  and _menhir_error_goto_variant_list0 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _v _menhir_s ->
      match _menhir_s with
      | MenhirState102 ->
          _menhir_error_run_074 _menhir_stack _menhir_lexbuf _v _menhir_s
      | MenhirState055 ->
          _menhir_error_run_074 _menhir_stack _menhir_lexbuf _v _menhir_s
      | MenhirState072 ->
          _menhir_error_run_073 _menhir_stack _menhir_lexbuf _v
      | MenhirState069 ->
          _menhir_error_run_070 _menhir_stack _menhir_lexbuf _v
      | _ ->
          _menhir_fail ()
  
  and _menhir_error_run_074 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_OP_BRACK as 'stack) -> _ -> _ -> ('stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _v _menhir_s ->
      let _1 = _v in
      let _v = _menhir_action_64 _1 in
      _menhir_error_goto_variant_list _menhir_stack _menhir_lexbuf _v _menhir_s
  
  and _menhir_error_goto_variant_list : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_OP_BRACK as 'stack) -> _ -> _ -> ('stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _v _menhir_s ->
      match _menhir_s with
      | MenhirState102 ->
          _menhir_error_run_105 _menhir_stack _menhir_lexbuf _v _menhir_s
      | MenhirState055 ->
          _menhir_error_run_075 _menhir_stack _menhir_lexbuf _v _menhir_s
      | _ ->
          _menhir_fail ()
  
  and _menhir_error_run_105 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_OP_BRACK as 'stack) -> _ -> _ -> ('stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _v _menhir_s ->
      let _menhir_stack = MenhirCell1_variant_list (_menhir_stack, _menhir_s, _v) in
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let MenhirCell1_variant_list (_menhir_stack, _, _) = _menhir_stack in
      let MenhirCell1_OP_BRACK (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos__e_, _startpos__e_, _e) = (_endpos, _startpos, ()) in
      let _v = _menhir_action_49 _e _endpos__e_ _startpos__e_ in
      _menhir_error_goto_type_expr _menhir_stack _menhir_lexbuf _endpos__e_ _startpos__1_ _v _menhir_s
  
  and _menhir_error_run_075 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_OP_BRACK as 'stack) -> _ -> _ -> ('stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _v _menhir_s ->
      let _menhir_stack = MenhirCell1_variant_list (_menhir_stack, _menhir_s, _v) in
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let MenhirCell1_variant_list (_menhir_stack, _, _) = _menhir_stack in
      let MenhirCell1_OP_BRACK (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos__e_, _startpos__e_, _e) = (_endpos, _startpos, ()) in
      let _v = _menhir_action_49 _e _endpos__e_ _startpos__e_ in
      _menhir_error_goto_type_expr _menhir_stack _menhir_lexbuf _endpos__e_ _startpos__1_ _v _menhir_s
  
  and _menhir_error_run_073 : type  ttv_stack. (ttv_stack, _menhir_box_full_module) _menhir_cell1_variant -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _v ->
      let MenhirCell1_variant (_menhir_stack, _menhir_s, _1) = _menhir_stack in
      let _3 = _v in
      let _v = _menhir_action_65 _1 _3 in
      _menhir_error_goto_variant_list0 _menhir_stack _menhir_lexbuf _v _menhir_s
  
  and _menhir_error_run_070 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_OP_BRACK, _menhir_box_full_module) _menhir_cell1_BAR -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _v ->
      let MenhirCell1_BAR (_menhir_stack, _menhir_s) = _menhir_stack in
      let _2 = _v in
      let _v = _menhir_action_63 _2 in
      _menhir_error_goto_variant_list _menhir_stack _menhir_lexbuf _v _menhir_s
  
  and _menhir_error_run_062 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_UIDENT, _menhir_box_full_module) _menhir_cell1_annot -> _ -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _endpos _v ->
      let MenhirCell1_annot (_menhir_stack, _, a, _, _) = _menhir_stack in
      let MenhirCell1_UIDENT (_menhir_stack, _menhir_s, x, _startpos_x_) = _menhir_stack in
      let (_endpos_t_, t) = (_endpos, _v) in
      let _v = _menhir_action_59 _endpos_t_ _startpos_x_ a t x in
      _menhir_error_goto_variant _menhir_stack _menhir_lexbuf _v _menhir_s
  
  let rec _menhir_error_run_143 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_OP_PAREN, _menhir_box_full_module) _menhir_cell1_annot_expr -> _ -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _endpos _v ->
      let MenhirCell1_annot_expr (_menhir_stack, _, x) = _menhir_stack in
      let MenhirCell1_OP_PAREN (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos_a_, a) = (_endpos, _v) in
      let _v = _menhir_action_45 _endpos_a_ _startpos__1_ a x in
      _menhir_error_goto_type_expr _menhir_stack _menhir_lexbuf _endpos_a_ _startpos__1_ _v _menhir_s
  
  let rec _menhir_error_run_140 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_OP_PAREN, _menhir_box_full_module) _menhir_cell1_cartesian_product -> _ -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _endpos _v ->
      let MenhirCell1_cartesian_product (_menhir_stack, _, l) = _menhir_stack in
      let MenhirCell1_OP_PAREN (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos_a_, a) = (_endpos, _v) in
      let _v = _menhir_action_46 _endpos_a_ _startpos__1_ a l in
      _menhir_error_goto_type_expr _menhir_stack _menhir_lexbuf _endpos_a_ _startpos__1_ _v _menhir_s
  
  let rec _menhir_error_run_134 : type  ttv_stack. ttv_stack -> _menhir_box_full_module =
    fun _menhir_stack ->
      _eRR ()
  
  let rec _menhir_error_run_133 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_OP_PAREN, _menhir_box_full_module) _menhir_cell1_annot_expr -> _ -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _endpos _v ->
      let MenhirCell1_annot_expr (_menhir_stack, _, x) = _menhir_stack in
      let MenhirCell1_OP_PAREN (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos_a_, a) = (_endpos, _v) in
      let _v = _menhir_action_45 _endpos_a_ _startpos__1_ a x in
      _menhir_error_goto_type_expr _menhir_stack _menhir_lexbuf _endpos_a_ _startpos__1_ _v _menhir_s
  
  let rec _menhir_error_run_129 : type  ttv_stack. ttv_stack -> _menhir_box_full_module =
    fun _menhir_stack ->
      _eRR ()
  
  let rec _menhir_error_run_123 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_OP_PAREN, _menhir_box_full_module) _menhir_cell1_cartesian_product -> _ -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _endpos _v ->
      let MenhirCell1_cartesian_product (_menhir_stack, _, l) = _menhir_stack in
      let MenhirCell1_OP_PAREN (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos_a_, a) = (_endpos, _v) in
      let _v = _menhir_action_46 _endpos_a_ _startpos__1_ a l in
      _menhir_error_goto_type_expr _menhir_stack _menhir_lexbuf _endpos_a_ _startpos__1_ _v _menhir_s
  
  let rec _menhir_error_run_110 : type  ttv_stack. (ttv_stack, _menhir_box_full_module) _menhir_cell1_type_inst -> _ -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _endpos _v ->
      let MenhirCell1_type_inst (_menhir_stack, _menhir_s, x, _startpos_x_) = _menhir_stack in
      let (_endpos_a_, a) = (_endpos, _v) in
      let _v = _menhir_action_47 _endpos_a_ _startpos_x_ a x in
      _menhir_error_goto_type_expr _menhir_stack _menhir_lexbuf _endpos_a_ _startpos_x_ _v _menhir_s
  
  let rec _menhir_error_run_108 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_OP_BRACK, _menhir_box_full_module) _menhir_cell1_variant_list -> _ -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _endpos _v ->
      let MenhirCell1_variant_list (_menhir_stack, _, l) = _menhir_stack in
      let MenhirCell1_OP_BRACK (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos_a_, a) = (_endpos, _v) in
      let _v = _menhir_action_41 _endpos_a_ _startpos__1_ a l in
      _menhir_error_goto_type_expr _menhir_stack _menhir_lexbuf _endpos_a_ _startpos__1_ _v _menhir_s
  
  let rec _menhir_error_run_104 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_OP_BRACK, _menhir_box_full_module) _menhir_cell1_CL_BRACK -> _ -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _endpos _v ->
      let MenhirCell1_CL_BRACK (_menhir_stack, _) = _menhir_stack in
      let MenhirCell1_OP_BRACK (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos_a_, a) = (_endpos, _v) in
      let _v = _menhir_action_42 _endpos_a_ _startpos__1_ a in
      _menhir_error_goto_type_expr _menhir_stack _menhir_lexbuf _endpos_a_ _startpos__1_ _v _menhir_s
  
  let rec _menhir_error_run_101 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_OP_CURL, _menhir_box_full_module) _menhir_cell1_field_list -> _ -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _endpos _v ->
      let MenhirCell1_field_list (_menhir_stack, _, l) = _menhir_stack in
      let MenhirCell1_OP_CURL (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos_a_, a) = (_endpos, _v) in
      let _v = _menhir_action_43 _endpos_a_ _startpos__1_ a l in
      _menhir_error_goto_type_expr _menhir_stack _menhir_lexbuf _endpos_a_ _startpos__1_ _v _menhir_s
  
  let rec _menhir_error_run_097 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_OP_CURL, _menhir_box_full_module) _menhir_cell1_CL_CURL -> _ -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _endpos _v ->
      let MenhirCell1_CL_CURL (_menhir_stack, _) = _menhir_stack in
      let MenhirCell1_OP_CURL (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos_a_, a) = (_endpos, _v) in
      let _v = _menhir_action_44 _endpos_a_ _startpos__1_ a in
      _menhir_error_goto_type_expr _menhir_stack _menhir_lexbuf _endpos_a_ _startpos__1_ _v _menhir_s
  
  let rec _menhir_error_run_083 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_OP_CURL, _menhir_box_full_module) _menhir_cell1_field_list -> _ -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _endpos _v ->
      let MenhirCell1_field_list (_menhir_stack, _, l) = _menhir_stack in
      let MenhirCell1_OP_CURL (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos_a_, a) = (_endpos, _v) in
      let _v = _menhir_action_43 _endpos_a_ _startpos__1_ a l in
      _menhir_error_goto_type_expr _menhir_stack _menhir_lexbuf _endpos_a_ _startpos__1_ _v _menhir_s
  
  let rec _menhir_error_run_078 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_OP_BRACK, _menhir_box_full_module) _menhir_cell1_variant_list -> _ -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _endpos _v ->
      let MenhirCell1_variant_list (_menhir_stack, _, l) = _menhir_stack in
      let MenhirCell1_OP_BRACK (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos_a_, a) = (_endpos, _v) in
      let _v = _menhir_action_41 _endpos_a_ _startpos__1_ a l in
      _menhir_error_goto_type_expr _menhir_stack _menhir_lexbuf _endpos_a_ _startpos__1_ _v _menhir_s
  
  let rec _menhir_error_run_068 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_OP_BRACK, _menhir_box_full_module) _menhir_cell1_CL_BRACK -> _ -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _endpos _v ->
      let MenhirCell1_CL_BRACK (_menhir_stack, _) = _menhir_stack in
      let MenhirCell1_OP_BRACK (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos_a_, a) = (_endpos, _v) in
      let _v = _menhir_action_42 _endpos_a_ _startpos__1_ a in
      _menhir_error_goto_type_expr _menhir_stack _menhir_lexbuf _endpos_a_ _startpos__1_ _v _menhir_s
  
  let rec _menhir_error_run_061 : type  ttv_stack. (ttv_stack, _menhir_box_full_module) _menhir_cell1_type_inst -> _ -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _endpos _v ->
      let MenhirCell1_type_inst (_menhir_stack, _menhir_s, x, _startpos_x_) = _menhir_stack in
      let (_endpos_a_, a) = (_endpos, _v) in
      let _v = _menhir_action_47 _endpos_a_ _startpos_x_ a x in
      _menhir_error_goto_type_expr _menhir_stack _menhir_lexbuf _endpos_a_ _startpos_x_ _v _menhir_s
  
  let rec _menhir_error_run_057 : type  ttv_stack. (ttv_stack, _menhir_box_full_module) _menhir_cell1_UIDENT -> _ -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _endpos _v ->
      let MenhirCell1_UIDENT (_menhir_stack, _menhir_s, x, _startpos_x_) = _menhir_stack in
      let (_endpos_a_, a) = (_endpos, _v) in
      let _v = _menhir_action_60 _endpos_a_ _startpos_x_ a x in
      _menhir_error_goto_variant _menhir_stack _menhir_lexbuf _v _menhir_s
  
  let rec _menhir_error_run_052 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_field_name, _menhir_box_full_module) _menhir_cell1_annot -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let MenhirCell1_annot (_menhir_stack, _, _, _, _) = _menhir_stack in
      let MenhirCell1_field_name (_menhir_stack, _menhir_s, _, _) = _menhir_stack in
      let (_endpos__e_, _startpos__e_, _e) = (_endpos, _startpos, ()) in
      let _v = _menhir_action_18 _e _endpos__e_ _startpos__e_ in
      _menhir_error_goto_field _menhir_stack _menhir_lexbuf _v _menhir_s
  
  let rec _menhir_error_run_051 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_field_name as 'stack) -> _ -> _ -> _ -> _ -> ('stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _endpos _startpos _v _menhir_s ->
      let _menhir_stack = MenhirCell1_annot (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
      _menhir_error_run_052 _menhir_stack _menhir_lexbuf
  
  let rec _menhir_error_run_049 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_OP_CURL, _menhir_box_full_module) _menhir_cell1_CL_CURL -> _ -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _endpos _v ->
      let MenhirCell1_CL_CURL (_menhir_stack, _) = _menhir_stack in
      let MenhirCell1_OP_CURL (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos_a_, a) = (_endpos, _v) in
      let _v = _menhir_action_44 _endpos_a_ _startpos__1_ a in
      _menhir_error_goto_type_expr _menhir_stack _menhir_lexbuf _endpos_a_ _startpos__1_ _v _menhir_s
  
  let rec _menhir_error_run_033 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_TYPE _menhir_cell0_type_param _menhir_cell0_LIDENT, _menhir_box_full_module) _menhir_cell1_annot -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let MenhirCell1_annot (_menhir_stack, _, _, _, _) = _menhir_stack in
      let MenhirCell0_LIDENT (_menhir_stack, _, _, _) = _menhir_stack in
      let MenhirCell0_type_param (_menhir_stack, _) = _menhir_stack in
      let MenhirCell1_TYPE (_menhir_stack, _menhir_s, _) = _menhir_stack in
      let (_endpos__e_, _startpos__e_, _e) = (_endpos, _startpos, ()) in
      let _v = _menhir_action_33 _e _endpos__e_ _startpos__e_ in
      _menhir_error_goto_module_item _menhir_stack _menhir_lexbuf _v _menhir_s
  
  let rec _menhir_error_run_032 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_TYPE _menhir_cell0_type_param _menhir_cell0_LIDENT as 'stack) -> _ -> _ -> _ -> _ -> ('stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _endpos _startpos _v _menhir_s ->
      let _menhir_stack = MenhirCell1_annot (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
      _menhir_error_run_033 _menhir_stack _menhir_lexbuf
  
  let rec _menhir_error_run_018 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _endpos _startpos _v _menhir_s ->
      let _menhir_stack = MenhirCell1_annot (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
      _menhir_error_run_019 _menhir_stack _menhir_lexbuf MenhirState018
  
  let rec _menhir_error_run_017 : type  ttv_stack. (ttv_stack, _menhir_box_full_module) _menhir_cell1_asection -> _ -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _endpos _v ->
      let MenhirCell1_asection (_menhir_stack, _menhir_s, x, _startpos_x_) = _menhir_stack in
      let (_endpos_l_, l) = (_endpos, _v) in
      let _v = _menhir_action_05 l x in
      _menhir_error_goto_annot _menhir_stack _menhir_lexbuf _endpos_l_ _startpos_x_ _v _menhir_s
  
  and _menhir_error_goto_annot : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _endpos _startpos _v _menhir_s ->
      match _menhir_s with
      | MenhirState142 ->
          _menhir_error_run_143 _menhir_stack _menhir_lexbuf _endpos _v
      | MenhirState139 ->
          _menhir_error_run_140 _menhir_stack _menhir_lexbuf _endpos _v
      | MenhirState037 ->
          _menhir_error_run_134 _menhir_stack
      | MenhirState039 ->
          _menhir_error_run_134 _menhir_stack
      | MenhirState132 ->
          _menhir_error_run_133 _menhir_stack _menhir_lexbuf _endpos _v
      | MenhirState125 ->
          _menhir_error_run_129 _menhir_stack
      | MenhirState122 ->
          _menhir_error_run_123 _menhir_stack _menhir_lexbuf _endpos _v
      | MenhirState109 ->
          _menhir_error_run_110 _menhir_stack _menhir_lexbuf _endpos _v
      | MenhirState107 ->
          _menhir_error_run_108 _menhir_stack _menhir_lexbuf _endpos _v
      | MenhirState103 ->
          _menhir_error_run_104 _menhir_stack _menhir_lexbuf _endpos _v
      | MenhirState100 ->
          _menhir_error_run_101 _menhir_stack _menhir_lexbuf _endpos _v
      | MenhirState088 ->
          _menhir_error_run_097 _menhir_stack _menhir_lexbuf _endpos _v
      | MenhirState095 ->
          _menhir_error_run_096 _menhir_stack _menhir_lexbuf _endpos _v
      | MenhirState082 ->
          _menhir_error_run_083 _menhir_stack _menhir_lexbuf _endpos _v
      | MenhirState077 ->
          _menhir_error_run_078 _menhir_stack _menhir_lexbuf _endpos _v
      | MenhirState067 ->
          _menhir_error_run_068 _menhir_stack _menhir_lexbuf _endpos _v
      | MenhirState060 ->
          _menhir_error_run_061 _menhir_stack _menhir_lexbuf _endpos _v
      | MenhirState056 ->
          _menhir_error_run_057 _menhir_stack _menhir_lexbuf _endpos _v
      | MenhirState050 ->
          _menhir_error_run_051 _menhir_stack _menhir_lexbuf _endpos _startpos _v _menhir_s
      | MenhirState048 ->
          _menhir_error_run_049 _menhir_stack _menhir_lexbuf _endpos _v
      | MenhirState031 ->
          _menhir_error_run_032 _menhir_stack _menhir_lexbuf _endpos _startpos _v _menhir_s
      | MenhirState000 ->
          _menhir_error_run_018 _menhir_stack _menhir_lexbuf _endpos _startpos _v _menhir_s
      | MenhirState016 ->
          _menhir_error_run_017 _menhir_stack _menhir_lexbuf _endpos _v
      | _ ->
          _menhir_fail ()
  
  and _menhir_error_run_096 : type  ttv_stack. (ttv_stack, _menhir_box_full_module) _menhir_cell1_asection -> _ -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _endpos _v ->
      let MenhirCell1_asection (_menhir_stack, _menhir_s, x, _startpos_x_) = _menhir_stack in
      let (_endpos_l_, l) = (_endpos, _v) in
      let _v = _menhir_action_05 l x in
      _menhir_error_goto_annot _menhir_stack _menhir_lexbuf _endpos_l_ _startpos_x_ _v _menhir_s
  
  let rec _menhir_error_run_016 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _endpos _startpos _v _menhir_s ->
      let _menhir_stack = MenhirCell1_asection (_menhir_stack, _menhir_s, _v, _startpos) in
      let _v = _menhir_action_06 () in
      _menhir_error_run_017 _menhir_stack _menhir_lexbuf _endpos _v
  
  let rec _menhir_error_goto_asection : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _endpos _startpos _v _menhir_s ->
      match _menhir_s with
      | MenhirState037 ->
          _menhir_error_run_095 _menhir_stack
      | MenhirState132 ->
          _menhir_error_run_095 _menhir_stack
      | MenhirState125 ->
          _menhir_error_run_095 _menhir_stack
      | MenhirState039 ->
          _menhir_error_run_095 _menhir_stack
      | MenhirState122 ->
          _menhir_error_run_095 _menhir_stack
      | MenhirState109 ->
          _menhir_error_run_095 _menhir_stack
      | MenhirState107 ->
          _menhir_error_run_095 _menhir_stack
      | MenhirState103 ->
          _menhir_error_run_095 _menhir_stack
      | MenhirState100 ->
          _menhir_error_run_095 _menhir_stack
      | MenhirState095 ->
          _menhir_error_run_095 _menhir_stack
      | MenhirState088 ->
          _menhir_error_run_095 _menhir_stack
      | MenhirState142 ->
          _menhir_error_run_016 _menhir_stack _menhir_lexbuf _endpos _startpos _v _menhir_s
      | MenhirState139 ->
          _menhir_error_run_016 _menhir_stack _menhir_lexbuf _endpos _startpos _v _menhir_s
      | MenhirState082 ->
          _menhir_error_run_016 _menhir_stack _menhir_lexbuf _endpos _startpos _v _menhir_s
      | MenhirState077 ->
          _menhir_error_run_016 _menhir_stack _menhir_lexbuf _endpos _startpos _v _menhir_s
      | MenhirState067 ->
          _menhir_error_run_016 _menhir_stack _menhir_lexbuf _endpos _startpos _v _menhir_s
      | MenhirState060 ->
          _menhir_error_run_016 _menhir_stack _menhir_lexbuf _endpos _startpos _v _menhir_s
      | MenhirState056 ->
          _menhir_error_run_016 _menhir_stack _menhir_lexbuf _endpos _startpos _v _menhir_s
      | MenhirState050 ->
          _menhir_error_run_016 _menhir_stack _menhir_lexbuf _endpos _startpos _v _menhir_s
      | MenhirState048 ->
          _menhir_error_run_016 _menhir_stack _menhir_lexbuf _endpos _startpos _v _menhir_s
      | MenhirState031 ->
          _menhir_error_run_016 _menhir_stack _menhir_lexbuf _endpos _startpos _v _menhir_s
      | MenhirState016 ->
          _menhir_error_run_016 _menhir_stack _menhir_lexbuf _endpos _startpos _v _menhir_s
      | MenhirState000 ->
          _menhir_error_run_016 _menhir_stack _menhir_lexbuf _endpos _startpos _v _menhir_s
      | _ ->
          _menhir_fail ()
  
  let rec _menhir_error_run_092 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_LT _menhir_cell0_LIDENT as 'stack) -> _ -> _ -> ('stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _v _menhir_s ->
      let _menhir_stack = MenhirCell1_afield_list (_menhir_stack, _menhir_s, _v) in
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let MenhirCell1_afield_list (_menhir_stack, _, _) = _menhir_stack in
      let MenhirCell0_LIDENT (_menhir_stack, _, _, _) = _menhir_stack in
      let MenhirCell1_LT (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos__e_, _startpos__e_, _e) = (_endpos, _startpos, ()) in
      let _v = _menhir_action_10 _e _endpos__e_ _startpos__e_ in
      _menhir_error_goto_asection _menhir_stack _menhir_lexbuf _endpos _startpos__1_ _v _menhir_s
  
  let rec _menhir_error_run_027 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_TYPE _menhir_cell0_OP_PAREN as 'stack) -> _ -> _ -> ('stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _v _menhir_s ->
      let _menhir_stack = MenhirCell1_type_var_list (_menhir_stack, _menhir_s, _v) in
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let MenhirCell1_type_var_list (_menhir_stack, _, _) = _menhir_stack in
      let MenhirCell0_OP_PAREN (_menhir_stack, _) = _menhir_stack in
      let (_endpos__e_, _startpos__e_, _e) = (_endpos, _startpos, ()) in
      let _ = _menhir_action_56 _e _endpos__e_ _startpos__e_ in
      _eRR ()
  
  let rec _menhir_error_goto_type_var_list : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _v _menhir_s ->
      match _menhir_s with
      | MenhirState023 ->
          _menhir_error_run_027 _menhir_stack _menhir_lexbuf _v _menhir_s
      | MenhirState025 ->
          _menhir_error_run_026 _menhir_stack _menhir_lexbuf _v
      | _ ->
          _menhir_fail ()
  
  and _menhir_error_run_026 : type  ttv_stack. (ttv_stack, _menhir_box_full_module) _menhir_cell1_TIDENT -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _v ->
      let MenhirCell1_TIDENT (_menhir_stack, _menhir_s, _1, _, _) = _menhir_stack in
      let _3 = _v in
      let _v = _menhir_action_57 _1 _3 in
      _menhir_error_goto_type_var_list _menhir_stack _menhir_lexbuf _v _menhir_s
  
  let rec _menhir_run_148 : type  ttv_stack. (ttv_stack, _menhir_box_full_module) _menhir_cell1_annot -> _ -> _menhir_box_full_module =
    fun _menhir_stack _v ->
      let MenhirCell1_annot (_menhir_stack, _, x, _startpos_x_, _endpos_x_) = _menhir_stack in
      let y = _v in
      let _v = _menhir_action_25 _endpos_x_ _startpos_x_ x y in
      MenhirBox_full_module _v
  
  let rec _menhir_run_147 : type  ttv_stack. (ttv_stack, _menhir_box_full_module) _menhir_cell1_module_item -> _ -> _menhir_box_full_module =
    fun _menhir_stack _v ->
      let MenhirCell1_module_item (_menhir_stack, _menhir_s, _1) = _menhir_stack in
      let _2 = _v in
      let _v = _menhir_action_28 _1 _2 in
      _menhir_goto_module_body _menhir_stack _v _menhir_s
  
  and _menhir_goto_module_body : type  ttv_stack. ttv_stack -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _v _menhir_s ->
      match _menhir_s with
      | MenhirState018 ->
          _menhir_run_148 _menhir_stack _v
      | MenhirState146 ->
          _menhir_run_147 _menhir_stack _v
      | _ ->
          _menhir_fail ()
  
  let rec _menhir_error_run_010 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_LT _menhir_cell0_LIDENT as 'stack) -> _ -> _ -> ('stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _v _menhir_s ->
      let _menhir_stack = MenhirCell1_afield_list (_menhir_stack, _menhir_s, _v) in
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let MenhirCell1_afield_list (_menhir_stack, _, _) = _menhir_stack in
      let MenhirCell0_LIDENT (_menhir_stack, _, _, _) = _menhir_stack in
      let MenhirCell1_LT (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos__e_, _startpos__e_, _e) = (_endpos, _startpos, ()) in
      let _v = _menhir_action_10 _e _endpos__e_ _startpos__e_ in
      _menhir_error_goto_asection _menhir_stack _menhir_lexbuf _endpos _startpos__1_ _v _menhir_s
  
  let rec _menhir_error_run_014 : type  ttv_stack. (ttv_stack, _menhir_box_full_module) _menhir_cell1_afield -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _v ->
      let MenhirCell1_afield (_menhir_stack, _menhir_s, x) = _menhir_stack in
      let l = _v in
      let _v = _menhir_action_03 l x in
      _menhir_error_goto_afield_list _menhir_stack _menhir_lexbuf _v _menhir_s
  
  and _menhir_error_goto_afield_list : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _v _menhir_s ->
      match _menhir_s with
      | MenhirState091 ->
          _menhir_error_run_092 _menhir_stack _menhir_lexbuf _v _menhir_s
      | MenhirState013 ->
          _menhir_error_run_014 _menhir_stack _menhir_lexbuf _v
      | MenhirState003 ->
          _menhir_error_run_010 _menhir_stack _menhir_lexbuf _v _menhir_s
      | _ ->
          _menhir_fail ()
  
  let rec _menhir_error_run_007 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _endpos _startpos _v _menhir_s ->
      let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
      let _v = _menhir_action_02 _1 _endpos__1_ _startpos__1_ in
      let _menhir_stack = MenhirCell1_afield (_menhir_stack, _menhir_s, _v) in
      let _v = _menhir_action_04 () in
      _menhir_error_run_014 _menhir_stack _menhir_lexbuf _v
  
  let rec _menhir_error_goto_lident_path : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _endpos _startpos _v _menhir_s ->
      match _menhir_s with
      | MenhirState091 ->
          _menhir_error_run_007 _menhir_stack _menhir_lexbuf _endpos _startpos _v _menhir_s
      | MenhirState013 ->
          _menhir_error_run_007 _menhir_stack _menhir_lexbuf _endpos _startpos _v _menhir_s
      | MenhirState003 ->
          _menhir_error_run_007 _menhir_stack _menhir_lexbuf _endpos _startpos _v _menhir_s
      | MenhirState005 ->
          _menhir_error_run_006 _menhir_stack _menhir_lexbuf _endpos _v
      | _ ->
          _menhir_fail ()
  
  and _menhir_error_run_006 : type  ttv_stack. (ttv_stack, _menhir_box_full_module) _menhir_cell1_LIDENT -> _ -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _endpos _v ->
      let MenhirCell1_LIDENT (_menhir_stack, _menhir_s, _1, _startpos__1_, _) = _menhir_stack in
      let (_3, _endpos__3_) = (_v, _endpos) in
      let _v = _menhir_action_26 _1 _3 in
      _menhir_error_goto_lident_path _menhir_stack _menhir_lexbuf _endpos__3_ _startpos__1_ _v _menhir_s
  
  let rec _menhir_run_001 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | LIDENT _v ->
          let _menhir_stack = MenhirCell1_LT (_menhir_stack, _menhir_s, _startpos) in
          let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _menhir_stack = MenhirCell0_LIDENT (_menhir_stack, _v, _startpos, _endpos) in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | LIDENT _v ->
              _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState003
          | GT ->
              let _v = _menhir_action_04 () in
              _menhir_run_010 _menhir_stack _menhir_lexbuf _menhir_lexer _v
          | _ ->
              let _v = _menhir_action_04 () in
              _menhir_error_run_010 _menhir_stack _menhir_lexbuf _v MenhirState003)
      | _ ->
          let _startpos_4 = _menhir_lexbuf.Lexing.lex_start_p in
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let (_endpos__e_, _startpos__e_, _e, _startpos__1_) = (_endpos, _startpos_4, (), _startpos) in
          let _v = _menhir_action_11 _e _endpos__e_ _startpos__e_ in
          _menhir_error_goto_asection _menhir_stack _menhir_lexbuf _endpos _startpos__1_ _v _menhir_s
  
  and _menhir_run_004 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | DOT ->
          let _menhir_stack = MenhirCell1_LIDENT (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | LIDENT _v ->
              _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState005
          | _ ->
              _eRR ())
      | EQ | GT | LIDENT _ ->
          let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
          let _v = _menhir_action_27 _1 in
          _menhir_goto_lident_path _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__1_ _startpos__1_ _v _menhir_s _tok
      | _ ->
          let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
          let _v = _menhir_action_27 _1 in
          _menhir_error_goto_lident_path _menhir_stack _menhir_lexbuf _endpos__1_ _startpos__1_ _v _menhir_s
  
  and _menhir_goto_lident_path : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState091 ->
          _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState013 ->
          _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState003 ->
          _menhir_run_007 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState005 ->
          _menhir_run_006 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_007 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match (_tok : MenhirBasics.token) with
      | EQ ->
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | STRING _v_0 ->
              let _endpos_1 = _menhir_lexbuf.Lexing.lex_curr_p in
              let _tok = _menhir_lexer _menhir_lexbuf in
              let (_startpos__1_, _1, _3, _endpos__3_) = (_startpos, _v, _v_0, _endpos_1) in
              let _v = _menhir_action_01 _1 _3 _endpos__3_ _startpos__1_ in
              _menhir_goto_afield _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
          | _ ->
              _eRR ())
      | GT | LIDENT _ ->
          let (_endpos__1_, _startpos__1_, _1) = (_endpos, _startpos, _v) in
          let _v = _menhir_action_02 _1 _endpos__1_ _startpos__1_ in
          _menhir_goto_afield _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_goto_afield : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_afield (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | LIDENT _v_0 ->
          _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _v_0 MenhirState013
      | GT ->
          let _v = _menhir_action_04 () in
          _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _v
      | _ ->
          let _v = _menhir_action_04 () in
          _menhir_error_run_014 _menhir_stack _menhir_lexbuf _v
  
  and _menhir_run_014 : type  ttv_stack. (ttv_stack, _menhir_box_full_module) _menhir_cell1_afield -> _ -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v ->
      let MenhirCell1_afield (_menhir_stack, _menhir_s, x) = _menhir_stack in
      let l = _v in
      let _v = _menhir_action_03 l x in
      _menhir_goto_afield_list _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
  
  and _menhir_goto_afield_list : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      match _menhir_s with
      | MenhirState091 ->
          _menhir_run_092 _menhir_stack _menhir_lexbuf _menhir_lexer _v
      | MenhirState013 ->
          _menhir_run_014 _menhir_stack _menhir_lexbuf _menhir_lexer _v
      | MenhirState003 ->
          _menhir_run_010 _menhir_stack _menhir_lexbuf _menhir_lexer _v
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_092 : type  ttv_stack. (ttv_stack, _menhir_box_full_module) _menhir_cell1_LT _menhir_cell0_LIDENT -> _ -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v ->
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let MenhirCell0_LIDENT (_menhir_stack, x, _, _) = _menhir_stack in
      let MenhirCell1_LT (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (l, _endpos__4_) = (_v, _endpos) in
      let _v = _menhir_action_09 _endpos__4_ _startpos__1_ l x in
      _menhir_goto_asection _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos__1_ _v _menhir_s _tok
  
  and _menhir_goto_asection : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState037 ->
          _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState132 ->
          _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState125 ->
          _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState039 ->
          _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState122 ->
          _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState109 ->
          _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState107 ->
          _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState103 ->
          _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState100 ->
          _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState095 ->
          _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState088 ->
          _menhir_run_095 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState142 ->
          _menhir_run_016 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState139 ->
          _menhir_run_016 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState082 ->
          _menhir_run_016 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState077 ->
          _menhir_run_016 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState067 ->
          _menhir_run_016 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState060 ->
          _menhir_run_016 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState056 ->
          _menhir_run_016 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState050 ->
          _menhir_run_016 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState048 ->
          _menhir_run_016 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState031 ->
          _menhir_run_016 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState016 ->
          _menhir_run_016 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState000 ->
          _menhir_run_016 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_095 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_asection (_menhir_stack, _menhir_s, _v, _startpos) in
      match (_tok : MenhirBasics.token) with
      | LT ->
          _menhir_run_089 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState095
      | CL_PAREN | COLON | COMMA | LIDENT _ | STAR ->
          let _v = _menhir_action_06 () in
          _menhir_run_096 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_089 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | LIDENT _v ->
          let _menhir_stack = MenhirCell1_LT (_menhir_stack, _menhir_s, _startpos) in
          let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _menhir_stack = MenhirCell0_LIDENT (_menhir_stack, _v, _startpos, _endpos) in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | LIDENT _v ->
              _menhir_run_004 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState091
          | GT ->
              let _v = _menhir_action_04 () in
              _menhir_run_092 _menhir_stack _menhir_lexbuf _menhir_lexer _v
          | _ ->
              let _v = _menhir_action_04 () in
              _menhir_error_run_092 _menhir_stack _menhir_lexbuf _v MenhirState091)
      | _ ->
          let _startpos_4 = _menhir_lexbuf.Lexing.lex_start_p in
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let (_endpos__e_, _startpos__e_, _e, _startpos__1_) = (_endpos, _startpos_4, (), _startpos) in
          let _v = _menhir_action_11 _e _endpos__e_ _startpos__e_ in
          _menhir_error_goto_asection _menhir_stack _menhir_lexbuf _endpos _startpos__1_ _v _menhir_s
  
  and _menhir_run_096 : type  ttv_stack. (ttv_stack, _menhir_box_full_module) _menhir_cell1_asection -> _ -> _ -> _ -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_asection (_menhir_stack, _menhir_s, x, _startpos_x_) = _menhir_stack in
      let (_endpos_l_, l) = (_endpos, _v) in
      let _v = _menhir_action_05 l x in
      _menhir_goto_annot _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_l_ _startpos_x_ _v _menhir_s _tok
  
  and _menhir_goto_annot : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState142 ->
          _menhir_run_143 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState139 ->
          _menhir_run_140 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState037 ->
          _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState039 ->
          _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState132 ->
          _menhir_run_133 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState125 ->
          _menhir_run_129 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState122 ->
          _menhir_run_123 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState109 ->
          _menhir_run_110 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState107 ->
          _menhir_run_108 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState103 ->
          _menhir_run_104 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState100 ->
          _menhir_run_101 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState088 ->
          _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState095 ->
          _menhir_run_096 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState082 ->
          _menhir_run_083 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState077 ->
          _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState067 ->
          _menhir_run_068 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState060 ->
          _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState056 ->
          _menhir_run_057 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState050 ->
          _menhir_run_051 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState048 ->
          _menhir_run_049 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | MenhirState031 ->
          _menhir_run_032 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState000 ->
          _menhir_run_018 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState016 ->
          _menhir_run_017 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_143 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_OP_PAREN, _menhir_box_full_module) _menhir_cell1_annot_expr -> _ -> _ -> _ -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_annot_expr (_menhir_stack, _, x) = _menhir_stack in
      let MenhirCell1_OP_PAREN (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos_a_, a) = (_endpos, _v) in
      let _v = _menhir_action_45 _endpos_a_ _startpos__1_ a x in
      _menhir_goto_type_expr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_a_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_goto_type_expr : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState034 ->
          _menhir_run_144 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState135 ->
          _menhir_run_136 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState130 ->
          _menhir_run_131 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState125 ->
          _menhir_run_126 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState112 ->
          _menhir_run_113 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState037 ->
          _menhir_run_111 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState039 ->
          _menhir_run_111 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState046 ->
          _menhir_run_087 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState053 ->
          _menhir_run_079 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState065 ->
          _menhir_run_066 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState058 ->
          _menhir_run_062 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_144 : type  ttv_stack. (((ttv_stack, _menhir_box_full_module) _menhir_cell1_TYPE _menhir_cell0_type_param _menhir_cell0_LIDENT, _menhir_box_full_module) _menhir_cell1_annot as 'stack) -> _ -> _ -> _ -> _ -> _ -> ('stack, _menhir_box_full_module) _menhir_state -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match (_tok : MenhirBasics.token) with
      | EOF | TYPE ->
          let MenhirCell1_annot (_menhir_stack, _, a, _, _) = _menhir_stack in
          let MenhirCell0_LIDENT (_menhir_stack, s, _, _) = _menhir_stack in
          let MenhirCell0_type_param (_menhir_stack, p) = _menhir_stack in
          let MenhirCell1_TYPE (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
          let (_endpos_t_, t) = (_endpos, _v) in
          let _v = _menhir_action_31 _endpos_t_ _startpos__1_ a p s t in
          let _menhir_stack = MenhirCell1_module_item (_menhir_stack, _menhir_s, _v) in
          (match (_tok : MenhirBasics.token) with
          | TYPE ->
              _menhir_run_020 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState146
          | EOF ->
              let _v = _menhir_action_29 () in
              _menhir_run_147 _menhir_stack _v
          | _ ->
              _menhir_fail ())
      | LIDENT _ ->
          let (_startpos__1_, _1) = (_startpos, _v) in
          let _v = _menhir_action_37 _1 in
          _menhir_goto_type_args _menhir_stack _menhir_lexbuf _menhir_lexer _startpos__1_ _v _menhir_s _tok
      | _ ->
          let MenhirCell1_annot (_menhir_stack, _, a, _, _) = _menhir_stack in
          let MenhirCell0_LIDENT (_menhir_stack, s, _, _) = _menhir_stack in
          let MenhirCell0_type_param (_menhir_stack, p) = _menhir_stack in
          let MenhirCell1_TYPE (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
          let (_endpos_t_, t) = (_endpos, _v) in
          let _v = _menhir_action_31 _endpos_t_ _startpos__1_ a p s t in
          _menhir_error_goto_module_item _menhir_stack _menhir_lexbuf _v _menhir_s
  
  and _menhir_run_020 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | TIDENT _v ->
          let _menhir_stack = MenhirCell1_TYPE (_menhir_stack, _menhir_s, _startpos) in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let _1 = _v in
          let _v = _menhir_action_53 _1 in
          _menhir_goto_type_param _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | OP_PAREN ->
          let _menhir_stack = MenhirCell1_TYPE (_menhir_stack, _menhir_s, _startpos) in
          let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
          let _menhir_stack = MenhirCell0_OP_PAREN (_menhir_stack, _startpos) in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | TIDENT _v ->
              _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState023
          | _ ->
              _eRR ())
      | LIDENT _ ->
          let _menhir_stack = MenhirCell1_TYPE (_menhir_stack, _menhir_s, _startpos) in
          let _v = _menhir_action_55 () in
          _menhir_goto_type_param _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
      | _ ->
          let _startpos_2 = _menhir_lexbuf.Lexing.lex_start_p in
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let (_endpos__e_, _startpos__e_, _e) = (_endpos, _startpos_2, ()) in
          let _v = _menhir_action_34 _e _endpos__e_ _startpos__e_ in
          _menhir_error_goto_module_item _menhir_stack _menhir_lexbuf _v _menhir_s
  
  and _menhir_goto_type_param : type  ttv_stack. (ttv_stack, _menhir_box_full_module) _menhir_cell1_TYPE -> _ -> _ -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok ->
      let _menhir_stack = MenhirCell0_type_param (_menhir_stack, _v) in
      match (_tok : MenhirBasics.token) with
      | LIDENT _v_0 ->
          let _v = _v_0 in
          let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _menhir_stack = MenhirCell0_LIDENT (_menhir_stack, _v, _startpos, _endpos) in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | LT ->
              _menhir_run_001 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState031
          | EQ ->
              let _v = _menhir_action_06 () in
              _menhir_run_032 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _endpos _v MenhirState031 _tok
          | _ ->
              let _v = _menhir_action_06 () in
              _menhir_error_run_032 _menhir_stack _menhir_lexbuf _endpos _endpos _v MenhirState031)
      | _ ->
          _eRR ()
  
  and _menhir_run_032 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_TYPE _menhir_cell0_type_param _menhir_cell0_LIDENT as 'stack) -> _ -> _ -> _ -> _ -> _ -> ('stack, _menhir_box_full_module) _menhir_state -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match (_tok : MenhirBasics.token) with
      | EQ ->
          let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | TIDENT _v_1 ->
              let _menhir_stack = MenhirCell1_annot (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
              let _startpos_2 = _menhir_lexbuf.Lexing.lex_start_p in
              let _endpos_3 = _menhir_lexbuf.Lexing.lex_curr_p in
              let _tok = _menhir_lexer _menhir_lexbuf in
              let (_endpos_x_, _startpos_x_, x) = (_endpos_3, _startpos_2, _v_1) in
              let _v = _menhir_action_48 _endpos_x_ _startpos_x_ x in
              _menhir_run_144 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_x_ _startpos_x_ _v MenhirState034 _tok
          | OP_PAREN ->
              let _menhir_stack = MenhirCell1_annot (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
              _menhir_run_037 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState034
          | OP_CURL ->
              let _menhir_stack = MenhirCell1_annot (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
              _menhir_run_047 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState034
          | OP_BRACK ->
              let _menhir_stack = MenhirCell1_annot (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
              _menhir_run_055 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState034
          | LIDENT _ ->
              let _menhir_stack = MenhirCell1_annot (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
              let _endpos = _endpos_0 in
              let _v = _menhir_action_39 () in
              _menhir_run_063 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v MenhirState034 _tok
          | _ ->
              let _startpos_6 = _menhir_lexbuf.Lexing.lex_start_p in
              let _endpos_7 = _menhir_lexbuf.Lexing.lex_curr_p in
              let MenhirCell0_LIDENT (_menhir_stack, _, _, _) = _menhir_stack in
              let MenhirCell0_type_param (_menhir_stack, _) = _menhir_stack in
              let MenhirCell1_TYPE (_menhir_stack, _menhir_s, _) = _menhir_stack in
              let (_endpos__e_, _startpos__e_, _e) = (_endpos_7, _startpos_6, ()) in
              let _v = _menhir_action_32 _e _endpos__e_ _startpos__e_ in
              _menhir_error_goto_module_item _menhir_stack _menhir_lexbuf _v _menhir_s)
      | _ ->
          let _menhir_stack = MenhirCell1_annot (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
          _menhir_error_run_033 _menhir_stack _menhir_lexbuf
  
  and _menhir_run_037 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _menhir_stack = MenhirCell1_OP_PAREN (_menhir_stack, _menhir_s, _startpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | TIDENT _v ->
          let _startpos_0 = _menhir_lexbuf.Lexing.lex_start_p in
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let (_endpos_x_, _startpos_x_, x) = (_endpos, _startpos_0, _v) in
          let _v = _menhir_action_48 _endpos_x_ _startpos_x_ x in
          _menhir_run_111 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_x_ _startpos_x_ _v MenhirState037 _tok
      | OP_PAREN ->
          _menhir_run_039 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState037
      | OP_CURL ->
          _menhir_run_040 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState037
      | OP_BRACK ->
          _menhir_run_102 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState037
      | LT ->
          _menhir_run_089 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState037
      | COLON ->
          let _v = _menhir_action_06 () in
          _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _endpos _v MenhirState037 _tok
      | CL_PAREN ->
          let _v = _menhir_action_14 () in
          _menhir_run_137 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState037
      | LIDENT _ ->
          let _v = _menhir_action_39 () in
          _menhir_run_115 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v MenhirState037 _tok
      | _ ->
          let _v = _menhir_action_14 () in
          _menhir_error_run_137 _menhir_stack _menhir_lexbuf _v MenhirState037
  
  and _menhir_run_111 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_OP_PAREN as 'stack) -> _ -> _ -> _ -> _ -> _ -> ('stack, _menhir_box_full_module) _menhir_state -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match (_tok : MenhirBasics.token) with
      | COMMA ->
          let _menhir_stack = MenhirCell1_type_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
          _menhir_run_112 _menhir_stack _menhir_lexbuf _menhir_lexer
      | CL_PAREN | STAR ->
          let (_endpos_x_, _startpos_x_, x) = (_endpos, _startpos, _v) in
          let _v = _menhir_action_08 _endpos_x_ _startpos_x_ x in
          _menhir_goto_annot_expr _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | LIDENT _ ->
          let (_startpos__1_, _1) = (_startpos, _v) in
          let _v = _menhir_action_37 _1 in
          _menhir_goto_type_args _menhir_stack _menhir_lexbuf _menhir_lexer _startpos__1_ _v _menhir_s _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_112 : type  ttv_stack. (ttv_stack, _menhir_box_full_module) _menhir_cell1_type_expr -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer ->
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | TIDENT _v ->
          let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let (_endpos_x_, _startpos_x_, x) = (_endpos, _startpos, _v) in
          let _v = _menhir_action_48 _endpos_x_ _startpos_x_ x in
          _menhir_run_113 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_x_ _startpos_x_ _v MenhirState112 _tok
      | OP_PAREN ->
          _menhir_run_037 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState112
      | OP_CURL ->
          _menhir_run_047 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState112
      | OP_BRACK ->
          _menhir_run_055 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState112
      | LIDENT _ ->
          let _v = _menhir_action_39 () in
          _menhir_run_063 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v MenhirState112 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_113 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_type_expr as 'stack) -> _ -> _ -> _ -> _ -> _ -> ('stack, _menhir_box_full_module) _menhir_state -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match (_tok : MenhirBasics.token) with
      | COMMA ->
          let _menhir_stack = MenhirCell1_type_expr (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
          _menhir_run_112 _menhir_stack _menhir_lexbuf _menhir_lexer
      | CL_PAREN ->
          let MenhirCell1_type_expr (_menhir_stack, _menhir_s, _1, _, _) = _menhir_stack in
          let _3 = _v in
          let _v = _menhir_action_36 _1 _3 in
          _menhir_goto_type_arg_list _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | LIDENT _ ->
          let (_startpos__1_, _1) = (_startpos, _v) in
          let _v = _menhir_action_37 _1 in
          _menhir_goto_type_args _menhir_stack _menhir_lexbuf _menhir_lexer _startpos__1_ _v _menhir_s _tok
      | _ ->
          let MenhirCell1_type_expr (_menhir_stack, _menhir_s, _1, _, _) = _menhir_stack in
          let _3 = _v in
          let _v = _menhir_action_36 _1 _3 in
          _menhir_error_goto_type_arg_list _menhir_stack _menhir_lexbuf _v _menhir_s
  
  and _menhir_goto_type_arg_list : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      match _menhir_s with
      | MenhirState037 ->
          _menhir_run_117 _menhir_stack _menhir_lexbuf _menhir_lexer _v
      | MenhirState039 ->
          _menhir_run_117 _menhir_stack _menhir_lexbuf _menhir_lexer _v
      | MenhirState112 ->
          _menhir_run_114 _menhir_stack _menhir_lexbuf _menhir_lexer _v
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_117 : type  ttv_stack. (ttv_stack, _menhir_box_full_module) _menhir_cell1_OP_PAREN -> _ -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v ->
      let _tok = _menhir_lexer _menhir_lexbuf in
      let MenhirCell1_OP_PAREN (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let _2 = _v in
      let _v = _menhir_action_38 _2 in
      _menhir_goto_type_args _menhir_stack _menhir_lexbuf _menhir_lexer _startpos__1_ _v _menhir_s _tok
  
  and _menhir_goto_type_args : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState037 ->
          _menhir_run_115 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
      | MenhirState135 ->
          _menhir_run_115 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
      | MenhirState039 ->
          _menhir_run_115 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
      | MenhirState034 ->
          _menhir_run_063 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
      | MenhirState130 ->
          _menhir_run_063 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
      | MenhirState125 ->
          _menhir_run_063 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
      | MenhirState112 ->
          _menhir_run_063 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
      | MenhirState046 ->
          _menhir_run_063 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
      | MenhirState053 ->
          _menhir_run_063 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
      | MenhirState065 ->
          _menhir_run_063 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
      | MenhirState058 ->
          _menhir_run_063 _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_115 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok ->
      match (_tok : MenhirBasics.token) with
      | LIDENT _v_0 ->
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let (_startpos_l_, l, _endpos_s_, s) = (_startpos, _v, _endpos, _v_0) in
          let _v = _menhir_action_52 _endpos_s_ _startpos_l_ l s in
          _menhir_goto_type_inst _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos_l_ _v _menhir_s _tok
      | _ ->
          _eRR ()
  
  and _menhir_goto_type_inst : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState037 ->
          _menhir_run_109 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState135 ->
          _menhir_run_109 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState039 ->
          _menhir_run_109 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState034 ->
          _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState130 ->
          _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState125 ->
          _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState112 ->
          _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState046 ->
          _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState053 ->
          _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState065 ->
          _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | MenhirState058 ->
          _menhir_run_060 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_109 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_type_inst (_menhir_stack, _menhir_s, _v, _startpos) in
      match (_tok : MenhirBasics.token) with
      | LT ->
          _menhir_run_089 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState109
      | CL_PAREN | COMMA | LIDENT _ | STAR ->
          let _v = _menhir_action_06 () in
          _menhir_run_110 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_110 : type  ttv_stack. (ttv_stack, _menhir_box_full_module) _menhir_cell1_type_inst -> _ -> _ -> _ -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_type_inst (_menhir_stack, _menhir_s, x, _startpos_x_) = _menhir_stack in
      let (_endpos_a_, a) = (_endpos, _v) in
      let _v = _menhir_action_47 _endpos_a_ _startpos_x_ a x in
      _menhir_goto_type_expr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_a_ _startpos_x_ _v _menhir_s _tok
  
  and _menhir_run_060 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_type_inst (_menhir_stack, _menhir_s, _v, _startpos) in
      match (_tok : MenhirBasics.token) with
      | LT ->
          _menhir_run_001 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState060
      | BAR | CL_BRACK | CL_CURL | CL_PAREN | COMMA | EOF | LIDENT _ | SEMICOLON | STAR | TYPE ->
          let _v = _menhir_action_06 () in
          _menhir_run_061 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | _ ->
          let _v = _menhir_action_06 () in
          _menhir_error_run_061 _menhir_stack _menhir_lexbuf _endpos _v
  
  and _menhir_run_061 : type  ttv_stack. (ttv_stack, _menhir_box_full_module) _menhir_cell1_type_inst -> _ -> _ -> _ -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_type_inst (_menhir_stack, _menhir_s, x, _startpos_x_) = _menhir_stack in
      let (_endpos_a_, a) = (_endpos, _v) in
      let _v = _menhir_action_47 _endpos_a_ _startpos_x_ a x in
      _menhir_goto_type_expr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_a_ _startpos_x_ _v _menhir_s _tok
  
  and _menhir_run_063 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _startpos _v _menhir_s _tok ->
      match (_tok : MenhirBasics.token) with
      | LIDENT _v_0 ->
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let (_startpos_l_, l, _endpos_s_, s) = (_startpos, _v, _endpos, _v_0) in
          let _v = _menhir_action_52 _endpos_s_ _startpos_l_ l s in
          _menhir_goto_type_inst _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos_l_ _v _menhir_s _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_114 : type  ttv_stack. (ttv_stack, _menhir_box_full_module) _menhir_cell1_type_expr -> _ -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v ->
      let MenhirCell1_type_expr (_menhir_stack, _menhir_s, _1, _, _) = _menhir_stack in
      let _3 = _v in
      let _v = _menhir_action_35 _1 _3 in
      _menhir_goto_type_arg_list _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
  
  and _menhir_run_047 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _menhir_stack = MenhirCell1_OP_CURL (_menhir_stack, _menhir_s, _startpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | TILDE ->
          _menhir_run_041 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState047
      | QUESTION ->
          _menhir_run_043 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState047
      | LIDENT _v ->
          let _startpos_0 = _menhir_lexbuf.Lexing.lex_start_p in
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let (_startpos_k_, k) = (_startpos_0, _v) in
          let _v = _menhir_action_22 k in
          _menhir_run_050 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos_k_ _v MenhirState047 _tok
      | INHERIT ->
          _menhir_run_046 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState047
      | CL_CURL ->
          let _menhir_s = MenhirState047 in
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _menhir_stack = MenhirCell1_CL_CURL (_menhir_stack, _menhir_s) in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | LT ->
              _menhir_run_001 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState048
          | BAR | CL_BRACK | CL_CURL | CL_PAREN | COMMA | EOF | LIDENT _ | SEMICOLON | STAR | TYPE ->
              let _v = _menhir_action_06 () in
              _menhir_run_049 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
          | _ ->
              let _v = _menhir_action_06 () in
              _menhir_error_run_049 _menhir_stack _menhir_lexbuf _endpos _v)
      | _ ->
          _eRR ()
  
  and _menhir_run_041 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | LIDENT _v ->
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let (_startpos__1_, k) = (_startpos, _v) in
          let _v = _menhir_action_24 k in
          _menhir_goto_field_name _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos__1_ _v _menhir_s _tok
      | _ ->
          _eRR ()
  
  and _menhir_goto_field_name : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      _menhir_run_050 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok
  
  and _menhir_run_050 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_field_name (_menhir_stack, _menhir_s, _v, _startpos) in
      match (_tok : MenhirBasics.token) with
      | LT ->
          _menhir_run_001 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState050
      | COLON ->
          let _v = _menhir_action_06 () in
          _menhir_run_051 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _endpos _v MenhirState050 _tok
      | _ ->
          let _v = _menhir_action_06 () in
          _menhir_error_run_051 _menhir_stack _menhir_lexbuf _endpos _endpos _v MenhirState050
  
  and _menhir_run_051 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_field_name as 'stack) -> _ -> _ -> _ -> _ -> _ -> ('stack, _menhir_box_full_module) _menhir_state -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match (_tok : MenhirBasics.token) with
      | COLON ->
          let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | TIDENT _v_1 ->
              let _menhir_stack = MenhirCell1_annot (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
              let _startpos_2 = _menhir_lexbuf.Lexing.lex_start_p in
              let _endpos_3 = _menhir_lexbuf.Lexing.lex_curr_p in
              let _tok = _menhir_lexer _menhir_lexbuf in
              let (_endpos_x_, _startpos_x_, x) = (_endpos_3, _startpos_2, _v_1) in
              let _v = _menhir_action_48 _endpos_x_ _startpos_x_ x in
              _menhir_run_079 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_x_ _startpos_x_ _v MenhirState053 _tok
          | OP_PAREN ->
              let _menhir_stack = MenhirCell1_annot (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
              _menhir_run_037 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState053
          | OP_CURL ->
              let _menhir_stack = MenhirCell1_annot (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
              _menhir_run_047 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState053
          | OP_BRACK ->
              let _menhir_stack = MenhirCell1_annot (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
              _menhir_run_055 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState053
          | LIDENT _ ->
              let _menhir_stack = MenhirCell1_annot (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
              let _endpos = _endpos_0 in
              let _v = _menhir_action_39 () in
              _menhir_run_063 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v MenhirState053 _tok
          | _ ->
              let _startpos_6 = _menhir_lexbuf.Lexing.lex_start_p in
              let _endpos_7 = _menhir_lexbuf.Lexing.lex_curr_p in
              let MenhirCell1_field_name (_menhir_stack, _menhir_s, _, _) = _menhir_stack in
              let (_endpos__e_, _startpos__e_, _e) = (_endpos_7, _startpos_6, ()) in
              let _v = _menhir_action_17 _e _endpos__e_ _startpos__e_ in
              _menhir_error_goto_field _menhir_stack _menhir_lexbuf _v _menhir_s)
      | _ ->
          let _menhir_stack = MenhirCell1_annot (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
          _menhir_error_run_052 _menhir_stack _menhir_lexbuf
  
  and _menhir_run_079 : type  ttv_stack. (((ttv_stack, _menhir_box_full_module) _menhir_cell1_field_name, _menhir_box_full_module) _menhir_cell1_annot as 'stack) -> _ -> _ -> _ -> _ -> _ -> ('stack, _menhir_box_full_module) _menhir_state -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match (_tok : MenhirBasics.token) with
      | CL_CURL | SEMICOLON ->
          let MenhirCell1_annot (_menhir_stack, _, a, _, _) = _menhir_stack in
          let MenhirCell1_field_name (_menhir_stack, _menhir_s, fn, _startpos_fn_) = _menhir_stack in
          let (_endpos_t_, t) = (_endpos, _v) in
          let _v = _menhir_action_15 _endpos_t_ _startpos_fn_ a fn t in
          _menhir_goto_field _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | LIDENT _ ->
          let (_startpos__1_, _1) = (_startpos, _v) in
          let _v = _menhir_action_37 _1 in
          _menhir_goto_type_args _menhir_stack _menhir_lexbuf _menhir_lexer _startpos__1_ _v _menhir_s _tok
      | _ ->
          let MenhirCell1_annot (_menhir_stack, _, a, _, _) = _menhir_stack in
          let MenhirCell1_field_name (_menhir_stack, _menhir_s, fn, _startpos_fn_) = _menhir_stack in
          let (_endpos_t_, t) = (_endpos, _v) in
          let _v = _menhir_action_15 _endpos_t_ _startpos_fn_ a fn t in
          _menhir_error_goto_field _menhir_stack _menhir_lexbuf _v _menhir_s
  
  and _menhir_goto_field : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match (_tok : MenhirBasics.token) with
      | SEMICOLON ->
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | TILDE ->
              let _menhir_stack = MenhirCell1_field (_menhir_stack, _menhir_s, _v) in
              _menhir_run_041 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState085
          | QUESTION ->
              let _menhir_stack = MenhirCell1_field (_menhir_stack, _menhir_s, _v) in
              _menhir_run_043 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState085
          | LIDENT _v_0 ->
              let _menhir_stack = MenhirCell1_field (_menhir_stack, _menhir_s, _v) in
              let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
              let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
              let _tok = _menhir_lexer _menhir_lexbuf in
              let (_startpos_k_, k) = (_startpos, _v_0) in
              let _v = _menhir_action_22 k in
              _menhir_run_050 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos_k_ _v MenhirState085 _tok
          | INHERIT ->
              let _menhir_stack = MenhirCell1_field (_menhir_stack, _menhir_s, _v) in
              _menhir_run_046 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState085
          | CL_CURL ->
              let x = _v in
              let _v = _menhir_action_20 x in
              _menhir_goto_field_list _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
          | _ ->
              let x = _v in
              let _v = _menhir_action_20 x in
              _menhir_error_goto_field_list _menhir_stack _menhir_lexbuf _v _menhir_s)
      | CL_CURL ->
          let x = _v in
          let _v = _menhir_action_21 x in
          _menhir_goto_field_list _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_043 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | LIDENT _v ->
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let (_startpos__1_, k) = (_startpos, _v) in
          let _v = _menhir_action_23 k in
          _menhir_goto_field_name _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos__1_ _v _menhir_s _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_046 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _menhir_stack = MenhirCell1_INHERIT (_menhir_stack, _menhir_s, _startpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | TIDENT _v ->
          let _startpos_0 = _menhir_lexbuf.Lexing.lex_start_p in
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let (_endpos_x_, _startpos_x_, x) = (_endpos, _startpos_0, _v) in
          let _v = _menhir_action_48 _endpos_x_ _startpos_x_ x in
          _menhir_run_087 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_x_ _startpos_x_ _v MenhirState046 _tok
      | OP_PAREN ->
          _menhir_run_037 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState046
      | OP_CURL ->
          _menhir_run_047 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState046
      | OP_BRACK ->
          _menhir_run_055 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState046
      | LIDENT _ ->
          let _v = _menhir_action_39 () in
          _menhir_run_063 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v MenhirState046 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_087 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_INHERIT as 'stack) -> _ -> _ -> _ -> _ -> _ -> ('stack, _menhir_box_full_module) _menhir_state -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match (_tok : MenhirBasics.token) with
      | CL_CURL | SEMICOLON ->
          let MenhirCell1_INHERIT (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
          let (_endpos_t_, t) = (_endpos, _v) in
          let _v = _menhir_action_16 _endpos_t_ _startpos__1_ t in
          _menhir_goto_field _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | LIDENT _ ->
          let (_startpos__1_, _1) = (_startpos, _v) in
          let _v = _menhir_action_37 _1 in
          _menhir_goto_type_args _menhir_stack _menhir_lexbuf _menhir_lexer _startpos__1_ _v _menhir_s _tok
      | _ ->
          let MenhirCell1_INHERIT (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
          let (_endpos_t_, t) = (_endpos, _v) in
          let _v = _menhir_action_16 _endpos_t_ _startpos__1_ t in
          _menhir_error_goto_field _menhir_stack _menhir_lexbuf _v _menhir_s
  
  and _menhir_run_055 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _menhir_stack = MenhirCell1_OP_BRACK (_menhir_stack, _menhir_s, _startpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | UIDENT _v ->
          _menhir_run_056 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState055
      | INHERIT ->
          _menhir_run_065 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState055
      | CL_BRACK ->
          let _menhir_s = MenhirState055 in
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _menhir_stack = MenhirCell1_CL_BRACK (_menhir_stack, _menhir_s) in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | LT ->
              _menhir_run_001 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState067
          | BAR | CL_BRACK | CL_CURL | CL_PAREN | COMMA | EOF | LIDENT _ | SEMICOLON | STAR | TYPE ->
              let _v = _menhir_action_06 () in
              _menhir_run_068 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
          | _ ->
              let _v = _menhir_action_06 () in
              _menhir_error_run_068 _menhir_stack _menhir_lexbuf _endpos _v)
      | BAR ->
          _menhir_run_069 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState055
      | _ ->
          _eRR ()
  
  and _menhir_run_056 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _menhir_stack = MenhirCell1_UIDENT (_menhir_stack, _menhir_s, _v, _startpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | LT ->
          _menhir_run_001 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState056
      | BAR | CL_BRACK | OF ->
          let _v = _menhir_action_06 () in
          _menhir_run_057 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _endpos _v MenhirState056 _tok
      | _ ->
          let _v = _menhir_action_06 () in
          _menhir_error_run_057 _menhir_stack _menhir_lexbuf _endpos _v
  
  and _menhir_run_057 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_UIDENT as 'stack) -> _ -> _ -> _ -> _ -> _ -> ('stack, _menhir_box_full_module) _menhir_state -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match (_tok : MenhirBasics.token) with
      | OF ->
          let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | TIDENT _v_1 ->
              let _menhir_stack = MenhirCell1_annot (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
              let _startpos_2 = _menhir_lexbuf.Lexing.lex_start_p in
              let _endpos_3 = _menhir_lexbuf.Lexing.lex_curr_p in
              let _tok = _menhir_lexer _menhir_lexbuf in
              let (_endpos_x_, _startpos_x_, x) = (_endpos_3, _startpos_2, _v_1) in
              let _v = _menhir_action_48 _endpos_x_ _startpos_x_ x in
              _menhir_run_062 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_x_ _startpos_x_ _v MenhirState058 _tok
          | OP_PAREN ->
              let _menhir_stack = MenhirCell1_annot (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
              _menhir_run_037 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState058
          | OP_CURL ->
              let _menhir_stack = MenhirCell1_annot (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
              _menhir_run_047 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState058
          | OP_BRACK ->
              let _menhir_stack = MenhirCell1_annot (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
              _menhir_run_055 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState058
          | LIDENT _ ->
              let _menhir_stack = MenhirCell1_annot (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
              let _endpos = _endpos_0 in
              let _v = _menhir_action_39 () in
              _menhir_run_063 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v MenhirState058 _tok
          | _ ->
              let _startpos_6 = _menhir_lexbuf.Lexing.lex_start_p in
              let _endpos_7 = _menhir_lexbuf.Lexing.lex_curr_p in
              let MenhirCell1_UIDENT (_menhir_stack, _menhir_s, _, _) = _menhir_stack in
              let (_endpos__e_, _startpos__e_, _e) = (_endpos_7, _startpos_6, ()) in
              let _v = _menhir_action_62 _e _endpos__e_ _startpos__e_ in
              _menhir_error_goto_variant _menhir_stack _menhir_lexbuf _v _menhir_s)
      | BAR | CL_BRACK ->
          let MenhirCell1_UIDENT (_menhir_stack, _menhir_s, x, _startpos_x_) = _menhir_stack in
          let (_endpos_a_, a) = (_endpos, _v) in
          let _v = _menhir_action_60 _endpos_a_ _startpos_x_ a x in
          _menhir_goto_variant _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | _ ->
          let MenhirCell1_UIDENT (_menhir_stack, _menhir_s, x, _startpos_x_) = _menhir_stack in
          let (_endpos_a_, a) = (_endpos, _v) in
          let _v = _menhir_action_60 _endpos_a_ _startpos_x_ a x in
          _menhir_error_goto_variant _menhir_stack _menhir_lexbuf _v _menhir_s
  
  and _menhir_run_062 : type  ttv_stack. (((ttv_stack, _menhir_box_full_module) _menhir_cell1_UIDENT, _menhir_box_full_module) _menhir_cell1_annot as 'stack) -> _ -> _ -> _ -> _ -> _ -> ('stack, _menhir_box_full_module) _menhir_state -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match (_tok : MenhirBasics.token) with
      | LIDENT _ ->
          let (_startpos__1_, _1) = (_startpos, _v) in
          let _v = _menhir_action_37 _1 in
          _menhir_goto_type_args _menhir_stack _menhir_lexbuf _menhir_lexer _startpos__1_ _v _menhir_s _tok
      | BAR | CL_BRACK ->
          let MenhirCell1_annot (_menhir_stack, _, a, _, _) = _menhir_stack in
          let MenhirCell1_UIDENT (_menhir_stack, _menhir_s, x, _startpos_x_) = _menhir_stack in
          let (_endpos_t_, t) = (_endpos, _v) in
          let _v = _menhir_action_59 _endpos_t_ _startpos_x_ a t x in
          _menhir_goto_variant _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | _ ->
          let MenhirCell1_annot (_menhir_stack, _, a, _, _) = _menhir_stack in
          let MenhirCell1_UIDENT (_menhir_stack, _menhir_s, x, _startpos_x_) = _menhir_stack in
          let (_endpos_t_, t) = (_endpos, _v) in
          let _v = _menhir_action_59 _endpos_t_ _startpos_x_ a t x in
          _menhir_error_goto_variant _menhir_stack _menhir_lexbuf _v _menhir_s
  
  and _menhir_goto_variant : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match (_tok : MenhirBasics.token) with
      | BAR ->
          let _menhir_stack = MenhirCell1_variant (_menhir_stack, _menhir_s, _v) in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | UIDENT _v ->
              _menhir_run_056 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState072
          | INHERIT ->
              _menhir_run_065 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState072
          | _ ->
              _eRR ())
      | CL_BRACK ->
          let _1 = _v in
          let _v = _menhir_action_66 _1 in
          _menhir_goto_variant_list0 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_065 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _menhir_stack = MenhirCell1_INHERIT (_menhir_stack, _menhir_s, _startpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | TIDENT _v ->
          let _startpos_0 = _menhir_lexbuf.Lexing.lex_start_p in
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let (_endpos_x_, _startpos_x_, x) = (_endpos, _startpos_0, _v) in
          let _v = _menhir_action_48 _endpos_x_ _startpos_x_ x in
          _menhir_run_066 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_x_ _startpos_x_ _v MenhirState065 _tok
      | OP_PAREN ->
          _menhir_run_037 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState065
      | OP_CURL ->
          _menhir_run_047 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState065
      | OP_BRACK ->
          _menhir_run_055 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState065
      | LIDENT _ ->
          let _v = _menhir_action_39 () in
          _menhir_run_063 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v MenhirState065 _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_066 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_INHERIT as 'stack) -> _ -> _ -> _ -> _ -> _ -> ('stack, _menhir_box_full_module) _menhir_state -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match (_tok : MenhirBasics.token) with
      | LIDENT _ ->
          let (_startpos__1_, _1) = (_startpos, _v) in
          let _v = _menhir_action_37 _1 in
          _menhir_goto_type_args _menhir_stack _menhir_lexbuf _menhir_lexer _startpos__1_ _v _menhir_s _tok
      | BAR | CL_BRACK ->
          let MenhirCell1_INHERIT (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
          let (_endpos_t_, t) = (_endpos, _v) in
          let _v = _menhir_action_61 _endpos_t_ _startpos__1_ t in
          _menhir_goto_variant _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | _ ->
          let MenhirCell1_INHERIT (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
          let (_endpos_t_, t) = (_endpos, _v) in
          let _v = _menhir_action_61 _endpos_t_ _startpos__1_ t in
          _menhir_error_goto_variant _menhir_stack _menhir_lexbuf _v _menhir_s
  
  and _menhir_goto_variant_list0 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      match _menhir_s with
      | MenhirState102 ->
          _menhir_run_074_spec_102 _menhir_stack _menhir_lexbuf _menhir_lexer _v
      | MenhirState055 ->
          _menhir_run_074_spec_055 _menhir_stack _menhir_lexbuf _menhir_lexer _v
      | MenhirState072 ->
          _menhir_run_073 _menhir_stack _menhir_lexbuf _menhir_lexer _v
      | MenhirState069 ->
          _menhir_run_070 _menhir_stack _menhir_lexbuf _menhir_lexer _v
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_074_spec_102 : type  ttv_stack. (ttv_stack, _menhir_box_full_module) _menhir_cell1_OP_BRACK -> _ -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v ->
      let _1 = _v in
      let _v = _menhir_action_64 _1 in
      _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState102
  
  and _menhir_run_105 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_OP_BRACK as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _menhir_stack = MenhirCell1_variant_list (_menhir_stack, _menhir_s, _v) in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | LT ->
          _menhir_run_089 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState107
      | CL_PAREN | COMMA | LIDENT _ | STAR ->
          let _v = _menhir_action_06 () in
          _menhir_run_108 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_108 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_OP_BRACK, _menhir_box_full_module) _menhir_cell1_variant_list -> _ -> _ -> _ -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_variant_list (_menhir_stack, _, l) = _menhir_stack in
      let MenhirCell1_OP_BRACK (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos_a_, a) = (_endpos, _v) in
      let _v = _menhir_action_41 _endpos_a_ _startpos__1_ a l in
      _menhir_goto_type_expr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_a_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_074_spec_055 : type  ttv_stack. (ttv_stack, _menhir_box_full_module) _menhir_cell1_OP_BRACK -> _ -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v ->
      let _1 = _v in
      let _v = _menhir_action_64 _1 in
      _menhir_run_075 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState055
  
  and _menhir_run_075 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_OP_BRACK as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _menhir_stack = MenhirCell1_variant_list (_menhir_stack, _menhir_s, _v) in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | LT ->
          _menhir_run_001 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState077
      | BAR | CL_BRACK | CL_CURL | CL_PAREN | COMMA | EOF | LIDENT _ | SEMICOLON | STAR | TYPE ->
          let _v = _menhir_action_06 () in
          _menhir_run_078 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | _ ->
          let _v = _menhir_action_06 () in
          _menhir_error_run_078 _menhir_stack _menhir_lexbuf _endpos _v
  
  and _menhir_run_078 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_OP_BRACK, _menhir_box_full_module) _menhir_cell1_variant_list -> _ -> _ -> _ -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_variant_list (_menhir_stack, _, l) = _menhir_stack in
      let MenhirCell1_OP_BRACK (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos_a_, a) = (_endpos, _v) in
      let _v = _menhir_action_41 _endpos_a_ _startpos__1_ a l in
      _menhir_goto_type_expr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_a_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_073 : type  ttv_stack. (ttv_stack, _menhir_box_full_module) _menhir_cell1_variant -> _ -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v ->
      let MenhirCell1_variant (_menhir_stack, _menhir_s, _1) = _menhir_stack in
      let _3 = _v in
      let _v = _menhir_action_65 _1 _3 in
      _menhir_goto_variant_list0 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
  
  and _menhir_run_070 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_OP_BRACK, _menhir_box_full_module) _menhir_cell1_BAR -> _ -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v ->
      let MenhirCell1_BAR (_menhir_stack, _menhir_s) = _menhir_stack in
      let _2 = _v in
      let _v = _menhir_action_63 _2 in
      _menhir_goto_variant_list _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
  
  and _menhir_goto_variant_list : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_OP_BRACK as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      match _menhir_s with
      | MenhirState102 ->
          _menhir_run_105 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | MenhirState055 ->
          _menhir_run_075 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_068 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_OP_BRACK, _menhir_box_full_module) _menhir_cell1_CL_BRACK -> _ -> _ -> _ -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_CL_BRACK (_menhir_stack, _) = _menhir_stack in
      let MenhirCell1_OP_BRACK (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos_a_, a) = (_endpos, _v) in
      let _v = _menhir_action_42 _endpos_a_ _startpos__1_ a in
      _menhir_goto_type_expr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_a_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_069 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_OP_BRACK as 'stack) -> _ -> _ -> ('stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _menhir_stack = MenhirCell1_BAR (_menhir_stack, _menhir_s) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | UIDENT _v ->
          _menhir_run_056 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState069
      | INHERIT ->
          _menhir_run_065 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState069
      | _ ->
          _eRR ()
  
  and _menhir_goto_field_list : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      match _menhir_s with
      | MenhirState040 ->
          _menhir_run_098 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | MenhirState085 ->
          _menhir_run_086 _menhir_stack _menhir_lexbuf _menhir_lexer _v
      | MenhirState047 ->
          _menhir_run_080 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_098 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_OP_CURL as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _menhir_stack = MenhirCell1_field_list (_menhir_stack, _menhir_s, _v) in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | LT ->
          _menhir_run_089 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState100
      | CL_PAREN | COMMA | LIDENT _ | STAR ->
          let _v = _menhir_action_06 () in
          _menhir_run_101 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_101 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_OP_CURL, _menhir_box_full_module) _menhir_cell1_field_list -> _ -> _ -> _ -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_field_list (_menhir_stack, _, l) = _menhir_stack in
      let MenhirCell1_OP_CURL (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos_a_, a) = (_endpos, _v) in
      let _v = _menhir_action_43 _endpos_a_ _startpos__1_ a l in
      _menhir_goto_type_expr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_a_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_086 : type  ttv_stack. (ttv_stack, _menhir_box_full_module) _menhir_cell1_field -> _ -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v ->
      let MenhirCell1_field (_menhir_stack, _menhir_s, x) = _menhir_stack in
      let l = _v in
      let _v = _menhir_action_19 l x in
      _menhir_goto_field_list _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
  
  and _menhir_run_080 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_OP_CURL as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _menhir_stack = MenhirCell1_field_list (_menhir_stack, _menhir_s, _v) in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | LT ->
          _menhir_run_001 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState082
      | BAR | CL_BRACK | CL_CURL | CL_PAREN | COMMA | EOF | LIDENT _ | SEMICOLON | STAR | TYPE ->
          let _v = _menhir_action_06 () in
          _menhir_run_083 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | _ ->
          let _v = _menhir_action_06 () in
          _menhir_error_run_083 _menhir_stack _menhir_lexbuf _endpos _v
  
  and _menhir_run_083 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_OP_CURL, _menhir_box_full_module) _menhir_cell1_field_list -> _ -> _ -> _ -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_field_list (_menhir_stack, _, l) = _menhir_stack in
      let MenhirCell1_OP_CURL (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos_a_, a) = (_endpos, _v) in
      let _v = _menhir_action_43 _endpos_a_ _startpos__1_ a l in
      _menhir_goto_type_expr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_a_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_049 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_OP_CURL, _menhir_box_full_module) _menhir_cell1_CL_CURL -> _ -> _ -> _ -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_CL_CURL (_menhir_stack, _) = _menhir_stack in
      let MenhirCell1_OP_CURL (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos_a_, a) = (_endpos, _v) in
      let _v = _menhir_action_44 _endpos_a_ _startpos__1_ a in
      _menhir_goto_type_expr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_a_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_goto_annot_expr : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match _menhir_s with
      | MenhirState037 ->
          _menhir_run_141 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState125 ->
          _menhir_run_128 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | MenhirState039 ->
          _menhir_run_124 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_141 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_OP_PAREN as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_full_module) _menhir_state -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_annot_expr (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | STAR ->
          _menhir_run_125 _menhir_stack _menhir_lexbuf _menhir_lexer
      | CL_PAREN ->
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | LT ->
              _menhir_run_001 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState142
          | BAR | CL_BRACK | CL_CURL | CL_PAREN | COMMA | EOF | LIDENT _ | SEMICOLON | STAR | TYPE ->
              let _v = _menhir_action_06 () in
              _menhir_run_143 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
          | _ ->
              let _v = _menhir_action_06 () in
              _menhir_error_run_143 _menhir_stack _menhir_lexbuf _endpos _v)
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_125 : type  ttv_stack. (ttv_stack, _menhir_box_full_module) _menhir_cell1_annot_expr -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer ->
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | TIDENT _v ->
          let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let (_endpos_x_, _startpos_x_, x) = (_endpos, _startpos, _v) in
          let _v = _menhir_action_48 _endpos_x_ _startpos_x_ x in
          _menhir_run_126 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_x_ _startpos_x_ _v MenhirState125 _tok
      | OP_PAREN ->
          _menhir_run_037 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState125
      | OP_CURL ->
          _menhir_run_047 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState125
      | OP_BRACK ->
          _menhir_run_055 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState125
      | LT ->
          _menhir_run_089 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState125
      | COLON ->
          let _v = _menhir_action_06 () in
          _menhir_run_129 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _endpos _v MenhirState125 _tok
      | CL_PAREN ->
          let _v = _menhir_action_14 () in
          _menhir_run_127 _menhir_stack _menhir_lexbuf _menhir_lexer _v
      | LIDENT _ ->
          let _v = _menhir_action_39 () in
          _menhir_run_063 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v MenhirState125 _tok
      | _ ->
          let _v = _menhir_action_14 () in
          _menhir_error_run_127 _menhir_stack _menhir_lexbuf _v
  
  and _menhir_run_126 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_annot_expr as 'stack) -> _ -> _ -> _ -> _ -> _ -> ('stack, _menhir_box_full_module) _menhir_state -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match (_tok : MenhirBasics.token) with
      | CL_PAREN | STAR ->
          let (_endpos_x_, _startpos_x_, x) = (_endpos, _startpos, _v) in
          let _v = _menhir_action_08 _endpos_x_ _startpos_x_ x in
          _menhir_goto_annot_expr _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | LIDENT _ ->
          let (_startpos__1_, _1) = (_startpos, _v) in
          let _v = _menhir_action_37 _1 in
          _menhir_goto_type_args _menhir_stack _menhir_lexbuf _menhir_lexer _startpos__1_ _v _menhir_s _tok
      | _ ->
          let (_endpos_x_, _startpos_x_, x) = (_endpos, _startpos, _v) in
          let _v = _menhir_action_08 _endpos_x_ _startpos_x_ x in
          _menhir_error_goto_annot_expr _menhir_stack _menhir_lexbuf _v _menhir_s
  
  and _menhir_run_129 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_annot (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
      match (_tok : MenhirBasics.token) with
      | COLON ->
          let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | TIDENT _v_1 ->
              let _startpos_2 = _menhir_lexbuf.Lexing.lex_start_p in
              let _endpos_3 = _menhir_lexbuf.Lexing.lex_curr_p in
              let _tok = _menhir_lexer _menhir_lexbuf in
              let (_endpos_x_, _startpos_x_, x) = (_endpos_3, _startpos_2, _v_1) in
              let _v = _menhir_action_48 _endpos_x_ _startpos_x_ x in
              _menhir_run_131 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_x_ _startpos_x_ _v MenhirState130 _tok
          | OP_PAREN ->
              _menhir_run_037 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState130
          | OP_CURL ->
              _menhir_run_047 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState130
          | OP_BRACK ->
              _menhir_run_055 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState130
          | LIDENT _ ->
              let _endpos = _endpos_0 in
              let _v = _menhir_action_39 () in
              _menhir_run_063 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v MenhirState130 _tok
          | _ ->
              _eRR ())
      | _ ->
          _eRR ()
  
  and _menhir_run_131 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_annot as 'stack) -> _ -> _ -> _ -> _ -> _ -> ('stack, _menhir_box_full_module) _menhir_state -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match (_tok : MenhirBasics.token) with
      | CL_PAREN | STAR ->
          let MenhirCell1_annot (_menhir_stack, _menhir_s, a, _startpos_a_, _) = _menhir_stack in
          let (_endpos_x_, x) = (_endpos, _v) in
          let _v = _menhir_action_07 _endpos_x_ _startpos_a_ a x in
          _menhir_goto_annot_expr _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | LIDENT _ ->
          let (_startpos__1_, _1) = (_startpos, _v) in
          let _v = _menhir_action_37 _1 in
          _menhir_goto_type_args _menhir_stack _menhir_lexbuf _menhir_lexer _startpos__1_ _v _menhir_s _tok
      | _ ->
          let MenhirCell1_annot (_menhir_stack, _menhir_s, a, _startpos_a_, _) = _menhir_stack in
          let (_endpos_x_, x) = (_endpos, _v) in
          let _v = _menhir_action_07 _endpos_x_ _startpos_a_ a x in
          _menhir_error_goto_annot_expr _menhir_stack _menhir_lexbuf _v _menhir_s
  
  and _menhir_run_127 : type  ttv_stack. (ttv_stack, _menhir_box_full_module) _menhir_cell1_annot_expr -> _ -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v ->
      let MenhirCell1_annot_expr (_menhir_stack, _menhir_s, x) = _menhir_stack in
      let l = _v in
      let _v = _menhir_action_12 l x in
      _menhir_goto_cartesian_product _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
  
  and _menhir_goto_cartesian_product : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      match _menhir_s with
      | MenhirState037 ->
          _menhir_run_137 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | MenhirState125 ->
          _menhir_run_127 _menhir_stack _menhir_lexbuf _menhir_lexer _v
      | MenhirState039 ->
          _menhir_run_120 _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_137 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_OP_PAREN as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _menhir_stack = MenhirCell1_cartesian_product (_menhir_stack, _menhir_s, _v) in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | LT ->
          _menhir_run_001 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState139
      | BAR | CL_BRACK | CL_CURL | CL_PAREN | COMMA | EOF | LIDENT _ | SEMICOLON | STAR | TYPE ->
          let _v = _menhir_action_06 () in
          _menhir_run_140 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | _ ->
          let _v = _menhir_action_06 () in
          _menhir_error_run_140 _menhir_stack _menhir_lexbuf _endpos _v
  
  and _menhir_run_140 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_OP_PAREN, _menhir_box_full_module) _menhir_cell1_cartesian_product -> _ -> _ -> _ -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_cartesian_product (_menhir_stack, _, l) = _menhir_stack in
      let MenhirCell1_OP_PAREN (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos_a_, a) = (_endpos, _v) in
      let _v = _menhir_action_46 _endpos_a_ _startpos__1_ a l in
      _menhir_goto_type_expr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_a_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_120 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_OP_PAREN as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _menhir_stack = MenhirCell1_cartesian_product (_menhir_stack, _menhir_s, _v) in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | LT ->
          _menhir_run_089 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState122
      | CL_PAREN | COMMA | LIDENT _ | STAR ->
          let _v = _menhir_action_06 () in
          _menhir_run_123 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_123 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_OP_PAREN, _menhir_box_full_module) _menhir_cell1_cartesian_product -> _ -> _ -> _ -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_cartesian_product (_menhir_stack, _, l) = _menhir_stack in
      let MenhirCell1_OP_PAREN (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos_a_, a) = (_endpos, _v) in
      let _v = _menhir_action_46 _endpos_a_ _startpos__1_ a l in
      _menhir_goto_type_expr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_a_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_128 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_annot_expr as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_full_module) _menhir_state -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      match (_tok : MenhirBasics.token) with
      | STAR ->
          let _menhir_stack = MenhirCell1_annot_expr (_menhir_stack, _menhir_s, _v) in
          _menhir_run_125 _menhir_stack _menhir_lexbuf _menhir_lexer
      | CL_PAREN ->
          let MenhirCell1_annot_expr (_menhir_stack, _menhir_s, x) = _menhir_stack in
          let y = _v in
          let _v = _menhir_action_13 x y in
          _menhir_goto_cartesian_product _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_124 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_OP_PAREN as 'stack) -> _ -> _ -> _ -> ('stack, _menhir_box_full_module) _menhir_state -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_annot_expr (_menhir_stack, _menhir_s, _v) in
      match (_tok : MenhirBasics.token) with
      | STAR ->
          _menhir_run_125 _menhir_stack _menhir_lexbuf _menhir_lexer
      | CL_PAREN ->
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | LT ->
              _menhir_run_089 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState132
          | CL_PAREN | COMMA | LIDENT _ | STAR ->
              let _v = _menhir_action_06 () in
              _menhir_run_133 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
          | _ ->
              _eRR ())
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_133 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_OP_PAREN, _menhir_box_full_module) _menhir_cell1_annot_expr -> _ -> _ -> _ -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_annot_expr (_menhir_stack, _, x) = _menhir_stack in
      let MenhirCell1_OP_PAREN (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos_a_, a) = (_endpos, _v) in
      let _v = _menhir_action_45 _endpos_a_ _startpos__1_ a x in
      _menhir_goto_type_expr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_a_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_039 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _menhir_stack = MenhirCell1_OP_PAREN (_menhir_stack, _menhir_s, _startpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | TIDENT _v ->
          let _startpos_0 = _menhir_lexbuf.Lexing.lex_start_p in
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let (_endpos_x_, _startpos_x_, x) = (_endpos, _startpos_0, _v) in
          let _v = _menhir_action_48 _endpos_x_ _startpos_x_ x in
          _menhir_run_111 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_x_ _startpos_x_ _v MenhirState039 _tok
      | OP_PAREN ->
          _menhir_run_039 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState039
      | OP_CURL ->
          _menhir_run_040 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState039
      | OP_BRACK ->
          _menhir_run_102 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState039
      | LT ->
          _menhir_run_089 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState039
      | COLON ->
          let _v = _menhir_action_06 () in
          _menhir_run_134 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _endpos _v MenhirState039 _tok
      | CL_PAREN ->
          let _v = _menhir_action_14 () in
          _menhir_run_120 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState039
      | LIDENT _ ->
          let _v = _menhir_action_39 () in
          _menhir_run_115 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v MenhirState039 _tok
      | _ ->
          let _v = _menhir_action_14 () in
          _menhir_error_run_120 _menhir_stack _menhir_lexbuf _v MenhirState039
  
  and _menhir_run_040 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _menhir_stack = MenhirCell1_OP_CURL (_menhir_stack, _menhir_s, _startpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | TILDE ->
          _menhir_run_041 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState040
      | QUESTION ->
          _menhir_run_043 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState040
      | LIDENT _v ->
          let _startpos_0 = _menhir_lexbuf.Lexing.lex_start_p in
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          let (_startpos_k_, k) = (_startpos_0, _v) in
          let _v = _menhir_action_22 k in
          _menhir_run_050 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos_k_ _v MenhirState040 _tok
      | INHERIT ->
          _menhir_run_046 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState040
      | CL_CURL ->
          let _menhir_s = MenhirState040 in
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _menhir_stack = MenhirCell1_CL_CURL (_menhir_stack, _menhir_s) in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | LT ->
              _menhir_run_089 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState088
          | CL_PAREN | COMMA | LIDENT _ | STAR ->
              let _v = _menhir_action_06 () in
              _menhir_run_097 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
          | _ ->
              _eRR ())
      | _ ->
          _eRR ()
  
  and _menhir_run_097 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_OP_CURL, _menhir_box_full_module) _menhir_cell1_CL_CURL -> _ -> _ -> _ -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_CL_CURL (_menhir_stack, _) = _menhir_stack in
      let MenhirCell1_OP_CURL (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos_a_, a) = (_endpos, _v) in
      let _v = _menhir_action_44 _endpos_a_ _startpos__1_ a in
      _menhir_goto_type_expr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_a_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_102 : type  ttv_stack. ttv_stack -> _ -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _menhir_stack = MenhirCell1_OP_BRACK (_menhir_stack, _menhir_s, _startpos) in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | UIDENT _v ->
          _menhir_run_056 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState102
      | INHERIT ->
          _menhir_run_065 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState102
      | CL_BRACK ->
          let _menhir_s = MenhirState102 in
          let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
          let _menhir_stack = MenhirCell1_CL_BRACK (_menhir_stack, _menhir_s) in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | LT ->
              _menhir_run_089 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState103
          | CL_PAREN | COMMA | LIDENT _ | STAR ->
              let _v = _menhir_action_06 () in
              _menhir_run_104 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
          | _ ->
              _eRR ())
      | BAR ->
          _menhir_run_069 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState102
      | _ ->
          _eRR ()
  
  and _menhir_run_104 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_OP_BRACK, _menhir_box_full_module) _menhir_cell1_CL_BRACK -> _ -> _ -> _ -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_CL_BRACK (_menhir_stack, _) = _menhir_stack in
      let MenhirCell1_OP_BRACK (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (_endpos_a_, a) = (_endpos, _v) in
      let _v = _menhir_action_42 _endpos_a_ _startpos__1_ a in
      _menhir_goto_type_expr _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_a_ _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_134 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_annot (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
      match (_tok : MenhirBasics.token) with
      | COLON ->
          let _endpos_0 = _menhir_lexbuf.Lexing.lex_curr_p in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | TIDENT _v_1 ->
              let _startpos_2 = _menhir_lexbuf.Lexing.lex_start_p in
              let _endpos_3 = _menhir_lexbuf.Lexing.lex_curr_p in
              let _tok = _menhir_lexer _menhir_lexbuf in
              let (_endpos_x_, _startpos_x_, x) = (_endpos_3, _startpos_2, _v_1) in
              let _v = _menhir_action_48 _endpos_x_ _startpos_x_ x in
              _menhir_run_136 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_x_ _startpos_x_ _v MenhirState135 _tok
          | OP_PAREN ->
              _menhir_run_039 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState135
          | OP_CURL ->
              _menhir_run_040 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState135
          | OP_BRACK ->
              _menhir_run_102 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState135
          | LIDENT _ ->
              let _endpos = _endpos_0 in
              let _v = _menhir_action_39 () in
              _menhir_run_115 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v MenhirState135 _tok
          | _ ->
              _eRR ())
      | _ ->
          _eRR ()
  
  and _menhir_run_136 : type  ttv_stack. ((ttv_stack, _menhir_box_full_module) _menhir_cell1_annot as 'stack) -> _ -> _ -> _ -> _ -> _ -> ('stack, _menhir_box_full_module) _menhir_state -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      match (_tok : MenhirBasics.token) with
      | CL_PAREN | STAR ->
          let MenhirCell1_annot (_menhir_stack, _menhir_s, a, _startpos_a_, _) = _menhir_stack in
          let (_endpos_x_, x) = (_endpos, _v) in
          let _v = _menhir_action_07 _endpos_x_ _startpos_a_ a x in
          _menhir_goto_annot_expr _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s _tok
      | LIDENT _ ->
          let (_startpos__1_, _1) = (_startpos, _v) in
          let _v = _menhir_action_37 _1 in
          _menhir_goto_type_args _menhir_stack _menhir_lexbuf _menhir_lexer _startpos__1_ _v _menhir_s _tok
      | _ ->
          _eRR ()
  
  and _menhir_run_024 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      let _startpos = _menhir_lexbuf.Lexing.lex_start_p in
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | COMMA ->
          let _menhir_stack = MenhirCell1_TIDENT (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
          let _tok = _menhir_lexer _menhir_lexbuf in
          (match (_tok : MenhirBasics.token) with
          | TIDENT _v ->
              _menhir_run_024 _menhir_stack _menhir_lexbuf _menhir_lexer _v MenhirState025
          | _ ->
              _eRR ())
      | CL_PAREN ->
          let _1 = _v in
          let _v = _menhir_action_58 _1 in
          _menhir_goto_type_var_list _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
      | _ ->
          let _1 = _v in
          let _v = _menhir_action_58 _1 in
          _menhir_error_goto_type_var_list _menhir_stack _menhir_lexbuf _v _menhir_s
  
  and _menhir_goto_type_var_list : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s ->
      match _menhir_s with
      | MenhirState023 ->
          _menhir_run_027 _menhir_stack _menhir_lexbuf _menhir_lexer _v
      | MenhirState025 ->
          _menhir_run_026 _menhir_stack _menhir_lexbuf _menhir_lexer _v
      | _ ->
          _menhir_fail ()
  
  and _menhir_run_027 : type  ttv_stack. (ttv_stack, _menhir_box_full_module) _menhir_cell1_TYPE _menhir_cell0_OP_PAREN -> _ -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v ->
      let _tok = _menhir_lexer _menhir_lexbuf in
      let MenhirCell0_OP_PAREN (_menhir_stack, _) = _menhir_stack in
      let _2 = _v in
      let _v = _menhir_action_54 _2 in
      _menhir_goto_type_param _menhir_stack _menhir_lexbuf _menhir_lexer _v _tok
  
  and _menhir_run_026 : type  ttv_stack. (ttv_stack, _menhir_box_full_module) _menhir_cell1_TIDENT -> _ -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v ->
      let MenhirCell1_TIDENT (_menhir_stack, _menhir_s, _1, _, _) = _menhir_stack in
      let _3 = _v in
      let _v = _menhir_action_57 _1 _3 in
      _menhir_goto_type_var_list _menhir_stack _menhir_lexbuf _menhir_lexer _v _menhir_s
  
  and _menhir_run_018 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_annot (_menhir_stack, _menhir_s, _v, _startpos, _endpos) in
      match (_tok : MenhirBasics.token) with
      | TYPE ->
          _menhir_run_020 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState018
      | EOF ->
          let _v = _menhir_action_29 () in
          _menhir_run_148 _menhir_stack _v
      | _ ->
          _menhir_error_run_019 _menhir_stack _menhir_lexbuf MenhirState018
  
  and _menhir_run_017 : type  ttv_stack. (ttv_stack, _menhir_box_full_module) _menhir_cell1_asection -> _ -> _ -> _ -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_asection (_menhir_stack, _menhir_s, x, _startpos_x_) = _menhir_stack in
      let (_endpos_l_, l) = (_endpos, _v) in
      let _v = _menhir_action_05 l x in
      _menhir_goto_annot _menhir_stack _menhir_lexbuf _menhir_lexer _endpos_l_ _startpos_x_ _v _menhir_s _tok
  
  and _menhir_run_016 : type  ttv_stack. ttv_stack -> _ -> _ -> _ -> _ -> _ -> (ttv_stack, _menhir_box_full_module) _menhir_state -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos _v _menhir_s _tok ->
      let _menhir_stack = MenhirCell1_asection (_menhir_stack, _menhir_s, _v, _startpos) in
      match (_tok : MenhirBasics.token) with
      | LT ->
          _menhir_run_001 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState016
      | BAR | CL_BRACK | CL_CURL | CL_PAREN | COLON | COMMA | EOF | EQ | LIDENT _ | OF | SEMICOLON | STAR | TYPE ->
          let _v = _menhir_action_06 () in
          _menhir_run_017 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok
      | _ ->
          let _v = _menhir_action_06 () in
          _menhir_error_run_017 _menhir_stack _menhir_lexbuf _endpos _v
  
  and _menhir_run_010 : type  ttv_stack. (ttv_stack, _menhir_box_full_module) _menhir_cell1_LT _menhir_cell0_LIDENT -> _ -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _v ->
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      let MenhirCell0_LIDENT (_menhir_stack, x, _, _) = _menhir_stack in
      let MenhirCell1_LT (_menhir_stack, _menhir_s, _startpos__1_) = _menhir_stack in
      let (l, _endpos__4_) = (_v, _endpos) in
      let _v = _menhir_action_09 _endpos__4_ _startpos__1_ l x in
      _menhir_goto_asection _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _startpos__1_ _v _menhir_s _tok
  
  and _menhir_run_006 : type  ttv_stack. (ttv_stack, _menhir_box_full_module) _menhir_cell1_LIDENT -> _ -> _ -> _ -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _v _tok ->
      let MenhirCell1_LIDENT (_menhir_stack, _menhir_s, _1, _startpos__1_, _) = _menhir_stack in
      let (_3, _endpos__3_) = (_v, _endpos) in
      let _v = _menhir_action_26 _1 _3 in
      _menhir_goto_lident_path _menhir_stack _menhir_lexbuf _menhir_lexer _endpos__3_ _startpos__1_ _v _menhir_s _tok
  
  let rec _menhir_run_000 : type  ttv_stack. ttv_stack -> _ -> _ -> _menhir_box_full_module =
    fun _menhir_stack _menhir_lexbuf _menhir_lexer ->
      let _endpos = _menhir_lexbuf.Lexing.lex_curr_p in
      let _tok = _menhir_lexer _menhir_lexbuf in
      match (_tok : MenhirBasics.token) with
      | LT ->
          _menhir_run_001 _menhir_stack _menhir_lexbuf _menhir_lexer MenhirState000
      | EOF | TYPE ->
          let _v = _menhir_action_06 () in
          _menhir_run_018 _menhir_stack _menhir_lexbuf _menhir_lexer _endpos _endpos _v MenhirState000 _tok
      | _ ->
          let _v = _menhir_action_06 () in
          _menhir_error_run_018 _menhir_stack _menhir_lexbuf _endpos _endpos _v MenhirState000
  
end

let full_module =
  fun _menhir_lexer _menhir_lexbuf ->
    let _menhir_stack = () in
    let MenhirBox_full_module v = _menhir_run_000 _menhir_stack _menhir_lexbuf _menhir_lexer in
    v
