# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_laze_global_optspecs
	string join \n C/chdir= v/verbose q/quiet g/global c/cache-dir= h/help V/version
end

function __fish_laze_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_laze_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_laze_using_subcommand
	set -l cmd (__fish_laze_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c laze -n "__fish_laze_needs_command" -s C -l chdir -d 'change working directory before doing anything else' -r -f -a "(__fish_complete_directories)"
complete -c laze -n "__fish_laze_needs_command" -s c -l cache-dir -d 'git cache base directory' -r -f -a "(__fish_complete_directories)"
complete -c laze -n "__fish_laze_needs_command" -s v -l verbose -d 'be verbose (e.g., show command lines)'
complete -c laze -n "__fish_laze_needs_command" -s q -l quiet -d 'do not print laze log messages'
complete -c laze -n "__fish_laze_needs_command" -s g -l global -d 'global mode'
complete -c laze -n "__fish_laze_needs_command" -s h -l help -d 'Print help'
complete -c laze -n "__fish_laze_needs_command" -s V -l version -d 'Print version'
complete -c laze -n "__fish_laze_needs_command" -f -a "build" -d 'generate build files and build'
complete -c laze -n "__fish_laze_needs_command" -f -a "clean" -d 'clean current configuration'
complete -c laze -n "__fish_laze_needs_command" -f -a "new" -d 'Create a new laze project at <PATH>'
complete -c laze -n "__fish_laze_needs_command" -f -a "completion" -d 'Generate laze shell completions.'
complete -c laze -n "__fish_laze_needs_command" -f -a "manpages" -d 'Generate laze manpages.'
complete -c laze -n "__fish_laze_needs_command" -f -a "git-clone" -d 'clone repository'
complete -c laze -n "__fish_laze_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c laze -n "__fish_laze_using_subcommand build" -s B -l build-dir -d 'specify build dir (relative to project root)' -r -f -a "(__fish_complete_directories)"
complete -c laze -n "__fish_laze_using_subcommand build" -s i -l info-export -d 'export build info to file (as JSON)' -r -F
complete -c laze -n "__fish_laze_using_subcommand build" -s k -l keep-going -d 'keep going until N jobs / tasks fail (0 means infinity)' -r
complete -c laze -n "__fish_laze_using_subcommand build" -s j -l jobs -d 'how many compile jobs to run in parallel' -r
complete -c laze -n "__fish_laze_using_subcommand build" -s b -l builders -d 'builders to configure' -r
complete -c laze -n "__fish_laze_using_subcommand build" -s a -l apps -d 'apps to configure' -r
complete -c laze -n "__fish_laze_using_subcommand build" -s P -l partition -d 'build only M/N subset (try "count:1/2")' -r
complete -c laze -n "__fish_laze_using_subcommand build" -s s -l select -d 'extra modules to select/enable' -r
complete -c laze -n "__fish_laze_using_subcommand build" -s d -l disable -d 'disable modules' -r
complete -c laze -n "__fish_laze_using_subcommand build" -s D -l define -d 'set/override variable' -r
complete -c laze -n "__fish_laze_using_subcommand build" -s C -l chdir -d 'change working directory before doing anything else' -r -f -a "(__fish_complete_directories)"
complete -c laze -n "__fish_laze_using_subcommand build" -s G -l generate-only -d 'generate build files only, don\'t start build'
complete -c laze -n "__fish_laze_using_subcommand build" -s c -l compile-commands -d 'generate compile_commands.json in project root'
complete -c laze -n "__fish_laze_using_subcommand build" -s m -l multiple-tasks -d 'if multiple tasks targets are available, execute them all'
complete -c laze -n "__fish_laze_using_subcommand build" -s v -l verbose -d 'be verbose (e.g., show command lines)'
complete -c laze -n "__fish_laze_using_subcommand build" -s q -l quiet -d 'do not print laze log messages'
complete -c laze -n "__fish_laze_using_subcommand build" -s g -l global -d 'global mode'
complete -c laze -n "__fish_laze_using_subcommand build" -s h -l help -d 'Print help'
complete -c laze -n "__fish_laze_using_subcommand clean" -s B -l build-dir -d 'specify build dir (relative to project root)' -r -f -a "(__fish_complete_directories)"
complete -c laze -n "__fish_laze_using_subcommand clean" -s C -l chdir -d 'change working directory before doing anything else' -r -f -a "(__fish_complete_directories)"
complete -c laze -n "__fish_laze_using_subcommand clean" -s u -l unused -d 'clean built files that are not produced by the current configuration'
complete -c laze -n "__fish_laze_using_subcommand clean" -s v -l verbose -d 'be verbose (e.g., show command lines)'
complete -c laze -n "__fish_laze_using_subcommand clean" -s q -l quiet -d 'do not print laze log messages'
complete -c laze -n "__fish_laze_using_subcommand clean" -s g -l global -d 'global mode'
complete -c laze -n "__fish_laze_using_subcommand clean" -s h -l help -d 'Print help'
complete -c laze -n "__fish_laze_using_subcommand new" -s t -l template -d 'template to use for new project' -r
complete -c laze -n "__fish_laze_using_subcommand new" -s C -l chdir -d 'change working directory before doing anything else' -r -f -a "(__fish_complete_directories)"
complete -c laze -n "__fish_laze_using_subcommand new" -s v -l verbose -d 'be verbose (e.g., show command lines)'
complete -c laze -n "__fish_laze_using_subcommand new" -s q -l quiet -d 'do not print laze log messages'
complete -c laze -n "__fish_laze_using_subcommand new" -s g -l global -d 'global mode'
complete -c laze -n "__fish_laze_using_subcommand new" -s h -l help -d 'Print help'
complete -c laze -n "__fish_laze_using_subcommand completion" -l generate -d 'shell to generate completions for' -r -f -a "bash\t''
elvish\t''
fish\t''
powershell\t''
zsh\t''"
complete -c laze -n "__fish_laze_using_subcommand completion" -s C -l chdir -d 'change working directory before doing anything else' -r -f -a "(__fish_complete_directories)"
complete -c laze -n "__fish_laze_using_subcommand completion" -s v -l verbose -d 'be verbose (e.g., show command lines)'
complete -c laze -n "__fish_laze_using_subcommand completion" -s q -l quiet -d 'do not print laze log messages'
complete -c laze -n "__fish_laze_using_subcommand completion" -s g -l global -d 'global mode'
complete -c laze -n "__fish_laze_using_subcommand completion" -s h -l help -d 'Print help'
complete -c laze -n "__fish_laze_using_subcommand manpages" -s C -l chdir -d 'change working directory before doing anything else' -r -f -a "(__fish_complete_directories)"
complete -c laze -n "__fish_laze_using_subcommand manpages" -s v -l verbose -d 'be verbose (e.g., show command lines)'
complete -c laze -n "__fish_laze_using_subcommand manpages" -s q -l quiet -d 'do not print laze log messages'
complete -c laze -n "__fish_laze_using_subcommand manpages" -s g -l global -d 'global mode'
complete -c laze -n "__fish_laze_using_subcommand manpages" -s h -l help -d 'Print help'
complete -c laze -n "__fish_laze_using_subcommand git-clone" -l commit -d 'check out specific commit' -r
complete -c laze -n "__fish_laze_using_subcommand git-clone" -l sparse-add -d 'do a sparse checkout, keep PATH' -r
complete -c laze -n "__fish_laze_using_subcommand git-clone" -l recurse-submodules -d 'recursively clone submodules' -r
complete -c laze -n "__fish_laze_using_subcommand git-clone" -s j -l jobs -d 'The number of submodules fetched at the same time.' -r
complete -c laze -n "__fish_laze_using_subcommand git-clone" -s b -l branch -r
complete -c laze -n "__fish_laze_using_subcommand git-clone" -s c -l config -r
complete -c laze -n "__fish_laze_using_subcommand git-clone" -s o -l origin -r
complete -c laze -n "__fish_laze_using_subcommand git-clone" -s u -l upload-pack -r
complete -c laze -n "__fish_laze_using_subcommand git-clone" -l bundle-uri -r
complete -c laze -n "__fish_laze_using_subcommand git-clone" -l depth -r
complete -c laze -n "__fish_laze_using_subcommand git-clone" -l filter -r
complete -c laze -n "__fish_laze_using_subcommand git-clone" -l reference -r
complete -c laze -n "__fish_laze_using_subcommand git-clone" -l reference-if-able -r
complete -c laze -n "__fish_laze_using_subcommand git-clone" -l separate-git-dir -r
complete -c laze -n "__fish_laze_using_subcommand git-clone" -l shallow-exclude -r
complete -c laze -n "__fish_laze_using_subcommand git-clone" -l shallow-since -r
complete -c laze -n "__fish_laze_using_subcommand git-clone" -l template -r
complete -c laze -n "__fish_laze_using_subcommand git-clone" -s C -l chdir -d 'change working directory before doing anything else' -r -f -a "(__fish_complete_directories)"
complete -c laze -n "__fish_laze_using_subcommand git-clone" -s U -l update -d 'force update of cached repo'
complete -c laze -n "__fish_laze_using_subcommand git-clone" -l shallow-submodules -d 'shallow-clone submodules'
complete -c laze -n "__fish_laze_using_subcommand git-clone" -l no-shallow-submodules -d 'don\'t shallow-clone submodules'
complete -c laze -n "__fish_laze_using_subcommand git-clone" -s l -l local
complete -c laze -n "__fish_laze_using_subcommand git-clone" -s q -l quiet
complete -c laze -n "__fish_laze_using_subcommand git-clone" -s s -l shared
complete -c laze -n "__fish_laze_using_subcommand git-clone" -s v -l verbose
complete -c laze -n "__fish_laze_using_subcommand git-clone" -s n -l no-checkout
complete -c laze -n "__fish_laze_using_subcommand git-clone" -l sparse
complete -c laze -n "__fish_laze_using_subcommand git-clone" -l also-filter-submodules
complete -c laze -n "__fish_laze_using_subcommand git-clone" -l bare
complete -c laze -n "__fish_laze_using_subcommand git-clone" -l dissociate
complete -c laze -n "__fish_laze_using_subcommand git-clone" -l mirror
complete -c laze -n "__fish_laze_using_subcommand git-clone" -l no-hardlinks
complete -c laze -n "__fish_laze_using_subcommand git-clone" -l no-reject-shallow
complete -c laze -n "__fish_laze_using_subcommand git-clone" -l no-remote-submodules
complete -c laze -n "__fish_laze_using_subcommand git-clone" -l no-single-branch
complete -c laze -n "__fish_laze_using_subcommand git-clone" -l no-tags
complete -c laze -n "__fish_laze_using_subcommand git-clone" -l reject-shallow
complete -c laze -n "__fish_laze_using_subcommand git-clone" -l remote-submodules
complete -c laze -n "__fish_laze_using_subcommand git-clone" -l single-branch
complete -c laze -n "__fish_laze_using_subcommand git-clone" -s g -l global -d 'global mode'
complete -c laze -n "__fish_laze_using_subcommand git-clone" -s h -l help -d 'Print help'
complete -c laze -n "__fish_laze_using_subcommand help; and not __fish_seen_subcommand_from build clean new completion manpages git-clone help" -f -a "build" -d 'generate build files and build'
complete -c laze -n "__fish_laze_using_subcommand help; and not __fish_seen_subcommand_from build clean new completion manpages git-clone help" -f -a "clean" -d 'clean current configuration'
complete -c laze -n "__fish_laze_using_subcommand help; and not __fish_seen_subcommand_from build clean new completion manpages git-clone help" -f -a "new" -d 'Create a new laze project at <PATH>'
complete -c laze -n "__fish_laze_using_subcommand help; and not __fish_seen_subcommand_from build clean new completion manpages git-clone help" -f -a "completion" -d 'Generate laze shell completions.'
complete -c laze -n "__fish_laze_using_subcommand help; and not __fish_seen_subcommand_from build clean new completion manpages git-clone help" -f -a "manpages" -d 'Generate laze manpages.'
complete -c laze -n "__fish_laze_using_subcommand help; and not __fish_seen_subcommand_from build clean new completion manpages git-clone help" -f -a "git-clone" -d 'clone repository'
complete -c laze -n "__fish_laze_using_subcommand help; and not __fish_seen_subcommand_from build clean new completion manpages git-clone help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
