// Copyright 2021 The Khronos Group
// SPDX-License-Identifier: Apache-2.0

// This file was generated by generate_extension_utility.py
// Don't make changes to this directly

#pragma once
#include <anari/anari.h>
typedef struct {
   int ANARI_KHR_LIGHT_DIRECTIONAL;
   int ANARI_KHR_LIGHT_POINT;
   int ANARI_KHR_LIGHT_RING;
   int ANARI_KHR_LIGHT_QUAD;
   int ANARI_KHR_LIGHT_HDRI;
   int ANARI_KHR_CAMERA_SHUTTER;
   int ANARI_KHR_INSTANCE_MOTION_SCALE_ROTATION_TRANSLATION;
   int ANARI_KHR_INSTANCE_MOTION_TRANSFORM;
   int ANARI_KHR_INSTANCE_TRANSFORM;
   int ANARI_KHR_VOLUME_TRANSFER_FUNCTION1D;
   int ANARI_KHR_AREA_LIGHTS;
   int ANARI_KHR_ARRAY1D_REGION;
   int ANARI_KHR_CAMERA_DEPTH_OF_FIELD;
   int ANARI_KHR_CAMERA_MOTION_TRANSFORMATION;
   int ANARI_KHR_CAMERA_OMNIDIRECTIONAL;
   int ANARI_KHR_CAMERA_ORTHOGRAPHIC;
   int ANARI_KHR_CAMERA_PERSPECTIVE;
   int ANARI_KHR_CAMERA_STEREO;
   int ANARI_KHR_DEVICE_SYNCHRONIZATION;
   int ANARI_KHR_FRAME_CHANNEL_ALBEDO;
   int ANARI_KHR_FRAME_CHANNEL_INSTANCE_ID;
   int ANARI_KHR_FRAME_CHANNEL_NORMAL;
   int ANARI_KHR_FRAME_CHANNEL_OBJECT_ID;
   int ANARI_KHR_FRAME_CHANNEL_PRIMITIVE_ID;
   int ANARI_KHR_FRAME_COMPLETION_CALLBACK;
   int ANARI_KHR_GEOMETRY_CONE;
   int ANARI_KHR_GEOMETRY_CURVE;
   int ANARI_KHR_GEOMETRY_CYLINDER;
   int ANARI_KHR_GEOMETRY_QUAD;
   int ANARI_KHR_GEOMETRY_QUAD_MOTION_DEFORMATION;
   int ANARI_KHR_GEOMETRY_SPHERE;
   int ANARI_KHR_GEOMETRY_TRIANGLE;
   int ANARI_KHR_GEOMETRY_TRIANGLE_MOTION_DEFORMATION;
   int ANARI_KHR_LIGHT_SPOT;
   int ANARI_KHR_MATERIAL_MATTE;
   int ANARI_KHR_MATERIAL_PHYSICALLY_BASED;
   int ANARI_KHR_RENDERER_AMBIENT_LIGHT;
   int ANARI_KHR_RENDERER_BACKGROUND_COLOR;
   int ANARI_KHR_RENDERER_BACKGROUND_IMAGE;
   int ANARI_KHR_SAMPLER_IMAGE1D;
   int ANARI_KHR_SAMPLER_IMAGE2D;
   int ANARI_KHR_SAMPLER_IMAGE3D;
   int ANARI_KHR_SAMPLER_PRIMITIVE;
   int ANARI_KHR_SAMPLER_TRANSFORM;
   int ANARI_KHR_SPATIAL_FIELD_STRUCTURED_REGULAR;
   int ANARI_EXP_VOLUME_SAMPLE_RATE;
} ANARIExtensions;
int anariGetDeviceExtensionStruct(ANARIExtensions *extensions, ANARILibrary library, const char *deviceName);
int anariGetObjectExtensionStruct(ANARIExtensions *extensions, ANARIDevice device, ANARIDataType objectType, const char *objectName);
int anariGetInstanceExtensionStruct(ANARIExtensions *extensions, ANARIDevice device, ANARIObject object);
#ifdef ANARI_EXTENSION_UTILITY_IMPL
#include <string.h>
static int extension_hash(const char *str) {
   static const uint32_t table[] = {0x4f4e0001u,0x42410002u,0x53520003u,0x4a490004u,0x605f0005u,0x4c450006u,0x5958000du,0x0u,0x0u,0x0u,0x0u,0x0u,0x49480023u,0x5150000eu,0x605f000fu,0x57560010u,0x504f0011u,0x4d4c0012u,0x56550013u,0x4e4d0014u,0x46450015u,0x605f0016u,0x54530017u,0x42410018u,0x4e4d0019u,0x5150001au,0x4d4c001bu,0x4645001cu,0x605f001du,0x5352001eu,0x4241001fu,0x55540020u,0x46450021u,0x1000022u,0x8000002du,0x53520024u,0x605f0025u,0x57410026u,0x5352003cu,0x0u,0x42410060u,0x464500dbu,0x0u,0x535200f1u,0x46450153u,0x0u,0x4f4e027cu,0x0u,0x0u,0x4a4902c0u,0x424102f5u,0x0u,0x0u,0x0u,0x0u,0x46450316u,0x51410348u,0x0u,0x0u,0x504f03a8u,0x5345003du,0x4241004bu,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x42410054u,0x605f004cu,0x4d4c004du,0x4a49004eu,0x4847004fu,0x49480050u,0x55540051u,0x54530052u,0x1000053u,0x8000000au,0x5a590055u,0x32310056u,0x45440057u,0x605f0058u,0x53520059u,0x4645005au,0x4847005bu,0x4a49005cu,0x504f005du,0x4f4e005eu,0x100005fu,0x8000000bu,0x4e4d0061u,0x46450062u,0x53520063u,0x42410064u,0x605f0065u,0x54440066u,0x46450076u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x504f0084u,0x0u,0x534d0099u,0x464500b8u,0x0u,0x0u,0x554800c3u,0x51500077u,0x55540078u,0x49480079u,0x605f007au,0x504f007bu,0x4746007cu,0x605f007du,0x4746007eu,0x4a49007fu,0x46450080u,0x4d4c0081u,0x45440082u,0x1000083u,0x8000000cu,0x55540085u,0x4a490086u,0x504f0087u,0x4f4e0088u,0x605f0089u,0x5554008au,0x5352008bu,0x4241008cu,0x4f4e008du,0x5453008eu,0x4746008fu,0x504f0090u,0x53520091u,0x4e4d0092u,0x42410093u,0x55540094u,0x4a490095u,0x504f0096u,0x4f4e0097u,0x1000098u,0x8000000du,0x4f4e009fu,0x0u,0x0u,0x0u,0x0u,0x555400adu,0x4a4900a0u,0x454400a1u,0x4a4900a2u,0x535200a3u,0x464500a4u,0x444300a5u,0x555400a6u,0x4a4900a7u,0x504f00a8u,0x4f4e00a9u,0x424100aau,0x4d4c00abu,0x10000acu,0x8000000eu,0x494800aeu,0x504f00afu,0x484700b0u,0x535200b1u,0x424100b2u,0x515000b3u,0x494800b4u,0x4a4900b5u,0x444300b6u,0x10000b7u,0x8000000fu,0x535200b9u,0x545300bau,0x515000bbu,0x464500bcu,0x444300bdu,0x555400beu,0x4a4900bfu,0x575600c0u,0x464500c1u,0x10000c2u,0x80000010u,0x565500d0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x464500d6u,0x555400d1u,0x555400d2u,0x464500d3u,0x535200d4u,0x10000d5u,0x80000005u,0x535200d7u,0x464500d8u,0x504f00d9u,0x10000dau,0x80000011u,0x575600dcu,0x4a4900ddu,0x444300deu,0x464500dfu,0x605f00e0u,0x545300e1u,0x5a5900e2u,0x4f4e00e3u,0x444300e4u,0x494800e5u,0x535200e6u,0x504f00e7u,0x4f4e00e8u,0x4a4900e9u,0x5b5a00eau,0x424100ebu,0x555400ecu,0x4a4900edu,0x504f00eeu,0x4f4e00efu,0x10000f0u,0x80000012u,0x424100f2u,0x4e4d00f3u,0x464500f4u,0x605f00f5u,0x444300f6u,0x504800f7u,0x424100ffu,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x4e4d0141u,0x4f4e0100u,0x4f4e0101u,0x46450102u,0x4d4c0103u,0x605f0104u,0x51410105u,0x4d4c0115u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x4f4e011bu,0x0u,0x0u,0x0u,0x0u,0x504f0126u,0x4342012cu,0x53520135u,0x43420116u,0x46450117u,0x45440118u,0x504f0119u,0x100011au,0x80000013u,0x5453011cu,0x5554011du,0x4241011eu,0x4f4e011fu,0x44430120u,0x46450121u,0x605f0122u,0x4a490123u,0x45440124u,0x1000125u,0x80000014u,0x53520127u,0x4e4d0128u,0x42410129u,0x4d4c012au,0x100012bu,0x80000015u,0x4b4a012du,0x4645012eu,0x4443012fu,0x55540130u,0x605f0131u,0x4a490132u,0x45440133u,0x1000134u,0x80000016u,0x4a490136u,0x4e4d0137u,0x4a490138u,0x55540139u,0x4a49013au,0x5756013bu,0x4645013cu,0x605f013du,0x4a49013eu,0x4544013fu,0x1000140u,0x80000017u,0x51500142u,0x4d4c0143u,0x46450144u,0x55540145u,0x4a490146u,0x504f0147u,0x4f4e0148u,0x605f0149u,0x4443014au,0x4241014bu,0x4d4c014cu,0x4d4c014du,0x4342014eu,0x4241014fu,0x44430150u,0x4c4b0151u,0x1000152u,0x80000018u,0x504f0154u,0x4e4d0155u,0x46450156u,0x55540157u,0x53520158u,0x5a590159u,0x605f015au,0x5543015bu,0x5a4f016du,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x56550186u,0x0u,0x515001fcu,0x53520202u,0x4f4e0178u,0x0u,0x0u,0x0u,0x0u,0x0u,0x5352017bu,0x0u,0x0u,0x0u,0x4d4c017fu,0x46450179u,0x100017au,0x80000019u,0x5756017cu,0x4645017du,0x100017eu,0x8000001au,0x4a490180u,0x4f4e0181u,0x45440182u,0x46450183u,0x53520184u,0x1000185u,0x8000001bu,0x42410187u,0x45440188u,0x60000189u,0x8000001cu,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x4e4d01e9u,0x504f01eau,0x555401ebu,0x4a4901ecu,0x504f01edu,0x4f4e01eeu,0x605f01efu,0x454401f0u,0x464501f1u,0x474601f2u,0x504f01f3u,0x535201f4u,0x4e4d01f5u,0x424101f6u,0x555401f7u,0x4a4901f8u,0x504f01f9u,0x4f4e01fau,0x10001fbu,0x8000001du,0x494801fdu,0x464501feu,0x535201ffu,0x46450200u,0x1000201u,0x8000001eu,0x4a490203u,0x42410204u,0x4f4e0205u,0x48470206u,0x4d4c0207u,0x46450208u,0x60000209u,0x8000001fu,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x4e4d0269u,0x504f026au,0x5554026bu,0x4a49026cu,0x504f026du,0x4f4e026eu,0x605f026fu,0x45440270u,0x46450271u,0x47460272u,0x504f0273u,0x53520274u,0x4e4d0275u,0x42410276u,0x55540277u,0x4a490278u,0x504f0279u,0x4f4e027au,0x100027bu,0x80000020u,0x5453027du,0x5554027eu,0x4241027fu,0x4f4e0280u,0x44430281u,0x46450282u,0x605f0283u,0x554d0284u,0x504f028cu,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x535202b7u,0x5554028du,0x4a49028eu,0x504f028fu,0x4f4e0290u,0x605f0291u,0x55530292u,0x44430294u,0x535202aeu,0x42410295u,0x4d4c0296u,0x46450297u,0x605f0298u,0x53520299u,0x504f029au,0x5554029bu,0x4241029cu,0x5554029du,0x4a49029eu,0x504f029fu,0x4f4e02a0u,0x605f02a1u,0x555402a2u,0x535202a3u,0x424102a4u,0x4f4e02a5u,0x545302a6u,0x4d4c02a7u,0x424102a8u,0x555402a9u,0x4a4902aau,0x504f02abu,0x4f4e02acu,0x10002adu,0x80000006u,0x424102afu,0x4f4e02b0u,0x545302b1u,0x474602b2u,0x504f02b3u,0x535202b4u,0x4e4d02b5u,0x10002b6u,0x80000007u,0x424102b8u,0x4f4e02b9u,0x545302bau,0x474602bbu,0x504f02bcu,0x535202bdu,0x4e4d02beu,0x10002bfu,0x80000008u,0x484702c1u,0x494802c2u,0x555402c3u,0x605f02c4u,0x544402c5u,0x4a4902d5u,0x0u,0x0u,0x0u,0x454402e0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x504f02e4u,0x565502e9u,0x4a4902edu,0x515002f1u,0x535202d6u,0x464502d7u,0x444302d8u,0x555402d9u,0x4a4902dau,0x504f02dbu,0x4f4e02dcu,0x424102ddu,0x4d4c02deu,0x10002dfu,0x80000000u,0x535202e1u,0x4a4902e2u,0x10002e3u,0x80000004u,0x4a4902e5u,0x4f4e02e6u,0x555402e7u,0x10002e8u,0x80000001u,0x424102eau,0x454402ebu,0x10002ecu,0x80000003u,0x4f4e02eeu,0x484702efu,0x10002f0u,0x80000002u,0x504f02f2u,0x555402f3u,0x10002f4u,0x80000021u,0x555402f6u,0x464502f7u,0x535202f8u,0x4a4902f9u,0x424102fau,0x4d4c02fbu,0x605f02fcu,0x514d02fdu,0x42410301u,0x0u,0x0u,0x49480306u,0x55540302u,0x55540303u,0x46450304u,0x1000305u,0x80000022u,0x5a590307u,0x54530308u,0x4a490309u,0x4443030au,0x4241030bu,0x4d4c030cu,0x4d4c030du,0x5a59030eu,0x605f030fu,0x43420310u,0x42410311u,0x54530312u,0x46450313u,0x45440314u,0x1000315u,0x80000023u,0x4f4e0317u,0x45440318u,0x46450319u,0x5352031au,0x4645031bu,0x5352031cu,0x605f031du,0x4341031eu,0x4e4d0320u,0x4241032du,0x43420321u,0x4a490322u,0x46450323u,0x4f4e0324u,0x55540325u,0x605f0326u,0x4d4c0327u,0x4a490328u,0x48470329u,0x4948032au,0x5554032bu,0x100032cu,0x80000024u,0x4443032eu,0x4c4b032fu,0x48470330u,0x53520331u,0x504f0332u,0x56550333u,0x4f4e0334u,0x45440335u,0x605f0336u,0x4a430337u,0x504f033eu,0x0u,0x0u,0x0u,0x0u,0x0u,0x4e4d0343u,0x4d4c033fu,0x504f0340u,0x53520341u,0x1000342u,0x80000025u,0x42410344u,0x48470345u,0x46450346u,0x1000347u,0x80000026u,0x4e4d0358u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x42410389u,0x51500359u,0x4d4c035au,0x4645035bu,0x5352035cu,0x605f035du,0x5549035eu,0x4e4d036au,0x0u,0x0u,0x0u,0x0u,0x0u,0x0u,0x53520377u,0x0u,0x0u,0x0u,0x53520380u,0x4241036bu,0x4847036cu,0x4645036du,0x3431036eu,0x45440371u,0x45440373u,0x45440375u,0x1000372u,0x80000027u,0x1000374u,0x80000028u,0x1000376u,0x80000029u,0x4a490378u,0x4e4d0379u,0x4a49037au,0x5554037bu,0x4a49037cu,0x5756037du,0x4645037eu,0x100037fu,0x8000002au,0x42410381u,0x4f4e0382u,0x54530383u,0x47460384u,0x504f0385u,0x53520386u,0x4e4d0387u,0x1000388u,0x8000002bu,0x5554038au,0x4a49038bu,0x4241038cu,0x4d4c038du,0x605f038eu,0x4746038fu,0x4a490390u,0x46450391u,0x4d4c0392u,0x45440393u,0x605f0394u,0x54530395u,0x55540396u,0x53520397u,0x56550398u,0x44430399u,0x5554039au,0x5655039bu,0x5352039cu,0x4645039du,0x4544039eu,0x605f039fu,0x535203a0u,0x464503a1u,0x484703a2u,0x565503a3u,0x4d4c03a4u,0x424103a5u,0x535203a6u,0x10003a7u,0x8000002cu,0x4d4c03a9u,0x565503aau,0x4e4d03abu,0x464503acu,0x605f03adu,0x555403aeu,0x535203afu,0x424103b0u,0x4f4e03b1u,0x545303b2u,0x474603b3u,0x464503b4u,0x535203b5u,0x605f03b6u,0x474603b7u,0x565503b8u,0x4f4e03b9u,0x444303bau,0x555403bbu,0x4a4903bcu,0x504f03bdu,0x4f4e03beu,0x323103bfu,0x454403c0u,0x10003c1u,0x80000009u};
   uint32_t cur = 0x42410000u;
   for(int i = 0;cur!=0;++i) {
      uint32_t idx = cur&0xFFFFu;
      uint32_t low = (cur>>16u)&0xFFu;
      uint32_t high = (cur>>24u)&0xFFu;
      uint32_t c = (uint32_t)str[i];
      if(c>=low && c<high) {
         cur = table[idx+c-low];
      } else {
         break;
      }
      if(cur&0x80000000u) {
         return cur&0xFFFFu;
      }
      if(str[i]==0) {
         break;
      }
   }
   return -1;
}
static void fillExtensionStruct(ANARIExtensions *extensions, const char *const *list) {
    memset(extensions, 0, sizeof(ANARIExtensions));
    for(const char *const *i = list;*i!=NULL;++i) {
        switch(extension_hash(*i)) {
            case 0: extensions->ANARI_KHR_LIGHT_DIRECTIONAL = 1; break;
            case 1: extensions->ANARI_KHR_LIGHT_POINT = 1; break;
            case 2: extensions->ANARI_KHR_LIGHT_RING = 1; break;
            case 3: extensions->ANARI_KHR_LIGHT_QUAD = 1; break;
            case 4: extensions->ANARI_KHR_LIGHT_HDRI = 1; break;
            case 5: extensions->ANARI_KHR_CAMERA_SHUTTER = 1; break;
            case 6: extensions->ANARI_KHR_INSTANCE_MOTION_SCALE_ROTATION_TRANSLATION = 1; break;
            case 7: extensions->ANARI_KHR_INSTANCE_MOTION_TRANSFORM = 1; break;
            case 8: extensions->ANARI_KHR_INSTANCE_TRANSFORM = 1; break;
            case 9: extensions->ANARI_KHR_VOLUME_TRANSFER_FUNCTION1D = 1; break;
            case 10: extensions->ANARI_KHR_AREA_LIGHTS = 1; break;
            case 11: extensions->ANARI_KHR_ARRAY1D_REGION = 1; break;
            case 12: extensions->ANARI_KHR_CAMERA_DEPTH_OF_FIELD = 1; break;
            case 13: extensions->ANARI_KHR_CAMERA_MOTION_TRANSFORMATION = 1; break;
            case 14: extensions->ANARI_KHR_CAMERA_OMNIDIRECTIONAL = 1; break;
            case 15: extensions->ANARI_KHR_CAMERA_ORTHOGRAPHIC = 1; break;
            case 16: extensions->ANARI_KHR_CAMERA_PERSPECTIVE = 1; break;
            case 17: extensions->ANARI_KHR_CAMERA_STEREO = 1; break;
            case 18: extensions->ANARI_KHR_DEVICE_SYNCHRONIZATION = 1; break;
            case 19: extensions->ANARI_KHR_FRAME_CHANNEL_ALBEDO = 1; break;
            case 20: extensions->ANARI_KHR_FRAME_CHANNEL_INSTANCE_ID = 1; break;
            case 21: extensions->ANARI_KHR_FRAME_CHANNEL_NORMAL = 1; break;
            case 22: extensions->ANARI_KHR_FRAME_CHANNEL_OBJECT_ID = 1; break;
            case 23: extensions->ANARI_KHR_FRAME_CHANNEL_PRIMITIVE_ID = 1; break;
            case 24: extensions->ANARI_KHR_FRAME_COMPLETION_CALLBACK = 1; break;
            case 25: extensions->ANARI_KHR_GEOMETRY_CONE = 1; break;
            case 26: extensions->ANARI_KHR_GEOMETRY_CURVE = 1; break;
            case 27: extensions->ANARI_KHR_GEOMETRY_CYLINDER = 1; break;
            case 28: extensions->ANARI_KHR_GEOMETRY_QUAD = 1; break;
            case 29: extensions->ANARI_KHR_GEOMETRY_QUAD_MOTION_DEFORMATION = 1; break;
            case 30: extensions->ANARI_KHR_GEOMETRY_SPHERE = 1; break;
            case 31: extensions->ANARI_KHR_GEOMETRY_TRIANGLE = 1; break;
            case 32: extensions->ANARI_KHR_GEOMETRY_TRIANGLE_MOTION_DEFORMATION = 1; break;
            case 33: extensions->ANARI_KHR_LIGHT_SPOT = 1; break;
            case 34: extensions->ANARI_KHR_MATERIAL_MATTE = 1; break;
            case 35: extensions->ANARI_KHR_MATERIAL_PHYSICALLY_BASED = 1; break;
            case 36: extensions->ANARI_KHR_RENDERER_AMBIENT_LIGHT = 1; break;
            case 37: extensions->ANARI_KHR_RENDERER_BACKGROUND_COLOR = 1; break;
            case 38: extensions->ANARI_KHR_RENDERER_BACKGROUND_IMAGE = 1; break;
            case 39: extensions->ANARI_KHR_SAMPLER_IMAGE1D = 1; break;
            case 40: extensions->ANARI_KHR_SAMPLER_IMAGE2D = 1; break;
            case 41: extensions->ANARI_KHR_SAMPLER_IMAGE3D = 1; break;
            case 42: extensions->ANARI_KHR_SAMPLER_PRIMITIVE = 1; break;
            case 43: extensions->ANARI_KHR_SAMPLER_TRANSFORM = 1; break;
            case 44: extensions->ANARI_KHR_SPATIAL_FIELD_STRUCTURED_REGULAR = 1; break;
            case 45: extensions->ANARI_EXP_VOLUME_SAMPLE_RATE = 1; break;
            default: break;
        }
    }
}
int anariGetDeviceExtensionStruct(ANARIExtensions *extensions, ANARILibrary library, const char *deviceName) {
    const char *const *list = (const char *const *)anariGetDeviceExtensions(library, deviceName);
    if(list) {
        fillExtensionStruct(extensions, list);
        return 0;
    } else {
        return 1;
    }
}
int anariGetObjectExtensionStruct(ANARIExtensions *extensions, ANARIDevice device, ANARIDataType objectType, const char *objectName) {
    const char *const *list = (const char *const *)anariGetObjectInfo(device, objectType, objectName, "extension", ANARI_STRING_LIST);
    if(list) {
        fillExtensionStruct(extensions, list);
        return 0;
    } else {
        return 1;
    }
}
int anariGetInstanceExtensionStruct(ANARIExtensions *extensions, ANARIDevice device, ANARIObject object) {
    const char *const *list = NULL;
    anariGetProperty(device, object, "extension", ANARI_STRING_LIST, &list, sizeof(list), ANARI_WAIT);
    if(list) {
        fillExtensionStruct(extensions, list);
        return 0;
    } else {
        return 1;
    }
}
#endif
